export const SureRankLogo = ( props ) => (
	<svg
		width="128"
		height="128"
		viewBox="0 0 128 128"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="128" height="128" fill="white" />
		<path
			d="M73.4731 0C99.6321 6.3594e-05 120.838 21.2062 120.838 47.3652C120.838 66.1146 109.944 82.3181 94.1401 89.9941H120.838V128H101.114C81.7276 128 65.7331 113.485 63.4018 94.7305H63.4008L63.4125 74.8838C81.2408 74.7673 94.685 60.2785 94.685 42.4229V33.9307H94.6879V27.6074C77.0272 27.6075 62.1389 39.4779 57.5649 55.6748C52.7868 48.9672 44.9453 44.5928 36.0825 44.5928H29.7495V50.915H29.7719C30.1453 64.2164 41.0453 74.8848 54.437 74.8848H56.1166L56.0356 94.7305H56.0073C53.6177 113.422 37.6508 127.868 18.31 127.868H7.16156V0H73.4731Z"
			fill="#4338CA"
		/>
	</svg>
);

export const SureMailLogo = ( props ) => (
	<svg
		width="142"
		height="28"
		viewBox="0 0 142 28"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_17611_13696)">
			<path
				d="M27.1581 0.03125H1.21629C0.738715 0.03125 0.351562 0.418603 0.351562 0.896429V26.8518C0.351562 27.3296 0.738715 27.717 1.21629 27.717H27.1581C27.6357 27.717 28.0228 27.3296 28.0228 26.8518V0.896429C28.0228 0.418603 27.6357 0.03125 27.1581 0.03125Z"
				fill="#0D7EE8"
			/>
			<path
				d="M7.7377 13.4819C7.97837 13.656 8.32006 13.5988 8.4775 13.3645C8.65153 13.1238 8.59436 12.7819 8.36022 12.6243L6.04272 10.9632C5.96037 10.8996 5.96752 10.8201 5.9711 10.7803C5.97472 10.7406 6.00504 10.6712 6.10475 10.6321L21.5249 6.69865C21.6145 6.68273 21.6672 6.7196 21.7034 6.76295C21.7395 6.8063 21.7756 6.84964 21.7352 6.9422L15.8927 21.7329C15.8523 21.8255 15.7793 21.8349 15.7461 21.8479C15.7063 21.8443 15.6268 21.8371 15.5777 21.7605L13.8117 18.5219C13.756 18.4287 13.7105 18.3123 13.6548 18.2191C12.9636 16.6493 12.7892 15.4909 14.0864 14.3499L17.4262 11.2575C17.653 11.0536 17.6753 10.7189 17.478 10.5086C17.2742 10.2817 16.9397 10.2594 16.7295 10.4568L13.2216 13.4819C11.4542 15.0373 11.7485 16.972 12.8669 19.0456L14.6328 22.2841C14.8584 22.7134 15.3172 22.9555 15.8078 22.9358C15.9371 22.9235 16.0766 22.888 16.1929 22.8424C16.5085 22.7187 16.7556 22.4686 16.8971 22.1446L22.7396 7.3539C22.915 6.92089 22.8325 6.41632 22.5203 6.05937C22.208 5.70237 21.7319 5.56299 21.2739 5.66576L5.83713 9.60573C5.36899 9.73167 5.01505 10.1004 4.91552 10.5804C4.81595 11.0604 5.02128 11.536 5.4202 11.8207L7.7377 13.4819Z"
				fill="white"
			/>
			<path
				d="M7.00243 17.9417C7.04586 17.9247 7.09805 17.8875 7.13578 17.8561L9.46991 15.8063C9.66737 15.6288 9.68675 15.3374 9.515 15.1543C9.33755 14.9568 9.04635 14.9374 8.86336 15.1092L6.52922 17.1589C6.33182 17.3365 6.31238 17.6279 6.48413 17.8109C6.61566 17.9764 6.81441 18.0153 7.00243 17.9417Z"
				fill="white"
			/>
			<path
				d="M6.70437 21.2197C6.7478 21.2029 6.80014 21.1659 6.83792 21.1345L10.8048 17.6588C11.0028 17.4818 11.023 17.1905 10.8517 17.0069C10.6748 16.8089 10.3837 16.7886 10.2003 16.96L6.23334 20.4357C6.03542 20.6127 6.01521 20.904 6.18643 21.0875C6.31185 21.2389 6.5306 21.2873 6.70437 21.2197Z"
				fill="white"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M36.0326 17.8763L34.8516 19.6108C36.3855 21.236 38.4258 22.0487 40.9722 22.0487C42.8538 22.0487 44.3111 21.611 45.3441 20.736C46.3871 19.8505 46.9087 18.7306 46.9087 17.3762C46.9087 16.5637 46.7349 15.8605 46.3871 15.2666C46.0396 14.6728 45.5894 14.2197 45.0373 13.9071C44.4953 13.5842 43.8869 13.3133 43.2119 13.0945C42.547 12.8758 41.8772 12.6934 41.2023 12.5476C40.5376 12.3913 39.9291 12.2298 39.3767 12.0632C38.8348 11.8861 38.39 11.6465 38.0423 11.3443C37.6945 11.0318 37.5207 10.6516 37.5207 10.2036C37.5207 9.5056 37.8276 8.9274 38.441 8.46903C39.0547 8.00023 39.8676 7.76581 40.8802 7.76581C41.8414 7.76581 42.7159 7.94817 43.5033 8.3128C44.301 8.667 44.935 9.13579 45.4054 9.71917L46.4945 8.06277C45.0628 6.56259 43.1913 5.8125 40.8802 5.8125C39.1314 5.8125 37.7558 6.2396 36.7536 7.09386C35.7515 7.93775 35.2504 8.99512 35.2504 10.2661C35.2504 11.037 35.4241 11.7038 35.7719 12.2663C36.1196 12.8185 36.5696 13.2456 37.1217 13.5477C37.6741 13.8498 38.2826 14.1051 38.9473 14.3134C39.6222 14.5217 40.2921 14.7041 40.9569 14.8603C41.6216 15.0166 42.2301 15.1885 42.7823 15.376C43.3345 15.5636 43.7844 15.8292 44.1322 16.173C44.4799 16.5167 44.6537 16.9387 44.6537 17.4388C44.6537 18.2305 44.3317 18.8712 43.6873 19.3608C43.0534 19.8505 42.1686 20.0952 41.0334 20.0952C40.0416 20.0952 39.0956 19.8817 38.1957 19.4546C37.2957 19.0275 36.5747 18.5014 36.0326 17.8763ZM49.487 6.20315V17.1106C49.487 20.4025 51.0977 22.0487 54.3191 22.0487C55.3831 22.0487 56.3901 21.8038 57.341 21.3141C58.292 20.8245 59.0849 20.215 59.7188 19.4858V21.658H62.0815V6.20315H59.7188V17.5637C59.2586 18.2201 58.6196 18.7722 57.8013 19.2202C56.9835 19.6681 56.1346 19.8921 55.2551 19.8921C54.1403 19.8921 53.2915 19.6317 52.7084 19.1108C52.1254 18.5795 51.8341 17.6679 51.8341 16.3761V6.20315H49.487ZM65.534 21.658V6.20315H67.8812V8.67218C68.5357 7.81792 69.2975 7.13555 70.1666 6.62507C71.0357 6.10422 71.9613 5.84377 72.9434 5.84377V8.3128C72.5749 8.27111 72.2733 8.25026 72.038 8.25026C71.312 8.25026 70.5248 8.50548 69.6759 9.01596C68.827 9.51602 68.2289 10.0838 67.8812 10.7193V21.658H65.534ZM74.7086 9.84419C74.0748 11.0735 73.7576 12.4278 73.7576 13.9071C73.7576 16.3136 74.4837 18.2722 75.9358 19.7827C77.3879 21.2933 79.2489 22.0487 81.5194 22.0487C83.9329 22.0487 85.9426 21.2465 87.5482 19.6421L86.4282 18.0795C85.8146 18.7149 85.0938 19.2045 84.2656 19.5483C83.4473 19.8921 82.5932 20.064 81.7034 20.064C80.1289 20.064 78.8504 19.5536 77.8683 18.5326C76.8971 17.5117 76.3654 16.2407 76.2732 14.7197H88.5297V14.1102C88.5297 12.5476 88.2437 11.1464 87.671 9.90667C87.1087 8.65657 86.2697 7.66164 85.1554 6.92197C84.0402 6.18231 82.7368 5.8125 81.2432 5.8125C79.8216 5.8125 78.5384 6.17712 77.3931 6.90637C76.2478 7.62519 75.3528 8.60446 74.7086 9.84419ZM86.1981 12.9226H76.2426C76.2732 12.3184 76.4012 11.7246 76.6261 11.1412C76.851 10.5474 77.1578 10.0005 77.5465 9.50041C77.945 8.98993 78.4617 8.57843 79.0961 8.26587C79.7299 7.95336 80.4357 7.79708 81.2126 7.79708C82.0413 7.79708 82.7824 7.9586 83.4369 8.28153C84.0915 8.59404 84.6133 9.00554 85.002 9.51602C85.3902 10.0265 85.682 10.5734 85.8758 11.1568C86.0805 11.7402 86.1878 12.3288 86.1981 12.9226Z"
				fill="#334155"
			/>
			<path
				d="M104.19 21.6529V10.3435L99.7628 21.6529H98.3024L93.8755 10.3435V21.6529H90.5312V5.9375H95.2178L99.0326 15.739L102.847 5.9375H107.557V21.6529H104.19Z"
				fill="#334155"
			/>
			<path
				d="M121.677 21.6529L120.688 18.9433H113.67L112.682 21.6529H109.008L115.084 5.9375H119.275L125.327 21.6529H121.677ZM117.18 8.83555L114.566 16.0453H119.77L117.18 8.83555Z"
				fill="#334155"
			/>
			<path
				d="M126.773 21.6529V5.9375H130.117V21.6529H126.773Z"
				fill="#334155"
			/>
			<path
				d="M131.602 21.6529V5.9375H134.946V18.7077H141.587V21.6529H131.602Z"
				fill="#334155"
			/>
		</g>
		<defs>
			<clipPath id="clip0_17611_13696">
				<rect width="142" height="28" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const SureMailIcon = ( props ) => (
	<svg
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M23.25 0H0.75C0.335787 0 0 0.335787 0 0.75V23.25C0 23.6642 0.335787 24 0.75 24H23.25C23.6642 24 24 23.6642 24 23.25V0.75C24 0.335787 23.6642 0 23.25 0Z"
			fill="#0D7EE8"
		/>
		<path
			d="M6.40292 11.6635C6.61165 11.8145 6.90801 11.7649 7.04455 11.5618C7.19552 11.3531 7.14591 11.0567 6.94285 10.9202L4.93281 9.48016C4.86137 9.42507 4.8676 9.35611 4.87071 9.32164C4.87386 9.28718 4.90015 9.22703 4.98662 9.19317L18.3609 5.78333C18.4386 5.76953 18.4844 5.80148 18.5157 5.83906C18.547 5.87667 18.5784 5.91424 18.5433 5.99446L13.476 18.8162C13.4409 18.8964 13.3776 18.9045 13.3488 18.9158C13.3143 18.9127 13.2454 18.9065 13.2028 18.8401L11.6711 16.0326C11.6228 15.9518 11.5833 15.8509 11.535 15.7701C10.9355 14.4093 10.7842 13.4051 11.9093 12.416L14.806 9.73531C15.0027 9.55853 15.0221 9.26839 14.8509 9.08611C14.6742 8.88942 14.384 8.87007 14.2017 9.04118L11.1593 11.6635C9.62635 13.0119 9.88161 14.6891 10.8516 16.4865L12.3833 19.294C12.5789 19.6661 12.9769 19.8759 13.4023 19.8589C13.5145 19.8482 13.6354 19.8175 13.7363 19.778C14.0101 19.6707 14.2244 19.4538 14.3471 19.1731L19.4144 6.35138C19.5666 5.97597 19.495 5.53861 19.2242 5.22916C18.9534 4.91967 18.5405 4.79884 18.1432 4.88794L4.7545 8.30341C4.34849 8.41257 4.04151 8.73226 3.95519 9.14836C3.86882 9.56446 4.04691 9.97673 4.39289 10.2235L6.40292 11.6635Z"
			fill="white"
		/>
		<path
			d="M5.76973 15.5256C5.80738 15.5108 5.85264 15.4786 5.88538 15.4513L7.90981 13.6745C8.08107 13.5206 8.09791 13.268 7.94892 13.1093C7.79502 12.9381 7.54246 12.9212 7.38376 13.0702L5.35929 14.847C5.18806 15.0009 5.17123 15.2535 5.32018 15.4122C5.43425 15.5557 5.60664 15.5894 5.76973 15.5256Z"
			fill="white"
		/>
		<path
			d="M5.51088 18.3676C5.54857 18.353 5.59394 18.321 5.62672 18.2938L9.0673 15.2807C9.23898 15.1273 9.25653 14.8748 9.10799 14.7156C8.95458 14.544 8.70205 14.5264 8.54294 14.6749L5.10235 17.688C4.93068 17.8414 4.91313 18.0939 5.06167 18.253C5.17045 18.3843 5.36017 18.4262 5.51088 18.3676Z"
			fill="white"
		/>
	</svg>
);

export const WelcomeImage = ( props ) => (
	<svg
		width="200"
		height="230"
		viewBox="0 0 200 230"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M99.4739 49.2188C97.5128 49.2188 4.05469 117.125 4.05469 117.125L99.5299 177.187L195.005 117.125C194.949 117.125 101.435 49.2188 99.4739 49.2188Z"
			fill="#7DD3FC"
		/>
		<path
			d="M98.8599 48.4922C98.3556 48.5482 97.8513 48.7723 97.4591 49.0525C96.7868 49.4447 96.1144 49.8929 95.386 50.3411C92.9767 51.9659 90.5674 53.5908 88.2141 55.2716C80.538 60.5943 72.9179 66.0291 65.3539 71.4638C56.221 77.9631 47.0881 84.5184 38.0112 91.1297C30.167 96.7886 22.2668 102.503 14.4226 108.162C10.6125 110.908 6.80247 113.597 3.04846 116.399L2.88037 116.511C2.65625 116.623 2.60022 116.959 2.71228 117.183C2.76831 117.295 2.82434 117.351 2.9364 117.407L12.4055 123.402L35.2097 137.745L62.7765 155.114L86.5893 170.13C90.4554 172.539 94.3214 175.004 98.1315 177.413L98.2996 177.525C98.8599 177.862 99.8684 178.198 100.485 177.806L110.01 171.811L132.814 157.467L160.437 140.099L184.25 125.139C188.116 122.73 192.038 120.377 195.792 117.855L195.96 117.743C196.352 117.519 196.24 117.127 195.904 116.903L186.491 110.067C178.927 104.633 171.419 99.1418 163.855 93.707C154.722 87.1517 145.589 80.5964 136.456 74.0411C128.556 68.3822 120.6 62.7234 112.587 57.1205C109.954 55.2716 107.264 53.4227 104.575 51.6298C103.23 50.6213 101.829 49.7248 100.373 48.9404C99.9805 48.7163 99.5322 48.6042 99.084 48.6042C98.6918 48.6042 97.8513 48.6603 97.9634 49.2205C98.0754 49.7808 99.14 50.005 99.5882 50.005C99.2521 50.005 98.9719 49.9489 98.6918 49.7808C98.7478 49.8369 98.8599 49.8369 98.9159 49.8929L99.196 50.061L99.3641 50.173C99.196 50.061 99.6443 50.3411 99.3641 50.173C100.093 50.6213 100.821 51.1255 101.549 51.6298C104.015 53.2546 106.424 54.9354 108.889 56.6723C116.565 62.051 124.185 67.4858 131.862 72.9205C140.938 79.4198 150.015 85.9191 159.036 92.4184C166.824 98.0212 174.613 103.624 182.401 109.283L190.021 114.83L192.374 116.567C192.766 116.903 193.158 117.183 193.607 117.463C193.663 117.519 193.719 117.519 193.775 117.575L193.719 116.735L184.194 122.73L161.389 137.073L133.767 154.442L110.066 169.233L102.278 174.164C101.045 174.948 99.7003 175.676 98.5237 176.517L98.3556 176.629L100.541 176.909L91.0717 170.914L68.2674 156.571L40.7007 139.202L16.8879 124.186L9.04367 119.256L6.57836 117.687C6.18615 117.351 5.7379 117.127 5.28966 116.903C5.23363 116.847 5.1776 116.847 5.12157 116.791L5.1776 117.631L14.4786 110.908C21.9306 105.529 29.3826 100.094 36.8346 94.7156C45.9115 88.1602 54.9883 81.661 64.0652 75.1056C71.9654 69.4468 79.9217 63.7879 87.878 58.1851C91.9121 55.3276 95.9463 52.3581 100.205 49.8369C100.597 49.6128 100.149 49.8369 99.9805 49.8369C100.485 49.8369 100.989 49.5007 100.653 48.9964C100.317 48.4922 99.4202 48.4922 98.8599 48.4922Z"
			fill="#7DD3FC"
		/>
		<path
			d="M82.5547 146.989C82.5547 146.989 110.346 106.873 126.594 116.566C127.827 117.294 128.892 118.246 129.788 119.367L129.732 118.919C129.732 118.919 158.812 162.621 153.433 184.584C148.67 203.97 131.245 208.9 120.879 174.723C108.553 170.129 87.9336 155.785 82.5547 146.989Z"
			fill="white"
		/>
		<path
			d="M83.6787 147.773L83.9028 147.492L84.0149 147.324L84.351 146.82C85.0794 145.812 85.8639 144.803 86.5922 143.851C89.0576 140.601 91.691 137.463 94.3804 134.438C97.6862 130.74 101.216 127.266 105.026 124.073C108.5 121.215 112.31 118.526 116.624 117.069C118.361 116.453 120.21 116.173 122.059 116.229C122.115 116.229 122.115 116.229 122.171 116.229L122.451 116.285C122.676 116.285 122.956 116.341 123.18 116.397C123.628 116.453 124.076 116.565 124.469 116.733C124.244 116.677 124.749 116.845 124.861 116.845C125.085 116.957 125.309 117.013 125.533 117.125C125.757 117.237 125.925 117.293 126.093 117.405C126.262 117.517 125.981 117.293 126.262 117.517C126.542 117.741 126.71 117.797 126.934 117.966C127.718 118.526 128.447 119.254 129.063 119.983C129.623 120.655 131.136 120.767 130.968 119.534L130.912 119.086L128.783 119.254C129.96 120.991 131.08 122.84 132.145 124.633C134.834 129.059 137.355 133.541 139.765 138.136C142.79 143.851 145.424 149.734 147.777 155.729C150.018 161.612 151.923 167.607 152.596 173.882C152.932 176.515 152.932 179.148 152.596 181.782C152.203 184.359 151.475 186.936 150.354 189.346C149.458 191.475 148.225 193.38 146.712 195.061C145.48 196.461 143.911 197.526 142.118 198.142C141.894 198.198 141.67 198.254 141.446 198.31C141.334 198.366 141.502 198.31 141.502 198.31L141.334 198.366L140.997 198.422C140.549 198.478 140.101 198.534 139.653 198.534H139.317H139.148H139.204C138.98 198.534 138.7 198.478 138.476 198.422C138.252 198.366 138.028 198.366 137.86 198.31L137.524 198.254L137.355 198.198C137.131 198.142 137.468 198.254 137.355 198.198C136.851 198.03 136.403 197.862 135.955 197.638L135.619 197.47L135.394 197.358L135.17 197.246L134.722 196.965C134.218 196.629 133.77 196.293 133.321 195.901C133.041 195.677 133.377 195.957 133.209 195.789L132.817 195.453C132.593 195.229 132.369 195.004 132.089 194.78C131.584 194.276 131.136 193.716 130.688 193.212C130.688 193.212 130.464 192.931 130.576 193.1L130.52 192.987C130.408 192.819 130.296 192.651 130.184 192.483C129.96 192.147 129.735 191.867 129.511 191.531C128.503 190.074 127.606 188.505 126.766 186.936C125.869 185.143 125.029 183.239 124.3 181.39C123.852 180.269 123.46 179.204 123.068 178.084C122.9 177.524 122.676 176.963 122.508 176.459C122.339 175.787 122.115 175.058 121.835 174.442C121.331 173.658 120.154 173.378 119.314 173.041C118.473 172.705 117.801 172.425 117.073 172.033C115.448 171.305 113.879 170.464 112.31 169.624C108.892 167.775 105.586 165.702 102.337 163.517C96.3415 159.483 90.3463 155 85.5837 149.509C85.3596 149.229 85.1355 148.949 84.9113 148.669C84.8553 148.613 84.8553 148.557 84.7993 148.501C84.6312 148.333 84.9113 148.669 84.7993 148.501L84.5191 148.109C84.1269 147.605 83.7907 147.1 83.4546 146.596C83.1184 146.092 82.39 145.587 81.7737 145.812C81.1573 146.036 81.2694 146.876 81.5495 147.38C82.9503 149.509 84.5752 151.527 86.4242 153.263C88.7774 155.561 91.2427 157.746 93.8201 159.763C99.3671 164.189 105.306 168.111 111.526 171.529C114.495 173.153 117.521 174.61 120.715 175.787L119.706 174.778C121.667 181.109 124.132 187.553 128.054 192.931C130.52 196.293 133.657 199.431 137.748 200.607C140.829 201.448 144.135 200.775 146.712 198.814C149.682 196.629 151.699 193.268 153.044 189.962C154.669 185.928 155.453 181.614 155.229 177.243C155.005 172.313 153.884 167.439 152.428 162.732C149.402 152.759 144.864 143.234 139.877 134.046C137.019 128.835 134.106 123.624 130.8 118.694L130.632 118.47C130.352 117.966 129.791 117.629 129.231 117.629C128.783 117.685 128.447 118.078 128.503 118.526C128.503 118.582 128.503 118.582 128.503 118.638L128.559 119.086L130.464 118.638C127.326 114.772 122.227 113.035 117.409 114.156C112.87 115.164 108.836 117.629 105.194 120.375C101.16 123.512 97.406 126.986 93.9322 130.74C90.9066 133.934 88.1051 137.295 85.4156 140.769C84.5191 141.89 83.6787 143.066 82.8382 144.187C82.334 144.803 81.8857 145.419 81.4935 146.092C81.4935 146.148 81.4375 146.148 81.4375 146.148C81.0453 146.708 81.6616 147.548 82.1098 147.885C82.5021 148.277 83.1744 148.277 83.5666 147.829C83.6226 147.885 83.6226 147.829 83.6787 147.773Z"
			fill="#082F49"
		/>
		<path
			d="M143.118 106.146C148.553 86.5357 136.675 79.196 127.878 77.179C119.082 75.1619 112.638 77.6832 110.397 81.157C108.716 83.7343 112.918 101.159 112.918 101.159L126.253 117.295C126.197 117.239 138.972 121.105 143.118 106.146Z"
			fill="#082F49"
		/>
		<path
			d="M103.057 108.219C98.5751 100.992 110.341 84.5195 110.341 84.5195C113.703 84.5755 119.642 82.7266 119.642 82.7266C115.888 92.1393 126.814 97.2939 126.814 97.2939C130.288 92.5315 136.059 95.7251 134.602 100.824C133.146 105.922 128.103 105.418 128.103 105.418C128.103 105.418 127.991 118.697 127.038 120.658C127.038 120.658 117.401 124.748 113.703 116.175C113.703 116.232 106.083 113.094 103.057 108.219Z"
			fill="white"
		/>
		<path
			d="M104.24 107.549C103.456 106.204 103.288 104.411 103.456 102.787C103.68 100.826 104.184 98.8646 104.913 97.0717C106.313 93.5419 108.05 90.1802 110.123 87.0426C110.572 86.3703 111.02 85.6419 111.524 84.9696L109.955 85.6419C113.317 85.6979 116.791 84.7455 119.985 83.7369L118.36 82.6164C117.071 85.81 117.351 89.4518 119.2 92.3653C120.545 94.4384 122.394 96.1752 124.523 97.4639C125.027 97.8001 125.588 98.0802 126.148 98.3603C126.82 98.5845 127.549 98.3603 127.997 97.8001C128.445 97.1838 129.006 96.6795 129.678 96.3433C130.126 96.1752 130.574 96.1192 131.079 96.1752C131.583 96.2873 132.087 96.5114 132.423 96.9036C132.816 97.2958 133.096 97.744 133.264 98.3043C133.656 99.7611 133.376 101.386 132.479 102.618C132.311 102.843 132.143 103.067 131.919 103.235L131.527 103.571C131.471 103.627 131.359 103.739 131.247 103.739C131.135 103.795 130.967 103.907 130.855 103.963C130.742 104.019 130.518 104.131 130.742 104.019C130.462 104.131 130.182 104.243 129.902 104.299C129.79 104.355 129.51 104.355 129.79 104.355L129.398 104.411C129.174 104.411 128.95 104.467 128.725 104.467C128.277 104.523 128.95 104.467 128.613 104.467H128.445C127.773 104.411 126.708 104.86 126.652 105.7C126.596 109.846 126.54 114.048 126.092 118.138C126.036 118.699 125.98 119.259 125.868 119.819C125.868 119.931 125.812 120.043 125.812 120.155C125.868 119.931 125.812 120.155 125.812 120.211C125.756 120.379 125.7 120.492 125.644 120.66L126.652 119.819C126.428 119.931 126.148 119.987 125.924 120.099C125.7 120.211 125.42 120.267 125.139 120.323L124.691 120.436C124.299 120.492 124.635 120.436 124.691 120.436L124.411 120.492C124.019 120.548 123.627 120.604 123.234 120.66C123.01 120.66 122.786 120.716 122.618 120.716H122.338C122.17 120.716 122.17 120.716 122.338 120.716H122.114C121.217 120.716 120.321 120.548 119.48 120.267C118.528 119.931 117.631 119.371 116.903 118.643C116.511 118.194 116.119 117.746 115.782 117.242C115.39 116.626 115.166 115.617 114.438 115.337C113.261 114.833 112.084 114.216 110.908 113.544C108.33 111.975 105.865 110.07 104.24 107.549C103.512 106.484 100.991 107.661 101.831 108.95C103.456 111.527 105.977 113.432 108.499 114.945C109.955 115.841 111.412 116.57 112.981 117.242L112.365 116.682C113.709 119.707 116.063 121.836 119.312 122.565C121.61 122.957 123.907 122.845 126.148 122.172C126.54 122.06 126.932 121.948 127.325 121.78C128.501 121.276 128.613 120.099 128.781 119.035C129.118 116.457 129.286 113.824 129.342 111.191C129.398 109.286 129.454 107.325 129.454 105.42L127.661 106.653C130.406 106.877 133.096 105.644 134.721 103.459C135.897 101.778 136.57 99.4809 135.897 97.4639C135.281 95.727 133.824 94.4384 131.975 94.1022C129.454 93.654 127.101 95.1107 125.644 97.0717L127.549 96.4554C127.381 96.3994 127.829 96.6235 127.717 96.5674C127.661 96.5114 127.549 96.5114 127.493 96.4554C127.213 96.3433 126.988 96.1752 126.764 96.0072C125.924 95.5029 125.139 94.9426 124.411 94.3263C122.562 92.8135 120.881 90.6284 120.377 88.1072C120.041 86.3703 120.265 84.5774 120.937 82.9526C121.329 81.944 120.041 81.6079 119.312 81.832C116.903 82.6724 114.382 83.2327 111.86 83.5128C110.908 83.6249 109.843 83.4008 109.171 84.2412C109.115 84.2972 109.059 84.4093 109.003 84.4653C108.667 84.9696 108.33 85.4738 107.938 86.0341C105.081 90.4604 102.391 95.3348 101.159 100.489C100.486 103.291 100.262 106.428 101.775 109.006C102.559 110.014 105.025 108.838 104.24 107.549Z"
			fill="#082F49"
		/>
		<path
			d="M120.709 103.566C120.709 103.734 120.709 103.902 120.709 104.126V103.902C120.709 104.63 120.597 105.415 120.317 106.087L120.373 105.863C120.317 106.087 120.205 106.255 120.093 106.423C120.093 106.479 120.037 106.479 120.037 106.535C119.925 106.703 120.205 106.367 120.037 106.479C119.981 106.535 119.925 106.591 119.813 106.703L119.757 106.759C119.645 106.815 119.981 106.647 119.869 106.703C119.813 106.703 119.757 106.759 119.757 106.759L119.701 106.815C119.589 106.871 119.813 106.759 119.813 106.759C119.813 106.759 119.701 106.815 119.645 106.815H119.589C119.421 106.871 119.813 106.815 119.757 106.815H119.477C119.309 106.815 119.589 106.815 119.645 106.815C119.701 106.815 119.533 106.815 119.421 106.759C119.365 106.759 119.253 106.703 119.197 106.703C119.028 106.647 119.421 106.815 119.309 106.759L119.197 106.703C119.028 106.647 118.804 106.535 118.636 106.423C118.188 106.199 117.572 106.311 117.235 106.703C116.955 107.207 117.348 107.6 117.74 107.824C118.524 108.272 119.421 108.44 120.261 108.328C120.933 108.216 121.494 107.824 121.886 107.264C122.39 106.423 122.67 105.471 122.67 104.462C122.67 104.182 122.67 103.846 122.67 103.566C122.614 103.342 122.502 103.117 122.278 103.005C122.054 102.837 121.774 102.781 121.494 102.781C120.989 102.781 120.541 103.061 120.597 103.566H120.709Z"
			fill="#082F49"
		/>
		<path
			d="M111.583 95.2188C109.454 96.2273 107.213 96.9556 104.859 97.3478C97.0153 98.7485 96.1188 101.494 98.5841 103.007C101.049 104.519 111.695 103.231 111.695 103.231"
			fill="white"
		/>
		<path
			d="M110.405 94.489C108.052 95.7776 105.362 96.2258 102.729 96.7861C101.104 97.0663 99.535 97.5705 98.0222 98.3549C97.2938 98.7471 96.4534 99.3074 96.1732 100.148C95.5569 102.053 98.3584 103.51 99.7591 103.902C102.112 104.63 104.746 104.462 107.155 104.35C109.06 104.238 110.965 104.126 112.814 103.902C113.262 103.846 112.254 103.061 112.198 103.005C111.694 102.613 111.133 102.445 110.517 102.445H110.349L109.452 102.557C108.5 102.669 107.491 102.725 106.539 102.781C104.298 103.005 102 103.005 99.7591 102.781C99.535 102.781 99.3109 102.725 99.0868 102.669C99.0307 102.669 98.7506 102.613 98.8627 102.613C98.9747 102.613 98.6946 102.557 98.6385 102.557C98.8066 102.613 98.8066 102.613 98.6385 102.557C98.6946 102.613 99.1428 102.837 98.9747 102.725C99.0868 102.837 99.1428 102.837 98.9747 102.725C99.1428 102.893 98.9747 102.725 98.9187 102.669C98.8627 102.613 98.9747 102.725 98.8627 102.613C98.8066 102.557 98.8066 102.501 98.7506 102.445C98.7506 102.445 98.6385 102.221 98.6385 102.165C98.5825 101.941 98.5825 101.661 98.6946 101.436C99.0307 100.708 99.6471 100.148 100.432 99.8117C101.776 99.1393 103.177 98.6911 104.578 98.4109C107.323 97.7946 110.181 97.3464 112.702 96.0578C113.094 95.8336 112.198 95.2734 112.086 95.1613C111.694 94.8251 110.797 94.2649 110.405 94.489Z"
			fill="#082F49"
		/>
		<path
			d="M116.288 94.2114C116.288 94.2114 115.055 94.1553 115.111 95.3319C115.167 96.5085 116.624 96.5085 116.904 95.444C117.072 94.9958 116.848 94.4355 116.4 94.2674C116.344 94.2114 116.344 94.2114 116.288 94.2114Z"
			fill="#082F49"
		/>
		<path
			d="M108.608 91.8598C108.608 91.8598 107.376 91.8038 107.432 92.9804C107.488 94.157 108.944 94.157 109.225 93.0924C109.393 92.6442 109.168 92.0839 108.72 91.9158C108.664 91.8598 108.664 91.8598 108.608 91.8598Z"
			fill="#082F49"
		/>
		<path
			d="M135.105 110.403C135.386 112.196 135.946 113.933 136.674 115.614C137.627 117.855 139.364 120.376 142.165 119.76C144.182 119.312 145.919 117.855 147.152 116.286C148.048 115.166 148.833 113.653 148.553 112.14C148.048 109.563 145.191 108.61 142.95 109.675C139.196 111.468 139.644 116.006 140.876 119.312C141.661 121.385 142.781 123.29 144.238 124.915C145.359 126.147 146.76 127.436 148.384 127.996C151.522 129.061 154.828 126.203 154.492 122.954C154.324 120.881 152.643 119.312 150.794 118.527C148.665 117.575 146.199 117.855 144.35 119.312C142.109 121.217 142.725 124.074 143.79 126.483C144.238 127.492 144.799 128.444 145.359 129.397C145.807 130.069 148.16 128.556 147.712 127.884C146.76 126.427 145.975 124.859 145.471 123.178C145.191 122.281 145.135 121.273 145.359 120.32C145.415 120.208 145.415 120.152 145.471 120.04C145.527 119.928 145.359 120.208 145.527 119.984L145.639 119.76C145.359 120.152 145.863 119.592 145.583 119.816C145.303 120.04 145.527 119.872 145.583 119.816C145.751 119.704 145.359 119.928 145.415 119.928C145.471 119.872 145.583 119.816 145.639 119.816C145.359 119.872 145.527 119.872 145.695 119.816L145.975 119.76H146.143H146.367C148.497 119.76 150.402 120.881 151.522 122.674C151.914 123.402 152.082 124.242 151.97 125.027C151.858 125.587 151.634 126.091 151.354 126.595C151.41 126.539 151.354 126.539 151.41 126.539C151.242 126.652 151.858 126.259 151.578 126.427C151.69 126.371 151.746 126.371 151.634 126.371C151.522 126.371 151.466 126.371 151.354 126.371C150.065 126.371 148.833 125.531 147.936 124.747C146.592 123.626 145.471 122.225 144.574 120.713C143.51 119.032 142.781 117.183 142.445 115.222C142.221 113.933 142.109 112.14 142.781 111.132C142.781 111.076 143.006 110.739 142.894 110.964C142.95 110.908 142.95 110.852 143.006 110.852C143.006 110.852 142.781 111.02 142.95 110.908C143.118 110.796 142.837 110.964 142.894 110.964C142.725 111.076 142.837 111.02 142.894 110.964C142.613 111.132 142.781 110.964 142.894 110.964C143.118 110.964 142.725 110.964 142.95 110.964H143.118C142.95 110.964 143.286 110.964 143.118 110.964C143.342 110.964 143.51 110.964 143.734 111.02C145.415 111.412 146.423 113.037 146.087 114.717C146.031 114.942 145.975 115.222 145.807 115.446C145.527 116.062 145.135 116.622 144.63 117.071C144.406 117.295 144.182 117.463 143.958 117.687C144.07 117.575 143.51 117.967 143.734 117.855C143.958 117.743 143.23 118.079 143.566 117.967C143.51 117.967 143.23 118.079 143.286 118.079C143.342 118.079 143.062 118.135 143.006 118.135C142.95 118.135 142.837 118.135 142.781 118.135C142.669 118.135 142.501 118.135 142.389 118.079C141.997 117.967 141.605 117.799 141.213 117.519C140.428 116.847 139.756 115.95 139.308 114.998C138.467 113.317 137.907 111.524 137.515 109.675L137.459 109.339C137.403 108.33 134.993 109.619 135.105 110.403Z"
			fill="#082F49"
		/>
		<path
			d="M81.1562 145.031L120.77 164.137L81.6045 176.295L81.1562 145.031Z"
			fill="#082F49"
		/>
		<path
			d="M84.7398 131.077L81.6021 176.292L41.1484 156.29L42.6052 110.234L84.7398 131.077Z"
			fill="#082F49"
		/>
		<path
			d="M67.5367 141.33C67.0324 139.817 65.6316 138.752 64.0628 138.752C62.55 138.696 61.0932 139.593 60.1407 140.713C59.0761 141.946 58.2357 143.571 58.2917 145.308C58.4038 146.821 59.1882 148.221 60.4769 149.062C61.7095 149.79 63.0543 150.294 64.511 150.462C65.2394 150.63 66.0239 150.238 66.248 149.454C66.4721 148.726 66.0239 147.941 65.2955 147.717C64.6791 147.605 64.1188 147.493 63.5025 147.325L63.0543 147.157C62.9982 147.157 62.55 146.933 62.8301 147.101C62.606 146.989 62.3259 146.877 62.1017 146.709C62.0457 146.652 61.6535 146.372 61.9337 146.596C61.8216 146.484 61.7095 146.428 61.5975 146.316C61.5414 146.26 61.3734 145.98 61.5414 146.26C61.4294 146.148 61.3734 145.98 61.3173 145.868C61.2613 145.756 61.2613 145.756 61.3173 145.868C61.2613 145.812 61.2613 145.7 61.2613 145.644C61.2613 145.532 61.2053 145.476 61.2053 145.364C61.2053 145.476 61.2053 145.476 61.2053 145.364C61.2053 145.196 61.2053 145.028 61.2053 144.86C61.2053 145.084 61.2613 144.579 61.2613 144.523C61.4294 143.851 61.7656 143.291 62.1578 142.73C61.9897 142.899 62.3259 142.506 62.3819 142.506C62.4379 142.506 62.55 142.282 62.662 142.226C62.7741 142.17 63.1103 141.89 62.8862 142.002C63.0543 141.89 63.1663 141.834 63.3344 141.722C63.5585 141.554 63.2223 141.722 63.5025 141.666C63.5585 141.666 64.1188 141.554 63.7266 141.554C63.8947 141.554 64.0628 141.554 64.1749 141.554C63.8387 141.554 64.2869 141.61 64.399 141.61C64.7352 141.666 64.2309 141.498 64.511 141.61C64.5671 141.666 64.9593 141.946 64.7352 141.722C64.7912 141.778 65.0153 142.114 64.9032 141.834C64.9593 141.89 64.9593 141.946 65.0153 142.058C64.9593 141.89 64.9593 141.89 65.0153 142.058C65.2394 142.787 65.9678 143.235 66.7522 143.011C67.3686 142.787 67.8168 142.002 67.5367 141.33Z"
			fill="white"
		/>
		<path
			d="M82.891 148.051C82.891 148.499 82.891 148.724 82.891 149.284C82.891 150.012 82.8349 150.685 82.8349 151.413C82.7229 153.374 82.6668 155.335 82.5548 157.296C82.3307 161.498 82.0505 165.7 81.7704 169.902C81.6583 171.247 81.6023 172.648 81.4342 173.992C81.3221 174.945 83.3392 175.337 83.5073 174.441C83.9555 171.359 84.0116 168.221 84.2357 165.084C84.5158 160.826 84.74 156.568 84.9081 152.253C84.9641 150.853 85.0201 149.452 85.0201 148.107C85.0201 147.267 82.947 146.987 82.891 148.051Z"
			fill="white"
		/>
		<path
			d="M106.362 163.237C105.689 162.789 104.905 162.396 104.176 162.004C102.552 161.108 100.927 160.211 99.3018 159.315L88.6001 153.432L86.1348 152.087C85.6865 151.863 85.5745 152.479 85.6305 152.76C85.6865 153.264 86.0227 153.712 86.471 153.936C92.186 157.074 97.9571 160.267 103.672 163.405C104.569 163.909 105.521 164.357 106.362 164.918C106.698 165.142 107.034 164.974 107.034 164.581C107.034 164.077 106.81 163.573 106.362 163.237Z"
			fill="white"
		/>
		<path
			d="M98.8618 165.708L87.7118 159.153L86.143 158.257C85.8068 158.032 85.1904 158.032 85.0784 158.481C84.9663 158.929 85.4706 159.433 85.8628 159.601L97.0128 166.157L98.5816 167.109C98.9178 167.333 99.5341 167.333 99.6462 166.885C99.7583 166.437 99.198 165.876 98.8618 165.708Z"
			fill="white"
		/>
		<path
			d="M92.307 168.003L86.76 164.305L85.9756 163.801C85.4714 163.521 84.855 163.689 84.5188 164.137C84.2387 164.529 84.2947 165.09 84.6869 165.37L84.743 165.426L90.2899 169.124L91.0744 169.628C91.5786 169.908 92.195 169.74 92.5311 169.292C92.8113 168.9 92.7553 168.339 92.3631 168.059C92.3631 168.003 92.307 168.003 92.307 168.003Z"
			fill="white"
		/>
		<path
			d="M101.273 159.426C100.937 159.594 101.553 159.314 101.273 159.426L101.049 159.538C100.601 159.707 100.152 159.875 99.7042 160.099C98.4155 160.603 97.1268 161.107 95.7821 161.612C93.0366 162.676 90.2911 163.685 87.4896 164.749L85.5846 165.421C85.3605 165.533 84.52 165.814 84.464 166.15C84.408 166.486 85.1364 166.15 85.2484 166.094C89.8989 164.357 94.6054 162.62 99.2559 160.771C100.152 160.435 101.049 160.099 101.945 159.651C102.057 159.594 102.73 159.202 102.506 159.09C102.282 158.978 101.441 159.37 101.273 159.482V159.426Z"
			fill="white"
		/>
		<path
			d="M99.4739 177.187L4.05469 117.125V228.285H194.949V117.125L99.4739 177.187Z"
			fill="white"
		/>
		<path
			d="M100.653 176.41L91.128 170.415L68.3238 156.072L40.757 138.703L16.8882 123.687L9.04395 118.757L6.57863 117.188C6.18642 116.908 5.73818 116.628 5.28994 116.404C5.23391 116.348 5.17788 116.348 5.12185 116.292C4.72964 116.067 2.76859 117.356 2.76859 117.748V227.228C2.71255 227.732 2.71255 228.236 2.76859 228.74C2.76859 228.796 2.76859 228.853 2.76859 228.909H2.82461H186.043C188.508 228.909 190.974 228.965 193.439 228.909H193.775C194.223 228.909 196.072 227.9 196.072 227.396V118.085C196.128 117.58 196.128 117.076 196.072 116.572C196.072 116.516 196.072 116.46 196.072 116.404C196.072 116.292 194.784 116.964 194.784 116.964L185.258 122.959L162.454 137.302L134.831 154.671L111.019 169.687C107.153 172.096 103.287 174.505 99.4765 176.97L99.3084 177.082C99.1963 177.138 98.1317 177.811 98.2438 177.979C98.3559 178.147 99.4765 177.475 99.5325 177.419L109.058 171.423L131.862 157.08L159.485 139.711L183.297 124.696C187.164 122.287 191.086 119.933 194.84 117.412L195.008 117.3L193.719 117.86V224.594C193.719 225.995 193.607 227.508 193.719 228.909C193.719 228.965 193.719 229.021 193.719 229.077L196.016 227.564H5.85024C5.68215 227.564 5.45803 227.564 5.28994 227.564C5.12185 227.508 5.23391 227.62 5.23391 227.564C5.06582 227.228 5.23391 226.219 5.23391 225.827V116.348L2.88064 117.804L12.4058 123.799L35.21 138.143L62.7768 155.511L86.6456 170.527L94.4898 175.458L96.9551 177.026C97.3473 177.306 97.7956 177.587 98.2438 177.811C98.2998 177.867 98.3559 177.867 98.4119 177.923C98.692 178.091 99.4765 177.475 99.7006 177.362C99.7006 177.306 100.765 176.522 100.653 176.41Z"
			fill="#7DD3FC"
		/>
		<path
			d="M17.3359 220.109C17.3359 220.109 89.2225 155.172 100.036 156.909C110.85 158.646 175.509 216.916 175.509 216.916"
			fill="white"
		/>
		<path
			d="M18.513 220.729C20.6982 218.769 22.8834 216.808 25.0686 214.903C30.4475 210.14 35.8824 205.434 41.3173 200.727C48.153 194.844 55.1007 189.017 62.1044 183.303C68.828 177.868 75.6077 172.489 82.6114 167.447C85.3569 165.486 88.1024 163.581 91.0159 161.788C92.1926 161.059 93.3132 160.387 94.5458 159.771C95.0501 159.491 95.5544 159.21 96.1147 158.986C96.3388 158.874 96.6189 158.762 96.8431 158.65L97.1793 158.482L97.4034 158.37C97.1793 158.426 97.5715 158.314 97.6275 158.314L97.9076 158.202C98.1318 158.146 98.2999 158.09 98.524 157.978C98.7481 157.866 98.8602 157.866 99.0283 157.866C99.0843 157.866 99.1963 157.866 99.2524 157.81C98.9162 157.866 99.3084 157.754 99.2524 157.81L99.7006 157.754C99.9808 157.698 99.5325 157.754 99.5885 157.754C99.6446 157.754 99.7566 157.754 99.8127 157.754C100.261 157.754 99.5885 157.698 99.8687 157.754C100.037 157.81 100.205 157.866 100.373 157.922C100.541 157.978 100.709 158.034 100.877 158.09C101.045 158.146 100.541 157.922 100.933 158.09L101.269 158.258C101.718 158.482 102.166 158.65 102.558 158.874C103.623 159.435 104.687 160.051 105.696 160.723C107.097 161.564 107.937 162.18 109.338 163.188C110.739 164.197 112.195 165.205 113.596 166.27C116.902 168.735 120.152 171.256 123.401 173.834C130.685 179.605 137.801 185.544 144.861 191.595C151.192 196.973 157.524 202.464 163.743 207.955C167.161 210.981 170.579 214.062 173.94 217.088L174.389 217.48C174.949 217.928 175.733 217.984 176.35 217.704C176.742 217.536 176.91 217.088 176.742 216.695C176.686 216.583 176.574 216.471 176.462 216.359C174.052 214.174 171.643 212.045 169.178 209.916C163.351 204.761 157.468 199.663 151.584 194.564C144.469 188.457 137.297 182.406 130.013 176.467C123.738 171.369 117.406 166.326 110.739 161.676C108.497 160.051 106.144 158.594 103.679 157.305C102.11 156.521 100.429 155.737 98.636 155.961C96.5629 156.185 94.6019 157.137 92.8089 158.09C90.2315 159.491 87.7102 161.003 85.2449 162.684C78.4092 167.278 71.8537 172.265 65.4662 177.42C58.1823 183.191 51.0665 189.13 44.0067 195.125C37.9555 200.279 31.9603 205.434 26.0211 210.7C22.8834 213.502 19.6897 216.303 16.552 219.105L16.1038 219.497C15.5995 219.945 15.9917 220.561 16.4399 220.842C17.1683 221.178 17.9527 221.122 18.513 220.729Z"
			fill="#7DD3FC"
		/>
		<path
			d="M118.523 155.17C118.523 155.17 121.213 200.553 140.487 201.73C159.762 202.907 155.391 165.872 142.56 142.396C129.729 118.92 128.329 119.873 128.329 119.873"
			fill="white"
		/>
		<path
			d="M117.352 154.726C117.464 156.912 117.744 159.041 117.968 161.17C118.584 166.156 119.481 171.087 120.657 175.961C122.002 181.396 123.739 186.831 126.484 191.761C128.894 196.075 132.312 200.333 137.13 202.126C141.613 203.807 147.047 203.079 150.297 199.381C153.995 195.235 154.724 189.072 154.78 183.749C154.892 176.409 153.491 169.014 151.53 162.01C150.465 158.2 149.121 154.446 147.608 150.804C145.927 146.938 144.078 143.129 142.005 139.431C138.811 133.66 135.561 127.777 131.751 122.398C131.135 121.446 130.407 120.549 129.622 119.765C129.23 119.317 128.67 118.98 128.053 118.812C127.885 118.756 127.661 118.812 127.493 118.868C126.372 119.597 128.277 121.614 129.23 120.997C128.894 121.109 128.558 121.053 128.277 120.885C128.558 121.053 128.165 120.773 128.165 120.773C128.221 120.829 128.277 120.885 128.389 120.941C128.446 120.997 128.446 120.997 128.502 121.053C128.726 121.221 128.221 120.717 128.446 120.997C128.67 121.278 129.006 121.67 129.286 122.006C129.734 122.566 130.126 123.126 130.519 123.687C130.631 123.855 130.743 124.023 130.855 124.191L130.967 124.359C130.967 124.359 130.799 124.135 130.911 124.303L131.135 124.695C131.415 125.143 131.751 125.648 132.031 126.096C133.824 128.897 135.505 131.811 137.186 134.724C139.371 138.59 141.613 142.456 143.574 146.434C145.198 149.796 146.599 153.27 147.776 156.799C150.185 163.747 151.754 170.919 152.314 178.258C152.707 183.805 152.594 189.968 149.961 195.067C149.009 196.916 147.608 198.485 145.759 199.549C143.798 200.558 141.613 200.95 139.427 200.67C138.923 200.614 138.363 200.502 137.859 200.39C138.139 200.446 137.69 200.334 137.634 200.334L137.298 200.221C137.018 200.109 136.794 200.053 136.514 199.941L136.178 199.773L135.954 199.661C136.122 199.717 135.729 199.549 135.673 199.549C135.617 199.549 135.449 199.437 135.337 199.325C135.113 199.213 134.889 199.045 134.665 198.933C134.553 198.877 134.441 198.821 134.385 198.709L134.217 198.597C134.049 198.485 134.497 198.821 134.217 198.597C133.768 198.26 133.376 197.924 132.984 197.532C132.816 197.364 132.592 197.196 132.424 196.972L132.312 196.86L132.031 196.524C131.639 196.075 131.247 195.627 130.911 195.179C130.743 194.955 130.575 194.731 130.407 194.451C130.351 194.338 130.238 194.226 130.182 194.114L130.07 193.89C129.902 193.666 130.126 193.946 130.014 193.834C127.045 189.408 125.308 184.534 123.851 179.379C123.123 176.802 122.506 174.224 122.002 171.591C121.498 169.238 121.162 167.109 120.825 164.699C120.433 161.842 120.097 158.985 119.873 156.071C119.873 155.959 119.873 155.791 119.873 155.679C119.761 155.007 119.313 154.39 118.64 154.166C118.136 153.998 117.408 154.054 117.464 154.726H117.352Z"
			fill="#082F49"
		/>
		<path
			d="M132.421 152.479C132.421 152.479 135.726 132.869 128.33 133.093C128.33 133.093 127.546 127.715 121.831 129.62C121.831 129.62 119.253 126.258 115.555 126.258C111.857 126.258 103.789 131.861 104.854 135.166C105.918 138.472 114.379 135.502 114.379 135.502C113.594 137.127 113.034 138.808 112.81 140.601C112.81 140.601 105.134 139.817 104.854 143.515C104.574 147.212 109.056 153.824 111.97 153.936C114.883 154.048 114.995 152.031 114.995 152.031C114.995 152.031 115.668 154.216 120.094 156.233C124.52 158.25 132.421 152.479 132.421 152.479Z"
			fill="white"
		/>
		<path
			d="M133.765 152.818C134.157 150.465 134.382 148.056 134.494 145.647C134.662 142.061 134.718 137.859 132.869 134.665C131.972 132.984 130.179 131.92 128.274 131.92L129.731 133.096C129.563 131.92 129.059 130.799 128.274 129.903C126.425 127.774 123.624 127.718 121.102 128.502L123.007 129.006C121.383 126.877 118.973 125.477 116.34 125.084C113.482 124.692 110.569 126.261 108.328 127.83C106.254 129.231 103.565 131.416 103.397 134.105C103.229 136.962 106.479 137.859 108.72 137.747C110.905 137.635 113.09 137.187 115.163 136.402L113.202 134.721C112.306 136.402 111.745 138.251 111.521 140.1L112.81 139.316C111.465 139.204 110.064 139.204 108.72 139.372C106.815 139.596 104.405 140.324 103.677 142.397C103.397 143.518 103.453 144.694 103.845 145.759C104.237 147.104 104.798 148.336 105.526 149.513C106.759 151.586 108.608 153.995 111.073 154.723C113.202 155.396 116.284 154.443 116.396 151.922L113.706 152.09C114.099 152.93 114.659 153.715 115.331 154.331C116.116 155.06 116.956 155.676 117.909 156.18C118.805 156.74 119.814 157.189 120.878 157.413C124.352 158.085 127.994 156.46 130.964 154.779C131.86 154.275 132.701 153.771 133.541 153.155C133.989 152.762 133.989 152.09 133.597 151.698C133.541 151.642 133.485 151.586 133.429 151.53C132.869 151.082 132.084 151.026 131.468 151.418L131.02 151.698L130.515 152.034L130.235 152.202C130.123 152.258 130.235 152.202 130.291 152.202L130.011 152.37C128.779 153.099 127.49 153.771 126.145 154.331C124.856 154.891 123.456 155.228 122.055 155.284C121.831 155.284 121.663 155.284 121.495 155.228C121.327 155.172 121.551 155.228 121.327 155.172C120.934 155.116 120.598 154.947 120.262 154.779C119.365 154.387 118.525 153.827 117.797 153.211C117.292 152.874 116.9 152.37 116.564 151.866C116.508 151.81 116.452 151.698 116.396 151.586C116.62 151.922 116.452 151.698 116.396 151.642L116.34 151.474C115.948 150.241 113.706 150.241 113.65 151.642C113.706 151.082 113.65 151.53 113.594 151.698C113.538 151.866 113.706 151.53 113.538 151.81L113.426 151.978C113.426 152.034 113.538 151.922 113.37 152.034C113.09 152.258 112.81 152.37 112.474 152.37C112.362 152.37 111.801 152.37 111.969 152.37C112.138 152.37 111.409 152.146 111.745 152.314C111.017 151.978 110.401 151.53 109.896 150.913C109.112 150.073 108.496 149.177 107.935 148.224C107.375 147.272 106.927 146.263 106.647 145.255C106.535 144.862 106.423 144.414 106.423 143.966C106.366 143.63 106.366 143.238 106.479 142.901C106.479 142.845 106.535 142.677 106.479 142.901C106.535 142.845 106.535 142.733 106.591 142.677C106.647 142.621 106.703 142.509 106.759 142.453C106.871 142.341 107.039 142.229 107.207 142.117C107.039 142.229 107.487 142.005 107.543 141.949C108.215 141.669 108.944 141.501 109.672 141.389C110.064 141.333 110.401 141.277 110.793 141.277C111.185 141.277 111.577 141.277 111.969 141.277C112.362 141.277 112.698 141.277 113.09 141.333C113.538 141.389 114.267 141.052 114.379 140.548C114.547 139.316 114.827 138.139 115.275 136.962C115.443 136.514 115.611 136.122 115.836 135.73C116.508 134.497 114.827 133.713 113.875 134.049C113.762 134.105 113.65 134.105 113.538 134.161C113.426 134.217 113.09 134.329 113.426 134.217L112.81 134.385C111.857 134.665 110.905 134.889 109.952 135.001C109.504 135.057 109.056 135.113 108.664 135.113C108.384 135.113 108.103 135.113 107.879 135.113H107.263H107.039C107.207 135.113 107.207 135.113 107.039 135.113C106.871 135.113 106.31 134.833 106.647 135.001L106.366 134.833C106.423 134.833 106.647 134.945 106.423 134.833C106.366 134.777 106.142 134.553 106.366 134.777C106.31 134.721 106.254 134.609 106.198 134.553C106.366 134.777 106.198 134.497 106.198 134.441C106.142 134.161 106.198 134.609 106.198 134.329C106.142 133.993 106.198 133.601 106.366 133.265C106.591 132.872 106.815 132.48 107.095 132.088C107.823 131.191 108.664 130.351 109.616 129.679C111.353 128.334 113.538 127.101 115.611 126.877C115.275 126.933 115.611 126.877 115.667 126.877C115.948 126.877 116.228 126.877 116.452 126.933C116.788 126.989 117.068 127.101 117.404 127.213C118.021 127.438 118.581 127.718 119.085 128.11C119.59 128.446 120.038 128.838 120.43 129.287C120.206 129.062 120.598 129.399 120.43 129.287L120.598 129.511L120.71 129.679C121.158 130.239 121.943 130.463 122.615 130.183C123.063 130.015 123.512 129.959 124.016 129.903C124.24 129.903 124.52 129.903 124.744 129.903C124.968 129.903 124.464 129.847 124.856 129.903L125.137 129.959C125.529 130.071 125.024 129.903 125.193 129.959L125.473 130.071C125.529 130.071 125.753 130.239 125.641 130.127C125.529 130.015 125.753 130.239 125.753 130.239C125.865 130.351 125.977 130.463 126.089 130.575C125.977 130.407 126.201 130.687 126.089 130.575L126.257 130.799C126.313 130.911 126.425 131.023 126.481 131.135C126.425 131.023 126.537 131.248 126.481 131.135C126.537 131.191 126.537 131.248 126.593 131.36C126.705 131.584 126.817 131.808 126.873 132.032C126.93 132.2 127.042 132.76 126.986 132.312C126.986 132.368 127.042 132.424 127.042 132.536C127.154 133.265 127.77 133.769 128.498 133.713C128.666 133.713 128.835 133.713 129.003 133.713C129.171 133.713 128.666 133.601 128.947 133.713C129.003 133.713 129.115 133.769 129.171 133.769C129.563 133.881 129.059 133.657 129.339 133.825C129.395 133.881 129.787 134.105 129.619 133.993C129.451 133.881 129.843 134.161 129.899 134.217C130.179 134.441 129.843 134.105 130.011 134.329C130.123 134.441 130.179 134.553 130.291 134.665C130.403 134.777 130.627 135.226 130.459 134.945C130.796 135.618 131.076 136.29 131.244 137.018C131.412 137.803 131.58 138.531 131.636 139.316C131.804 141.165 131.86 143.013 131.748 144.862C131.692 145.703 131.636 146.543 131.58 147.384C131.524 147.888 131.524 147.832 131.524 148.224C131.524 148.616 131.468 148.896 131.412 149.289C131.3 150.073 131.244 150.801 131.076 151.586C131.02 152.258 131.468 152.874 132.14 153.043C132.645 153.715 133.653 153.547 133.765 152.818Z"
			fill="#082F49"
		/>
		<path
			d="M112.586 144.977C112.586 144.977 116.564 148.45 114.883 151.98L112.586 144.977Z"
			fill="white"
		/>
		<path
			d="M111.577 145.869L111.746 146.038L111.914 146.206C112.026 146.318 111.746 146.038 111.858 146.15L112.026 146.318C112.418 146.766 112.81 147.27 113.146 147.83C113.314 148.167 113.539 148.503 113.651 148.839C113.651 148.895 113.763 149.175 113.707 148.951C113.707 149.007 113.763 149.119 113.763 149.175C113.819 149.343 113.875 149.567 113.931 149.735C113.987 149.96 113.987 150.128 113.987 150.352C113.987 150.408 113.987 150.688 113.987 150.576C113.987 150.464 113.987 150.8 113.987 150.8C113.931 151.024 113.931 151.248 113.875 151.416C113.819 151.64 113.931 151.248 113.819 151.528C113.763 151.64 113.707 151.752 113.651 151.921C113.426 152.257 113.539 152.705 113.875 152.929C113.987 152.985 114.155 153.041 114.323 153.041C115.051 153.041 115.668 152.593 116.004 151.977C117.349 149.119 115.724 145.982 113.539 144.021C113.258 143.852 112.978 143.852 112.698 143.909C112.362 143.965 112.026 144.133 111.746 144.413C111.409 144.805 111.073 145.477 111.577 145.869Z"
			fill="#082F49"
		/>
		<path
			d="M126.988 144.47C126.652 146.151 125.811 147.664 124.69 148.953C124.354 149.289 123.962 149.569 123.514 149.793C123.29 149.905 123.066 149.961 122.841 149.905C122.617 149.905 122.841 149.905 122.617 149.905L122.337 149.849C122.393 149.849 122.393 149.849 122.337 149.849C122.057 149.849 122.449 149.905 122.393 149.905C122.337 149.905 122.281 149.849 122.169 149.793C121.889 149.457 122.617 150.073 122.169 149.793C122.057 149.681 121.945 149.569 121.889 149.401C121.833 149.233 121.833 149.345 121.833 149.345C121.777 149.233 121.721 149.177 121.665 149.065C121.273 148.28 121.049 147.44 120.936 146.599C120.768 145.535 120.768 144.414 120.88 143.35C121.049 141.109 121.721 138.923 122.841 136.962C123.402 135.954 124.242 135.17 125.251 134.553C125.419 134.441 125.643 134.329 125.811 134.273C126.091 134.161 126.371 134.105 126.708 134.049C126.539 134.049 126.876 133.993 126.708 134.049H126.932L127.436 133.993C127.716 133.993 127.996 133.993 128.332 134.049C128.893 134.105 129.621 133.881 129.621 133.209C129.621 132.536 128.725 132.144 128.164 132.088C125.419 131.696 122.729 132.76 120.993 134.889C119.424 137.018 118.471 139.54 118.247 142.117C117.967 144.414 118.023 146.992 119.031 149.121C120.152 151.53 123.01 152.538 125.419 151.418C125.531 151.362 125.643 151.306 125.699 151.25C127.772 150.129 129.061 147.44 129.565 145.255C129.957 144.022 127.268 143.238 126.988 144.47Z"
			fill="#082F49"
		/>
		<path
			d="M120.881 129.007C118.08 129.791 115.614 131.472 113.877 133.881C112.253 136.123 111.356 138.812 111.3 141.557C111.244 143.63 111.916 145.759 113.765 146.88C115.895 148.057 118.472 148.001 120.545 146.712C121.049 146.376 120.545 145.983 120.153 145.815C119.536 145.535 118.864 145.535 118.248 145.759C117.968 145.984 117.631 146.152 117.295 146.264C117.127 146.32 116.903 146.376 116.735 146.432C116.623 146.432 116.511 146.432 116.455 146.488C116.623 146.488 116.287 146.488 116.287 146.488C116.007 146.488 116.287 146.488 116.343 146.488L116.119 146.432C116.343 146.488 115.951 146.376 116.007 146.376C115.895 146.32 115.782 146.208 115.67 146.152C114.214 144.975 114.102 142.79 114.27 141.109C114.606 136.907 117.015 133.153 120.657 131.024C121.329 130.632 122.058 130.296 122.842 130.127C123.403 130.015 123.403 129.567 122.954 129.287C122.226 128.951 121.498 128.839 120.881 129.007Z"
			fill="#082F49"
		/>
		<path
			d="M140.988 166.769C139.979 165.033 139.251 163.184 138.411 161.391C137.29 158.925 136.113 156.404 134.881 153.995C134.544 153.211 134.096 152.426 133.536 151.698C133.088 151.194 130.846 152.818 131.183 153.155C131.631 153.771 132.023 154.387 132.303 155.06C132.864 156.18 133.424 157.245 133.928 158.365C135.105 160.83 136.225 163.296 137.402 165.761C137.794 166.545 138.13 167.386 138.579 168.17C138.915 168.73 141.324 167.274 140.988 166.769Z"
			fill="#082F49"
		/>
		<path
			d="M27.8732 166.152C26.3044 166.152 24.5674 166.488 23.5589 167.777C22.6064 169.009 22.5503 170.746 23.5028 172.035C24.4554 173.212 26.1363 173.548 27.481 172.931C28.9938 172.259 29.7222 170.69 30.2265 169.177L27.8172 168.561C28.0413 171.138 30.0584 173.268 32.6357 173.604C35.6614 173.884 36.2217 170.466 36.1656 168.169C36.1096 165.368 34.933 162.902 32.4116 161.502C26.8086 158.644 20.029 160.885 17.1714 166.432C16.7232 167.272 16.387 168.225 16.2189 169.121C15.3225 173.772 17.5637 178.814 21.8219 181.055C24.6234 182.456 27.8732 182.568 30.7868 181.392C33.4202 180.215 35.6614 178.254 37.1742 175.789C37.5104 175.172 37.3983 174.388 36.838 173.884C36.3898 173.492 35.4933 173.324 35.1011 173.884C32.9159 177.246 29.2179 180.047 25.0157 179.487C21.3177 178.982 18.9084 175.901 18.5722 172.315C18.292 168.897 20.085 165.592 23.1106 164.023C24.6235 163.182 26.3043 162.79 27.9853 162.846C29.6101 162.902 31.5712 163.351 32.6918 164.583C33.3081 165.368 33.6443 166.32 33.7003 167.329C33.8124 168.281 33.7003 169.29 33.4202 170.242C33.028 171.138 32.1315 171.026 31.4031 170.578C30.7307 170.13 30.3385 169.346 30.2825 168.561C30.1704 167.441 28.3214 166.6 27.8732 167.945C27.6491 168.785 27.2569 169.57 26.6405 170.186C26.4724 170.354 25.5199 170.914 25.2398 170.522C25.1277 170.354 25.5199 169.682 25.688 169.514C26.3604 168.897 27.425 168.841 28.2654 168.785C30.0023 168.785 29.386 166.152 27.8732 166.152Z"
			fill="#7DD3FC"
		/>
		<path
			d="M44.4562 167.276C42.6072 167.725 41.7107 169.686 41.5426 171.478C41.3185 173.72 42.4952 176.073 44.8484 176.633C46.8655 177.025 48.9386 176.297 50.2273 174.784C51.0117 174 51.2919 172.823 51.0117 171.759C50.6755 170.75 49.2748 169.517 48.1542 169.966C47.2577 170.302 46.9215 171.422 46.9775 172.263C47.0336 173.271 47.4818 174.28 48.2102 175.008C49.723 176.689 52.1883 177.025 54.1494 175.961C56.0544 174.728 57.3991 172.823 57.8474 170.582C58.1275 169.461 57.9034 168.341 57.2871 167.388C56.7268 166.492 55.5502 165.427 54.3735 165.539C53.0848 165.651 53.1409 167.556 53.0288 168.453C52.9167 169.742 53.0848 171.03 53.5891 172.207C54.5416 174.448 56.8949 176.465 59.4162 176.185C60.7609 176.073 59.1921 173.888 58.1836 173.944C55.4941 174.168 55.1019 171.03 55.326 169.013C55.3821 168.677 55.4381 168.397 55.4941 168.061L55.6062 167.725C55.6062 167.725 55.326 167.725 55.3821 167.612C55.3821 167.668 55.4941 167.949 55.4941 168.005C55.5502 168.397 55.5501 168.733 55.4381 169.125C55.1019 170.47 54.4296 171.703 53.5331 172.767C52.7487 173.776 51.572 174.336 50.2833 174.336C49.3868 174.28 48.9386 173.776 49.2188 172.823C49.2748 172.599 49.3868 172.431 49.4989 172.263L49.5549 172.207C49.8911 171.927 49.611 171.646 48.7145 171.478C48.6585 171.646 48.6024 171.815 48.6024 171.983C48.3783 172.543 48.0421 173.047 47.5939 173.439C46.6974 174.224 45.5208 174.616 44.3441 174.56C44.2321 174.504 44.12 174.504 44.008 174.504C43.8399 174.504 43.8959 174.448 43.9519 174.56C43.8399 174.392 43.7838 174.168 43.7278 173.944C43.6158 173.327 43.6718 172.655 43.8399 172.039C44.12 170.862 44.7924 169.742 46.025 169.461C46.6414 169.293 46.1931 168.341 45.969 168.061C45.7449 167.5 45.1286 167.22 44.4562 167.276Z"
			fill="#7DD3FC"
		/>
		<path
			d="M25.188 55.2196C25.188 55.2196 12.4692 48.5522 13.2536 47.7118C14.038 46.8714 56.6769 31.2395 57.2372 35.1615C57.7975 39.0835 50.2895 62.5033 48.0483 62.6154C45.8071 62.7274 39.5877 60.5423 39.5877 60.5423C39.5877 60.5423 29.9506 72.9806 28.83 72.6444C27.7094 72.3083 25.188 55.2196 25.188 55.2196Z"
			fill="white"
		/>
		<path
			d="M25.2436 54.2717C22.4981 52.8149 19.7526 51.3022 17.1192 49.7334C16.3348 49.2291 15.4944 48.7249 14.7099 48.2206C14.4858 48.1086 14.7099 48.2206 14.766 48.2766L14.5418 48.1086L14.1496 47.8284C14.0936 47.7724 13.9815 47.6603 13.8695 47.6043C13.6454 47.4923 14.1496 47.8844 13.9815 47.7164C13.8135 47.5483 13.8135 47.4362 14.0936 47.8284C14.2617 48.1646 14.2617 48.5008 14.1496 48.8369C14.1496 48.8369 14.2057 48.8369 14.2057 48.7809C14.2057 48.7249 13.9815 48.893 14.1496 48.8369C14.3177 48.7809 14.6539 48.6128 14.9341 48.5008C21.0413 45.8674 27.4288 43.7944 33.7602 41.6653C37.7383 40.3206 41.7724 39.088 45.8626 37.9114C48.8322 37.015 51.9139 36.2866 55.0516 35.8944C55.1076 35.8944 55.2197 35.8944 55.2757 35.8944H55.6119C55.836 35.8944 56.0601 35.8944 56.2842 35.8944C56.5084 35.8944 56.6204 35.9504 56.7885 35.9504C56.9566 35.9504 56.5084 35.8944 56.7325 35.9504C56.7885 35.9504 56.9006 36.0064 56.9566 36.0064C56.6764 35.9504 56.6764 35.8944 56.8445 35.9504C56.7325 35.8944 56.3963 35.6142 56.4523 35.6142C56.2842 35.3901 56.2282 35.166 56.1161 34.9979C56.0041 34.8298 56.1161 34.9419 56.1161 35.11C56.1722 34.7178 56.1161 35.11 56.1161 35.222C56.1161 35.3341 56.1161 35.4462 56.1161 35.5582C56.1161 35.8944 56.0601 36.1745 56.0041 36.5107C55.4998 40.4327 54.2672 44.3547 53.0345 48.1086C51.8018 52.0305 50.5131 56.0086 48.6081 59.6504C48.4961 59.9305 48.328 60.2107 48.1599 60.4908C48.1038 60.6029 47.9918 60.7149 47.9358 60.883C47.8797 61.0511 47.6556 61.2752 47.8237 61.0511C47.7116 61.2192 47.5435 61.3313 47.4315 61.4993C47.3755 61.5554 47.3194 61.5554 47.2634 61.6114C47.3755 61.4993 47.4875 61.4993 47.3194 61.5554C47.1513 61.6114 47.6556 61.6114 47.3755 61.5554C46.3669 61.4433 45.3584 61.2752 44.3498 61.0511C43.1732 60.771 42.0526 60.4348 40.932 60.0426C40.3717 59.8745 39.8674 59.7064 39.3071 59.5383C39.139 59.4823 38.7468 59.4263 38.5787 59.5944C35.6652 63.3483 32.7516 67.2142 29.3898 70.5759C29.1097 70.9121 28.7735 71.1922 28.3813 71.4724L28.2132 71.5844L28.1011 71.6405C28.5494 71.6405 28.9416 71.8646 29.2217 72.2007C29.1097 72.0887 29.5019 72.5929 29.3338 72.3688C29.1657 72.1447 29.4458 72.761 29.3898 72.4809C29.3338 72.3128 29.2777 72.1447 29.2217 71.9766C29.1657 71.8085 29.1657 71.7525 29.1097 71.6405C29.0536 71.5284 29.1657 71.8646 29.1097 71.5284C29.0536 71.1922 28.9416 71.0242 28.8855 70.744C28.1571 67.8866 27.6529 64.9171 27.1486 62.0036C26.8124 59.9305 26.4202 57.8575 26.1401 55.7284C25.972 55.0561 25.5237 54.4958 24.8514 54.2157C24.5152 54.0476 24.179 54.2157 24.0109 54.4958C23.9549 54.6639 23.9549 54.832 23.9549 54.944C24.6833 59.8745 25.4677 64.9171 26.6443 69.7915C27.0365 71.2483 28.0451 75.2263 30.2303 73.4894C31.1267 72.761 31.9112 71.9206 32.6396 71.0802C33.7041 69.9036 34.7687 68.6149 35.7772 67.3823C37.3461 65.5334 38.8589 63.6284 40.3157 61.6674L39.5873 61.7234C41.3802 62.3398 43.2292 62.9 45.1343 63.3483C46.479 63.6844 48.44 64.4128 49.5046 63.1242C50.4011 61.8355 51.1295 60.4908 51.6337 59.0341C52.4742 57.0171 53.2586 54.944 53.987 52.871C55.5558 48.5008 56.7885 44.0185 57.797 39.4802C58.0212 38.2476 58.4134 36.7348 58.1893 35.4462C57.9091 34.2696 56.8445 33.3731 55.6119 33.3171C54.4913 33.2611 53.3707 33.3171 52.3061 33.5412C50.7373 33.7653 49.1684 34.1575 47.5996 34.5497C43.5094 35.5582 39.4752 36.7908 35.4971 38.0795C28.3252 40.3767 21.2094 42.7859 14.2057 45.6433C13.5333 45.8674 12.8609 46.1476 12.3006 46.5398C11.124 47.4923 13.2532 49.2291 13.9815 49.7334C17.1753 52.0306 20.7051 53.8795 24.179 55.7284L25.0195 56.1766C25.4677 56.4008 26.084 56.4568 26.1961 55.8405C26.2521 55.1681 25.8599 54.5518 25.2436 54.2717Z"
			fill="#7DD3FC"
		/>
		<path
			d="M49.8394 41.7188C49.8394 41.7188 30.7331 56.7343 30.2289 57.7429C29.7246 58.7514 28.8281 72.6464 28.8281 72.6464"
			fill="white"
		/>
		<path
			d="M48.893 42.1147C44.5226 45.5324 40.1523 49.0062 35.838 52.536C33.7088 54.2729 31.5237 55.9537 29.5066 57.8587C29.0583 58.2509 28.7782 58.8112 28.7782 59.4275C28.5541 60.9402 28.442 62.509 28.2739 64.0218C27.9938 67.1594 27.8257 70.297 27.6016 73.4346C27.6016 73.5466 28.8342 72.9303 28.8903 72.8743C29.1704 72.7062 29.9548 72.37 30.0109 71.9778C30.1789 69.3445 30.347 66.7672 30.5712 64.1899C30.6832 62.453 30.8513 60.7721 31.0194 59.0913C31.0754 58.587 31.1315 58.0268 31.2435 57.5225C31.2435 57.4104 31.2995 57.2984 31.3556 57.1863C31.4116 57.0183 31.2995 57.2424 31.4116 57.1303C31.5797 56.9622 31.6357 56.9062 31.6918 56.8502L31.9159 56.6821L32.0279 56.57C32.4201 56.1778 32.8684 55.8417 33.3166 55.5055C34.4933 54.497 35.7259 53.4885 36.9025 52.536C39.7601 50.2388 42.6176 47.9417 45.4751 45.6445C47.2121 44.2438 48.949 42.8991 50.6859 41.4984C51.0782 41.2183 50.9661 41.1062 50.5179 41.2743C49.9015 41.5544 49.3412 41.8906 48.837 42.2828L48.893 42.1147Z"
			fill="#7DD3FC"
		/>
		<path
			d="M45.6409 60.3214L32.1377 56.8477L30.1766 56.3434C29.5043 56.1754 29 56.9597 29 57.52C29.056 58.2484 29.5603 58.8647 30.2887 59.0328L43.7919 62.5066L45.753 63.0108C46.4253 63.1789 46.9296 62.3945 46.9296 61.8342C46.8736 61.1058 46.3693 60.4895 45.6409 60.3214Z"
			fill="#7DD3FC"
		/>
		<path
			d="M49.0616 40.5954L41.1053 44.6854L28.4425 51.1847L25.5289 52.6414C24.5764 53.1457 26.0892 55.4429 27.0978 54.9386L35.054 50.8485L47.7168 44.3492L50.6304 42.8365C51.5269 42.3883 50.0701 40.0911 49.0616 40.5954Z"
			fill="#7DD3FC"
		/>
		<path
			d="M17.8894 4.23069L1.28906 9.71094L5.25885 21.7352L21.8592 16.2549L17.8894 4.23069Z"
			fill="white"
		/>
		<path
			d="M21.9398 15.4408L7.37195 20.2592L5.29884 20.9316L6.5315 21.0996L3.05764 10.5663L2.55336 9.05354L1.26467 10.4543L15.8325 5.63581L17.9056 4.96348L16.6729 4.79539L20.1468 15.3287L20.6511 16.8415C20.9312 17.6819 23.5086 16.5613 23.1724 15.6089L19.6986 5.07553L19.1943 3.56277C19.0822 3.11454 18.2418 3.33865 17.9616 3.39468L3.39381 8.21312L1.3207 8.88546C0.816434 9.05354 -0.192109 9.61383 0.0320111 10.2862L3.50588 20.8195L4.01014 22.3323C4.1222 22.7805 4.96266 22.5564 5.24281 22.5003L19.8106 17.6819L21.8837 17.0096C22.332 16.8415 23.2285 16.3933 23.1724 15.7769C23.1164 15.1606 22.2759 15.3287 21.9398 15.4408Z"
			fill="#7DD3FC"
		/>
		<path
			d="M1.82812 9.95416C4.74169 10.2343 7.26304 12.1393 10.1206 12.5875C10.3447 12.6435 10.5128 12.6435 10.7369 12.5875C10.905 12.4754 11.0731 12.3634 11.1851 12.1953L17.1243 4.6875"
			fill="white"
		/>
		<path
			d="M0.983156 10.9001C2.552 11.1242 4.12084 11.6284 5.57762 12.3008C6.97837 12.8611 8.82736 13.8135 10.3962 13.4774C11.4608 13.2533 12.0771 12.4689 12.6934 11.6845L14.4864 9.44333L18.1284 4.84901C18.4645 4.45681 18.6887 3.89652 18.0163 3.67241C17.3439 3.61638 16.6716 3.8405 16.2233 4.40078L13.0856 8.37879L11.4608 10.4518L10.6764 11.4043C10.5083 11.5724 10.3962 11.7405 10.2281 11.9086L10.1161 12.0767C11.0686 11.8525 11.2927 11.6845 10.8444 11.6284C10.2281 11.4043 9.49973 11.2923 8.82736 11.0682C8.155 10.844 7.48264 10.5079 6.81028 10.2277C5.46556 9.61141 4.06481 9.21922 2.66406 8.9951C1.9917 8.93907 1.31933 9.21922 0.871093 9.7795C0.646973 10.0596 0.310795 10.9001 0.983156 10.9001Z"
			fill="#7DD3FC"
		/>
		<path
			d="M4.90625 20.9333C5.07434 18.6361 6.19494 14.2099 6.81127 11.9688L4.90625 20.9333Z"
			fill="white"
		/>
		<path
			d="M6.30363 21.0404C6.47172 19.5276 6.69584 18.0149 7.08805 16.5021C7.42423 14.9893 7.81644 13.5326 8.20865 12.0198C8.37674 11.3475 5.63127 10.8993 5.40715 11.7397C5.01494 13.1964 4.62273 14.7092 4.28655 16.222C3.89434 17.7347 3.67022 19.1915 3.50213 20.7603C3.4461 21.2645 4.51067 21.4326 4.84685 21.4326C5.18303 21.4326 6.2476 21.5446 6.30363 21.0404Z"
			fill="#7DD3FC"
		/>
		<path
			d="M14.2031 9.84375C16.2762 11.7487 18.2933 13.7097 20.2544 15.7267L14.2031 9.84375Z"
			fill="white"
		/>
		<path
			d="M13.6517 10.6216C15.7248 12.5266 17.7419 14.4876 19.7029 16.5046C20.0391 16.8968 20.8236 17.289 21.2158 16.7287C21.4959 16.1124 21.3839 15.384 20.8796 14.9358C18.8625 12.9748 16.8454 11.0138 14.8283 9.05284C14.4361 8.71667 13.7077 8.26844 13.3155 8.88475C12.9793 9.44503 13.1474 10.1734 13.6517 10.6216Z"
			fill="#7DD3FC"
		/>
		<path
			d="M120.057 1.92077L96.8047 2.05469L96.9015 18.8632L120.154 18.7293L120.057 1.92077Z"
			fill="white"
		/>
		<path
			d="M119.546 17.7382L99.2071 17.8502H96.2936L98.1986 19.307L98.1426 4.57153V2.49848L97.4142 3.05876L117.753 2.94671H120.667L118.762 1.48997L118.818 16.2254V18.3545C118.818 19.4751 121.395 20.4275 121.395 19.251L121.339 4.5155V2.38642C121.339 1.48997 120.218 0.929688 119.434 0.929688L99.0951 1.04174H96.1815C95.8453 1.04174 95.4531 1.20983 95.4531 1.60203L95.5092 16.3375V18.4666C95.5092 19.363 96.6298 19.9233 97.4142 19.9233L117.753 19.8112H120.667C121.003 19.8112 121.339 19.5311 121.339 19.1949C121.339 19.0268 121.283 18.9148 121.227 18.7467C120.891 18.1304 120.218 17.7382 119.546 17.7382Z"
			fill="#7DD3FC"
		/>
		<path
			d="M97.2969 2.66698C100.883 4.17974 103.292 7.6535 106.71 9.39038C106.934 9.50243 107.214 9.61449 107.494 9.61449C107.774 9.55846 108.055 9.4464 108.223 9.27832L118.812 2.21875"
			fill="white"
		/>
		<path
			d="M96.7911 3.0655C98.6401 3.84989 100.153 5.30663 101.666 6.59528C103.179 7.88393 104.972 9.45273 106.933 10.069C107.493 10.2932 108.165 10.3492 108.782 10.1811C109.286 9.95698 109.79 9.67684 110.182 9.34067L113.432 7.15556L120.1 2.72933C120.548 2.44918 119.539 1.8889 119.371 1.77684C118.923 1.55273 118.083 1.27259 117.634 1.60876L111.639 5.58677L108.613 7.60379L107.101 8.6123L106.821 8.78039C106.372 8.94847 106.596 9.06053 107.437 9.06053C107.269 8.94847 107.157 8.89244 106.989 8.83641C105.42 7.8279 103.963 6.70734 102.618 5.47471C101.161 4.18606 99.5366 3.12152 97.7997 2.2811C97.4075 2.11301 96.3989 1.72081 96.0627 2.11301C95.7266 2.50521 96.567 2.95344 96.7911 3.0655Z"
			fill="#7DD3FC"
		/>
		<path
			d="M96.7422 17.6818C97.9188 14.8243 101.113 9.66971 102.793 7.14844L96.7422 17.6818Z"
			fill="white"
		/>
		<path
			d="M97.9675 17.2353C98.7519 15.3864 99.7045 13.5935 100.825 11.8566C101.834 10.1197 102.954 8.38283 104.075 6.70198C104.187 6.47787 103.122 6.87007 103.066 6.87007C102.73 6.98212 102.394 7.15021 102.058 7.31829C101.834 7.37432 101.666 7.54241 101.497 7.65447C100.377 9.33532 99.3122 11.0722 98.2477 12.8091C97.1831 14.546 96.2306 16.3389 95.4462 18.1878C95.3341 18.4119 96.3427 18.0757 96.4547 18.0197C96.7909 17.9076 97.1271 17.7396 97.4633 17.5715C97.6314 17.5155 97.9675 17.4034 97.9675 17.2353Z"
			fill="#7DD3FC"
		/>
		<path
			d="M113.047 7.54688C114.84 10.7965 116.577 14.1022 118.314 17.4639L113.047 7.54688Z"
			fill="white"
		/>
		<path
			d="M111.703 7.48595C113.496 10.7916 115.233 14.0413 116.97 17.403C117.194 17.8512 118.258 17.8512 118.65 17.8512C118.875 17.8512 119.883 17.8512 119.659 17.459C117.978 14.1533 116.185 10.8476 114.392 7.54198C114.168 7.09375 113.103 7.09375 112.711 7.09375C112.543 7.09375 111.479 7.09375 111.703 7.48595Z"
			fill="#7DD3FC"
		/>
		<path
			d="M177.141 37.9185L170.836 53.5L192.391 62.2217L198.696 46.6403L177.141 37.9185Z"
			fill="white"
		/>
		<path
			d="M193.672 61.8313L177.48 55.2759L173.614 53.7071L172.493 53.2589C172.381 53.2589 172.325 53.2029 172.213 53.1469C172.101 53.0348 172.213 53.2029 172.213 53.1469C172.269 52.8667 172.381 52.6426 172.493 52.4185L173.165 50.7376L175.182 45.8072L178.544 37.571L175.855 38.4114L192.048 44.9667L195.914 46.5355L197.034 46.9837C197.146 46.9837 197.202 47.0398 197.314 47.0958C197.314 47.0398 197.426 47.2079 197.314 47.0958C197.258 47.3759 197.146 47.6001 197.034 47.8242L196.362 49.505L194.345 54.4355L190.983 62.6717C190.927 62.7837 192.328 62.5596 192.384 62.5036C192.72 62.3915 193.504 62.2234 193.672 61.8313L199.219 48.2164L200.004 46.2554L199.948 46.1994L181.122 38.5795L178.432 37.515C178.04 37.3469 177.256 37.683 176.919 37.7951C176.583 37.9072 175.967 38.0192 175.799 38.3554L170.252 51.9703L169.523 53.9313L169.579 53.9873L188.406 61.6071L191.095 62.6717C191.543 62.8398 192.384 62.5036 192.776 62.3355C192.888 62.3355 193.897 61.8873 193.672 61.8313Z"
			fill="#7DD3FC"
		/>
		<path
			d="M177.43 38.6875C180.175 41.4329 181.072 45.523 183.593 48.4925C183.761 48.7166 183.985 48.8847 184.209 48.9967C184.489 49.0527 184.77 49.0527 185.05 48.9967L197.544 46.5315"
			fill="white"
		/>
		<path
			d="M177.703 39.6958C178.992 41.0405 179.776 42.8334 180.617 44.4582C181.569 46.2511 182.578 48.3802 184.147 49.7249C184.987 50.4533 185.996 50.0611 187.004 49.893L190.646 49.1646L198.266 47.6519C198.602 47.5958 197.594 45.0746 196.866 45.2426L189.806 46.6433L186.276 47.3717L184.539 47.7079C183.923 47.8199 183.699 47.8199 183.306 47.3717C182.186 45.971 181.513 44.3462 180.729 42.7774C179.832 40.9285 178.656 39.2476 177.255 37.6788C176.919 37.2866 176.695 37.5107 176.751 37.959C176.863 38.6313 177.199 39.1916 177.703 39.6958Z"
			fill="#7DD3FC"
		/>
		<path
			d="M171.148 52.4205C173.334 50.2354 178.208 46.7056 180.786 44.9688L171.148 52.4205Z"
			fill="white"
		/>
		<path
			d="M172.38 52.6435C172.548 52.4754 172.324 52.6995 172.492 52.5314L172.716 52.3073C172.884 52.1392 173.052 51.9711 173.221 51.8591C173.557 51.5229 173.949 51.2428 174.341 50.9066C175.182 50.2343 176.022 49.5059 176.919 48.8896C178.543 47.657 180.168 46.5364 181.849 45.4158C182.129 45.2477 182.241 44.8555 182.073 44.5194C181.961 44.3513 181.849 44.2953 181.681 44.2392C181.009 44.0151 180.28 44.1272 179.72 44.5194C178.039 45.6399 176.358 46.8726 174.677 48.1052C172.996 49.3378 171.372 50.6825 169.859 52.1392C169.411 52.6435 170.083 53.0917 170.531 53.2038C171.203 53.3158 171.932 53.0917 172.38 52.6435Z"
			fill="#7DD3FC"
		/>
		<path
			d="M190.086 49.2266C190.478 52.9244 190.87 56.6223 191.151 60.3762L190.086 49.2266Z"
			fill="white"
		/>
		<path
			d="M189.018 48.4436C189.41 52.1414 189.802 55.8393 190.082 59.5932C190.138 60.1535 190.811 60.6577 191.203 60.9379C191.315 60.9939 192.324 61.6102 192.268 61.162C191.931 57.4081 191.595 53.7102 191.203 50.0124C191.147 49.4521 190.475 48.9478 190.082 48.6677C189.97 48.6116 188.962 47.9953 189.018 48.4436Z"
			fill="#7DD3FC"
		/>
		<path
			d="M37.0672 12.1356C46.3682 10.8469 56.0614 14.6008 62.3368 21.4923C63.9056 23.2292 65.3064 25.1341 66.371 27.2072C67.6036 29.5604 68.5001 32.0256 69.9009 34.2668C71.2456 36.5639 73.2066 38.3568 75.6159 39.5334C78.0252 40.598 80.7147 41.0462 83.3481 40.8221C89.7355 40.2618 94.9463 36.2277 99.4847 32.0256C100.605 31.0171 98.2521 29.4483 97.2435 30.4008C93.3214 33.9866 88.839 37.6285 83.4041 38.4689C81.0508 38.8611 78.6415 38.5809 76.4564 37.5724C74.2712 36.5639 72.7584 34.659 71.6378 32.5859C70.4051 30.3448 69.5086 27.9916 68.276 25.7504C67.0993 23.6774 65.6426 21.7164 64.0177 19.9795C60.6559 16.3937 56.5097 13.6483 51.9712 11.8554C46.8725 9.8384 41.3255 9.16606 35.8906 9.89443C35.3863 10.0065 35.0502 10.4547 35.1622 10.959C35.1622 11.071 35.2182 11.1831 35.2743 11.2391C35.6105 11.9675 36.3388 12.3036 37.0672 12.1356Z"
			fill="#082F49"
		/>
		<path
			d="M131.082 12.8041C132.875 11.0112 135.396 10.2829 137.805 9.83462C140.551 9.27434 143.352 8.77009 146.21 8.43392C151.477 7.87363 157.304 7.8176 162.066 10.3389C165.988 12.4119 169.35 16.0538 170.415 20.424C170.695 21.4885 170.807 22.6091 170.751 23.7297C170.751 24.2899 170.695 24.7942 170.583 25.2984C170.527 25.5786 170.471 25.8587 170.359 26.1389C170.247 26.363 170.135 26.5311 169.966 26.7552C169.518 27.7077 169.854 26.7552 169.854 26.8112C169.966 26.8112 170.079 26.8672 170.191 26.8672C170.303 26.8672 170.359 27.0353 170.191 26.8672C169.91 26.5871 169.742 26.1949 169.742 25.8027C169.798 24.8502 170.807 24.2339 171.647 24.0098C173.72 23.4495 176.13 24.2899 177.811 25.5786C179.828 27.0353 181.172 29.1644 181.733 31.5736C181.957 32.1899 182.517 32.6382 183.134 32.6942C183.47 32.7502 184.534 32.7502 184.366 32.1339C183.19 26.5871 177.867 22.3289 172.208 22.1048C170.191 22.0488 166.325 23.0573 167.109 25.8587C167.781 28.2679 172.096 30.0048 172.936 26.8672C174.449 21.3765 171.423 15.7736 167.445 12.1878C162.627 7.81761 156.015 6.30484 149.628 6.36087C145.762 6.47293 141.895 6.92115 138.085 7.70555C134.724 8.32186 131.082 8.9942 128.56 11.4594C127.888 12.2999 130.353 13.5325 131.082 12.8041Z"
			fill="#082F49"
		/>
		<path
			d="M37.7402 120.717C31.745 120.381 25.5256 119.26 20.8751 115.17C17.0091 111.696 15.104 105.982 17.4573 101.107C18.0176 99.9305 18.802 98.922 19.8106 98.1376C20.4269 97.6893 21.7156 96.961 22.5 97.4652C23.2844 97.9695 23.0603 99.1461 22.7802 99.8184C22.3319 100.771 21.3234 101.331 20.3148 101.163C17.6254 100.771 16.5608 97.5773 16.0565 95.3362C15.4962 92.8149 15.4402 90.2376 15.7764 87.6603C16.6168 81.7773 19.7545 76.4546 24.5171 72.9248C24.9093 72.5886 24.9653 72.0284 24.6291 71.6362C24.5731 71.5801 24.5171 71.5241 24.405 71.4681C23.8447 71.0199 23.0603 70.9638 22.444 71.356C17.4013 75.0539 14.0395 80.6567 13.087 86.8198C12.5827 89.9014 12.6947 93.039 13.4792 96.0085C14.3196 99.3142 16.2807 102.564 19.9226 103.236C21.6035 103.628 23.3965 103.124 24.6291 101.891C25.5256 100.939 25.9178 99.5383 25.6377 98.2496C25.2455 96.6808 23.9008 95.5042 22.2759 95.2801C20.595 95.056 18.9701 95.5603 17.6254 96.5688C15.104 98.4737 13.8714 101.611 13.6473 104.693C13.4792 107.886 14.4317 111.024 16.3367 113.601C21.2113 120.437 29.952 122.398 37.8522 122.846C38.4125 122.902 39.197 122.566 39.1409 121.894C39.0849 121.221 38.3565 120.717 37.7402 120.717Z"
			fill="#082F49"
		/>
	</svg>
);

export const AwsIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="32" height="32" fill="url(#pattern0_12821_28776)" />
		<defs>
			<pattern
				id="pattern0_12821_28776"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_12821_28776"
					transform="scale(0.0025)"
				/>
			</pattern>
			<image
				id="image0_12821_28776"
				width="400"
				height="400"
				xlinkHref="data:image/jpeg;base64,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"
			/>
		</defs>
	</svg>
);

export const SmtpIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect y="4" width="32" height="24" fill="url(#pattern0_12804_171885)" />
		<defs>
			<pattern
				id="pattern0_12804_171885"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_12804_171885"
					transform="matrix(0.0078125 0 0 0.0104167 0 -0.166667)"
				/>
			</pattern>
			<image
				id="image0_12804_171885"
				width="128"
				height="128"
				xlinkHref="data:image/png;base64,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"
			/>
		</defs>
	</svg>
);

export const MailGunIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M15.6224 10.8496C12.7776 10.8496 10.4704 13.1568 10.4704 16.0016C10.4704 18.8464 12.7776 21.1536 15.6224 21.1536C18.4672 21.1536 20.7744 18.8464 20.7744 16.0016C20.7744 13.1568 18.4704 10.8496 15.6224 10.8496ZM7.5904 16.0016C7.5904 11.5632 11.1872 7.96955 15.6224 7.96955C20.0608 7.96955 23.6576 11.5664 23.6576 16.0016C23.6576 16.296 23.6416 16.584 23.6128 16.8688C23.552 17.6528 24.128 18.2512 24.9056 18.2512C26.2272 18.2512 26.368 16.5488 26.368 16.0016C26.368 10.0688 21.5584 5.26235 15.6288 5.26235C9.6992 5.26235 4.8832 10.072 4.8832 16.0016C4.8832 21.9344 9.6928 26.7408 15.6224 26.7408C18.7712 26.7408 21.6064 25.384 23.5712 23.224L25.7792 25.0768C23.2864 27.864 19.6576 29.6208 15.6224 29.6208C8.0992 29.6208 2 23.5216 2 15.9984C2 8.47515 8.0992 2.37915 15.6224 2.37915C23.1456 2.37915 29.2448 8.47835 29.2448 16.0016C29.2448 19.0256 27.8048 21.48 24.912 21.48C23.6384 21.48 22.864 20.8976 22.4416 20.2448C21.0272 22.5232 18.5024 24.0368 15.6224 24.0368C11.1872 24.0368 7.5904 20.44 7.5904 16.0016ZM15.6224 13.6464C16.9248 13.6464 17.9808 14.7024 17.9808 16.0048C17.9808 17.3072 16.9248 18.3632 15.6224 18.3632C14.32 18.3632 13.264 17.3072 13.264 16.0048C13.264 14.7024 14.32 13.6464 15.6224 13.6464Z"
			fill="#C12126"
		/>
	</svg>
);

export const OutlookIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_12821_41628)">
			<path d="M15.2076 15.2051H0V0H15.2076V15.2051Z" fill="#F1511B" />
			<path
				d="M31.9999 15.2051H16.791V0H31.9986V15.2051H31.9999Z"
				fill="#80CC28"
			/>
			<path d="M15.2076 32H0V16.7949H15.2076V32Z" fill="#00ADEF" />
			<path
				d="M31.9999 32H16.791V16.7949H31.9986V32H31.9999Z"
				fill="#FBBC09"
			/>
		</g>
		<defs>
			<clipPath id="clip0_12821_41628">
				<rect width="32" height="32" fill="white" />
			</clipPath>
		</defs>
	</svg>
);
export const PostMarkIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="32" height="32" fill="url(#pattern0_12804_171889)" />
		<defs>
			<pattern
				id="pattern0_12804_171889"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_12804_171889"
					transform="scale(0.0025)"
				/>
			</pattern>
			<image
				id="image0_12804_171889"
				width="400"
				height="400"
				xlinkHref="data:image/png;base64,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"
			/>
		</defs>
	</svg>
);
export const SendGridIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_12821_41635)">
			<path
				d="M21.3332 0H12.7998C11.6265 0 10.6665 0.96 10.6665 2.13333V8.53333C10.6665 9.70667 11.6265 10.6667 12.7998 10.6667H19.1998C20.3732 10.6667 21.3332 11.6267 21.3332 12.8V19.2C21.3332 20.3733 22.2932 21.3333 23.4665 21.3333H29.8665C31.0398 21.3333 31.9998 20.3733 31.9998 19.2V1.06667C31.9998 0.48 31.5198 0 30.9332 0H21.3332Z"
				fill="#51A9E3"
			/>
			<path
				d="M10.6667 32H19.2C20.3733 32 21.3333 31.04 21.3333 29.8666V23.4666C21.3333 22.2933 20.3733 21.3333 19.2 21.3333H12.8C11.6267 21.3333 10.6667 20.3733 10.6667 19.2V12.8C10.6667 11.6266 9.70667 10.6666 8.53333 10.6666H2.13333C0.96 10.6666 0 11.6266 0 12.8V30.9333C0 31.52 0.48 32 1.06667 32H10.6667Z"
				fill="#51A9E3"
			/>
		</g>
		<defs>
			<clipPath id="clip0_12821_41635">
				<rect width="32" height="32" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const GmailIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M22.56 12.25C22.56 11.47 22.49 10.72 22.36 10H12V14.255H17.92C17.665 15.63 16.89 16.795 15.725 17.575V20.335H19.28C21.36 18.42 22.56 15.6 22.56 12.25Z"
			fill="#4285F4"
		/>
		<path
			d="M12.0019 23.0037C14.9719 23.0037 17.4619 22.0187 19.2819 20.3387L15.7269 17.5788C14.7419 18.2388 13.4819 18.6287 12.0019 18.6287C9.13688 18.6287 6.71187 16.6937 5.84687 14.0938H2.17188V16.9438C3.98187 20.5388 7.70187 23.0037 12.0019 23.0037Z"
			fill="#34A853"
		/>
		<path
			d="M5.845 14.0925C5.625 13.4325 5.5 12.7275 5.5 12.0025C5.5 11.2775 5.625 10.5725 5.845 9.9125V7.0625H2.17C1.4 8.59536 0.999321 10.2871 1 12.0025C1 13.7775 1.425 15.4575 2.17 16.9425L5.845 14.0925Z"
			fill="#FBBC05"
		/>
		<path
			d="M12.0019 5.375C13.6169 5.375 15.0669 5.93 16.2069 7.02L19.3619 3.865C17.4569 2.09 14.9669 1 12.0019 1C7.70187 1 3.98187 3.465 2.17188 7.06L5.84687 9.91C6.71187 7.31 9.13688 5.375 12.0019 5.375Z"
			fill="#EA4335"
		/>
	</svg>
);

export const SparkPostIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="24" height="24" fill="url(#pattern0_16769_11064)" />
		<defs>
			<pattern
				id="pattern0_16769_11064"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_16769_11064"
					transform="scale(0.0208333)"
				/>
			</pattern>
			<image
				id="image0_16769_11064"
				width="48"
				height="48"
				xlinkHref="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAAERlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAA6ABAAMAAAABAAEAAKACAAQAAAABAAAAMKADAAQAAAABAAAAMAAAAADbN2wMAAAEHElEQVRoBdVZXXLTMBBeJU6Ap3KDBFqeCScgN2hu0DykM7xRToA5AeGNGcI0vUG4QXOD8EzLpCegeQISx2LXkRNZli1LtjuDZzxerXZX32f9SwA1PuvR8wt6ayyi/tDr85PFenQ8raukRl2BD3H5GOWzukjUTqC12c4EmbO/oxNfyJV9WGWRcgJRMwLOX0YmrPGq/eXHIsfcKqv2GojQcH4fo2I89GO5iu/DEADoxWA5wOnvN91unC77rZ2AAHskA21um305XUaunUAzaAxSADn8PwSANYYpAgBdjc5JVWsNbEYn/f3o4wTP7FQrAQ7cN0MoZ1EbgfX58RChvS4Hz+xdCwE+7D4FDmNz8eUtaiGwaTZ9hJYYOmWoHNi1nC4jV04g6rgM3uaBYhDuZ+Y8uyJ5lRKgpoMdd2oqmEFjYbIpml8pAdF0OqbCW5Oba5NN0fzKCBRpOhEoxr7H4NbnL3qx7PqthEDRphOB5DxqPhF4Ho5dgcd+lRAo2nR2hfLFbpgNZzGIMl+vjDP5UtPBjps76shlUAfetNgA5wljX5H9suTSNcCZ3YQVeMESwQ8FoE7ZvUEpAtGRSbxVzPpFiv7xH7hH1X6J0Qi8oWJilWRW1pIxteON11yiKnPGlcwlkb8DYB8lxaoVbLtsuiRi1o9zDaw97wJLswRP+Bj5yc+RiCXrCsvOBBhwFUjRQlOdF2MNizqrdk4ExFLZ9PfvsLC5eFdqwUq6I2IqanPSaRhlHAY8O/YVbiPH6tmPmLio1s60rruRaarNy1Fad2LReX9pYq4YsIFpnSPmjRn6p2pw622fPfm8XGpiZ6qsm9C62exroq3wr/dN4MkvskFbktXH5bjFmgAw1lMLBtz7qk0mbXPQkC1uaj4cNEIKDwdgqbwMhTUBHDH6Sqy79uTnWNEZk+0gIJ9k52YPQCCFjAO1Z+tHTFxOvnJh1jWAzj05ADRgkUhbJLAZLRXzZGwlU5d0IZAYPRhPgdCVo9eJvYGUmYgt6TNFFwJzORqH0Pqv7f3TA0Ii9t4uR3AhoITTjUqKSUayAdydvIhpTUBzpjOIdlgZILPU5IOz+amcr4ktZ2tlawKMsZkS6UhsKRV1flLnE3rBNN8rnWtNQExYybaKB1k2i7HINn34NbddRhAdawLkhGsen76Jh8NlkUvt3S4OLhO+mNDGVI00aabRFVKJe1/dyvIO0fh0vRrvsmjfG61zOPgYvJMqgMOn9tfbi5S+gMKZQLQqbXnXFVxgzNuT234BrFoTpyZEkejvtjZBH8Vkf6DMgg/+vW+4Hx4UNNeaOdeAHI1u4HGR917WmWRajT6a3PgmO1O+cw3IgQkIbUZQdyXrM+Qrsq0CPMWvpAZkoFGHpatVup2Mz4zoQJeH060XzlyGSjm+Kv8Dpn4zXhDA20IAAAAASUVORK5CYII="
			/>
		</defs>
	</svg>
);

export const BrevoIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="32" height="32" fill="url(#pattern0_12821_41641)" />
		<defs>
			<pattern
				id="pattern0_12821_41641"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_12821_41641"
					transform="scale(0.00144092)"
				/>
			</pattern>
			<image
				id="image0_12821_41641"
				width="694"
				height="694"
				xlinkHref="data:image/png;base64,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"
			/>
		</defs>
	</svg>
);

export const ElasticEmailIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect y="0.570312" width="24" height="24" rx="1" fill="#2C2F7A" />
		<path
			d="M4 5.03255C4 4.89788 4.10935 4.78906 4.24349 4.78906H6.20539C6.31205 4.78906 6.39824 4.87525 6.39824 4.98191V5.09935C6.39824 5.20601 6.31205 5.2922 6.20539 5.2922H4.57316V6.58505H5.86602C5.97268 6.58505 6.05887 6.67124 6.05941 6.7779V6.89479C6.05941 7.00145 5.97268 7.08764 5.86602 7.08764H4.57316V8.41551H6.30505C6.41171 8.41551 6.4979 8.5017 6.4979 8.60836V8.72526C6.4979 8.83192 6.41171 8.91811 6.30505 8.91811H4.24403C4.10935 8.91811 4.00054 8.80875 4.00054 8.67462V5.03255H4Z"
			fill="white"
		/>
		<path
			d="M7.67661 8.74513C7.67661 8.87388 7.61197 8.93798 7.48376 8.93798H7.30223C7.17348 8.93798 7.10938 8.87334 7.10938 8.74513V4.70066C7.10938 4.57192 7.17348 4.50781 7.30223 4.50781H7.48376C7.61251 4.50781 7.67661 4.57192 7.67661 4.70066V8.74513Z"
			fill="white"
		/>
		<path
			d="M10.9001 5.96121H10.76C10.6313 5.96121 10.5666 6.01562 10.5666 6.12497V6.27203C10.5672 6.31082 10.571 6.35014 10.5785 6.38839H10.5666C10.523 6.29358 10.4589 6.21008 10.3797 6.14275C10.2946 6.0711 10.1987 6.01292 10.0958 5.97037C9.95146 5.91327 9.7974 5.88633 9.64225 5.89118C8.85308 5.89118 8.32031 6.45303 8.32031 7.46684C8.32031 8.39931 8.84553 9.00803 9.59323 9.00803C9.99348 9.00803 10.4298 8.84158 10.5666 8.50489H10.5785C10.5726 8.54476 10.5683 8.58462 10.5666 8.62502V8.7737C10.5666 8.88252 10.6313 8.93746 10.76 8.93746H10.9001C11.0288 8.93746 11.0929 8.87282 11.0929 8.74461V6.1546C11.0935 6.02585 11.0288 5.96121 10.9001 5.96121ZM9.71282 8.51675C9.21454 8.51675 8.8994 8.04863 8.8994 7.44368C8.8994 6.8759 9.12727 6.38246 9.73868 6.38246C10.2073 6.38246 10.5376 6.79833 10.5376 7.44368C10.5376 8.08418 10.2041 8.51675 9.71282 8.51675Z"
			fill="white"
		/>
		<path
			d="M11.8009 8.66983C11.7557 8.64721 11.725 8.60303 11.7191 8.55294C11.7164 8.50122 11.7309 8.44951 11.76 8.40695L11.8187 8.32507C11.8457 8.28251 11.8893 8.25289 11.9389 8.24319C11.9916 8.24211 12.0434 8.25666 12.0881 8.28413C12.1786 8.34015 12.2723 8.39133 12.3687 8.43604C12.5082 8.49853 12.6602 8.52816 12.8131 8.52385C12.9419 8.52977 13.069 8.49368 13.1757 8.4215C13.2683 8.35524 13.3211 8.24588 13.3157 8.13222C13.3184 8.0401 13.2759 7.95284 13.2015 7.89843C13.1137 7.83325 13.0184 7.77938 12.9176 7.73736C12.8045 7.68888 12.6828 7.64201 12.5519 7.59676C12.4237 7.55313 12.3009 7.49441 12.1861 7.42115C12.0751 7.35112 11.9793 7.26116 11.9022 7.15504C11.8214 7.03437 11.7816 6.89054 11.788 6.74564C11.7853 6.61635 11.8144 6.48922 11.8726 6.37394C11.9275 6.26836 12.0067 6.17732 12.1037 6.10783C12.2077 6.03457 12.3235 5.98016 12.4458 5.94676C12.5799 5.90905 12.7189 5.89074 12.8584 5.89128C13.0324 5.88589 13.2064 5.9139 13.3701 5.97316C13.4763 6.0141 13.5786 6.06312 13.6772 6.11914C13.7246 6.138 13.7602 6.1784 13.7736 6.22742C13.7817 6.27967 13.7704 6.33246 13.7413 6.37664L13.6885 6.46444C13.6341 6.56194 13.5479 6.58349 13.431 6.52855C13.3524 6.48599 13.2716 6.44882 13.1881 6.41758C13.0728 6.3761 12.951 6.35617 12.8282 6.35886C12.7038 6.35455 12.5804 6.38741 12.4743 6.45259C12.3795 6.51346 12.3246 6.62066 12.331 6.73325C12.3289 6.8259 12.3709 6.91425 12.4452 6.97027C12.5319 7.03707 12.6273 7.09094 12.7291 7.13134C12.8422 7.1782 12.964 7.22507 13.0949 7.27194C13.222 7.31719 13.3448 7.37482 13.4606 7.44432C13.5727 7.51165 13.6691 7.60107 13.7445 7.70773C13.8248 7.83002 13.8647 7.97439 13.8587 8.12037C13.8609 8.36278 13.7537 8.5928 13.5662 8.74633C13.4666 8.82767 13.3524 8.88908 13.2301 8.92786C13.089 8.97257 12.9419 8.99412 12.7943 8.99197C12.6795 8.99304 12.5648 8.98227 12.4522 8.95965C12.3574 8.94079 12.2642 8.91332 12.1743 8.87776C12.0988 8.8476 12.0256 8.81258 11.955 8.77272C11.9017 8.74202 11.85 8.70808 11.8009 8.66983Z"
			fill="white"
		/>
		<path
			d="M16.6929 5.36761C16.5641 5.36761 16.5 5.30297 16.5 5.17476V4.98191C16.5 4.85317 16.5646 4.78906 16.6929 4.78906H16.8916C17.0204 4.78906 17.0845 4.85317 17.0845 4.98191V5.17476C17.0845 5.30351 17.0204 5.36815 16.8916 5.36761H16.6929ZM16.5054 6.15194C16.5054 6.0232 16.5695 5.95909 16.6982 5.95909H16.8798C17.0085 5.95909 17.0726 6.02374 17.0726 6.15194V8.74249C17.0726 8.87124 17.008 8.93535 16.8798 8.93535H16.6982C16.5695 8.93535 16.5054 8.8707 16.5054 8.74249V6.15194Z"
			fill="white"
		/>
		<path
			d="M19.9845 8.61442C20.0216 8.69037 19.992 8.78195 19.9177 8.82235C19.6963 8.93709 19.4506 8.99527 19.2012 8.9915C18.1481 8.9915 17.7031 8.19963 17.7031 7.44115C17.7031 6.69723 18.175 5.89081 19.177 5.89081C19.4135 5.88704 19.6478 5.94091 19.859 6.04811C19.9355 6.08797 19.9662 6.1817 19.9274 6.25873L19.8557 6.4031C19.8191 6.47744 19.7307 6.5103 19.6543 6.47798C19.5212 6.41819 19.3768 6.38586 19.2308 6.38317C18.6167 6.38317 18.2828 6.715 18.2828 7.43631C18.2828 8.05203 18.6054 8.50129 19.2427 8.50129C19.4054 8.50022 19.5665 8.46466 19.7146 8.39787C19.7916 8.36501 19.8805 8.3984 19.9166 8.47382C19.9376 8.51907 19.9624 8.56917 19.9845 8.61442Z"
			fill="white"
		/>
		<path
			d="M15.2961 8.74472C15.2961 8.85138 15.2099 8.93757 15.1033 8.93757H14.9217C14.8151 8.93757 14.7284 8.85138 14.7284 8.74472V6.4526H14.4218C14.2969 6.4526 14.2344 6.3885 14.2344 6.25975V6.15309C14.2344 6.06313 14.3071 5.99041 14.3971 5.99041H14.7397V5.34129C14.7397 5.23463 14.8259 5.14844 14.9325 5.14844H15.1022C15.2089 5.14844 15.2951 5.23463 15.2951 5.34129V5.99095H15.8402C15.9302 5.99095 16.0029 6.06367 16.0029 6.15363V6.26029C16.0029 6.38904 15.9404 6.45368 15.8154 6.45314H15.2945L15.2961 8.74472Z"
			fill="white"
		/>
		<path
			d="M5.125 15.5169C5.125 15.3823 5.23435 15.2734 5.36849 15.2734H7.33039C7.43705 15.2734 7.52324 15.3596 7.52324 15.4663V15.5832C7.52324 15.6898 7.43705 15.776 7.33039 15.776H5.69816V17.0689H6.99102C7.09768 17.0689 7.18387 17.1551 7.18387 17.2617V17.3786C7.18387 17.4853 7.09768 17.5715 6.99102 17.5715H5.69816V18.8993H7.42951C7.53617 18.8993 7.62236 18.9855 7.6229 19.0922V19.2091C7.6229 19.3158 7.53617 19.4019 7.42951 19.4019H5.36903C5.23435 19.4019 5.125 19.2926 5.125 19.1579V15.5169Z"
			fill="white"
		/>
		<path
			d="M8.21929 16.6384C8.21929 16.5097 8.28339 16.4456 8.41214 16.4456H8.5759C8.70465 16.4456 8.76929 16.5097 8.76875 16.6384V16.9013C8.76875 16.9406 8.76498 16.98 8.7569 17.0182C8.75259 17.0354 8.75097 17.0532 8.75097 17.071H8.76283C8.80161 16.9789 8.85386 16.8932 8.91797 16.8162C8.98746 16.7316 9.06772 16.6567 9.15768 16.5943C9.25034 16.5296 9.35053 16.4763 9.45612 16.4364C9.56332 16.3955 9.67752 16.3745 9.79226 16.375C10.2798 16.375 10.5761 16.5991 10.6816 17.0478H10.6935C10.736 16.9568 10.791 16.8722 10.8572 16.7963C10.9278 16.7144 11.0081 16.6417 11.097 16.5797C11.1891 16.5161 11.2893 16.466 11.3954 16.4305C11.5069 16.3933 11.6233 16.3745 11.7407 16.375C12.0801 16.375 12.3279 16.4698 12.4835 16.6589C12.6398 16.848 12.7173 17.1319 12.7173 17.51V19.2284C12.7173 19.3572 12.6527 19.4213 12.5245 19.4213H12.3429C12.2142 19.4213 12.1496 19.3572 12.1501 19.2284V17.6328C12.1506 17.5348 12.1436 17.4373 12.1296 17.3403C12.1183 17.2585 12.093 17.1793 12.0537 17.1065C12.0165 17.0403 11.9621 16.9859 11.8958 16.9487C11.814 16.9067 11.7218 16.8862 11.6297 16.89C11.5004 16.8878 11.3728 16.9212 11.2613 16.9864C11.1514 17.0516 11.0566 17.1394 10.9833 17.2439C10.9057 17.3549 10.847 17.4788 10.8109 17.6097C10.7721 17.7449 10.7527 17.8844 10.7522 18.025V19.229C10.7522 19.3577 10.6897 19.4218 10.5653 19.4218H10.3778C10.2528 19.4218 10.1903 19.3572 10.1903 19.229V17.6334C10.1903 17.5397 10.185 17.4459 10.1726 17.3527C10.1629 17.2703 10.1392 17.19 10.1025 17.1157C10.0675 17.0473 10.0137 16.9907 9.9474 16.9519C9.8639 16.9072 9.77017 16.8862 9.67536 16.8905C9.54285 16.8884 9.41248 16.9229 9.29828 16.9897C9.18731 17.0559 9.09196 17.1443 9.01763 17.2498C8.94005 17.3608 8.88134 17.4847 8.84524 17.6156C8.807 17.7487 8.78707 17.8866 8.78707 18.025V19.229C8.78707 19.3577 8.72242 19.4218 8.59368 19.4218H8.4116C8.28285 19.4218 8.21875 19.3577 8.21875 19.229V16.6384H8.21929Z"
			fill="white"
		/>
		<path
			d="M17.1069 15.852C16.9782 15.852 16.9141 15.7873 16.9141 15.6591V15.4663C16.9141 15.3375 16.9782 15.2734 17.1069 15.2734H17.3057C17.4344 15.2734 17.4985 15.3381 17.4985 15.4663V15.6591C17.4985 15.7879 17.4344 15.852 17.3057 15.852H17.1069ZM16.92 16.6363C16.92 16.5076 16.9841 16.4435 17.1128 16.4435H17.2944C17.4231 16.4435 17.4872 16.5076 17.4872 16.6363V19.2263C17.4872 19.3551 17.4231 19.4192 17.2944 19.4192H17.1128C16.9841 19.4192 16.92 19.3545 16.92 19.2263V16.6363Z"
			fill="white"
		/>
		<path
			d="M18.8719 19.23C18.8719 19.3588 18.8073 19.4229 18.6785 19.4229H18.4975C18.3688 19.4229 18.3047 19.3583 18.3047 19.23V15.1856C18.3047 15.0568 18.3688 14.9922 18.4975 14.9922H18.6791C18.8078 14.9922 18.8719 15.0568 18.8719 15.1856V19.23Z"
			fill="white"
		/>
		<path
			d="M15.8996 16.4456H15.759C15.6302 16.4456 15.5661 16.5 15.5661 16.6093V16.7564C15.5666 16.7952 15.5704 16.8345 15.578 16.8728H15.5666C15.523 16.778 15.4589 16.6945 15.3797 16.6271C15.2946 16.5555 15.1987 16.4973 15.0958 16.4547C14.952 16.3976 14.7974 16.3707 14.6423 16.3756C13.8531 16.3756 13.3203 16.9374 13.3203 17.9512C13.3203 18.8837 13.8455 19.4929 14.5932 19.4929C14.994 19.4929 15.4298 19.3265 15.5666 18.9898H15.5785C15.5726 19.0297 15.5683 19.0695 15.5666 19.1099V19.2586C15.5666 19.3674 15.6313 19.4224 15.7595 19.4224H15.9001C16.0288 19.4224 16.0929 19.3577 16.0929 19.2295V16.639C16.0929 16.5097 16.0283 16.4456 15.8996 16.4456ZM14.7123 19.0011C14.214 19.0011 13.8989 18.533 13.8989 17.9275C13.8989 17.3597 14.1267 16.8668 14.7381 16.8668C15.2068 16.8668 15.537 17.2827 15.537 17.9281C15.537 18.5686 15.2036 19.0011 14.7123 19.0011Z"
			fill="white"
		/>
		<path
			d="M14.7628 11.7318C14.5634 11.4727 14.2699 11.3025 13.9456 11.2583C13.896 11.2508 13.8454 11.2465 13.7953 11.2465H13.3471C13.2706 11.2459 13.2081 11.3079 13.2076 11.3844V11.3849V11.6111C13.2076 11.6876 13.27 11.7496 13.3465 11.7496H13.3471H13.7166C13.7436 11.7496 13.7705 11.7512 13.7969 11.7534C13.8206 11.7544 13.8437 11.7582 13.8669 11.7636C14.0511 11.7997 14.2138 11.9058 14.3205 12.0604C14.4239 12.2118 14.4681 12.3955 14.4444 12.5776C14.4207 12.7607 14.3291 12.9288 14.188 13.0473C14.1163 13.1076 14.0334 13.1523 13.9434 13.1787C13.8416 13.2014 13.7371 13.2111 13.6326 13.2089H10.2782C10.1624 13.2073 10.0482 13.182 9.94257 13.1351C9.77719 13.0489 9.65168 12.9018 9.59242 12.7252C9.53316 12.5522 9.53909 12.3632 9.60858 12.194C9.71578 11.9257 9.97543 11.7496 10.2647 11.7496H11.8129L11.3566 12.2527C11.3146 12.2991 11.3184 12.3702 11.3642 12.4122L11.3679 12.4154L11.5166 12.5388C11.5667 12.5802 11.6411 12.5732 11.6831 12.5231L12.413 11.6445C12.4841 11.5594 12.4841 11.4361 12.413 11.351L11.6831 10.4724C11.6416 10.4223 11.5673 10.4153 11.5166 10.4567L11.3674 10.5806C11.3195 10.6205 11.313 10.6916 11.3529 10.7396L11.3561 10.7428L11.8129 11.2459H10.2647C10.1058 11.2448 9.94742 11.2718 9.79766 11.3251C9.49007 11.4388 9.23958 11.6677 9.0979 11.9635C8.95838 12.2646 8.94707 12.6088 9.06612 12.9185C9.18679 13.224 9.42219 13.4691 9.72278 13.6016C9.86769 13.6722 10.0261 13.7093 10.1871 13.7115H13.631C13.7802 13.7136 13.9294 13.7007 14.0765 13.6738C14.2327 13.6334 14.3797 13.5639 14.5106 13.4691C15.058 13.0726 15.1797 12.3077 14.7832 11.7604C14.7768 11.7507 14.7698 11.7415 14.7628 11.7318Z"
			fill="white"
		/>
	</svg>
);

export const NetcoreIcon = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M20.5241 0.689655L18.3448 6.15172L20.469 10.5379L22.7862 4.88276H27.8345V24.2207C27.8345 24.9655 27.531 25.6552 27.0069 26.1793C26.4828 26.7034 25.7655 27.0069 25.0207 27.0069C24.4414 27.0069 23.4207 26.6759 23.0069 25.8759L19.9172 19.0897L19.8897 19.1172L14.8138 8L14.8414 7.97241L12.6897 3.33793C11.4759 0.910345 9.02069 0 7.0069 0C5.15862 0 3.36552 0.744828 2.06897 2.04138C0.744828 3.33793 0 5.13103 0 6.97931L0.0827587 30.4828H10.6759L13.4069 24.5793L11.2828 20.1931L8.41379 26.2897H4.1931V6.97931C4.1931 6.23448 4.49655 5.54483 5.02069 5.02069C5.54483 4.49655 6.26207 4.1931 7.0069 4.1931C7.36552 4.1931 8.63448 4.27586 9.10345 5.48966L11.4759 10.6759L12.2483 12.4138L17.3241 23.531C18.2069 25.4345 19.2 27.531 19.6138 28.4414C20.4966 30.2621 22.7862 31.2 25.0207 31.2C25.931 31.2 26.8414 31.0069 27.6966 30.6759C28.5517 30.3172 29.3241 29.8207 29.9586 29.1586C30.6207 28.5241 31.1172 27.7517 31.4759 26.8966C31.8345 26.0414 32 25.131 32 24.2207V0.689655H20.5241Z"
			fill="#FC5E02"
		/>
	</svg>
);

export const MailjetIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="24" height="24" fill="url(#pattern0_12821_41640)" />
		<defs>
			<pattern
				id="pattern0_12821_41640"
				patternContentUnits="objectBoundingBox"
				width="1"
				height="1"
			>
				<use
					xlinkHref="#image0_12821_41640"
					transform="scale(0.0025)"
				/>
			</pattern>
			<image
				id="image0_12821_41640"
				width="400"
				height="400"
				xlinkHref="data:image/png;base64,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"
			/>
		</defs>
	</svg>
);

export const SMTP2GoIcon = ( props ) => (
	<svg
		width="96"
		height="96"
		viewBox="0 0 96 96"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="96" height="96" fill="white" />
		<path
			d="M54.0222 66.6055C53.6517 66.6055 53.2812 66.5055 53.0033 66.2055C52.3549 65.7055 52.1696 64.7055 52.6328 63.9055C52.7254 63.7055 63.1001 45.1055 57.7275 35.9055C56.6159 34.0055 55.4117 32.9055 54.0222 32.9055C51.4286 32.8055 48.557 35.9055 47.6307 37.2055C47.0749 38.0055 46.0559 38.1055 45.3149 37.5055C44.5738 36.9055 44.4812 35.8055 45.037 35.0055C45.2222 34.8055 49.298 29.1055 54.1149 29.4055C56.6159 29.5055 58.7465 31.1055 60.4138 34.1055C64.397 41.0055 61.618 51.4055 58.8391 58.3055C61.7107 56.1055 65.3233 54.0055 68.658 53.4055C69.5844 53.3055 70.418 53.9055 70.5107 54.9055C70.6033 55.9055 70.0475 56.8055 69.1212 56.9055C62.7296 58.0055 55.1338 66.0055 55.0412 66.1055C54.8559 66.5055 54.3928 66.6055 54.0222 66.6055Z"
			fill="#ABD3FF"
		/>
		<path
			d="M14.0968 51.9055C14.0968 52.8055 13.9116 53.7055 13.4484 54.4055C12.9853 55.1055 12.3368 55.7055 11.5032 56.1055C10.6695 56.5055 9.65053 56.7055 8.44632 56.7055C7.52 56.7055 6.68632 56.6055 6.03789 56.5055C5.38947 56.4055 4.74105 56.1055 4 55.8055V52.2055C4.74105 52.6055 5.48211 52.9055 6.31579 53.1055C7.05684 53.3055 7.79789 53.4055 8.44632 53.4055C9.00211 53.4055 9.46526 53.3055 9.74316 53.1055C10.0211 52.9055 10.1137 52.6055 10.1137 52.3055C10.1137 52.1055 10.0211 51.9055 9.92842 51.8055C9.92842 51.6055 9.74316 51.4055 9.46526 51.3055C9.18737 51.1055 8.53895 50.8055 7.52 50.3055C6.59368 49.9055 5.85263 49.4055 5.38947 49.0055C4.92632 48.6055 4.55579 48.1055 4.37053 47.6055C4.18526 47.1055 4 46.4055 4 45.7055C4 44.3055 4.46316 43.2055 5.48211 42.5055C6.40842 41.7055 7.79789 41.3055 9.46526 41.3055C10.9474 41.3055 12.5221 41.7055 14.0042 42.4055L12.8926 45.4055C11.5032 44.8055 10.3916 44.4055 9.37263 44.4055C8.90947 44.4055 8.53895 44.5055 8.26105 44.7055C8.07579 44.9055 7.89053 45.2055 7.89053 45.4055C7.89053 45.7055 8.07579 46.0055 8.35368 46.2055C8.63158 46.4055 9.46526 46.9055 10.7621 47.5055C11.9663 48.1055 12.8926 48.7055 13.3558 49.4055C13.8189 50.1055 14.0968 50.9055 14.0968 51.9055ZM22.2484 56.5055L19.2842 45.6055H19.1916C19.2842 47.5055 19.3768 48.9055 19.3768 49.9055V56.4055H15.9495V41.4055H21.1368L24.1937 52.1055H24.2863L27.1579 41.4055H32.3453V56.5055H28.7326V48.8055C28.7326 48.8055 28.8253 47.4055 28.8253 45.7055H28.7326L25.8611 56.5055H22.2484ZM41.0526 56.5055H37.1621V44.7055H33.6421V41.4055H44.5726V44.7055H41.0526V56.5055ZM56.7074 46.2055C56.7074 47.9055 56.2442 49.2055 55.3179 50.1055C54.3916 51.0055 53.0021 51.5055 51.2421 51.5055H50.1305V56.5055H46.24V41.4055H51.2421C53.0947 41.4055 54.4842 41.8055 55.3179 42.6055C56.2442 43.5055 56.7074 44.7055 56.7074 46.2055ZM50.1305 48.2055H50.8716C51.4274 48.2055 51.8905 48.0055 52.2611 47.7055C52.6316 47.4055 52.8168 46.9055 52.8168 46.3055C52.8168 45.3055 52.2611 44.8055 51.1495 44.8055H50.1305V48.2055ZM70.1389 47.7055H76.3453V55.8055C74.6779 56.4055 72.8253 56.7055 70.7874 56.7055C68.5642 56.7055 66.8042 56.0055 65.6 54.7055C64.3958 53.4055 63.7474 51.4055 63.7474 48.9055C63.7474 46.5055 64.3958 44.6055 65.7853 43.2055C67.0821 41.8055 69.0274 41.2055 71.3432 41.2055C72.2695 41.2055 73.1032 41.3055 73.9368 41.5055C74.7705 41.7055 75.4189 41.9055 76.0674 42.2055L74.7705 45.3055C73.7516 44.8055 72.5474 44.5055 71.3432 44.5055C70.2316 44.5055 69.3053 44.9055 68.6568 45.7055C68.0084 46.5055 67.7305 47.6055 67.7305 49.0055C67.7305 50.4055 68.0084 51.5055 68.5642 52.2055C69.12 52.9055 69.9537 53.3055 70.9726 53.3055C71.5284 53.3055 72.0842 53.2055 72.5474 53.1055V50.7055H70.1389V47.7055ZM92 48.9055C92 51.4055 91.4442 53.4055 90.24 54.7055C89.0358 56.0055 87.2758 56.7055 84.96 56.7055C82.7368 56.7055 80.9768 56.0055 79.7726 54.7055C78.5684 53.4055 77.92 51.4055 77.92 48.9055C77.92 46.4055 78.5684 44.5055 79.68 43.1055C80.7916 41.7055 82.6442 41.1055 84.96 41.1055C87.2758 41.1055 89.0358 41.8055 90.1474 43.1055C91.2589 44.4055 92 46.4055 92 48.9055ZM82.0884 48.9055C82.0884 51.8055 83.1074 53.3055 85.0526 53.3055C86.0716 53.3055 86.8126 52.9055 87.2758 52.2055C87.7389 51.5055 88.0168 50.4055 88.0168 48.9055C88.0168 47.4055 87.7389 46.3055 87.2758 45.6055C86.8126 44.9055 86.0716 44.5055 85.1453 44.5055C83.0147 44.5055 82.0884 46.0055 82.0884 48.9055Z"
			fill="#252E37"
		/>
	</svg>
);

export const MailerSendIcon = ( props ) => (
	<svg
		width="30px"
		height="30px"
		viewBox="0 0 30 30"
		version="1.1"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<title>symbol</title>
		<g
			id="logo"
			stroke="none"
			strokeWidth="1"
			fill="none"
			fillRule="evenodd"
		>
			<g id="symbol" fillRule="nonzero">
				<path
					d="M29.5793151,10.1663649 C29.4628886,9.99688216 29.2691772,9.90994232 29.0738683,9.90994232 L17.9522395,9.90994232 L23.498176,1.04527667 C23.6409633,0.817634197 23.6489514,0.506049814 23.4756097,0.256222694 C23.3579849,0.0865401142 23.1622765,0 22.9661687,0 L13.3890387,0 C12.4274714,0 11.5290101,0.515643175 10.9904126,1.3764475 L0.106230039,18.7748078 C-0.0361578035,19.0026502 -0.0421488768,19.3142345 0.129395522,19.5640617 C0.245622344,19.7333445 0.439333714,19.8200845 0.634842406,19.8200845 L11.7508795,19.8200845 L6.20434385,28.6869486 C6.10449263,28.846838 6.07393815,29.0480987 6.11947031,29.2399659 C6.18956587,29.5371603 6.45277369,29.7322253 6.73655086,29.7322253 L16.3080893,29.7322253 C17.2768458,29.7322253 18.182097,29.2125849 18.7244888,28.345385 L24.0563444,19.8200845 L24.0565441,19.8200845 L29.6020812,10.9554189 C29.7446688,10.7277764 29.7506598,10.4157923 29.5793151,10.1663649"
					id="Fill-1"
					fill="#4E48E0"
				></path>
				<path
					d="M24.0576142,19.8181059 L18.7245604,28.3452051 C18.1821686,29.2126049 17.2767177,29.7320454 16.3081608,29.7320454 L6.73662243,29.7320454 C6.45284526,29.7320454 6.18963744,29.5371803 6.11954188,29.2399859 C6.07400973,29.0481187 6.1045642,28.846858 6.20441542,28.6869686 L11.7519496,19.8181059 L24.0576142,19.8181059 Z"
					id="Fill-3"
					fill="#4E48E0"
				></path>
				<path
					d="M17.9450419,9.90992233 L29.0738599,9.90992233 C29.2691689,9.90992233 29.4628803,9.99686217 29.5793068,10.166145 C29.7508512,10.4157723 29.7444608,10.7275565 29.6022726,10.9553989 L24.0567355,19.8200645 L11.746278,19.8200645 L17.9450419,9.90992233 Z"
					id="Fill-5"
					fill="#1C81C1"
				></path>
				<path
					d="M0.634794157,19.8200445 C0.439485167,19.8200445 0.245773797,19.7333046 0.129546975,19.5640217 C-0.0421971263,19.3141946 -0.036206053,19.0026102 0.106381492,18.7749677 L10.9905641,1.37640753 C11.5289618,0.515603203 12.4276228,-3.99723392e-05 13.3889904,-3.99723392e-05 L22.9661205,-3.99723392e-05 C23.1622283,-3.99723392e-05 23.3581364,0.0867000036 23.4757611,0.256182722 C23.6489031,0.506009841 23.640915,0.817594225 23.4983275,1.04543656 L11.7520295,19.8200445 L0.634794157,19.8200445 Z"
					id="Fill-7"
					fill="#5CC4CD"
				></path>
			</g>
		</g>
	</svg>
);

export const ZohoIcon = ( props ) => (
	<svg
		version="1.1"
		viewBox="0 0 1024 450"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="m458.1 353c-7.7 0-15.5-1.6-23-4.9l-160-71.3c-28.6-12.7-41.5-46.4-28.8-75l71.3-160c12.7-28.6 46.4-41.5 75-28.8l160 71.3c28.6 12.7 41.5 46.4 28.8 75l-71.3 160c-9.5 21.2-30.3 33.7-52 33.7zm-9.7-34.9c12.1 5.4 26.3-0.1 31.7-12.1l71.3-160c5.4-12.1-0.1-26.3-12.1-31.7l-160.1-71.3c-12.1-5.4-26.3 0.1-31.7 12.1l-71.3 160c-5.4 12.1 0.1 26.3 12.1 31.7z"
			fill="#089949"
		/>
		<path
			d="m960 353.1h-175.2c-31.3 0-56.8-25.5-56.8-56.8v-175.2c0-31.3 25.5-56.8 56.8-56.8h175.2c31.3 0 56.8 25.5 56.8 56.8v175.2c0 31.3-25.5 56.8-56.8 56.8zm-175.2-256c-13.2 0-24 10.8-24 24v175.2c0 13.2 10.8 24 24 24h175.2c13.2 0 24-10.8 24-24v-175.2c0-13.2-10.8-24-24-24z"
			fill="#f9b21d"
		/>
		<path
			d="m303.9 153.2-23.6 52.8c-0.3 0.6-0.6 1.1-0.9 1.6l9.2 56.8c2.1 13.1-6.8 25.4-19.8 27.5l-173 28c-6.3 1-12.7-0.5-17.9-4.2s-8.6-9.3-9.6-15.6l-28-173c-1-6.3 0.5-12.7 4.2-17.9s9.3-8.6 15.6-9.6l173-28c1.3-0.2 2.6-0.3 3.8-0.3 11.5 0 21.8 8.4 23.7 20.2l9.3 57.2 24.4-54.7-1.3-7.7c-5-30.9-34.2-52-65.1-47l-173 28c-14.9 2.3-28.1 10.4-36.9 22.7-8.9 12.3-12.4 27.3-10 42.3l28 173c2.4 15 10.5 28.1 22.8 37 9.7 7.1 21.2 10.7 33.1 10.7 3 0 6.1-0.2 9.2-0.7l173-28c30.9-5 52-34.2 47-65.1z"
			fill="#e42527"
		/>
		<path
			d="m511.4 235.8 25.4-56.9-7.2-52.9c-0.9-6.3 0.8-12.6 4.7-17.7s9.5-8.4 15.9-9.2l173.6-23.6c1.1-0.1 2.2-0.2 3.3-0.2 5.2 0 10.2 1.7 14.5 4.9 0.8 0.6 1.5 1.3 2.2 1.9 7.7-8.1 17.8-13.9 29.1-16.4-3.2-4.4-7-8.3-11.5-11.7-12.1-9.2-27-13.1-42-11.1l-173.8 23.6c-15 2-28.4 9.8-37.5 21.9-9.2 12.1-13.1 27-11.1 42z"
			fill="#226db4"
		/>
		<path
			d="m806.8 265.1-22.8-168c-12.8 0.4-23.1 11-23.1 23.9v49.3l13.5 99.2c0.9 6.3-0.8 12.6-4.7 17.7s-9.5 8.4-15.9 9.2l-173.6 23.6c-6.3 0.9-12.6-0.8-17.7-4.7s-8.4-9.5-9.2-15.9l-8-58.9-25.4 56.9 0.9 6.4c2 15 9.8 28.4 21.9 37.5 10 7.6 21.9 11.6 34.3 11.6 2.6 0 5.2-0.2 7.8-0.5l173.4-23.4c15-2 28.4-9.8 37.5-21.9 9.2-12.1 13.1-27 11.1-42z"
			fill="#226db4"
		/>
		<path d="m655.4 415.6c0-15 11-25.8 26-25.8 15.5 0 26 10.6 26 25.9 0 15.5-10.7 26.2-26.2 26.2-15.6 0-25.8-10.7-25.8-26.3zm40 0.2c0-9.1-4.4-16.9-14.3-16.9-10 0-13.8 8.1-13.8 17.3 0 8.7 4.7 16.7 14.3 16.7 9.9-0.1 13.8-8.6 13.8-17.1zm-150.9-25.2h7.4c1.1 0 2 0.9 2 2v18.6h21v-18.6c0-1.1 0.9-2 2-2h7.4c1.1 0 2 0.9 2 2v46.5c0 1.1-0.9 2-2 2h-7.3c-1.1 0-2-0.9-2-2v-18.8h-21v18.8c0 1.1-0.9 2-2 2h-7.4c-1.1 0-2-0.9-2-2v-46.5c-0.1-1.1 0.8-2 1.9-2zm-123.1 25c0-15 11-25.8 26-25.8 15.5 0 26 10.6 26 25.9 0 15.5-10.7 26.2-26.2 26.2-15.6 0-25.8-10.7-25.8-26.3zm40.1 0.2c0-9.1-4.4-16.9-14.3-16.9-10 0-13.8 8.1-13.8 17.3 0 8.7 4.7 16.7 14.3 16.7 9.9-0.1 13.8-8.6 13.8-17.1zm-144.5 20.4 24.8-36.6h-20.4c-1.1 0-2-0.9-2-2v-4.9c0-1.1 0.9-2 2-2h33.5c1.1 0 2 0.9 2 2v1.9c0 0.4-0.1 0.8-0.3 1.1l-24.3 36.6h21.8c1.1 0 2 0.9 2 2v4.9c0 1.1-0.9 2-2 2h-35.4c-1.1 0-2-0.9-2-2v-1.8c-0.1-0.5 0.1-0.9 0.3-1.2z" />
	</svg>
);

export const SureCartLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M12 24C18.6275 24 24 18.6273 24 11.9999C24 5.37255 18.6275 0 12 0C5.37259 0 0 5.37255 0 11.9999C0 18.6273 5.37259 24 12 24ZM12.0517 5.99996C11.0882 5.99996 9.75474 6.55101 9.0734 7.23073L7.2229 9.07688H16.4465L19.5307 5.99996H12.0517ZM14.9111 16.7692C14.2298 17.4489 12.8964 17.9999 11.9328 17.9999H4.45388L7.53804 14.923H16.7616L14.9111 16.7692ZM17.9089 10.6153H5.68418L5.10673 11.1923C3.73941 12.423 4.14495 13.3846 6.0598 13.3846H18.3176L18.8952 12.8076C20.2492 11.5841 19.8237 10.6153 17.9089 10.6153Z"
			fill="#01824C"
		/>
	</svg>
);

export const SpectraLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M12 24C18.6274 24 24 18.6274 24 12C24 5.37257 18.6274 0 12 0C5.37257 0 0 5.37257 0 12C0 18.6274 5.37257 24 12 24ZM15.6902 15.516C16.384 15.0774 16.8 14.3435 16.8 13.5581C16.8 12.4668 16.0032 11.5178 14.8731 11.2631L11.4871 10.4226C11.1679 10.3507 11.0914 9.95709 11.3629 9.78387L14.0009 8.10127C15.2289 7.31805 15.5481 5.74841 14.714 4.59538C14.6098 4.45125 14.4008 4.41377 14.2473 4.51169L8.28802 8.53145C7.60745 8.96554 7.2 9.68798 7.2 10.4605C7.2 11.5388 7.98723 12.4764 9.10385 12.7281L12.545 13.581C12.865 13.6531 12.9408 14.048 12.6679 14.2205L10.0105 15.9005C8.77913 16.6789 8.45294 18.2473 9.28193 19.4035C9.38558 19.5481 9.59434 19.5864 9.74829 19.489L15.6902 15.516Z"
			fill="#6005FF"
		/>
	</svg>
);

export const AbandonedCartsLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="24" height="24" rx="2" fill="#F06434" />
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M16.9795 5.76469C17.0428 5.54848 17.2411 5.3999 17.4664 5.3999H19.2926C19.5728 5.3999 19.7999 5.62702 19.7999 5.90719C19.7999 6.18736 19.5728 6.41448 19.2926 6.41448H17.8465L15.6795 13.8183C15.8743 13.8846 16.0547 13.9878 16.209 14.1375C16.5283 14.4473 16.6547 14.8774 16.6547 15.3428C16.6547 15.8072 16.5294 16.2467 16.2317 16.5753C15.9527 16.8832 15.5706 17.0405 15.1466 17.0644C15.2034 17.2239 15.2343 17.3958 15.2343 17.5748C15.2343 18.4154 14.5529 19.0967 13.7124 19.0967C12.8719 19.0967 12.1906 18.4154 12.1906 17.5748C12.1906 17.397 12.2211 17.2262 12.2772 17.0676H10.4806C10.5367 17.2262 10.5672 17.397 10.5672 17.5748C10.5672 18.4154 9.88587 19.0967 9.04537 19.0967C8.20486 19.0967 7.5235 18.4154 7.5235 17.5748C7.5235 16.7343 8.20486 16.053 9.04537 16.053H15.0314C15.2718 16.053 15.4033 15.9785 15.4798 15.8941C15.5625 15.8028 15.6401 15.6335 15.6401 15.3428C15.6401 15.053 15.5637 14.9251 15.5024 14.8656C15.4384 14.8035 15.3064 14.734 15.0314 14.734H7.92645C7.5237 14.734 7.16851 14.4702 7.05222 14.0846L5.44818 8.76588C5.23212 8.04949 5.76841 7.3276 6.51668 7.3276H16.5221L16.9795 5.76469ZM16.2251 8.34218H14.4775L14.3142 9.45822H15.8985L16.2251 8.34218ZM15.6015 10.4728H14.1657L14.0024 11.5888H15.2749L15.6015 10.4728ZM14.9779 12.6034H13.8539L13.6906 13.7194H14.6513L14.9779 12.6034ZM12.6652 13.7194L12.8285 12.6034H11.6833V13.7194H12.6652ZM10.6687 13.7194V12.6034H9.58616L9.85189 13.7194H10.6687ZM8.80895 13.7194L8.54322 12.6034H7.66524L8.00182 13.7194H8.80895ZM7.35926 11.5888H8.30166L8.03593 10.4728H7.02267L7.35926 11.5888ZM6.71669 9.45822H7.79437L7.52864 8.34218H6.51668C6.44865 8.34218 6.3999 8.40781 6.41954 8.47293L6.71669 9.45822ZM8.57158 8.34218L8.83731 9.45822H10.6687V8.34218H8.57158ZM11.6833 8.34218V9.45822H13.2888L13.4521 8.34218H11.6833ZM13.1403 10.4728H11.6833V11.5888H12.977L13.1403 10.4728ZM10.6687 11.5888V10.4728H9.07887L9.3446 11.5888H10.6687ZM9.04537 17.0676C8.7652 17.0676 8.53808 17.2947 8.53808 17.5748C8.53808 17.855 8.7652 18.0821 9.04537 18.0821C9.32554 18.0821 9.55266 17.855 9.55266 17.5748C9.55266 17.2947 9.32554 17.0676 9.04537 17.0676ZM13.7124 17.0676C13.4323 17.0676 13.2051 17.2947 13.2051 17.5748C13.2051 17.855 13.4323 18.0821 13.7124 18.0821C13.9926 18.0821 14.2197 17.855 14.2197 17.5748C14.2197 17.2947 13.9926 17.0676 13.7124 17.0676Z"
			fill="white"
		/>
	</svg>
);

export const SureTriggersLogo = ( props ) => (
	<svg
		width="52"
		height="52"
		viewBox="0 0 52 52"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g filter="url(#filter0_d_17130_33424)">
			<g clipPath="url(#clip0_17130_33424)">
				<rect
					x="2"
					y="2"
					width="48"
					height="48"
					rx="12.9231"
					fill="#D2F059"
				/>
				<g filter="url(#filter1_dddd_17130_33424)">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M25.9963 35.6777C31.3412 35.6777 35.6733 31.3451 35.6733 26.0005C35.6733 20.6559 31.3412 16.3232 25.9963 16.3232C20.6514 16.3232 16.3193 20.6559 16.3193 26.0005C16.3193 31.3451 20.6514 35.6777 25.9963 35.6777ZM25.9963 43.078C34.1601 43.078 40.986 37.3493 42.6734 29.6924H47.2264V22.3078L42.6732 22.3078C40.9855 14.6513 34.1598 8.92297 25.9963 8.92297C17.8328 8.92297 11.0071 14.6513 9.31944 22.3078L4.76562 22.3078V29.6924H9.31928C11.0067 37.3493 17.8325 43.078 25.9963 43.078Z"
						fill="url(#paint0_linear_17130_33424)"
					/>
				</g>
			</g>
		</g>
		<defs>
			<filter
				id="filter0_d_17130_33424"
				x="0.615385"
				y="0.615385"
				width="50.7692"
				height="50.7692"
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feMorphology
					radius="1.38462"
					operator="dilate"
					in="SourceAlpha"
					result="effect1_dropShadow_17130_33424"
				/>
				<feOffset />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.777287 0 0 0 0 0.9125 0 0 0 0 0.231927 0 0 0 1 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_17130_33424"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_17130_33424"
					result="shape"
				/>
			</filter>
			<filter
				id="filter1_dddd_17130_33424"
				x="-3.1163"
				y="6.29567"
				width="58.2245"
				height="49.9188"
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.25461" />
				<feGaussianBlur stdDeviation="3.94096" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.06 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_17130_33424"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dx="-1.18229" dy="3.94096" />
				<feGaussianBlur stdDeviation="2.29889" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
				/>
				<feBlend
					mode="normal"
					in2="effect1_dropShadow_17130_33424"
					result="effect2_dropShadow_17130_33424"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="1.31365" />
				<feGaussianBlur stdDeviation="1.31365" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"
				/>
				<feBlend
					mode="normal"
					in2="effect2_dropShadow_17130_33424"
					result="effect3_dropShadow_17130_33424"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="1.31365" />
				<feGaussianBlur stdDeviation="0.656827" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0"
				/>
				<feBlend
					mode="normal"
					in2="effect3_dropShadow_17130_33424"
					result="effect4_dropShadow_17130_33424"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect4_dropShadow_17130_33424"
					result="shape"
				/>
			</filter>
			<linearGradient
				id="paint0_linear_17130_33424"
				x1="25.9961"
				y1="43.0779"
				x2="25.9961"
				y2="8.92297"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#072F50" stopOpacity="0.95" />
				<stop offset="1" stopColor="#172A39" stopOpacity="0.75" />
			</linearGradient>
			<clipPath id="clip0_17130_33424">
				<rect
					x="2"
					y="2"
					width="48"
					height="48"
					rx="12.9231"
					fill="white"
				/>
			</clipPath>
		</defs>
	</svg>
);

export const SureFormsLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path d="M24 0H0V24H24V0Z" fill="#D54407" />
		<path
			d="M6.85156 5.14062H17.1373V8.56921H8.56586L6.85156 10.2835V8.56921V5.14062Z"
			fill="white"
		/>
		<path
			d="M6.85156 10.2812H15.423V13.7098H8.56586L6.85156 15.4241V13.7098V10.2812Z"
			fill="white"
		/>
		<path
			d="M6.85156 15.4297H11.9944V18.8582H6.85156V15.4297Z"
			fill="white"
		/>
	</svg>
);

export const SureDashLogo = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M0 0H16C24.8366 0 32 7.16344 32 16C32 24.8366 24.8366 32 16 32H0V0ZM15.5417 13.8237C16.2444 13.029 16.6735 11.9684 16.6735 10.8036C16.6735 9.77758 16.3406 8.83247 15.7811 8.07871C16.4338 7.55548 17.2624 7.24252 18.1641 7.24252C20.2699 7.24252 21.9771 8.94969 21.9771 11.0556C21.9771 13.1615 20.2699 14.8687 18.1641 14.8687C17.1482 14.8687 16.2251 14.4714 15.5417 13.8237ZM11.05 14.9207C8.68087 14.9207 6.76031 13.0001 6.76031 10.631C6.76031 8.26185 8.68087 6.34129 11.05 6.34129C13.4191 6.34129 15.3397 8.26185 15.3397 10.631C15.3397 13.0001 13.4191 14.9207 11.05 14.9207ZM17.3691 25.5941V20.6459C17.3691 18.5614 16.1814 16.7749 14.4933 16.0246H18.1405C20.8009 16.0246 22.9576 18.1813 22.9576 20.8417C22.9576 23.5021 20.8009 25.6587 18.1405 25.6587C17.871 25.6587 17.6138 25.6366 17.3691 25.5941ZM6.22407 25.645V20.819C6.22407 18.1537 8.33823 15.9931 10.9462 15.9931C13.5541 15.9931 16.1612 18.1537 16.1612 20.819V25.645H6.22407Z"
			fill="#4B3BED"
		/>
	</svg>
);

export const CartFlowsLogo = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M20.0214 1.77322C18.8526 2.91414 18.1255 4.50139 18.1255 6.26346V16.7001C18.1255 18.2334 16.8759 19.4831 15.3426 19.4831H8.34589C6.81264 19.4831 5.56392 18.2334 5.56392 16.7001C5.56392 15.1668 6.81264 13.9161 8.34589 13.9161H16.0167V8.35096H8.34589C7.87541 8.35096 7.40958 8.38909 6.95398 8.46348C3.0079 9.12928 0 12.566 0 16.7001C0 20.3349 2.32357 23.4257 5.56392 24.5685C6.01116 24.7265 6.47606 24.8577 6.95398 24.9283C7.40958 25.012 7.87541 25.0539 8.34589 25.0539H15.3426C15.8196 25.0539 16.2817 25.012 16.7336 24.9283C17.2106 24.8577 17.6764 24.7265 18.1265 24.5685C21.3668 23.4257 23.6913 20.3349 23.6913 16.7001V13.9161C26.768 13.9161 29.258 11.4251 29.258 8.3519H23.6913V6.26253C23.6913 5.87664 24.0037 5.56979 24.384 5.56979H25.7787C27.4756 5.56979 29.0181 4.89751 30.146 3.79564C31.1567 2.81093 31.8401 1.4859 32 0H24.3849C22.6927 0.000929848 21.1502 0.67786 20.0214 1.77322Z"
			fill="#F16334"
		/>
		<path
			d="M8.34446 26.4414C6.80936 26.4414 5.5625 27.6837 5.5625 29.2198C5.5625 30.754 6.80936 32.0019 8.34446 32.0019C9.88234 32.0019 11.1292 30.754 11.1292 29.2179C11.1292 27.6837 9.88141 26.4414 8.34446 26.4414Z"
			fill="#F16334"
		/>
		<path
			d="M16.6923 26.4414C15.1553 26.4414 13.9141 27.6837 13.9141 29.2198C13.9141 30.754 15.1553 32.0019 16.6923 32.0019C18.2339 32.0019 19.4752 30.754 19.4752 29.2179C19.4743 27.6837 18.2339 26.4414 16.6923 26.4414Z"
			fill="#F16334"
		/>
	</svg>
);

export const SureFeedbackLogo = ( props ) => (
	<svg
		width="32"
		height="32"
		viewBox="0 0 32 32"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M0 6.0183C0 3.7994 1.7912 2 4 2H28C30.2096 2 32 3.7994 32 6.0183V22.0915C32 24.3113 30.2096 26.1098 28 26.1098H8.09678L2.5688 30.3355C1.5152 31.1408 0 30.3861 0 29.056V16.3091V16.3044V6.0183ZM9.42883 12.4444C9.04082 11.6471 8.08237 11.316 7.2888 11.7058C6.4944 12.0956 6.1656 13.0583 6.5536 13.8556C8.25922 17.3619 11.8464 19.7826 16 19.7826C20.1536 19.7826 23.7408 17.3619 25.4464 13.8556C25.8344 13.0575 25.5056 12.0956 24.7112 11.7058C23.9176 11.316 22.9592 11.6471 22.5712 12.4444C21.3816 14.8891 18.8848 16.568 16 16.568C13.1152 16.568 10.6184 14.8899 9.42883 12.4444Z"
			fill="#455AFB"
		/>
	</svg>
);

export const NoEmailLogs = ( props ) => (
	<svg
		width="328"
		height="336"
		viewBox="0 0 328 336"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M266.945 155.07V266.366L211.969 194.942L266.945 155.07Z"
			fill="white"
		/>
		<path
			d="M266.946 266.75C266.818 266.75 266.754 266.686 266.626 266.622L211.65 195.198C211.586 195.134 211.586 195.07 211.586 195.006C211.586 194.878 211.65 194.75 211.714 194.686L266.69 154.814C266.818 154.75 266.946 154.75 267.074 154.814C267.202 154.878 267.266 155.006 267.266 155.134V266.43C267.266 266.558 267.138 266.75 267.01 266.75H266.946ZM212.482 195.006L266.562 265.342V155.774L212.482 195.006Z"
			fill="#172554"
		/>
		<path
			d="M135.491 193.662L79.5547 266.366V155.07L135.491 193.662Z"
			fill="white"
		/>
		<path
			d="M79.5559 266.751H79.4279C79.2999 266.687 79.1719 266.559 79.1719 266.431V155.071C79.1719 154.943 79.2359 154.815 79.3639 154.751C79.4919 154.687 79.6199 154.687 79.7479 154.751L135.684 193.343C135.748 193.407 135.812 193.471 135.812 193.599C135.812 193.727 135.812 193.791 135.748 193.855L79.8119 266.623C79.7479 266.687 79.6839 266.751 79.5559 266.751ZM79.9399 155.775V265.343L134.98 193.727L79.9399 155.775Z"
			fill="#172554"
		/>
		<path
			d="M266.947 266.368H79.5547L135.491 193.664L175.619 221.312L211.971 194.944L266.947 266.368Z"
			fill="white"
		/>
		<path
			d="M266.949 266.751H79.5574C79.4294 266.751 79.3014 266.687 79.2374 266.559C79.1734 266.431 79.1734 266.303 79.3014 266.175L135.237 193.407C135.365 193.279 135.557 193.215 135.749 193.343L175.685 220.863L211.845 194.623C211.973 194.495 212.229 194.559 212.357 194.687L267.205 266.111C267.269 266.239 267.269 266.367 267.269 266.495C267.205 266.623 267.077 266.751 266.949 266.751ZM80.2614 266.047H266.181L211.909 195.519L175.813 221.695C175.685 221.759 175.493 221.759 175.429 221.695L135.557 194.239L80.2614 266.047Z"
			fill="#172554"
		/>
		<path
			d="M266.947 155.07L211.971 194.942L175.619 221.31L135.491 193.662L79.5547 155.07H266.947Z"
			fill="#7DD3FC"
		/>
		<path
			d="M175.62 221.695C175.556 221.695 175.492 221.695 175.428 221.631L79.364 155.327C79.236 155.263 79.172 155.072 79.236 154.944C79.3 154.816 79.428 154.688 79.556 154.688H266.948C267.14 154.688 267.332 154.815 267.332 155.007C267.332 155.135 267.268 155.263 267.204 155.327L212.356 195.2L212.292 195.264L175.94 221.631C175.812 221.695 175.748 221.695 175.62 221.695ZM80.708 155.392L175.62 220.864L211.716 194.688L211.78 194.624L265.86 155.392H80.708Z"
			fill="#172554"
		/>
		<path
			d="M266.947 155.07H79.5547L175.619 88.7656L266.947 155.07Z"
			fill="white"
		/>
		<path
			d="M266.948 155.392H79.5559C79.3639 155.392 79.1719 155.264 79.1719 155.008C79.1719 154.88 79.2359 154.752 79.2999 154.688L175.364 88.3839C175.492 88.3199 175.62 88.3199 175.748 88.3839L267.076 154.688C267.204 154.752 267.268 154.944 267.204 155.072C267.204 155.328 267.076 155.392 266.948 155.392ZM80.7079 154.688H265.796L175.62 89.2159L80.7079 154.688Z"
			fill="#172554"
		/>
		<path
			d="M170.236 211.071C170.108 211.071 169.98 211.007 169.916 210.879L127.868 111.167C127.804 110.975 127.868 110.783 128.06 110.719C128.252 110.655 128.444 110.719 128.508 110.911L170.556 210.623C170.62 210.815 170.556 211.007 170.364 211.071C170.3 211.071 170.236 211.071 170.236 211.071Z"
			fill="#172554"
		/>
		<path
			d="M170.235 211.074C170.107 211.074 170.043 211.01 169.979 210.946L95.6751 123.586C95.5471 123.458 95.5471 123.202 95.7391 123.074C95.8671 122.946 96.1231 122.946 96.2511 123.138L170.491 210.562C170.619 210.69 170.619 210.946 170.427 211.074C170.363 211.074 170.299 211.074 170.235 211.074Z"
			fill="#172554"
		/>
		<path
			d="M170.233 211.074C170.041 211.074 169.849 210.946 169.849 210.754L165.945 119.618C165.945 119.426 166.073 119.234 166.265 119.234C166.457 119.234 166.649 119.362 166.649 119.554L170.553 210.69C170.553 210.882 170.425 211.074 170.233 211.074Z"
			fill="#172554"
		/>
		<path
			d="M170.236 211.068C170.172 211.068 170.108 211.068 170.044 211.004L73.0204 144.38C72.8284 144.252 72.8284 144.06 72.9564 143.868C73.0844 143.74 73.2764 143.676 73.4684 143.804L170.428 210.428C170.62 210.556 170.62 210.748 170.492 210.94C170.428 211.004 170.364 211.068 170.236 211.068Z"
			fill="#172554"
		/>
		<path
			d="M156.543 200.447C157.887 197.695 160.511 195.775 163.519 195.391C163.967 195.327 163.775 194.688 163.327 194.688C160.127 195.2 157.311 197.184 155.903 200.128C155.711 200.447 156.351 200.832 156.543 200.447Z"
			fill="#172554"
		/>
		<path
			d="M144.51 192.131C146.878 186.819 151.678 182.979 157.374 181.763C157.822 181.699 157.63 180.995 157.182 181.059C152.638 182.019 148.606 184.643 145.854 188.355C145.086 189.379 144.446 190.531 143.87 191.747C143.742 192.131 144.318 192.515 144.51 192.131Z"
			fill="#172554"
		/>
		<path
			d="M130.75 182.846C134.59 177.15 139.966 172.734 146.302 170.11C148.094 169.342 149.886 168.766 151.806 168.318C152.254 168.19 152.062 167.55 151.614 167.614C144.83 169.214 138.622 172.798 133.822 177.918C132.478 179.326 131.262 180.926 130.174 182.526C129.854 182.91 130.494 183.23 130.75 182.846Z"
			fill="#172554"
		/>
		<path
			d="M117.754 173.692C124.73 164.284 134.458 157.244 145.53 153.532C145.978 153.404 145.786 152.7 145.338 152.828C134.074 156.604 124.218 163.772 117.114 173.372C116.858 173.692 117.498 174.076 117.754 173.692Z"
			fill="#172554"
		/>
		<path
			d="M106.361 166.595C108.665 161.283 112.762 156.803 117.114 153.027C123.834 147.267 131.898 143.171 140.473 141.123C140.922 140.995 140.729 140.355 140.281 140.419C134.713 141.763 129.337 143.939 124.409 146.819C119.481 149.763 115.002 153.411 111.226 157.699C108.986 160.195 107.129 163.075 105.721 166.147C105.593 166.595 106.169 166.979 106.361 166.595Z"
			fill="#172554"
		/>
		<path
			d="M163.963 195.388C164.411 194.556 165.115 193.916 166.011 193.596C167.035 193.148 168.123 192.892 169.211 192.956C169.659 193.02 169.659 192.252 169.211 192.252C167.995 192.188 166.779 192.444 165.627 192.956C164.667 193.34 163.835 194.044 163.323 195.004C163.195 195.452 163.771 195.772 163.963 195.388Z"
			fill="#172554"
		/>
		<path
			d="M158.525 181.505C159.805 177.985 163.645 176.193 167.165 177.473C167.549 177.601 167.869 177.793 168.189 177.985C168.573 178.177 168.957 177.601 168.573 177.345C164.989 175.297 160.445 176.577 158.397 180.161C158.205 180.545 158.013 180.929 157.821 181.377C157.693 181.761 158.333 181.953 158.525 181.505Z"
			fill="#172554"
		/>
		<path
			d="M152.379 168.062C155.963 163.326 162.171 161.47 167.803 163.454C168.251 163.582 168.443 162.942 167.995 162.75C162.171 160.766 155.707 162.686 151.867 167.486C151.611 167.934 152.123 168.446 152.379 168.062Z"
			fill="#172554"
		/>
		<path
			d="M146.233 153.023C151.545 147.199 160.057 145.727 167.033 149.439C167.417 149.631 167.801 149.055 167.417 148.799C161.785 145.855 155.065 146.047 149.625 149.375C148.217 150.271 146.873 151.295 145.785 152.575C145.401 152.895 145.913 153.407 146.233 153.023Z"
			fill="#172554"
		/>
		<path
			d="M140.863 140.867C143.039 138.307 146.175 136.771 149.247 135.555C152.703 134.083 156.415 133.379 160.191 133.507C162.303 133.635 164.351 134.019 166.271 134.723C166.719 134.851 166.911 134.147 166.463 134.019C162.879 132.803 159.039 132.483 155.327 133.059C153.407 133.379 151.487 133.891 149.695 134.659C148.031 135.299 146.431 136.003 144.831 136.835C143.167 137.731 141.631 138.947 140.351 140.355C140.031 140.739 140.543 141.251 140.863 140.867Z"
			fill="#172554"
		/>
		<path
			d="M175.682 238.848C186.038 238.848 194.434 230.452 194.434 220.096C194.434 209.739 186.038 201.344 175.682 201.344C165.325 201.344 156.93 209.739 156.93 220.096C156.93 230.452 165.325 238.848 175.682 238.848Z"
			fill="white"
		/>
		<path
			d="M175.683 239.17C165.123 239.17 156.547 230.594 156.547 220.034C156.547 209.474 165.123 200.898 175.683 200.898C186.243 200.898 194.819 209.474 194.819 220.034C194.755 230.658 186.243 239.17 175.683 239.17ZM175.683 201.73C165.507 201.73 157.315 209.986 157.315 220.098C157.315 230.274 165.571 238.466 175.683 238.466C185.859 238.466 194.051 230.21 194.051 220.098C194.051 209.922 185.859 201.73 175.683 201.73Z"
			fill="#172554"
		/>
		<path
			d="M181.318 226.515C180.614 227.283 179.782 227.923 178.758 228.371C176.774 229.139 174.534 229.139 172.55 228.371C171.59 227.987 170.694 227.347 169.99 226.515V226.451C169.862 226.323 169.67 226.259 169.478 226.387C169.35 226.515 169.286 226.707 169.414 226.835C169.99 227.923 170.95 228.883 172.102 229.395C174.342 230.483 177.03 230.483 179.334 229.395C180.486 228.819 181.382 227.923 181.958 226.771C182.022 226.579 181.958 226.387 181.83 226.259C181.638 226.259 181.446 226.323 181.318 226.515Z"
			fill="#172554"
		/>
		<path
			d="M186.881 218.688C186.177 218.112 185.281 217.792 184.385 217.856C183.937 217.856 183.489 217.92 183.105 218.048C182.657 218.176 182.272 218.432 181.952 218.688L181.889 218.752C181.761 218.88 181.505 218.88 181.377 218.688C181.313 218.56 181.312 218.432 181.312 218.304C181.569 217.664 182.016 217.152 182.592 216.832C183.744 216.192 185.153 216.192 186.241 216.832C186.817 217.152 187.265 217.664 187.521 218.304C187.585 218.496 187.521 218.688 187.329 218.752C187.201 218.816 187.073 218.752 186.945 218.688H186.881Z"
			fill="#172554"
		/>
		<path
			d="M169.413 218.687C169.093 218.431 168.645 218.175 168.261 218.047C167.813 217.919 167.429 217.855 166.981 217.855C166.533 217.855 166.085 217.919 165.701 218.047C165.253 218.175 164.869 218.431 164.549 218.687L164.485 218.751C164.357 218.879 164.101 218.879 163.973 218.687C163.909 218.559 163.845 218.431 163.909 218.303C164.165 217.663 164.613 217.151 165.189 216.831C165.765 216.511 166.405 216.383 167.045 216.383C167.685 216.383 168.325 216.511 168.901 216.831C169.477 217.151 169.925 217.663 170.181 218.303C170.245 218.495 170.181 218.687 169.989 218.751C169.861 218.815 169.733 218.751 169.605 218.687H169.413Z"
			fill="#172554"
		/>
		<path
			d="M128.125 66.494C128.125 66.494 131.261 61.246 135.357 63.486C140.349 66.238 138.813 74.174 135.805 82.814L131.069 82.11L128.125 66.494Z"
			fill="#7DD3FC"
		/>
		<path
			d="M135.742 83.2005L131.006 82.4965C130.878 82.4965 130.75 82.3685 130.686 82.1765L127.742 66.4965C127.742 66.4325 127.742 66.3045 127.806 66.2405C127.806 66.1765 131.198 60.7365 135.486 63.1045C141.054 66.2405 138.75 75.3285 136.126 82.8805C136.062 83.1365 135.934 83.2005 135.742 83.2005ZM131.39 81.8565L135.55 82.4325C139.262 71.7445 139.134 65.9845 135.166 63.8085C131.774 61.8885 129.022 65.8565 128.51 66.5605L131.39 81.8565Z"
			fill="#172554"
		/>
		<path
			d="M120.829 88.7717C106.813 85.6357 106.493 71.7477 111.293 71.9397C116.029 72.0677 118.397 76.8677 118.397 76.8677C116.733 72.8997 116.669 62.0837 125.309 65.0917C133.949 68.0997 134.845 82.9477 134.845 82.9477L120.829 88.7717Z"
			fill="#7DD3FC"
		/>
		<path
			d="M120.828 89.1555H120.764C110.588 86.9155 107.708 79.3635 108.22 75.0755C108.476 72.8355 109.692 71.4915 111.292 71.5555C113.724 71.6835 115.964 72.8355 117.436 74.7555C116.86 71.8755 116.988 67.7795 119.036 65.6035C120.508 64.0675 122.62 63.7475 125.372 64.7075C134.14 67.7795 135.1 82.2435 135.164 82.8835C135.164 83.0115 135.1 83.2035 134.972 83.2675L120.956 89.1555C120.892 89.1555 120.892 89.1555 120.828 89.1555ZM111.164 72.2595C109.692 72.2595 109.052 73.7315 108.86 75.1395C108.348 79.4275 111.676 86.3395 120.764 88.3875L134.46 82.6275C134.268 80.6435 132.924 68.0355 125.18 65.3475C122.684 64.5155 120.828 64.7075 119.548 66.0515C117.308 68.4195 117.564 73.9235 118.652 76.6115C118.716 76.8035 118.652 76.9955 118.46 77.0595C118.268 77.1235 118.076 77.0595 118.012 76.8675C118.012 76.8035 115.708 72.2595 111.228 72.1315L111.164 72.2595Z"
			fill="#172554"
		/>
		<path
			d="M130.557 81.6676C130.365 81.6676 130.173 81.4756 130.173 81.2836C130.173 81.1556 130.365 70.7236 125.821 69.7636C124.989 69.5076 124.093 69.6996 123.389 70.2116C121.789 71.6836 122.237 75.5236 122.237 75.5876C122.237 75.7796 122.109 75.9716 121.917 75.9716C121.725 75.9716 121.533 75.8436 121.533 75.6516C121.533 75.4596 121.021 71.3636 122.877 69.6356C123.709 68.9316 124.861 68.6756 125.949 68.9956C131.069 70.0836 130.877 80.8356 130.877 81.2196C130.941 81.5396 130.813 81.6676 130.557 81.6676Z"
			fill="#172554"
		/>
		<path
			d="M112.443 81.2771C112.315 81.2771 112.251 81.2131 112.187 81.1491C111.355 80.2531 111.355 78.8451 112.251 78.0131C113.403 76.9251 115.899 76.7331 119.163 79.8051C119.291 79.9331 119.291 80.1891 119.163 80.3171C119.035 80.4451 118.779 80.4451 118.651 80.3171C115.899 77.7571 113.659 77.5651 112.699 78.5251C112.123 79.1011 112.059 80.0611 112.635 80.6371C112.635 80.6371 112.635 80.6371 112.699 80.7011C112.827 80.8291 112.827 81.0851 112.699 81.2131C112.635 81.2771 112.571 81.2771 112.443 81.2771Z"
			fill="#172554"
		/>
		<path
			d="M138.047 82.8788C137.919 82.8788 137.791 82.8148 137.727 82.6228C137.663 82.4308 137.727 82.2388 137.919 82.1748C140.287 81.2788 142.271 79.5508 143.423 77.3108C143.615 76.9268 143.743 76.4788 143.679 76.0948C143.423 75.6468 142.911 75.4548 142.399 75.5188C141.887 75.5188 141.503 75.8388 141.311 76.2868C141.247 76.4788 141.055 76.6068 140.863 76.5428C140.671 76.4788 140.543 76.2868 140.607 76.0948C140.799 75.3268 141.503 74.7508 142.335 74.7508C143.167 74.6228 143.999 75.0068 144.383 75.7748C144.511 76.3508 144.447 76.9908 144.127 77.5668C142.911 79.9988 140.799 81.8548 138.239 82.8148C138.111 82.8788 138.111 82.8788 138.047 82.8788Z"
			fill="#172554"
		/>
		<path
			d="M147.644 83.842C147.58 83.842 147.452 83.842 147.388 83.778C145.66 81.986 140.604 82.754 140.54 82.754C140.348 82.754 140.156 82.626 140.156 82.434C140.156 82.242 140.284 82.05 140.476 82.05C140.668 82.05 145.98 81.218 147.964 83.266C148.092 83.394 148.092 83.65 147.964 83.778C147.836 83.842 147.772 83.906 147.644 83.842Z"
			fill="#172554"
		/>
		<path
			d="M118.463 89.0255C127.039 83.7135 136.958 81.1535 138.046 82.5615C139.134 83.9055 123.326 90.6895 120.446 91.2015C117.566 91.7135 117.183 90.2415 118.463 89.0255Z"
			fill="white"
		/>
		<path
			d="M119.358 91.7133C118.142 91.7133 117.694 91.2653 117.566 90.9453C117.246 90.3693 117.502 89.5373 118.206 88.8333L118.27 88.7693C126.014 83.9693 136.894 80.5133 138.302 82.3693C138.43 82.5613 138.494 82.8173 138.366 83.0093C137.598 85.0573 122.942 91.1373 120.51 91.5853C120.126 91.6493 119.742 91.7133 119.358 91.7133ZM118.718 89.3453C118.27 89.7933 118.078 90.3053 118.206 90.5613C118.334 90.8173 119.038 91.1373 120.446 90.8813C123.39 90.3053 137.278 84.2893 137.79 82.7533C136.766 81.8573 127.678 83.7773 118.718 89.3453Z"
			fill="#172554"
		/>
		<path
			d="M194.433 199.423C194.369 199.423 194.305 199.423 194.241 199.359C194.049 199.295 193.985 199.039 194.113 198.911C194.817 197.631 195.457 196.351 196.097 195.071C196.161 194.879 196.417 194.815 196.545 194.879C196.737 194.943 196.801 195.199 196.673 195.391C196.033 196.671 195.329 197.951 194.689 199.231C194.689 199.359 194.561 199.423 194.433 199.423ZM198.401 191.743C198.337 191.743 198.273 191.743 198.273 191.679C198.081 191.615 198.017 191.359 198.081 191.231C198.721 189.951 199.361 188.607 199.937 187.327C200.001 187.135 200.193 187.071 200.385 187.135C200.577 187.199 200.641 187.391 200.577 187.583C200.577 187.583 200.577 187.583 200.577 187.647C199.937 188.927 199.361 190.271 198.657 191.551C198.657 191.615 198.529 191.743 198.401 191.743ZM202.049 183.871C201.985 183.871 201.921 183.871 201.921 183.871C201.729 183.807 201.665 183.551 201.729 183.423C202.305 182.079 202.881 180.735 203.457 179.455C203.521 179.263 203.713 179.199 203.905 179.263C204.097 179.327 204.161 179.583 204.097 179.711C203.585 180.991 203.009 182.335 202.369 183.679C202.305 183.807 202.177 183.871 202.049 183.871ZM205.377 175.935C205.313 175.935 205.313 175.935 205.249 175.935C205.057 175.871 204.993 175.679 205.057 175.487C205.569 174.143 206.081 172.735 206.529 171.455C206.593 171.263 206.785 171.135 206.977 171.263C207.169 171.327 207.297 171.519 207.169 171.711C206.721 173.055 206.209 174.399 205.697 175.807C205.697 175.807 205.569 175.935 205.377 175.935ZM201.025 170.623C200.833 170.623 200.641 170.495 200.641 170.303C200.641 170.111 200.769 169.919 200.961 169.919C202.305 169.663 203.649 169.151 204.801 168.383C204.993 168.255 205.185 168.319 205.313 168.511C205.441 168.703 205.377 168.895 205.185 169.023C203.969 169.855 202.561 170.367 201.089 170.623H201.025ZM196.737 170.303C196.673 170.303 196.673 170.303 196.609 170.303C195.777 169.983 194.945 169.599 194.177 169.151C193.665 168.831 193.217 168.511 192.705 168.191C192.513 168.063 192.513 167.871 192.641 167.679C192.769 167.551 192.961 167.487 193.153 167.615C193.601 167.935 194.113 168.255 194.625 168.575C195.329 169.023 196.097 169.407 196.865 169.663C197.057 169.663 197.185 169.855 197.185 170.111C197.185 170.239 196.993 170.367 196.737 170.303ZM208.193 167.743H208.065C207.873 167.679 207.745 167.487 207.809 167.295C207.937 166.975 208.001 166.655 208.065 166.335L208.001 166.271C207.873 166.143 207.873 165.887 208.001 165.759L208.257 165.503C208.449 164.671 208.705 163.903 208.833 163.135C208.897 162.943 209.089 162.815 209.281 162.879C209.473 162.943 209.601 163.135 209.537 163.327C209.473 163.711 209.345 164.031 209.281 164.479C209.793 163.903 210.305 163.263 210.817 162.623C210.945 162.495 211.137 162.431 211.329 162.559C211.457 162.687 211.521 162.879 211.393 163.071C210.625 164.095 209.793 165.055 208.897 165.951C208.769 166.463 208.577 167.039 208.449 167.551C208.449 167.679 208.321 167.743 208.193 167.743ZM189.761 165.375C189.633 165.375 189.569 165.311 189.505 165.247C188.545 164.159 187.649 162.943 186.945 161.663C186.881 161.471 186.945 161.279 187.073 161.151C187.265 161.087 187.457 161.151 187.521 161.279C188.225 162.495 188.993 163.647 189.953 164.735C190.081 164.863 190.081 165.119 189.953 165.247C189.953 165.311 189.889 165.375 189.761 165.375ZM213.761 159.615C213.697 159.615 213.633 159.615 213.569 159.551C213.377 159.423 213.377 159.231 213.441 159.039C214.209 157.951 214.977 156.671 215.745 155.391C215.873 155.199 216.065 155.135 216.257 155.263C216.449 155.391 216.513 155.583 216.385 155.775C215.617 157.055 214.849 158.335 214.081 159.487C214.017 159.615 213.889 159.615 213.761 159.615ZM210.177 159.295C209.921 159.231 209.793 159.103 209.793 158.911C210.049 157.503 210.177 156.095 210.241 154.623C210.241 154.431 210.433 154.239 210.625 154.239C210.817 154.239 211.009 154.431 211.009 154.623C210.945 156.095 210.753 157.503 210.561 158.975C210.497 159.167 210.369 159.295 210.177 159.295ZM185.729 157.823C185.537 157.823 185.409 157.695 185.409 157.567C185.089 156.223 184.961 154.879 184.961 153.471V153.151C184.961 152.959 185.089 152.767 185.345 152.767C185.537 152.767 185.729 152.959 185.729 153.151V153.471C185.729 154.815 185.857 156.095 186.177 157.375C186.241 157.567 186.113 157.759 185.921 157.823H185.729ZM218.177 152.191C218.113 152.191 218.049 152.191 217.985 152.127C217.793 151.999 217.729 151.807 217.857 151.615C218.497 150.399 219.201 149.119 219.841 147.775C219.905 147.583 220.161 147.519 220.353 147.583C220.545 147.647 220.609 147.903 220.545 148.095C219.841 149.439 219.201 150.719 218.497 151.935C218.433 152.127 218.369 152.255 218.177 152.191ZM210.561 150.719C210.369 150.719 210.241 150.591 210.177 150.399C210.049 148.991 209.793 147.583 209.409 146.239C209.345 146.047 209.473 145.855 209.665 145.791C209.857 145.727 210.049 145.855 210.113 146.047C210.561 147.455 210.817 148.927 210.881 150.399C210.945 150.527 210.817 150.655 210.561 150.719ZM185.857 149.247H185.793C185.601 149.183 185.473 148.991 185.537 148.799C185.921 147.391 186.433 145.983 187.073 144.703C187.137 144.511 187.393 144.447 187.521 144.511C187.713 144.575 187.777 144.831 187.713 144.959C187.073 146.239 186.561 147.519 186.241 148.927C186.177 149.119 186.049 149.247 185.857 149.247ZM222.145 144.511C222.081 144.511 222.017 144.511 222.017 144.511C221.825 144.447 221.761 144.191 221.825 143.999C222.465 142.719 223.041 141.375 223.681 140.095C223.745 139.903 224.001 139.839 224.129 139.903C224.321 139.967 224.385 140.223 224.321 140.351C223.681 141.631 223.105 142.975 222.465 144.255C222.401 144.447 222.273 144.511 222.145 144.511ZM208.001 142.527C207.873 142.527 207.745 142.463 207.681 142.335C206.913 141.183 205.953 140.095 204.865 139.263C204.737 139.135 204.673 138.943 204.801 138.751C204.929 138.623 205.121 138.559 205.313 138.687C206.465 139.583 207.489 140.671 208.321 141.951C208.449 142.143 208.385 142.335 208.257 142.463C208.129 142.527 208.065 142.527 208.001 142.527ZM189.761 141.631C189.697 141.631 189.569 141.567 189.505 141.567C189.377 141.439 189.313 141.247 189.441 141.055C190.401 139.967 191.489 138.943 192.769 138.175C192.961 138.047 193.153 138.111 193.281 138.303C193.409 138.495 193.345 138.687 193.153 138.815C192.001 139.583 190.913 140.543 190.017 141.567C189.953 141.567 189.889 141.631 189.761 141.631ZM201.281 137.343H201.153C200.385 137.087 199.553 137.023 198.721 137.023C198.145 137.023 197.633 137.087 197.057 137.151C196.865 137.215 196.673 137.023 196.609 136.831C196.545 136.639 196.737 136.447 196.929 136.383C197.505 136.255 198.081 136.255 198.721 136.255C199.617 136.255 200.513 136.383 201.345 136.639C201.537 136.639 201.665 136.831 201.665 137.023C201.665 137.279 201.473 137.407 201.281 137.343ZM225.793 136.639C225.729 136.639 225.665 136.639 225.665 136.575C225.473 136.511 225.409 136.255 225.473 136.127C226.049 134.783 226.689 133.503 227.265 132.159C227.329 131.967 227.585 131.903 227.777 132.031C227.969 132.095 228.033 132.287 227.969 132.479C227.393 133.759 226.817 135.103 226.177 136.447C226.049 136.575 225.985 136.639 225.793 136.639ZM229.377 128.703C229.313 128.703 229.249 128.703 229.249 128.703C229.057 128.639 228.993 128.447 229.057 128.255C229.633 126.911 230.273 125.567 230.849 124.287C230.913 124.095 231.169 124.031 231.297 124.095C231.489 124.159 231.553 124.415 231.489 124.607C230.913 125.887 230.273 127.231 229.697 128.511C229.633 128.639 229.505 128.767 229.377 128.703ZM233.025 120.831C232.961 120.831 232.897 120.831 232.897 120.767C232.705 120.703 232.641 120.447 232.705 120.255C233.409 118.783 234.049 117.567 234.689 116.351C234.817 116.159 235.009 116.159 235.201 116.287C235.329 116.351 235.393 116.543 235.329 116.735C234.753 117.887 234.113 119.167 233.409 120.575C233.281 120.767 233.153 120.895 233.025 120.831ZM237.121 113.215C237.057 113.215 236.993 113.215 236.929 113.151C236.737 113.023 236.737 112.831 236.801 112.639C237.569 111.359 238.465 110.207 239.425 109.119C239.553 108.991 239.809 108.991 239.937 109.119C240.065 109.247 240.065 109.503 239.937 109.631C238.977 110.655 238.145 111.807 237.377 113.023C237.377 113.151 237.249 113.215 237.121 113.215Z"
			fill="#172554"
		/>
		<path
			d="M239.742 80.7097C239.742 80.7097 240.446 74.6297 244.99 74.9497C250.686 75.3977 252.606 83.2057 253.502 92.3577L248.958 93.7017L239.742 80.7097Z"
			fill="#7DD3FC"
		/>
		<path
			d="M248.959 94.082C248.831 94.082 248.703 94.018 248.639 93.954L239.423 80.962C239.359 80.898 239.359 80.834 239.359 80.706C239.359 80.642 240.127 74.242 244.991 74.626C251.391 75.138 253.055 84.354 253.823 92.354C253.823 92.546 253.759 92.674 253.567 92.738L248.959 94.018V94.082ZM240.127 80.642L249.087 93.314L253.119 92.098C252.031 80.834 249.535 75.65 244.991 75.33C241.087 75.01 240.255 79.746 240.127 80.642Z"
			fill="#172554"
		/>
		<path
			d="M242.371 103.937C228.291 106.945 222.275 94.4646 226.627 92.6086C231.043 90.7526 235.139 94.0806 235.139 94.0806C232.003 91.2006 227.395 81.3446 236.483 80.5126C245.635 79.6166 252.611 92.7366 252.611 92.7366L242.371 103.937Z"
			fill="#7DD3FC"
		/>
		<path
			d="M238.082 104.832C230.594 104.832 226.242 100.288 225.154 96.8321C224.514 94.7201 225.026 92.9921 226.498 92.3521C228.738 91.4561 231.298 91.5841 233.41 92.7361C231.682 90.3041 230.082 86.5921 231.042 83.7121C231.746 81.6641 233.538 80.5121 236.482 80.2561C245.762 79.3601 252.674 92.0961 252.93 92.6721C252.994 92.8001 252.994 92.9921 252.866 93.0561L242.562 104.256C242.498 104.32 242.434 104.32 242.37 104.384C241.026 104.64 239.554 104.832 238.082 104.832ZM229.442 92.4161C228.546 92.4161 227.65 92.6081 226.818 92.9281C225.474 93.5041 225.474 95.1681 225.858 96.5121C227.138 100.608 233.09 105.472 242.178 103.552L252.226 92.6081C251.266 90.9441 244.738 80.0641 236.546 80.8321C233.922 81.0881 232.322 82.1121 231.746 83.8401C230.722 86.9121 233.218 91.8401 235.394 93.8241C235.522 93.9521 235.522 94.2081 235.394 94.3361C235.266 94.4641 235.074 94.4641 234.882 94.3361C233.346 93.1841 231.426 92.4801 229.442 92.4161Z"
			fill="#172554"
		/>
		<path
			d="M248.13 93.5046C248.002 93.5046 247.874 93.4406 247.81 93.3126C247.746 93.1846 243.586 83.6486 239.042 84.6086C238.146 84.7366 237.442 85.2486 237.058 86.0806C236.226 88.1286 238.274 91.3926 238.274 91.4566C238.402 91.5846 238.402 91.8406 238.21 91.9686C238.082 92.0966 237.826 92.0966 237.698 91.9046L237.634 91.8406C237.57 91.7126 235.394 88.1926 236.354 85.8246C236.802 84.8006 237.762 84.0966 238.85 83.9686C243.97 82.8166 248.258 92.6726 248.45 93.0566C248.514 93.2486 248.45 93.4406 248.258 93.5046C248.258 93.5046 248.194 93.5046 248.13 93.5046Z"
			fill="#172554"
		/>
		<path
			d="M231.49 100.674C231.426 100.674 231.362 100.674 231.362 100.674C230.21 100.226 229.634 98.9461 230.082 97.7941C230.658 96.3221 232.834 95.1061 237.122 96.5141C237.314 96.5781 237.378 96.7701 237.314 96.9621C237.25 97.1541 237.058 97.2181 236.866 97.2181C233.282 96.0021 231.234 96.7701 230.722 98.0501C230.402 98.8181 230.85 99.7141 231.618 99.9701C231.81 100.034 231.938 100.226 231.938 100.418C231.874 100.61 231.682 100.738 231.49 100.674Z"
			fill="#172554"
		/>
		<path
			d="M255.424 91.5219C255.36 91.5219 255.232 91.4579 255.168 91.3939C255.04 91.2659 255.04 91.0099 255.168 90.8819C256.96 89.0899 257.984 86.7219 258.112 84.1619C258.176 83.7139 258.048 83.3299 257.792 82.9459C257.344 82.6899 256.832 82.6899 256.384 82.9459C255.936 83.1379 255.68 83.6499 255.744 84.0979C255.808 84.2899 255.68 84.4819 255.488 84.5459C255.296 84.6099 255.104 84.4819 255.04 84.2899C254.912 83.5219 255.296 82.6899 256 82.3699C256.704 81.9219 257.6 81.9859 258.24 82.4979C258.624 83.0099 258.816 83.5859 258.752 84.2259C258.624 86.9139 257.536 89.5379 255.616 91.4579C255.616 91.4579 255.552 91.4579 255.424 91.5219Z"
			fill="#172554"
		/>
		<path
			d="M257.605 90.3023C257.477 90.3023 257.349 90.2383 257.285 90.1743C257.157 89.9823 257.221 89.7903 257.413 89.6623C257.605 89.5343 262.085 86.5903 264.709 87.6783C264.901 87.7423 265.029 87.9343 264.965 88.1263C264.901 88.3183 264.709 88.4463 264.517 88.3823H264.453C262.149 87.4223 257.861 90.3023 257.797 90.3023C257.733 90.3023 257.669 90.3023 257.605 90.3023Z"
			fill="#172554"
		/>
		<path
			d="M240.382 105.22C245.95 96.8361 253.886 90.3721 255.486 91.1401C257.086 91.9081 245.502 104.644 243.134 106.372C240.766 108.036 239.742 106.884 240.382 105.22Z"
			fill="white"
		/>
		<path
			d="M241.093 107.585C240.773 107.585 240.517 107.521 240.261 107.329C239.749 106.881 239.621 106.113 240.005 105.153C240.005 105.153 240.005 105.089 240.069 105.089C245.125 97.5373 253.509 89.8573 255.621 90.8813C255.813 91.0093 255.941 91.2013 255.941 91.3933C256.069 93.5693 245.317 105.217 243.269 106.689C242.693 107.201 241.925 107.457 241.093 107.585ZM240.645 105.409C240.453 106.049 240.453 106.561 240.709 106.753C240.965 106.945 241.669 106.881 242.885 106.113C245.381 104.385 255.429 93.0573 255.237 91.5213C253.957 91.0093 246.533 96.6413 240.645 105.409Z"
			fill="#172554"
		/>
	</svg>
);

export const NoNotifications = ( props ) => (
	<svg
		width="280"
		height="280"
		viewBox="0 0 280 280"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M211.679 72.4669V158.651C211.679 160.835 209.887 162.571 207.759 162.571H70.9513C68.7672 162.571 67.0312 160.835 67.0312 158.651V72.4669C67.0312 70.2829 68.7672 68.5469 70.9513 68.5469H207.703C209.887 68.5469 211.623 70.2829 211.679 72.4669Z"
			fill="white"
		/>
		<path
			d="M207.71 162.85H70.9578C68.6058 162.85 66.7578 160.946 66.7578 158.65V72.4656C66.7578 70.1136 68.6618 68.2656 70.9578 68.2656H207.71C210.062 68.2656 211.91 70.1696 211.91 72.4656V158.65C211.966 160.946 210.062 162.85 207.71 162.85ZM70.9578 68.8256C68.9418 68.8256 67.3178 70.4496 67.3178 72.4656V158.65C67.3178 160.666 68.9418 162.29 70.9578 162.29H207.71C209.726 162.29 211.35 160.666 211.35 158.65V72.4656C211.35 70.4496 209.726 68.8256 207.71 68.8256H70.9578Z"
			fill="#082F49"
		/>
		<path
			d="M205.69 74.4219H72.9141V156.686H205.69V74.4219Z"
			fill="white"
		/>
		<path
			d="M205.745 156.972H72.9128C72.7448 156.972 72.6328 156.86 72.6328 156.692V74.4284C72.6328 74.2604 72.7448 74.1484 72.9128 74.1484H205.745C205.913 74.1484 206.025 74.2604 206.025 74.4284V156.692C206.025 156.86 205.913 156.972 205.745 156.972ZM73.2488 156.412H205.465V74.7084H73.2488V156.412Z"
			fill="#082F49"
		/>
		<path
			d="M70.0003 121.407C69.2723 121.407 68.6562 120.791 68.6562 120.063C68.6562 119.335 69.2723 118.719 70.0003 118.719C70.7283 118.719 71.3443 119.335 71.3443 120.063C71.3443 120.791 70.7283 121.407 70.0003 121.407ZM70.0003 119.335C69.6083 119.335 69.2722 119.671 69.2722 120.063C69.2722 120.455 69.6083 120.791 70.0003 120.791C70.3923 120.791 70.7283 120.455 70.7283 120.063C70.7843 119.671 70.4483 119.335 70.0003 119.335Z"
			fill="white"
		/>
		<path
			d="M70.0003 118.215C69.2723 118.215 68.6562 117.599 68.6562 116.871V111.047C68.6562 110.319 69.2723 109.703 70.0003 109.703C70.7283 109.703 71.3443 110.319 71.3443 111.047V116.871C71.3443 117.599 70.7843 118.215 70.0003 118.215ZM70.0003 110.319C69.6083 110.319 69.2722 110.655 69.2722 111.047V116.871C69.2722 117.263 69.6083 117.599 70.0003 117.599C70.3923 117.599 70.7283 117.263 70.7283 116.871V111.047C70.7843 110.599 70.4483 110.263 70.0003 110.319Z"
			fill="white"
		/>
		<path
			d="M70.0003 121.407C69.2723 121.407 68.6562 120.791 68.6562 120.063C68.6562 119.335 69.2723 118.719 70.0003 118.719C70.7283 118.719 71.3443 119.335 71.3443 120.063C71.3443 120.791 70.7283 121.407 70.0003 121.407ZM70.0003 119.335C69.6083 119.335 69.2722 119.671 69.2722 120.063C69.2722 120.455 69.6083 120.791 70.0003 120.791C70.3923 120.791 70.7283 120.455 70.7283 120.063C70.7843 119.671 70.4483 119.335 70.0003 119.335Z"
			fill="#082F49"
		/>
		<path
			d="M70.0003 118.215C69.2723 118.215 68.6562 117.599 68.6562 116.871V111.047C68.6562 110.319 69.2723 109.703 70.0003 109.703C70.7283 109.703 71.3443 110.319 71.3443 111.047V116.871C71.3443 117.599 70.7843 118.215 70.0003 118.215ZM70.0003 110.319C69.6083 110.319 69.2722 110.655 69.2722 111.047V116.871C69.2722 117.263 69.6083 117.599 70.0003 117.599C70.3923 117.599 70.7283 117.263 70.7283 116.871V111.047C70.7843 110.599 70.4483 110.263 70.0003 110.319Z"
			fill="#082F49"
		/>
		<path
			d="M70.0003 121.407C69.2723 121.407 68.6562 120.791 68.6562 120.063C68.6562 119.335 69.2723 118.719 70.0003 118.719C70.7283 118.719 71.3443 119.335 71.3443 120.063C71.3443 120.791 70.7283 121.407 70.0003 121.407ZM70.0003 119.335C69.6083 119.335 69.2722 119.671 69.2722 120.063C69.2722 120.455 69.6083 120.791 70.0003 120.791C70.3923 120.791 70.7283 120.455 70.7283 120.063C70.7843 119.671 70.4483 119.335 70.0003 119.335Z"
			stroke="#082F49"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M70.0003 118.215C69.2723 118.215 68.6562 117.599 68.6562 116.871V111.047C68.6562 110.319 69.2723 109.703 70.0003 109.703C70.7283 109.703 71.3443 110.319 71.3443 111.047V116.871C71.3443 117.599 70.7843 118.215 70.0003 118.215ZM70.0003 110.319C69.6083 110.319 69.2722 110.655 69.2722 111.047V116.871C69.2722 117.263 69.6083 117.599 70.0003 117.599C70.3923 117.599 70.7283 117.263 70.7283 116.871V111.047C70.7843 110.599 70.4483 110.263 70.0003 110.319Z"
			stroke="#082F49"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M230.945 188.215C235.313 188.327 238.057 190.343 241.865 198.855C245.673 207.367 252.393 223.999 252.393 223.999C252.393 223.999 206.025 235.031 205.745 234.527C205.465 233.967 202.385 199.023 202.385 199.023C202.049 196.559 203.449 194.207 205.801 193.311C209.833 191.687 221.033 187.767 230.945 188.215Z"
			fill="#7DD3FC"
		/>
		<path
			d="M230.948 188.22C230.948 188.22 216.052 188.556 205.804 193.316L201.772 173.156C201.772 173.156 196.676 167.052 194.828 162.572H207.764C208.66 162.572 209.556 162.236 210.284 161.676C201.548 149.748 197.46 134.852 200.092 133.452C202.332 132.22 207.26 135.58 211.684 140.06V120.18C217.004 124.772 226.076 143.588 226.076 149.804C226.076 156.468 223.612 162.74 224.956 169.74C226.244 176.74 230.948 188.22 230.948 188.22Z"
			fill="white"
		/>
		<path
			d="M205.748 193.593C205.692 193.593 205.636 193.593 205.636 193.537C205.58 193.481 205.524 193.425 205.468 193.369L201.436 173.265C200.876 172.593 196.284 166.993 194.492 162.625C194.436 162.513 194.492 162.457 194.548 162.345C194.604 162.289 194.716 162.233 194.772 162.233H207.708C208.492 162.233 209.22 162.009 209.836 161.561C206.308 156.689 203.452 151.313 201.324 145.713C199.476 140.729 198.636 136.529 199.084 134.457C199.14 133.953 199.42 133.449 199.868 133.169C202.388 131.825 207.316 135.409 211.348 139.329V120.121C211.348 120.009 211.404 119.897 211.516 119.841C211.628 119.785 211.74 119.785 211.796 119.897C217.06 124.433 226.244 143.417 226.244 149.745C226.188 152.321 225.908 154.953 225.46 157.529C224.9 161.393 224.284 165.425 225.124 169.625C226.468 176.513 231.116 187.937 231.116 188.049C231.172 188.105 231.172 188.217 231.116 188.329C231.06 188.385 230.948 188.441 230.892 188.441C230.724 188.441 215.94 188.833 205.86 193.537C205.86 193.593 205.804 193.593 205.748 193.593ZM195.22 162.849C197.124 167.273 201.884 172.929 201.94 172.985C201.996 173.041 201.996 173.041 201.996 173.097L205.972 192.865C215.212 188.665 228.036 187.993 230.5 187.881C229.66 185.809 225.796 175.953 224.62 169.737C223.78 165.425 224.396 161.393 224.956 157.417C225.404 154.897 225.628 152.321 225.684 149.745C225.684 143.697 217.172 125.945 211.908 120.793V140.001C211.908 140.113 211.852 140.225 211.74 140.281C211.628 140.337 211.516 140.281 211.404 140.225C206.532 135.297 201.996 132.609 200.148 133.673C199.868 133.897 199.644 134.233 199.644 134.569C198.804 138.265 202.668 150.865 210.452 161.449C210.564 161.561 210.508 161.729 210.396 161.841C209.668 162.457 208.716 162.793 207.708 162.793L195.22 162.849Z"
			fill="#082F49"
		/>
		<path
			d="M217.283 145.993C217.227 145.993 217.115 145.937 217.059 145.881C214.091 142.689 211.459 140.281 211.459 140.281C211.347 140.169 211.347 140.001 211.459 139.889C211.571 139.777 211.739 139.777 211.851 139.889C211.851 139.889 214.483 142.353 217.507 145.545C217.619 145.657 217.619 145.825 217.507 145.937C217.451 145.937 217.339 145.993 217.283 145.993Z"
			fill="#082F49"
		/>
		<path
			d="M212.302 164.98C212.19 164.98 212.134 164.924 212.078 164.868L210.006 161.844C209.894 161.732 209.95 161.508 210.062 161.452C210.174 161.34 210.398 161.396 210.454 161.508L212.526 164.588C212.638 164.7 212.582 164.868 212.47 164.98C212.414 164.98 212.358 164.98 212.302 164.98Z"
			fill="#082F49"
		/>
		<path
			d="M47.7149 188.215C43.3469 188.327 40.6029 190.343 36.7949 198.855C32.9869 207.367 26.2109 223.999 26.2109 223.999C26.2109 223.999 72.5789 235.031 72.8589 234.527C73.1389 233.967 76.2749 199.023 76.2749 199.023C76.6109 196.559 75.2109 194.207 72.8589 193.311C68.8269 191.687 57.6269 187.767 47.7149 188.215Z"
			fill="#7DD3FC"
		/>
		<path
			d="M47.7188 188.22C47.7188 188.22 62.6148 188.556 72.8628 193.316L76.8948 173.156C76.8948 173.156 81.9907 167.108 83.8387 162.572H70.9028C70.0068 162.572 69.1108 162.236 68.3828 161.676C77.1188 149.748 81.2068 134.852 78.5748 133.452C76.3348 132.22 71.4068 135.58 66.9828 140.06V120.18C61.6628 124.772 52.5908 143.588 52.5908 149.804C52.5908 156.468 55.0548 162.74 53.7108 169.74C52.3668 176.74 47.7188 188.22 47.7188 188.22Z"
			fill="white"
		/>
		<path
			d="M72.8628 193.596C72.8068 193.596 72.8068 193.596 72.7508 193.54C62.6148 188.836 47.8308 188.444 47.6628 188.444C47.5508 188.444 47.4948 188.388 47.4388 188.332C47.3828 188.275 47.3828 188.163 47.3828 188.051C47.4388 187.939 52.0868 176.572 53.4308 169.628C54.2148 165.428 53.6548 161.396 53.0948 157.532C52.6468 154.956 52.4228 152.38 52.3108 149.748C52.3108 143.42 61.4948 124.436 66.7588 119.9C66.8708 119.844 66.9828 119.788 67.0948 119.844C67.2068 119.9 67.2628 120.012 67.2628 120.124V139.332C71.2388 135.356 76.2228 131.828 78.7428 133.172C79.1908 133.452 79.4708 133.956 79.5268 134.46C79.9748 136.532 79.1908 140.732 77.2868 145.716C75.1588 151.372 72.3028 156.692 68.7748 161.564C69.3908 162.012 70.1188 162.236 70.9028 162.236H83.8388C83.9508 162.236 84.0068 162.292 84.0628 162.348C84.1188 162.404 84.1188 162.516 84.1188 162.628C82.3268 166.996 77.7348 172.596 77.1748 173.268L73.1428 193.372C73.1428 193.484 73.0868 193.54 72.9748 193.54C72.9748 193.596 72.9188 193.596 72.8628 193.596ZM48.1108 187.94C50.5748 188.052 63.3988 188.724 72.6388 192.924L76.6148 173.156C76.6148 173.1 76.6708 173.044 76.6708 173.044C76.7268 172.988 81.4868 167.276 83.3908 162.908H70.8468C69.8388 162.908 68.8868 162.572 68.1588 161.956C68.0468 161.844 68.0468 161.676 68.1028 161.564C75.8308 150.98 79.7508 138.324 78.9108 134.684C78.8548 134.348 78.6868 134.012 78.4068 133.788C76.5028 132.78 71.9668 135.412 67.1508 140.34C67.0388 140.452 66.8708 140.452 66.7588 140.34C66.7028 140.284 66.6468 140.228 66.6468 140.116V120.908C61.3828 126.06 52.8708 143.812 52.8708 149.86C52.9268 152.436 53.2068 155.012 53.5988 157.532C54.1588 161.451 54.7748 165.54 53.9348 169.852C52.8148 176.012 48.9508 185.868 48.1108 187.94Z"
			fill="#082F49"
		/>
		<path
			d="M61.3816 145.994C61.2136 145.994 61.1016 145.882 61.1016 145.714C61.1016 145.658 61.1016 145.546 61.2136 145.49C64.1816 142.298 66.8136 139.89 66.8696 139.834C66.9816 139.722 67.1496 139.722 67.2616 139.834C67.3736 139.946 67.3736 140.114 67.2616 140.226C67.2056 140.226 64.6296 142.634 61.6616 145.826C61.4936 145.938 61.4376 145.994 61.3816 145.994Z"
			fill="#082F49"
		/>
		<path
			d="M66.3085 164.981C66.2525 164.981 66.1965 164.981 66.1405 164.925C66.0285 164.813 65.9725 164.645 66.0845 164.533L68.1565 161.453C68.2685 161.341 68.4365 161.285 68.5485 161.397C68.6605 161.509 68.7165 161.677 68.6045 161.789L66.4765 164.869C66.4765 164.981 66.3645 164.981 66.3085 164.981Z"
			fill="#082F49"
		/>
		<path
			d="M105.053 156.965C104.885 156.965 104.773 156.853 104.773 156.685V74.4206C104.773 74.2526 104.885 74.1406 105.053 74.1406C105.221 74.1406 105.333 74.2526 105.333 74.4206V156.685C105.389 156.853 105.221 156.965 105.053 156.965Z"
			fill="#082F49"
		/>
		<path
			d="M99.3984 79.3516H78.7344V85.4556H99.3984V79.3516Z"
			fill="#7DD3FC"
		/>
		<path
			d="M99.3424 85.6796H78.6784C78.5104 85.6796 78.3984 85.5676 78.3984 85.3996V79.2956C78.3984 79.1276 78.5104 79.0156 78.6784 79.0156H99.3424C99.5104 79.0156 99.6224 79.1276 99.6224 79.2956V85.3996C99.6224 85.5676 99.5104 85.6796 99.3424 85.6796ZM79.0144 85.1196H99.0624V79.6316H79.0144V85.1196Z"
			fill="#082F49"
		/>
		<path
			d="M80.75 83.1043L83.158 80.6963C83.326 80.5283 83.662 80.5283 83.83 80.6963C83.998 80.8643 83.998 81.2003 83.83 81.3683L81.422 83.7763L80.75 83.1043Z"
			fill="white"
		/>
		<path
			d="M81.4207 84.0518C81.3647 84.0518 81.2528 84.0518 81.1968 83.9958L80.5248 83.3238C80.4688 83.2678 80.4688 83.2118 80.4688 83.0998C80.4688 83.0438 80.5248 82.9318 80.5248 82.8758L82.9328 80.4678C83.2128 80.1878 83.7168 80.1878 84.0528 80.4678C84.3888 80.7478 84.3328 81.2518 84.0528 81.5878L81.6448 83.9958C81.5888 83.9958 81.4767 84.0518 81.4207 84.0518ZM81.1407 83.0998L81.4207 83.3798L83.6048 81.1958C83.6608 81.1398 83.6608 80.9718 83.6048 80.9158C83.5488 80.8598 83.3808 80.8598 83.3248 80.9158L81.1407 83.0998Z"
			fill="#082F49"
		/>
		<path
			d="M81.4234 83.7736L80.7514 83.1016L80.3594 84.1096L81.4234 83.7736Z"
			fill="#082F49"
		/>
		<path
			d="M80.3579 84.4443C80.3019 84.4443 80.1899 84.3883 80.1339 84.3323C80.0779 84.2763 80.0219 84.1643 80.0779 84.0523L80.4699 82.9883C80.5259 82.8763 80.5819 82.8203 80.6939 82.8203C80.8059 82.8203 80.8619 82.8203 80.9739 82.8763L81.6459 83.5483C81.7579 83.6603 81.7579 83.8283 81.6459 83.9403C81.5899 83.9963 81.5899 83.9963 81.5339 83.9963L80.4699 84.3883C80.4139 84.4443 80.4139 84.4443 80.3579 84.4443ZM80.8619 83.6043V83.6603H80.9179L80.8619 83.6043Z"
			fill="#082F49"
		/>
		<path
			d="M99.3424 96.7055H78.6784C78.5104 96.7055 78.3984 96.5935 78.3984 96.4255V91.2175C78.3984 91.0495 78.5104 90.9375 78.6784 90.9375H99.3424C99.5104 90.9375 99.6224 91.0495 99.6224 91.2175V96.4255C99.6784 96.5375 99.5104 96.7055 99.3424 96.7055ZM79.0144 96.1455H99.0624V91.4975H79.0144V96.1455Z"
			fill="#082F49"
		/>
		<path
			d="M99.3424 105.112H78.6784C78.5104 105.112 78.3984 105 78.3984 104.832V99.6238C78.3984 99.4557 78.5104 99.3438 78.6784 99.3438H99.3424C99.5104 99.3438 99.6224 99.4557 99.6224 99.6238V104.832C99.6784 105 99.5104 105.112 99.3424 105.112ZM79.0144 104.552H99.0624V99.9038H79.0144V104.552Z"
			fill="#082F49"
		/>
		<path
			d="M99.3424 113.51H78.6784C78.5104 113.51 78.3984 113.398 78.3984 113.23V108.022C78.3984 107.854 78.5104 107.742 78.6784 107.742H99.3424C99.5104 107.742 99.6224 107.854 99.6224 108.022V113.23C99.6784 113.398 99.5104 113.51 99.3424 113.51ZM79.0144 112.95H99.0624V108.302H79.0144V112.95Z"
			fill="#082F49"
		/>
		<path
			d="M99.3424 121.909H78.6784C78.5104 121.909 78.3984 121.797 78.3984 121.629V116.421C78.3984 116.253 78.5104 116.141 78.6784 116.141H99.3424C99.5104 116.141 99.6224 116.253 99.6224 116.421V121.629C99.6224 121.797 99.5104 121.909 99.3424 121.909ZM79.0144 121.349H99.0624V116.701H79.0144V121.349Z"
			fill="#082F49"
		/>
		<path
			d="M134.171 91.4975H118.491C118.323 91.4975 118.211 91.3855 118.211 91.2175C118.211 91.0495 118.323 90.9375 118.491 90.9375H134.171C134.339 90.9375 134.451 91.0495 134.451 91.2175C134.507 91.3295 134.339 91.4975 134.171 91.4975Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 91.4975H140.389C140.221 91.4975 140.109 91.3855 140.109 91.2175C140.109 91.0495 140.221 90.9375 140.389 90.9375H192.917C193.085 90.9375 193.197 91.0495 193.197 91.2175C193.197 91.3855 193.085 91.4975 192.917 91.4975Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 94.9194H140.389C140.221 94.9194 140.109 94.8074 140.109 94.6394C140.109 94.4714 140.221 94.3594 140.389 94.3594H192.917C193.085 94.3594 193.197 94.4714 193.197 94.6394C193.197 94.8074 193.085 94.9194 192.917 94.9194Z"
			fill="#082F49"
		/>
		<path
			d="M134.171 100.794H118.491C118.323 100.794 118.211 100.682 118.211 100.514C118.211 100.346 118.323 100.234 118.491 100.234H134.171C134.339 100.234 134.451 100.346 134.451 100.514C134.451 100.682 134.339 100.794 134.171 100.794Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 100.794H140.389C140.221 100.794 140.109 100.682 140.109 100.514C140.109 100.346 140.221 100.234 140.389 100.234H192.917C193.085 100.234 193.197 100.346 193.197 100.514C193.197 100.626 193.085 100.794 192.917 100.794Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 104.216H140.389C140.221 104.216 140.109 104.104 140.109 103.936C140.109 103.768 140.221 103.656 140.389 103.656H192.917C193.085 103.656 193.197 103.768 193.197 103.936C193.197 104.104 193.085 104.216 192.917 104.216Z"
			fill="#082F49"
		/>
		<path
			d="M134.171 110.091H118.491C118.323 110.091 118.211 109.979 118.211 109.811C118.211 109.643 118.323 109.531 118.491 109.531H134.171C134.339 109.531 134.451 109.643 134.451 109.811C134.451 109.979 134.339 110.091 134.171 110.091Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 110.091H140.389C140.221 110.091 140.109 109.979 140.109 109.811C140.109 109.643 140.221 109.531 140.389 109.531H192.917C193.085 109.531 193.197 109.643 193.197 109.811C193.197 109.923 193.085 110.091 192.917 110.091Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 113.505H140.389C140.221 113.505 140.109 113.393 140.109 113.225C140.109 113.057 140.221 112.945 140.389 112.945H192.917C193.085 112.945 193.197 113.057 193.197 113.225C193.197 113.393 193.085 113.505 192.917 113.505Z"
			fill="#082F49"
		/>
		<path
			d="M134.171 119.333H118.491C118.323 119.333 118.211 119.221 118.211 119.053C118.211 118.885 118.323 118.773 118.491 118.773H134.171C134.339 118.773 134.451 118.885 134.451 119.053C134.507 119.221 134.339 119.333 134.171 119.333Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 119.333H140.389C140.221 119.333 140.109 119.221 140.109 119.053C140.109 118.885 140.221 118.773 140.389 118.773H192.917C193.085 118.773 193.197 118.885 193.197 119.053C193.197 119.221 193.085 119.333 192.917 119.333Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 122.802H140.389C140.221 122.802 140.109 122.69 140.109 122.522C140.109 122.354 140.221 122.242 140.389 122.242H192.917C193.085 122.242 193.197 122.354 193.197 122.522C193.197 122.69 193.085 122.802 192.917 122.802Z"
			fill="#082F49"
		/>
		<path
			d="M134.171 128.63H118.491C118.323 128.63 118.211 128.518 118.211 128.35C118.211 128.182 118.323 128.07 118.491 128.07H134.171C134.339 128.07 134.451 128.182 134.451 128.35C134.507 128.518 134.339 128.63 134.171 128.63Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 128.63H140.389C140.221 128.63 140.109 128.518 140.109 128.35C140.109 128.182 140.221 128.07 140.389 128.07H192.917C193.085 128.07 193.197 128.182 193.197 128.35C193.197 128.518 193.085 128.63 192.917 128.63Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 132.099H140.389C140.221 132.099 140.109 131.987 140.109 131.819C140.109 131.651 140.221 131.539 140.389 131.539H192.917C193.085 131.539 193.197 131.651 193.197 131.819C193.197 131.987 193.085 132.099 192.917 132.099Z"
			fill="#082F49"
		/>
		<path
			d="M134.176 85.6796H119.28C119.112 85.6796 119 85.5676 119 85.3996V79.2956C119 79.1276 119.112 79.0156 119.28 79.0156H134.232C134.4 79.0156 134.512 79.1276 134.512 79.2956V85.3996C134.456 85.5676 134.344 85.6796 134.176 85.6796ZM119.504 85.1196H133.896V79.6316H119.504V85.1196Z"
			fill="#082F49"
		/>
		<path
			d="M192.917 85.6796H140.389C140.221 85.6796 140.109 85.5676 140.109 85.3996V79.2956C140.109 79.1276 140.221 79.0156 140.389 79.0156H192.917C193.085 79.0156 193.197 79.1276 193.197 79.2956V85.3996C193.197 85.5676 193.085 85.6796 192.917 85.6796ZM140.669 85.1196H192.637V79.6316H140.669V85.1196Z"
			fill="#082F49"
		/>
		<path
			d="M232.505 43.3984H177.961V88.2544H232.505V43.3984Z"
			fill="white"
		/>
		<path
			d="M232.456 88.541H177.968C177.799 88.541 177.688 88.429 177.688 88.261V43.405C177.688 43.237 177.799 43.125 177.968 43.125H232.456C232.624 43.125 232.736 43.237 232.736 43.405V88.261C232.736 88.429 232.624 88.541 232.456 88.541ZM178.192 87.981H232.12V43.685H178.192V87.981Z"
			fill="#082F49"
		/>
		<path d="M221.591 61.375H188.047V83.663H221.591V61.375Z" fill="white" />
		<path
			d="M221.59 83.9496H188.046C187.878 83.9496 187.766 83.8376 187.766 83.6696V61.3816C187.766 61.2136 187.878 61.1016 188.046 61.1016H221.59C221.758 61.1016 221.87 61.2136 221.87 61.3816V83.6696C221.87 83.7816 221.758 83.9496 221.59 83.9496ZM188.326 83.3336H221.31V61.6056H188.326V83.3336Z"
			fill="#082F49"
		/>
		<path
			d="M221.591 61.3816L217.391 64.1816L204.791 72.5256L192.247 64.1816L188.047 61.3816L192.247 57.7976L202.607 49.0056L204.791 47.1016L207.031 49.0056L217.391 57.7976L221.591 61.3816Z"
			fill="white"
		/>
		<path
			d="M204.79 72.7997C204.734 72.7997 204.678 72.7997 204.622 72.7437L187.878 61.5997C187.822 61.5437 187.766 61.4877 187.766 61.3757C187.766 61.2637 187.822 61.2077 187.878 61.1517L204.622 46.9278C204.734 46.8158 204.902 46.8158 205.014 46.9278L221.758 61.1517C221.814 61.2077 221.87 61.3197 221.87 61.3757C221.87 61.4877 221.814 61.5437 221.758 61.5997L204.958 72.7437C204.902 72.7997 204.846 72.7997 204.79 72.7997ZM188.494 61.3197L204.79 72.1278L221.086 61.3197L204.79 47.4877L188.494 61.3197Z"
			fill="#082F49"
		/>
		<path
			d="M188.043 83.9454C187.987 83.9454 187.931 83.9454 187.875 83.8894C187.763 83.7774 187.707 83.6094 187.819 83.4974L199.411 68.9374C199.523 68.8254 199.691 68.7694 199.803 68.8814C199.915 68.9934 199.971 69.1614 199.859 69.2734L188.267 83.8334C188.211 83.8894 188.155 83.9454 188.043 83.9454Z"
			fill="#082F49"
		/>
		<path
			d="M221.588 83.9449C221.476 83.9449 221.419 83.8889 221.363 83.8329L209.772 69.2729C209.66 69.1609 209.66 68.9929 209.772 68.8809C209.884 68.7689 210.051 68.7689 210.163 68.8809L210.219 68.9369L221.811 83.4969C221.924 83.6089 221.867 83.7769 221.755 83.8889C221.699 83.8889 221.644 83.9449 221.588 83.9449Z"
			fill="#082F49"
		/>
		<path
			d="M217.386 49V64.176L204.786 72.52L192.242 64.176V49H217.386Z"
			fill="#7DD3FC"
		/>
		<path
			d="M204.785 72.7987C204.729 72.7987 204.673 72.7987 204.617 72.7427L192.073 64.3988C192.017 64.3427 191.961 64.2307 191.961 64.1747V48.9988C191.961 48.8307 192.073 48.7188 192.241 48.7188H217.329C217.497 48.7188 217.609 48.8307 217.609 48.9988V64.1747C217.609 64.2867 217.553 64.3427 217.497 64.3988L204.953 72.7427C204.897 72.7987 204.841 72.7987 204.785 72.7987ZM192.521 64.0068L204.785 72.1268L217.049 64.0068V49.2788H192.521V64.0068Z"
			fill="#082F49"
		/>
		<path
			d="M202.434 53.6538H195.21C195.042 53.6538 194.93 53.5418 194.93 53.3738C194.93 53.2057 195.042 53.0938 195.21 53.0938H202.434C202.602 53.0938 202.714 53.2057 202.714 53.3738C202.714 53.5418 202.602 53.6538 202.434 53.6538Z"
			fill="#082F49"
		/>
		<path
			d="M213.298 56.2788H195.21C195.042 56.2788 194.93 56.1668 194.93 55.9988C194.93 55.8307 195.042 55.7188 195.21 55.7188H213.298C213.466 55.7188 213.578 55.8307 213.578 55.9988C213.578 56.1107 213.41 56.2788 213.298 56.2788Z"
			fill="#082F49"
		/>
		<path
			d="M213.298 58.8569H195.21C195.042 58.8569 194.93 58.7449 194.93 58.5769C194.93 58.4089 195.042 58.2969 195.21 58.2969H213.298C213.466 58.2969 213.578 58.4089 213.578 58.5769C213.578 58.7449 213.41 58.8569 213.298 58.8569Z"
			fill="#082F49"
		/>
		<path
			d="M213.298 61.4897H195.21C195.042 61.4897 194.93 61.3777 194.93 61.2097C194.93 61.0417 195.042 60.9297 195.21 60.9297H213.298C213.466 60.9297 213.578 61.0417 213.578 61.2097C213.578 61.3777 213.41 61.4897 213.298 61.4897Z"
			fill="#082F49"
		/>
		<path
			d="M213.298 64.1225H195.21C195.042 64.1225 194.93 64.0105 194.93 63.8425C194.93 63.6745 195.042 63.5625 195.21 63.5625H213.298C213.466 63.5625 213.578 63.6745 213.578 63.8425C213.578 63.9545 213.41 64.1225 213.298 64.1225Z"
			fill="#082F49"
		/>
		<path
			d="M177.966 48.6113C180.842 48.6113 183.174 46.2796 183.174 43.4033C183.174 40.527 180.842 38.1953 177.966 38.1953C175.09 38.1953 172.758 40.527 172.758 43.4033C172.758 46.2796 175.09 48.6113 177.966 48.6113Z"
			fill="#7DD3FC"
		/>
		<path
			d="M177.965 48.8901C174.941 48.8901 172.477 46.4261 172.477 43.4021C172.477 40.3781 174.941 37.9141 177.965 37.9141C180.989 37.9141 183.453 40.3781 183.453 43.4021C183.397 46.4261 180.989 48.8901 177.965 48.8901ZM177.965 38.4741C175.277 38.4741 173.037 40.6581 173.037 43.4021C173.037 46.0901 175.221 48.3301 177.965 48.3301C180.653 48.3301 182.893 46.1461 182.893 43.4021C182.837 40.6581 180.653 38.4741 177.965 38.4741Z"
			fill="#082F49"
		/>
		<path
			d="M177.968 46.5949C177.799 46.5949 177.688 46.4829 177.688 46.3149V40.4909C177.688 40.3229 177.799 40.2109 177.968 40.2109C178.136 40.2109 178.248 40.3229 178.248 40.4909V46.3149C178.248 46.4269 178.079 46.5949 177.968 46.5949Z"
			fill="#082F49"
		/>
		<path
			d="M180.823 43.685H174.999C174.831 43.685 174.719 43.573 174.719 43.405C174.719 43.237 174.831 43.125 174.999 43.125H180.823C180.991 43.125 181.103 43.237 181.103 43.405C181.159 43.573 180.991 43.685 180.823 43.685Z"
			fill="#082F49"
		/>
		<path
			d="M175.894 45.6994C175.838 45.6994 175.726 45.6434 175.67 45.5874C175.558 45.4754 175.558 45.3074 175.67 45.1954L179.758 41.1074C179.87 40.9954 180.038 40.9954 180.15 41.1074C180.262 41.2194 180.262 41.3874 180.15 41.4994L176.062 45.5874C176.062 45.6994 175.95 45.6994 175.894 45.6994Z"
			fill="#082F49"
		/>
		<path
			d="M179.982 45.6994C179.926 45.6994 179.814 45.6434 179.758 45.5874L175.67 41.4994C175.558 41.3874 175.558 41.2194 175.67 41.1074C175.782 40.9954 175.95 40.9954 176.062 41.1074L180.15 45.1954C180.262 45.3074 180.262 45.4754 180.15 45.5874C180.15 45.6994 180.094 45.6994 179.982 45.6994Z"
			fill="#082F49"
		/>
		<path
			d="M221.588 76.9496C224.031 76.9496 226.012 74.9689 226.012 72.5256C226.012 70.0823 224.031 68.1016 221.588 68.1016C219.145 68.1016 217.164 70.0823 217.164 72.5256C217.164 74.9689 219.145 76.9496 221.588 76.9496Z"
			fill="#7DD3FC"
		/>
		<path
			d="M221.587 77.2283C218.955 77.2283 216.883 75.1003 216.883 72.5243C216.883 69.8923 219.011 67.8203 221.587 67.8203C224.219 67.8203 226.291 69.9483 226.291 72.5243C226.291 75.1003 224.163 77.2283 221.587 77.2283ZM221.587 68.3803C219.291 68.3803 217.443 70.2283 217.443 72.5243C217.443 74.8203 219.291 76.6683 221.587 76.6683C223.883 76.6683 225.731 74.8203 225.731 72.5243C225.731 70.2283 223.883 68.3803 221.587 68.3803Z"
			fill="#082F49"
		/>
		<path
			d="M221.418 70.8959L220.69 71.2879L220.578 70.8399L221.53 70.3359H222.034V74.6479H221.474L221.418 70.8959Z"
			fill="white"
		/>
	</svg>
);

export const NoConnections = ( props ) => (
	<svg
		width="324"
		height="336"
		viewBox="0 0 324 336"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M167.422 92.7344C165.182 92.7344 58.4297 170.302 58.4297 170.302L167.486 238.91L276.542 170.302C276.478 170.302 169.662 92.7344 167.422 92.7344Z"
			fill="#7DD3FC"
		/>
		<path
			d="M166.716 91.9062C166.14 91.9703 165.564 92.2262 165.116 92.5462C164.348 92.9942 163.58 93.5062 162.748 94.0182C159.996 95.8742 157.244 97.7302 154.556 99.6502C145.788 105.73 137.084 111.938 128.444 118.146C118.012 125.57 107.58 133.058 97.2121 140.61C88.2521 147.074 79.2281 153.602 70.2681 160.066C65.9161 163.202 61.5641 166.274 57.2761 169.474L57.0841 169.602C56.8281 169.73 56.7641 170.114 56.8921 170.37C56.9561 170.498 57.0201 170.562 57.1481 170.626L67.9641 177.474L94.0121 193.858L125.5 213.698L152.7 230.85C157.116 233.602 161.532 236.418 165.884 239.17L166.076 239.298C166.716 239.682 167.868 240.066 168.572 239.618L179.452 232.77L205.5 216.386L237.052 196.546L264.252 179.458C268.668 176.706 273.148 174.018 277.436 171.138L277.628 171.01C278.076 170.754 277.948 170.306 277.564 170.05L266.812 162.242C258.172 156.034 249.596 149.762 240.956 143.554C230.524 136.066 220.092 128.578 209.66 121.09C200.636 114.626 191.548 108.162 182.396 101.762C179.388 99.6502 176.316 97.5382 173.244 95.4902C171.708 94.3382 170.108 93.3142 168.444 92.4182C167.996 92.1622 167.484 92.0342 166.972 92.0342C166.524 92.0342 165.564 92.0982 165.692 92.7382C165.82 93.3782 167.036 93.6342 167.548 93.6342C167.164 93.6342 166.844 93.5702 166.524 93.3782C166.588 93.4422 166.716 93.4423 166.78 93.5062L167.1 93.6982L167.292 93.8262C167.1 93.6982 167.612 94.0182 167.292 93.8262C168.124 94.3382 168.956 94.9142 169.788 95.4902C172.604 97.3462 175.356 99.2662 178.172 101.25C186.94 107.394 195.644 113.602 204.412 119.81C214.78 127.234 225.148 134.658 235.452 142.082C244.348 148.482 253.244 154.882 262.14 161.346L270.844 167.682L273.532 169.666C273.98 170.05 274.428 170.37 274.94 170.69C275.004 170.754 275.068 170.754 275.132 170.818L275.068 169.858L264.188 176.706L238.14 193.09L206.588 212.93L179.516 229.826L170.62 235.458C169.212 236.354 167.676 237.186 166.332 238.146L166.14 238.274L168.636 238.594L157.82 231.746L131.772 215.362L100.284 195.522L73.0841 178.37L64.1241 172.738L61.3081 170.946C60.8601 170.562 60.3481 170.306 59.8361 170.05C59.7721 169.986 59.7081 169.986 59.6441 169.922L59.7081 170.882L70.3321 163.202C78.8441 157.058 87.3561 150.85 95.8681 144.706C106.236 137.218 116.604 129.794 126.972 122.306C135.996 115.842 145.084 109.378 154.172 102.978C158.78 99.7142 163.388 96.3222 168.252 93.4422C168.7 93.1862 168.188 93.4422 167.996 93.4422C168.572 93.4422 169.148 93.0582 168.764 92.4822C168.38 91.9062 167.356 91.9062 166.716 91.9062Z"
			fill="#7DD3FC"
		/>
		<path
			d="M148.094 204.415C148.094 204.415 179.838 158.591 198.398 169.663C199.806 170.495 201.022 171.583 202.046 172.863L201.982 172.351C201.982 172.351 235.198 222.271 229.054 247.359C223.614 269.503 203.71 275.135 191.87 236.095C177.79 230.847 154.238 214.463 148.094 204.415Z"
			fill="white"
		/>
		<path
			d="M149.375 205.314L149.631 204.994L149.759 204.802L150.143 204.226C150.975 203.074 151.871 201.922 152.703 200.834C155.519 197.122 158.527 193.538 161.599 190.082C165.375 185.858 169.407 181.89 173.759 178.242C177.727 174.978 182.079 171.906 187.007 170.242C188.991 169.538 191.103 169.218 193.215 169.282C193.279 169.282 193.279 169.282 193.343 169.282L193.663 169.346C193.919 169.346 194.239 169.41 194.495 169.474C195.007 169.538 195.519 169.666 195.967 169.858C195.711 169.794 196.287 169.986 196.415 169.986C196.671 170.114 196.927 170.178 197.183 170.306C197.439 170.434 197.631 170.498 197.823 170.626C198.015 170.754 197.695 170.498 198.015 170.754C198.335 171.01 198.527 171.074 198.783 171.266C199.679 171.906 200.511 172.738 201.215 173.57C201.855 174.338 203.583 174.466 203.391 173.058L203.327 172.546L200.895 172.738C202.239 174.722 203.519 176.834 204.735 178.882C207.807 183.938 210.687 189.058 213.439 194.306C216.895 200.834 219.903 207.554 222.591 214.402C225.151 221.122 227.327 227.97 228.095 235.138C228.479 238.146 228.479 241.154 228.095 244.162C227.647 247.106 226.815 250.05 225.535 252.802C224.511 255.234 223.103 257.41 221.375 259.33C219.967 260.93 218.175 262.146 216.127 262.85C215.871 262.914 215.615 262.978 215.359 263.042C215.231 263.106 215.423 263.042 215.423 263.042L215.231 263.106L214.847 263.17C214.335 263.234 213.823 263.298 213.311 263.298H212.927H212.735H212.799C212.543 263.298 212.223 263.234 211.967 263.17C211.711 263.106 211.455 263.106 211.263 263.042L210.879 262.978L210.687 262.914C210.431 262.85 210.815 262.978 210.687 262.914C210.111 262.722 209.599 262.53 209.087 262.274L208.703 262.082L208.447 261.954L208.191 261.826L207.679 261.506C207.103 261.122 206.591 260.738 206.079 260.29C205.759 260.034 206.143 260.354 205.951 260.162L205.503 259.778C205.247 259.522 204.991 259.266 204.671 259.01C204.095 258.434 203.583 257.794 203.071 257.218C203.071 257.218 202.815 256.898 202.943 257.09L202.879 256.962C202.751 256.77 202.623 256.578 202.495 256.386C202.239 256.002 201.983 255.682 201.727 255.298C200.575 253.634 199.551 251.842 198.591 250.05C197.567 248.002 196.607 245.826 195.775 243.714C195.263 242.434 194.815 241.218 194.367 239.938C194.175 239.298 193.919 238.658 193.727 238.082C193.535 237.314 193.279 236.482 192.959 235.778C192.383 234.882 191.039 234.562 190.079 234.178C189.119 233.794 188.351 233.474 187.519 233.026C185.663 232.194 183.871 231.234 182.079 230.274C178.175 228.162 174.399 225.794 170.687 223.298C163.839 218.69 156.991 213.57 151.551 207.298C151.295 206.978 151.039 206.658 150.783 206.338C150.719 206.274 150.719 206.21 150.655 206.146C150.463 205.954 150.783 206.338 150.655 206.146L150.335 205.698C149.887 205.122 149.503 204.546 149.119 203.97C148.735 203.394 147.903 202.818 147.199 203.074C146.495 203.33 146.623 204.29 146.943 204.866C148.543 207.298 150.399 209.602 152.511 211.586C155.199 214.21 158.015 216.706 160.959 219.01C167.295 224.066 174.079 228.546 181.183 232.45C184.575 234.306 188.031 235.97 191.679 237.314L190.527 236.162C192.767 243.394 195.583 250.754 200.063 256.898C202.879 260.738 206.463 264.322 211.135 265.666C214.655 266.626 218.431 265.858 221.375 263.618C224.767 261.122 227.071 257.282 228.607 253.506C230.463 248.898 231.359 243.97 231.103 238.978C230.847 233.346 229.567 227.778 227.903 222.402C224.447 211.01 219.263 200.13 213.567 189.634C210.303 183.682 206.975 177.73 203.199 172.098L203.007 171.842C202.687 171.266 202.047 170.882 201.407 170.882C200.895 170.946 200.511 171.394 200.575 171.906C200.575 171.97 200.575 171.97 200.575 172.034L200.639 172.546L202.815 172.034C199.231 167.618 193.407 165.634 187.903 166.914C182.719 168.066 178.111 170.882 173.951 174.018C169.343 177.602 165.055 181.57 161.087 185.858C157.631 189.506 154.431 193.346 151.359 197.314C150.335 198.594 149.375 199.938 148.415 201.218C147.839 201.922 147.327 202.626 146.879 203.394C146.879 203.458 146.815 203.458 146.815 203.458C146.367 204.098 147.071 205.058 147.583 205.442C148.031 205.89 148.799 205.89 149.247 205.378C149.311 205.442 149.311 205.378 149.375 205.314Z"
			fill="#082F49"
		/>
		<path
			d="M217.275 157.76C223.483 135.36 209.915 126.976 199.867 124.672C189.819 122.368 182.459 125.248 179.899 129.216C177.979 132.16 182.779 152.064 182.779 152.064L198.011 170.496C197.947 170.432 212.539 174.848 217.275 157.76Z"
			fill="#082F49"
		/>
		<path
			d="M171.515 160.128C166.395 151.872 179.835 133.056 179.835 133.056C183.675 133.12 190.459 131.008 190.459 131.008C186.171 141.76 198.651 147.648 198.651 147.648C202.619 142.208 209.211 145.856 207.547 151.68C205.883 157.504 200.123 156.928 200.123 156.928C200.123 156.928 199.995 172.096 198.907 174.336C198.907 174.336 187.899 179.008 183.675 169.216C183.675 169.28 174.971 165.696 171.515 160.128Z"
			fill="white"
		/>
		<path
			d="M172.862 159.366C171.966 157.83 171.774 155.782 171.966 153.926C172.222 151.686 172.798 149.446 173.63 147.398C175.23 143.366 177.214 139.526 179.582 135.942C180.094 135.174 180.606 134.342 181.182 133.574L179.39 134.342C183.23 134.406 187.198 133.318 190.846 132.166L188.99 130.886C187.518 134.534 187.838 138.694 189.95 142.022C191.486 144.39 193.598 146.374 196.03 147.846C196.606 148.23 197.246 148.55 197.886 148.87C198.654 149.126 199.486 148.87 199.998 148.23C200.51 147.526 201.15 146.95 201.918 146.566C202.43 146.374 202.942 146.31 203.518 146.374C204.094 146.502 204.67 146.758 205.054 147.206C205.502 147.654 205.822 148.166 206.014 148.806C206.462 150.47 206.142 152.326 205.118 153.734C204.926 153.99 204.734 154.246 204.478 154.438L204.03 154.822C203.966 154.886 203.838 155.014 203.71 155.014C203.582 155.078 203.39 155.206 203.262 155.27C203.134 155.334 202.878 155.462 203.134 155.334C202.814 155.462 202.494 155.59 202.174 155.654C202.046 155.718 201.726 155.718 202.046 155.718L201.598 155.782C201.342 155.782 201.086 155.846 200.83 155.846C200.318 155.91 201.086 155.846 200.702 155.846H200.51C199.742 155.782 198.526 156.294 198.462 157.254C198.398 161.99 198.334 166.79 197.822 171.462C197.758 172.102 197.694 172.742 197.566 173.382C197.566 173.51 197.502 173.638 197.502 173.766C197.566 173.51 197.502 173.766 197.502 173.83C197.438 174.022 197.374 174.15 197.31 174.342L198.462 173.382C198.206 173.51 197.886 173.574 197.63 173.702C197.374 173.83 197.054 173.894 196.734 173.958L196.222 174.086C195.774 174.15 196.158 174.086 196.222 174.086L195.902 174.15C195.454 174.214 195.006 174.278 194.558 174.342C194.302 174.342 194.046 174.406 193.854 174.406H193.534C193.342 174.406 193.342 174.406 193.534 174.406H193.278C192.254 174.406 191.23 174.214 190.27 173.894C189.182 173.51 188.158 172.87 187.326 172.038C186.878 171.526 186.43 171.014 186.046 170.438C185.598 169.734 185.342 168.582 184.51 168.262C183.166 167.686 181.822 166.982 180.478 166.214C177.534 164.422 174.718 162.246 172.862 159.366C172.03 158.15 169.15 159.494 170.11 160.966C171.966 163.91 174.846 166.086 177.726 167.814C179.39 168.838 181.054 169.67 182.846 170.438L182.142 169.798C183.678 173.254 186.366 175.686 190.078 176.518C192.702 176.966 195.326 176.838 197.886 176.07C198.334 175.942 198.782 175.814 199.23 175.622C200.574 175.046 200.702 173.702 200.894 172.486C201.278 169.542 201.47 166.534 201.534 163.526C201.598 161.35 201.662 159.11 201.662 156.934L199.614 158.342C202.75 158.598 205.822 157.19 207.678 154.694C209.022 152.774 209.79 150.15 209.022 147.846C208.318 145.862 206.654 144.39 204.542 144.006C201.662 143.494 198.974 145.158 197.31 147.398L199.486 146.694C199.294 146.63 199.806 146.886 199.678 146.822C199.614 146.758 199.486 146.758 199.422 146.694C199.102 146.566 198.846 146.374 198.59 146.182C197.63 145.606 196.734 144.966 195.902 144.262C193.79 142.534 191.87 140.038 191.294 137.158C190.91 135.174 191.166 133.126 191.934 131.27C192.382 130.118 190.91 129.734 190.078 129.99C187.326 130.95 184.446 131.59 181.566 131.91C180.478 132.038 179.262 131.782 178.494 132.742C178.43 132.806 178.366 132.934 178.302 132.998C177.918 133.574 177.534 134.15 177.086 134.79C173.822 139.846 170.75 145.414 169.342 151.302C168.574 154.502 168.318 158.086 170.046 161.03C170.942 162.182 173.758 160.838 172.862 159.366Z"
			fill="#082F49"
		/>
		<path
			d="M191.678 154.818C191.678 155.01 191.678 155.202 191.678 155.458V155.202C191.678 156.034 191.55 156.93 191.23 157.698L191.294 157.442C191.23 157.698 191.102 157.89 190.974 158.082C190.974 158.146 190.91 158.146 190.91 158.21C190.782 158.402 191.102 158.018 190.91 158.146C190.846 158.21 190.782 158.274 190.654 158.402L190.59 158.466C190.462 158.53 190.846 158.338 190.718 158.402C190.654 158.402 190.59 158.466 190.59 158.466L190.526 158.53C190.398 158.594 190.654 158.466 190.654 158.466C190.654 158.466 190.526 158.53 190.462 158.53H190.398C190.206 158.594 190.654 158.53 190.59 158.53H190.27C190.078 158.53 190.398 158.53 190.462 158.53C190.526 158.53 190.334 158.53 190.206 158.466C190.142 158.466 190.014 158.402 189.95 158.402C189.758 158.338 190.206 158.53 190.078 158.466L189.95 158.402C189.758 158.338 189.502 158.21 189.31 158.082C188.798 157.826 188.094 157.954 187.71 158.402C187.39 158.978 187.838 159.426 188.286 159.682C189.182 160.194 190.206 160.386 191.166 160.258C191.934 160.13 192.574 159.682 193.022 159.042C193.598 158.082 193.918 156.994 193.918 155.842C193.918 155.522 193.918 155.138 193.918 154.818C193.854 154.562 193.726 154.306 193.47 154.178C193.214 153.986 192.894 153.922 192.574 153.922C191.998 153.922 191.486 154.242 191.55 154.818H191.678Z"
			fill="#082F49"
		/>
		<path
			d="M181.246 145.281C178.814 146.433 176.254 147.265 173.566 147.713C164.606 149.313 163.582 152.449 166.398 154.177C169.214 155.905 181.374 154.433 181.374 154.433"
			fill="white"
		/>
		<path
			d="M179.903 144.449C177.215 145.921 174.143 146.433 171.135 147.073C169.279 147.393 167.487 147.969 165.759 148.865C164.927 149.313 163.967 149.953 163.647 150.913C162.943 153.089 166.143 154.753 167.743 155.201C170.431 156.033 173.439 155.841 176.191 155.713C178.367 155.585 180.543 155.457 182.655 155.201C183.167 155.137 182.015 154.241 181.951 154.177C181.375 153.729 180.735 153.537 180.031 153.537H179.839L178.815 153.665C177.727 153.793 176.575 153.857 175.487 153.921C172.927 154.177 170.303 154.177 167.743 153.921C167.487 153.921 167.231 153.857 166.975 153.793C166.911 153.793 166.591 153.729 166.719 153.729C166.847 153.729 166.527 153.665 166.463 153.665C166.655 153.729 166.655 153.729 166.463 153.665C166.527 153.729 167.039 153.985 166.847 153.857C166.975 153.985 167.039 153.985 166.847 153.857C167.039 154.049 166.847 153.857 166.783 153.793C166.719 153.729 166.847 153.857 166.719 153.729C166.655 153.665 166.655 153.601 166.591 153.537C166.591 153.537 166.463 153.281 166.463 153.217C166.399 152.961 166.399 152.641 166.527 152.385C166.911 151.553 167.615 150.913 168.511 150.529C170.047 149.761 171.647 149.249 173.247 148.929C176.383 148.225 179.647 147.713 182.527 146.241C182.975 145.985 181.951 145.345 181.823 145.217C181.375 144.833 180.351 144.193 179.903 144.449Z"
			fill="#082F49"
		/>
		<path
			d="M186.62 144.133C186.62 144.133 185.212 144.069 185.276 145.413C185.34 146.757 187.004 146.757 187.324 145.541C187.516 145.029 187.26 144.389 186.748 144.197C186.684 144.133 186.684 144.133 186.62 144.133Z"
			fill="#082F49"
		/>
		<path
			d="M177.854 141.446C177.854 141.446 176.446 141.382 176.51 142.726C176.574 144.07 178.238 144.07 178.558 142.854C178.75 142.342 178.494 141.702 177.982 141.51C177.918 141.446 177.918 141.446 177.854 141.446Z"
			fill="#082F49"
		/>
		<path
			d="M208.122 162.623C208.442 164.671 209.082 166.655 209.914 168.575C211.002 171.135 212.986 174.015 216.186 173.311C218.49 172.799 220.474 171.135 221.882 169.343C222.906 168.063 223.802 166.335 223.482 164.607C222.906 161.663 219.642 160.575 217.082 161.791C212.794 163.839 213.306 169.023 214.714 172.799C215.61 175.167 216.89 177.343 218.554 179.199C219.834 180.607 221.434 182.079 223.29 182.719C226.874 183.935 230.65 180.671 230.266 176.959C230.074 174.591 228.154 172.799 226.042 171.903C223.61 170.815 220.794 171.135 218.682 172.799C216.122 174.975 216.826 178.239 218.042 180.991C218.554 182.143 219.194 183.231 219.834 184.319C220.346 185.087 223.034 183.359 222.522 182.591C221.434 180.927 220.538 179.135 219.962 177.215C219.642 176.191 219.578 175.039 219.834 173.951C219.898 173.823 219.898 173.759 219.962 173.631C220.026 173.503 219.834 173.823 220.026 173.567L220.154 173.311C219.834 173.759 220.41 173.119 220.09 173.375C219.77 173.631 220.026 173.439 220.09 173.375C220.282 173.247 219.834 173.503 219.898 173.503C219.962 173.439 220.09 173.375 220.154 173.375C219.834 173.439 220.026 173.439 220.218 173.375L220.538 173.311H220.73H220.986C223.418 173.311 225.594 174.591 226.874 176.639C227.322 177.471 227.514 178.431 227.386 179.327C227.258 179.967 227.002 180.543 226.682 181.119C226.746 181.055 226.682 181.055 226.746 181.055C226.554 181.183 227.258 180.735 226.938 180.927C227.066 180.863 227.13 180.863 227.002 180.863C226.874 180.863 226.81 180.863 226.682 180.863C225.21 180.863 223.802 179.903 222.778 179.007C221.242 177.727 219.962 176.127 218.938 174.399C217.722 172.479 216.89 170.367 216.506 168.127C216.25 166.655 216.122 164.607 216.89 163.455C216.89 163.391 217.146 163.007 217.018 163.263C217.082 163.199 217.082 163.135 217.146 163.135C217.146 163.135 216.89 163.327 217.082 163.199C217.274 163.071 216.954 163.263 217.018 163.263C216.826 163.391 216.954 163.327 217.018 163.263C216.698 163.455 216.89 163.263 217.018 163.263C217.274 163.263 216.826 163.263 217.082 163.263H217.274C217.082 163.263 217.466 163.263 217.274 163.263C217.53 163.263 217.722 163.263 217.978 163.327C219.898 163.775 221.05 165.631 220.666 167.551C220.602 167.807 220.538 168.127 220.346 168.383C220.026 169.087 219.578 169.727 219.002 170.239C218.746 170.495 218.49 170.687 218.234 170.943C218.362 170.815 217.722 171.263 217.978 171.135C218.234 171.007 217.402 171.391 217.786 171.263C217.722 171.263 217.402 171.391 217.466 171.391C217.53 171.391 217.21 171.455 217.146 171.455C217.082 171.455 216.954 171.455 216.89 171.455C216.762 171.455 216.57 171.455 216.442 171.391C215.994 171.263 215.546 171.071 215.098 170.751C214.202 169.983 213.434 168.959 212.922 167.871C211.962 165.951 211.322 163.903 210.874 161.791L210.81 161.407C210.746 160.255 207.994 161.727 208.122 162.623Z"
			fill="#082F49"
		/>
		<path
			d="M146.492 202.18L191.74 224.004L147.004 237.892L146.492 202.18Z"
			fill="#082F49"
		/>
		<path
			d="M150.589 186.245L147.005 237.894L100.797 215.045L102.461 162.438L150.589 186.245Z"
			fill="#082F49"
		/>
		<path
			d="M130.938 197.955C130.362 196.227 128.762 195.011 126.97 195.011C125.242 194.947 123.578 195.971 122.49 197.251C121.274 198.659 120.314 200.515 120.378 202.499C120.506 204.227 121.402 205.827 122.874 206.787C124.282 207.619 125.818 208.195 127.482 208.387C128.314 208.579 129.21 208.131 129.466 207.235C129.722 206.403 129.21 205.507 128.378 205.251C127.674 205.123 127.034 204.995 126.33 204.803L125.818 204.611C125.754 204.611 125.242 204.355 125.562 204.547C125.306 204.419 124.986 204.291 124.73 204.099C124.666 204.035 124.218 203.715 124.538 203.971C124.41 203.843 124.282 203.779 124.154 203.651C124.09 203.587 123.898 203.267 124.09 203.587C123.962 203.459 123.898 203.267 123.834 203.139C123.77 203.011 123.77 203.011 123.834 203.139C123.77 203.075 123.77 202.947 123.77 202.883C123.77 202.755 123.706 202.691 123.706 202.563C123.706 202.691 123.706 202.691 123.706 202.563C123.706 202.371 123.706 202.179 123.706 201.987C123.706 202.243 123.77 201.667 123.77 201.603C123.962 200.835 124.346 200.195 124.794 199.555C124.602 199.747 124.986 199.299 125.05 199.299C125.114 199.299 125.242 199.043 125.37 198.979C125.498 198.915 125.882 198.595 125.626 198.723C125.818 198.595 125.946 198.531 126.138 198.403C126.394 198.211 126.01 198.403 126.33 198.339C126.394 198.339 127.034 198.211 126.586 198.211C126.778 198.211 126.97 198.211 127.098 198.211C126.714 198.211 127.226 198.275 127.354 198.275C127.738 198.339 127.162 198.147 127.482 198.275C127.546 198.339 127.994 198.659 127.738 198.403C127.802 198.467 128.058 198.851 127.93 198.531C127.994 198.595 127.994 198.659 128.058 198.787C127.994 198.595 127.994 198.595 128.058 198.787C128.314 199.619 129.146 200.131 130.042 199.875C130.746 199.619 131.258 198.723 130.938 197.955Z"
			fill="white"
		/>
		<path
			d="M148.474 205.634C148.474 206.146 148.474 206.402 148.474 207.042C148.474 207.874 148.41 208.642 148.41 209.474C148.282 211.714 148.218 213.954 148.09 216.194C147.834 220.994 147.514 225.794 147.194 230.594C147.066 232.13 147.002 233.73 146.81 235.266C146.682 236.354 148.986 236.802 149.178 235.778C149.69 232.258 149.754 228.674 150.01 225.09C150.33 220.226 150.586 215.362 150.778 210.434C150.842 208.834 150.906 207.234 150.906 205.698C150.906 204.738 148.538 204.418 148.474 205.634Z"
			fill="white"
		/>
		<path
			d="M175.289 222.978C174.521 222.466 173.625 222.018 172.793 221.57C170.937 220.546 169.081 219.522 167.225 218.498L155.001 211.778L152.185 210.242C151.673 209.986 151.545 210.69 151.609 211.01C151.673 211.586 152.057 212.098 152.569 212.354C159.097 215.938 165.689 219.586 172.217 223.17C173.241 223.746 174.329 224.258 175.289 224.898C175.673 225.154 176.057 224.962 176.057 224.514C176.057 223.938 175.801 223.362 175.289 222.978Z"
			fill="white"
		/>
		<path
			d="M166.715 225.797L153.979 218.309L152.187 217.285C151.803 217.029 151.099 217.029 150.971 217.541C150.843 218.053 151.419 218.629 151.867 218.821L164.603 226.309L166.395 227.397C166.779 227.653 167.483 227.653 167.611 227.141C167.739 226.629 167.099 225.989 166.715 225.797Z"
			fill="white"
		/>
		<path
			d="M159.229 228.417L152.893 224.193L151.997 223.617C151.421 223.297 150.717 223.489 150.333 224.001C150.013 224.449 150.077 225.089 150.525 225.409L150.589 225.473L156.925 229.697L157.821 230.273C158.397 230.593 159.101 230.401 159.485 229.889C159.805 229.441 159.741 228.801 159.293 228.481C159.293 228.417 159.229 228.417 159.229 228.417Z"
			fill="white"
		/>
		<path
			d="M169.469 218.626C169.085 218.818 169.789 218.498 169.469 218.626L169.213 218.753C168.701 218.945 168.189 219.137 167.677 219.393C166.205 219.969 164.733 220.546 163.197 221.122C160.061 222.338 156.925 223.49 153.725 224.706L151.549 225.473C151.293 225.601 150.333 225.922 150.269 226.306C150.205 226.69 151.037 226.306 151.165 226.242C156.477 224.258 161.853 222.274 167.165 220.162C168.189 219.778 169.213 219.394 170.237 218.882C170.365 218.818 171.133 218.37 170.877 218.242C170.621 218.114 169.661 218.562 169.469 218.69V218.626Z"
			fill="white"
		/>
		<path
			d="M167.422 238.913L58.4297 170.305V297.281H276.478V170.305L167.422 238.913Z"
			fill="white"
		/>
		<path
			d="M168.762 238.022L157.882 231.174L131.834 214.79L100.346 194.95L73.0822 177.798L64.1222 172.166L61.3063 170.374C60.8583 170.054 60.3462 169.734 59.8342 169.478C59.7702 169.414 59.7062 169.414 59.6422 169.35C59.1942 169.094 56.9543 170.566 56.9543 171.014V296.07C56.8903 296.646 56.8903 297.222 56.9543 297.798C56.9543 297.862 56.9543 297.926 56.9543 297.99H57.0182H266.298C269.114 297.99 271.93 298.054 274.746 297.99H275.13C275.642 297.99 277.754 296.838 277.754 296.262V171.398C277.818 170.822 277.818 170.246 277.754 169.67C277.754 169.606 277.754 169.542 277.754 169.478C277.754 169.35 276.282 170.118 276.282 170.118L265.402 176.966L239.354 193.35L207.802 213.19L180.602 230.342C176.186 233.094 171.77 235.846 167.418 238.662L167.226 238.79C167.098 238.854 165.882 239.622 166.01 239.814C166.138 240.006 167.418 239.238 167.482 239.174L178.362 232.326L204.41 215.942L235.962 196.102L263.162 178.95C267.578 176.198 272.058 173.51 276.346 170.63L276.538 170.502L275.066 171.142V293.062C275.066 294.662 274.938 296.39 275.066 297.99C275.066 298.054 275.066 298.118 275.066 298.182L277.69 296.454H60.4742C60.2822 296.454 60.0262 296.454 59.8342 296.454C59.6422 296.39 59.7703 296.518 59.7703 296.454C59.5783 296.07 59.7703 294.918 59.7703 294.47V169.414L57.0822 171.078L67.9622 177.926L94.0102 194.31L125.498 214.15L152.762 231.302L161.722 236.934L164.538 238.726C164.986 239.046 165.498 239.366 166.01 239.622C166.074 239.686 166.138 239.686 166.202 239.75C166.522 239.942 167.418 239.238 167.674 239.11C167.674 239.046 168.89 238.15 168.762 238.022Z"
			fill="#7DD3FC"
		/>
		<path
			d="M73.5938 287.942C73.5938 287.942 155.706 213.766 168.058 215.75C180.41 217.734 254.266 284.294 254.266 284.294"
			fill="white"
		/>
		<path
			d="M74.9363 288.646C77.4323 286.406 79.9283 284.166 82.4243 281.99C88.5683 276.55 94.7763 271.174 100.984 265.798C108.792 259.078 116.728 252.422 124.728 245.894C132.408 239.686 140.152 233.542 148.152 227.782C151.288 225.542 154.424 223.366 157.752 221.318C159.096 220.486 160.376 219.718 161.784 219.014C162.36 218.694 162.936 218.374 163.576 218.118C163.832 217.99 164.152 217.862 164.408 217.734L164.792 217.542L165.048 217.414C164.792 217.478 165.24 217.35 165.304 217.35L165.624 217.222C165.88 217.158 166.072 217.094 166.328 216.966C166.584 216.838 166.712 216.838 166.904 216.838C166.968 216.838 167.096 216.838 167.16 216.774C166.776 216.838 167.224 216.71 167.16 216.774L167.672 216.71C167.992 216.646 167.48 216.71 167.544 216.71C167.608 216.71 167.736 216.71 167.8 216.71C168.312 216.71 167.544 216.646 167.864 216.71C168.056 216.774 168.248 216.838 168.44 216.902C168.632 216.966 168.824 217.03 169.016 217.094C169.208 217.158 168.632 216.902 169.08 217.094L169.464 217.286C169.976 217.542 170.488 217.734 170.936 217.99C172.152 218.63 173.368 219.334 174.52 220.102C176.12 221.062 177.08 221.766 178.68 222.918C180.28 224.07 181.944 225.222 183.544 226.438C187.32 229.254 191.032 232.134 194.744 235.078C203.064 241.67 211.192 248.454 219.256 255.366C226.488 261.51 233.72 267.782 240.824 274.054C244.728 277.51 248.632 281.03 252.472 284.486L252.984 284.934C253.624 285.446 254.52 285.51 255.224 285.19C255.672 284.998 255.864 284.486 255.672 284.038C255.608 283.91 255.48 283.782 255.352 283.654C252.6 281.158 249.848 278.726 247.032 276.294C240.376 270.406 233.656 264.582 226.936 258.758C218.808 251.782 210.616 244.87 202.296 238.086C195.128 232.262 187.896 226.502 180.28 221.19C177.72 219.334 175.032 217.67 172.216 216.198C170.424 215.302 168.504 214.406 166.456 214.662C164.088 214.918 161.848 216.006 159.8 217.094C156.856 218.694 153.976 220.422 151.16 222.342C143.352 227.59 135.864 233.286 128.568 239.174C120.248 245.766 112.12 252.55 104.056 259.398C97.1443 265.286 90.2963 271.174 83.5123 277.19C79.9283 280.39 76.2803 283.59 72.6963 286.79L72.1843 287.238C71.6083 287.75 72.0563 288.454 72.5683 288.774C73.4003 289.158 74.2963 289.094 74.9363 288.646Z"
			fill="#7DD3FC"
		/>
		<path
			d="M189.18 213.764C189.18 213.764 192.252 265.604 214.268 266.948C236.284 268.292 231.292 225.988 216.636 199.172C201.98 172.356 200.38 173.444 200.38 173.444"
			fill="white"
		/>
		<path
			d="M187.836 213.254C187.964 215.75 188.284 218.182 188.54 220.614C189.244 226.31 190.268 231.942 191.612 237.51C193.148 243.718 195.132 249.926 198.268 255.558C201.02 260.486 204.924 265.35 210.428 267.398C215.548 269.318 221.756 268.486 225.468 264.262C229.692 259.526 230.524 252.486 230.588 246.406C230.716 238.022 229.116 229.574 226.876 221.574C225.66 217.222 224.124 212.934 222.396 208.774C220.476 204.358 218.364 200.006 215.996 195.782C212.348 189.19 208.636 182.47 204.284 176.326C203.58 175.238 202.748 174.214 201.852 173.318C201.404 172.806 200.764 172.422 200.06 172.23C199.868 172.166 199.612 172.23 199.42 172.294C198.14 173.126 200.316 175.43 201.404 174.726C201.02 174.854 200.636 174.79 200.316 174.598C200.636 174.79 200.188 174.47 200.188 174.47C200.252 174.534 200.316 174.598 200.444 174.662C200.508 174.726 200.508 174.726 200.572 174.79C200.828 174.982 200.252 174.406 200.508 174.726C200.764 175.046 201.148 175.494 201.468 175.878C201.98 176.518 202.428 177.158 202.876 177.798C203.004 177.99 203.132 178.182 203.26 178.374L203.388 178.566C203.388 178.566 203.196 178.31 203.324 178.502L203.58 178.95C203.9 179.462 204.284 180.038 204.604 180.55C206.652 183.75 208.572 187.078 210.492 190.406C212.988 194.822 215.548 199.238 217.788 203.782C219.644 207.622 221.244 211.59 222.588 215.622C225.34 223.558 227.132 231.75 227.772 240.134C228.22 246.47 228.092 253.51 225.084 259.334C223.996 261.446 222.396 263.238 220.284 264.454C218.044 265.606 215.548 266.054 213.052 265.734C212.476 265.67 211.836 265.542 211.26 265.414C211.58 265.478 211.068 265.35 211.004 265.35L210.62 265.222C210.3 265.094 210.044 265.03 209.724 264.902L209.34 264.71L209.084 264.582C209.276 264.646 208.828 264.454 208.764 264.454C208.7 264.454 208.508 264.326 208.38 264.198C208.124 264.07 207.868 263.878 207.612 263.75C207.484 263.686 207.356 263.622 207.292 263.494L207.1 263.366C206.908 263.238 207.42 263.622 207.1 263.366C206.588 262.982 206.14 262.598 205.692 262.15C205.5 261.958 205.244 261.766 205.052 261.51L204.924 261.382L204.604 260.998C204.156 260.486 203.708 259.974 203.324 259.462C203.132 259.206 202.94 258.95 202.748 258.63C202.684 258.502 202.556 258.374 202.492 258.246L202.364 257.99C202.172 257.734 202.428 258.054 202.3 257.926C198.908 252.87 196.924 247.302 195.26 241.414C194.428 238.47 193.724 235.526 193.148 232.518C192.572 229.83 192.188 227.398 191.804 224.646C191.356 221.382 190.972 218.118 190.716 214.79C190.716 214.662 190.716 214.47 190.716 214.342C190.588 213.574 190.076 212.87 189.308 212.614C188.732 212.422 187.9 212.486 187.964 213.254H187.836Z"
			fill="#082F49"
		/>
		<path
			d="M205.051 210.686C205.051 210.686 208.827 188.286 200.379 188.542C200.379 188.542 199.483 182.398 192.955 184.574C192.955 184.574 190.011 180.734 185.787 180.734C181.563 180.734 172.347 187.134 173.563 190.91C174.779 194.686 184.443 191.294 184.443 191.294C183.547 193.15 182.907 195.07 182.651 197.118C182.651 197.118 173.883 196.222 173.563 200.446C173.243 204.67 178.363 212.222 181.691 212.35C185.019 212.478 185.147 210.174 185.147 210.174C185.147 210.174 185.915 212.67 190.971 214.974C196.027 217.278 205.051 210.686 205.051 210.686Z"
			fill="white"
		/>
		<path
			d="M206.586 211.078C207.034 208.39 207.29 205.638 207.418 202.886C207.61 198.79 207.674 193.99 205.562 190.342C204.538 188.422 202.49 187.206 200.314 187.206L201.978 188.55C201.786 187.206 201.21 185.926 200.314 184.902C198.202 182.47 195.002 182.406 192.122 183.302L194.298 183.878C192.442 181.446 189.69 179.846 186.682 179.398C183.418 178.95 180.09 180.742 177.53 182.534C175.162 184.134 172.09 186.63 171.898 189.702C171.706 192.966 175.418 193.99 177.978 193.862C180.474 193.734 182.97 193.222 185.338 192.326L183.098 190.406C182.074 192.326 181.434 194.438 181.178 196.55L182.65 195.654C181.114 195.526 179.514 195.526 177.978 195.718C175.802 195.974 173.05 196.806 172.218 199.174C171.898 200.454 171.962 201.798 172.41 203.014C172.858 204.55 173.498 205.958 174.33 207.302C175.738 209.67 177.85 212.422 180.666 213.254C183.098 214.022 186.618 212.934 186.746 210.054L183.674 210.246C184.122 211.206 184.762 212.102 185.53 212.806C186.426 213.638 187.386 214.342 188.474 214.918C189.498 215.558 190.65 216.07 191.866 216.326C195.834 217.094 199.994 215.238 203.386 213.318C204.41 212.742 205.37 212.166 206.33 211.462C206.842 211.014 206.842 210.246 206.394 209.798C206.33 209.734 206.266 209.67 206.202 209.606C205.562 209.094 204.666 209.03 203.962 209.478L203.45 209.798L202.874 210.182L202.554 210.374C202.426 210.438 202.554 210.374 202.618 210.374L202.298 210.566C200.89 211.398 199.418 212.166 197.882 212.806C196.41 213.446 194.81 213.83 193.21 213.894C192.954 213.894 192.762 213.894 192.57 213.83C192.378 213.766 192.634 213.83 192.378 213.766C191.93 213.702 191.546 213.51 191.162 213.318C190.138 212.87 189.178 212.23 188.346 211.526C187.77 211.142 187.322 210.566 186.938 209.99C186.874 209.926 186.81 209.798 186.746 209.67C187.002 210.054 186.81 209.798 186.746 209.734L186.682 209.542C186.234 208.134 183.674 208.134 183.61 209.734C183.674 209.094 183.61 209.606 183.546 209.798C183.482 209.99 183.674 209.606 183.482 209.926L183.354 210.118C183.354 210.182 183.482 210.054 183.29 210.182C182.97 210.438 182.65 210.566 182.266 210.566C182.138 210.566 181.498 210.566 181.69 210.566C181.882 210.566 181.05 210.31 181.434 210.502C180.602 210.118 179.898 209.606 179.322 208.902C178.426 207.942 177.722 206.918 177.082 205.83C176.442 204.742 175.93 203.59 175.61 202.438C175.482 201.99 175.354 201.478 175.354 200.966C175.29 200.582 175.29 200.134 175.418 199.75C175.418 199.686 175.482 199.494 175.418 199.75C175.482 199.686 175.482 199.558 175.546 199.494C175.61 199.43 175.674 199.302 175.738 199.238C175.866 199.11 176.058 198.982 176.25 198.854C176.058 198.982 176.57 198.726 176.634 198.662C177.402 198.342 178.234 198.15 179.066 198.022C179.514 197.958 179.898 197.894 180.346 197.894C180.794 197.894 181.242 197.894 181.69 197.894C182.138 197.894 182.522 197.894 182.97 197.958C183.482 198.022 184.314 197.638 184.442 197.062C184.634 195.654 184.954 194.31 185.466 192.966C185.658 192.454 185.85 192.006 186.106 191.558C186.874 190.15 184.954 189.254 183.866 189.638C183.738 189.702 183.61 189.702 183.482 189.766C183.354 189.83 182.97 189.958 183.354 189.83L182.65 190.022C181.562 190.342 180.474 190.598 179.386 190.726C178.874 190.79 178.362 190.854 177.914 190.854C177.594 190.854 177.274 190.854 177.018 190.854H176.314H176.058C176.25 190.854 176.25 190.854 176.058 190.854C175.866 190.854 175.226 190.534 175.61 190.726L175.29 190.534C175.354 190.534 175.61 190.662 175.354 190.534C175.29 190.47 175.034 190.214 175.29 190.47C175.226 190.406 175.162 190.278 175.098 190.214C175.29 190.47 175.098 190.15 175.098 190.086C175.034 189.766 175.098 190.278 175.098 189.958C175.034 189.574 175.098 189.126 175.29 188.742C175.546 188.294 175.802 187.846 176.122 187.398C176.954 186.374 177.914 185.414 179.002 184.646C180.986 183.11 183.482 181.702 185.85 181.446C185.466 181.51 185.85 181.446 185.914 181.446C186.234 181.446 186.554 181.446 186.81 181.51C187.194 181.574 187.514 181.702 187.898 181.83C188.602 182.086 189.242 182.406 189.818 182.854C190.394 183.238 190.906 183.686 191.354 184.198C191.098 183.942 191.546 184.326 191.354 184.198L191.546 184.454L191.674 184.646C192.186 185.286 193.082 185.542 193.85 185.222C194.362 185.03 194.874 184.966 195.45 184.902C195.706 184.902 196.026 184.902 196.282 184.902C196.538 184.902 195.962 184.838 196.41 184.902L196.73 184.966C197.178 185.094 196.602 184.902 196.794 184.966L197.114 185.094C197.178 185.094 197.434 185.286 197.306 185.158C197.178 185.03 197.434 185.286 197.434 185.286C197.562 185.414 197.69 185.542 197.818 185.67C197.69 185.478 197.946 185.798 197.818 185.67L198.01 185.926C198.074 186.054 198.202 186.182 198.266 186.31C198.202 186.182 198.33 186.438 198.266 186.31C198.33 186.374 198.33 186.438 198.394 186.566C198.522 186.822 198.65 187.078 198.714 187.334C198.778 187.526 198.906 188.166 198.842 187.654C198.842 187.718 198.906 187.782 198.906 187.91C199.034 188.742 199.738 189.318 200.57 189.254C200.762 189.254 200.954 189.254 201.146 189.254C201.338 189.254 200.762 189.126 201.082 189.254C201.146 189.254 201.274 189.318 201.338 189.318C201.786 189.446 201.21 189.19 201.53 189.382C201.594 189.446 202.042 189.702 201.85 189.574C201.658 189.446 202.106 189.766 202.17 189.83C202.49 190.086 202.106 189.702 202.298 189.958C202.426 190.086 202.49 190.214 202.618 190.342C202.746 190.47 203.002 190.982 202.81 190.662C203.194 191.43 203.514 192.198 203.706 193.03C203.898 193.926 204.09 194.758 204.154 195.654C204.346 197.766 204.41 199.878 204.282 201.99C204.218 202.95 204.154 203.91 204.09 204.87C204.026 205.446 204.026 205.382 204.026 205.83C204.026 206.278 203.962 206.598 203.898 207.046C203.77 207.942 203.706 208.774 203.514 209.67C203.45 210.438 203.962 211.142 204.73 211.334C205.306 212.102 206.458 211.91 206.586 211.078Z"
			fill="#082F49"
		/>
		<path
			d="M182.398 202.117C182.398 202.117 186.942 206.085 185.022 210.117L182.398 202.117Z"
			fill="white"
		/>
		<path
			d="M181.247 203.138L181.439 203.33L181.631 203.522C181.759 203.65 181.439 203.33 181.567 203.458L181.759 203.65C182.207 204.162 182.655 204.738 183.039 205.378C183.231 205.762 183.487 206.146 183.615 206.53C183.615 206.594 183.743 206.914 183.679 206.658C183.679 206.722 183.743 206.85 183.743 206.914C183.807 207.106 183.871 207.362 183.935 207.554C183.999 207.81 183.999 208.002 183.999 208.258C183.999 208.322 183.999 208.642 183.999 208.514C183.999 208.386 183.999 208.77 183.999 208.77C183.935 209.026 183.935 209.282 183.871 209.474C183.807 209.73 183.935 209.282 183.807 209.602C183.743 209.73 183.679 209.858 183.615 210.05C183.359 210.434 183.487 210.946 183.871 211.202C183.999 211.266 184.191 211.33 184.383 211.33C185.215 211.33 185.919 210.818 186.303 210.114C187.839 206.85 185.983 203.266 183.487 201.026C183.167 200.834 182.847 200.834 182.527 200.898C182.143 200.962 181.759 201.154 181.439 201.474C181.055 201.922 180.671 202.69 181.247 203.138Z"
			fill="#082F49"
		/>
		<path
			d="M198.845 201.54C198.461 203.46 197.501 205.188 196.221 206.66C195.837 207.044 195.389 207.364 194.877 207.62C194.621 207.748 194.365 207.812 194.109 207.748C193.853 207.748 194.109 207.748 193.853 207.748L193.533 207.684C193.597 207.684 193.597 207.684 193.533 207.684C193.213 207.684 193.661 207.748 193.597 207.748C193.533 207.748 193.469 207.684 193.341 207.62C193.021 207.236 193.853 207.94 193.341 207.62C193.213 207.492 193.085 207.364 193.021 207.172C192.957 206.98 192.957 207.108 192.957 207.108C192.893 206.98 192.829 206.916 192.765 206.788C192.317 205.892 192.061 204.932 191.933 203.972C191.741 202.756 191.741 201.476 191.869 200.26C192.061 197.7 192.829 195.204 194.109 192.964C194.749 191.812 195.709 190.916 196.861 190.212C197.053 190.084 197.309 189.956 197.501 189.892C197.821 189.764 198.141 189.7 198.525 189.636C198.333 189.636 198.717 189.572 198.525 189.636H198.781L199.357 189.572C199.677 189.572 199.997 189.572 200.381 189.636C201.021 189.7 201.853 189.444 201.853 188.676C201.853 187.908 200.829 187.46 200.189 187.396C197.053 186.948 193.981 188.164 191.997 190.596C190.205 193.028 189.117 195.908 188.861 198.852C188.541 201.476 188.605 204.42 189.757 206.852C191.037 209.604 194.301 210.756 197.053 209.476C197.181 209.412 197.309 209.348 197.373 209.284C199.741 208.004 201.213 204.932 201.789 202.436C202.237 201.028 199.165 200.132 198.845 201.54Z"
			fill="#082F49"
		/>
		<path
			d="M191.87 183.877C188.67 184.773 185.854 186.693 183.87 189.445C182.014 192.005 180.99 195.077 180.926 198.213C180.862 200.581 181.63 203.013 183.742 204.293C186.174 205.637 189.118 205.573 191.486 204.101C192.062 203.717 191.486 203.269 191.038 203.077C190.334 202.757 189.566 202.757 188.862 203.013C188.542 203.269 188.158 203.461 187.774 203.589C187.582 203.653 187.326 203.717 187.134 203.781C187.006 203.781 186.878 203.781 186.814 203.845C187.006 203.845 186.622 203.845 186.622 203.845C186.302 203.845 186.622 203.845 186.686 203.845L186.43 203.781C186.686 203.845 186.238 203.717 186.302 203.717C186.174 203.653 186.046 203.525 185.918 203.461C184.254 202.117 184.126 199.621 184.318 197.701C184.702 192.901 187.454 188.613 191.614 186.181C192.382 185.733 193.214 185.349 194.11 185.157C194.75 185.029 194.75 184.517 194.238 184.197C193.406 183.813 192.574 183.685 191.87 183.877Z"
			fill="#082F49"
		/>
		<path
			d="M214.841 227.013C213.689 225.029 212.857 222.917 211.897 220.869C210.617 218.053 209.273 215.173 207.865 212.421C207.481 211.525 206.969 210.629 206.329 209.797C205.817 209.221 203.257 211.077 203.641 211.461C204.153 212.165 204.601 212.869 204.921 213.637C205.561 214.917 206.201 216.133 206.777 217.413C208.121 220.229 209.401 223.045 210.745 225.861C211.193 226.757 211.577 227.717 212.089 228.613C212.473 229.253 215.225 227.589 214.841 227.013Z"
			fill="#082F49"
		/>
		<path
			d="M85.6291 226.303C83.8371 226.303 81.8531 226.687 80.7011 228.159C79.6131 229.567 79.5491 231.551 80.6371 233.023C81.7251 234.367 83.6451 234.751 85.1811 234.047C86.9091 233.279 87.7411 231.487 88.3171 229.759L85.5651 229.055C85.8211 231.999 88.1251 234.431 91.0691 234.815C94.5251 235.135 95.1651 231.231 95.1011 228.607C95.0371 225.407 93.6931 222.591 90.8131 220.991C84.4131 217.727 76.6691 220.287 73.4051 226.623C72.8931 227.583 72.5091 228.671 72.3171 229.695C71.2931 235.007 73.8531 240.767 78.7171 243.327C81.9171 244.927 85.6291 245.055 88.9571 243.711C91.9651 242.367 94.5251 240.127 96.2531 237.311C96.6371 236.607 96.5091 235.711 95.8691 235.135C95.3571 234.687 94.3331 234.495 93.8851 235.135C91.3891 238.975 87.1651 242.175 82.3651 241.535C78.1411 240.959 75.3891 237.439 75.0051 233.343C74.6851 229.439 76.7331 225.663 80.1891 223.871C81.9171 222.911 83.8371 222.463 85.7571 222.527C87.6131 222.591 89.8531 223.103 91.1331 224.511C91.8371 225.407 92.2211 226.495 92.2851 227.647C92.4131 228.735 92.2851 229.887 91.9651 230.975C91.5171 231.999 90.4931 231.871 89.6611 231.359C88.8931 230.847 88.4451 229.951 88.3811 229.055C88.2531 227.775 86.1411 226.815 85.6291 228.351C85.3731 229.311 84.9251 230.207 84.2211 230.911C84.0291 231.103 82.9411 231.743 82.6211 231.295C82.4931 231.103 82.9411 230.335 83.1331 230.143C83.9011 229.439 85.1171 229.375 86.0771 229.311C88.0611 229.311 87.3571 226.303 85.6291 226.303Z"
			fill="#7DD3FC"
		/>
		<path
			d="M104.57 227.587C102.458 228.099 101.434 230.339 101.242 232.387C100.986 234.947 102.33 237.635 105.018 238.275C107.322 238.723 109.69 237.891 111.162 236.163C112.058 235.267 112.378 233.923 112.058 232.707C111.674 231.555 110.074 230.147 108.794 230.659C107.77 231.043 107.386 232.323 107.45 233.283C107.514 234.435 108.026 235.587 108.858 236.419C110.586 238.339 113.402 238.723 115.642 237.507C117.818 236.099 119.354 233.923 119.866 231.363C120.186 230.083 119.93 228.803 119.226 227.715C118.586 226.691 117.242 225.475 115.898 225.603C114.426 225.731 114.49 227.907 114.362 228.931C114.234 230.403 114.426 231.875 115.002 233.219C116.09 235.779 118.778 238.083 121.658 237.763C123.194 237.635 121.402 235.139 120.25 235.203C117.178 235.459 116.73 231.875 116.986 229.571C117.05 229.187 117.114 228.867 117.178 228.483L117.306 228.099C117.306 228.099 116.986 228.099 117.05 227.971C117.05 228.035 117.178 228.355 117.178 228.419C117.242 228.867 117.242 229.251 117.114 229.699C116.73 231.235 115.962 232.643 114.938 233.859C114.042 235.011 112.698 235.651 111.226 235.651C110.202 235.587 109.69 235.011 110.01 233.923C110.074 233.667 110.202 233.475 110.33 233.283L110.394 233.219C110.778 232.899 110.458 232.579 109.434 232.387C109.37 232.579 109.306 232.771 109.306 232.963C109.05 233.603 108.666 234.179 108.154 234.627C107.13 235.523 105.786 235.971 104.442 235.907C104.314 235.843 104.186 235.843 104.058 235.843C103.866 235.843 103.93 235.779 103.994 235.907C103.866 235.715 103.802 235.459 103.738 235.203C103.61 234.499 103.674 233.731 103.866 233.027C104.186 231.683 104.954 230.403 106.362 230.083C107.066 229.891 106.554 228.803 106.298 228.483C106.042 227.843 105.338 227.523 104.57 227.587Z"
			fill="#7DD3FC"
		/>
		<path
			d="M82.5624 99.585C82.5624 99.585 68.0344 91.969 68.9304 91.009C69.8264 90.049 118.53 72.193 119.17 76.673C119.81 81.153 111.234 107.905 108.674 108.033C106.114 108.161 99.0104 105.665 99.0104 105.665C99.0104 105.665 88.0024 119.873 86.7224 119.489C85.4424 119.105 82.5624 99.585 82.5624 99.585Z"
			fill="white"
		/>
		<path
			d="M82.6263 98.4981C79.4903 96.8341 76.3543 95.1061 73.3463 93.3141C72.4503 92.7381 71.4903 92.1621 70.5943 91.5861C70.3383 91.4581 70.5943 91.5861 70.6583 91.6501L70.4023 91.4581L69.9543 91.1381C69.8903 91.0741 69.7623 90.9461 69.6343 90.8821C69.3783 90.7541 69.9543 91.2021 69.7623 91.0101C69.5703 90.8181 69.5703 90.6901 69.8903 91.1381C70.0823 91.5221 70.0823 91.9061 69.9543 92.2901C69.9543 92.2901 70.0183 92.2901 70.0183 92.2261C70.0183 92.1621 69.7623 92.3541 69.9543 92.2901C70.1463 92.2261 70.5303 92.0341 70.8503 91.9061C77.8263 88.8981 85.1223 86.5301 92.3543 84.0981C96.8983 82.5621 101.506 81.1541 106.178 79.8101C109.57 78.7861 113.09 77.9541 116.674 77.5061C116.738 77.5061 116.866 77.5061 116.93 77.5061H117.314C117.57 77.5061 117.826 77.5061 118.082 77.5061C118.338 77.5061 118.466 77.5701 118.658 77.5701C118.85 77.5701 118.338 77.5061 118.594 77.5701C118.658 77.5701 118.786 77.6341 118.85 77.6341C118.53 77.5701 118.53 77.5061 118.722 77.5701C118.594 77.5061 118.21 77.1861 118.274 77.1861C118.082 76.9301 118.018 76.6741 117.89 76.4821C117.762 76.2901 117.89 76.4181 117.89 76.6101C117.954 76.1621 117.89 76.6101 117.89 76.7381C117.89 76.8661 117.89 76.9941 117.89 77.1221C117.89 77.5061 117.826 77.8261 117.762 78.2101C117.186 82.6901 115.778 87.1701 114.37 91.4581C112.962 95.9381 111.49 100.482 109.314 104.642C109.186 104.962 108.994 105.282 108.802 105.602C108.738 105.73 108.61 105.858 108.546 106.05C108.482 106.242 108.226 106.498 108.418 106.242C108.29 106.434 108.098 106.562 107.97 106.754C107.906 106.818 107.842 106.818 107.778 106.882C107.906 106.754 108.034 106.754 107.842 106.818C107.65 106.882 108.226 106.882 107.906 106.818C106.754 106.69 105.602 106.498 104.45 106.242C103.106 105.922 101.826 105.538 100.546 105.09C99.9063 104.898 99.3303 104.706 98.6903 104.514C98.4983 104.45 98.0503 104.386 97.8583 104.578C94.5303 108.866 91.2023 113.282 87.3623 117.122C87.0423 117.506 86.6583 117.826 86.2103 118.146L86.0183 118.274L85.8903 118.338C86.4023 118.338 86.8503 118.594 87.1703 118.978C87.0423 118.85 87.4903 119.426 87.2983 119.17C87.1063 118.914 87.4263 119.618 87.3623 119.298C87.2983 119.106 87.2343 118.914 87.1703 118.722C87.1063 118.53 87.1063 118.466 87.0423 118.338C86.9783 118.21 87.1063 118.594 87.0423 118.21C86.9783 117.826 86.8503 117.634 86.7863 117.314C85.9543 114.05 85.3783 110.658 84.8023 107.33C84.4183 104.962 83.9703 102.594 83.6503 100.162C83.4583 99.3941 82.9463 98.7541 82.1783 98.4341C81.7943 98.2421 81.4103 98.4341 81.2183 98.7541C81.1543 98.9461 81.1543 99.1381 81.1543 99.2661C81.9863 104.898 82.8823 110.658 84.2263 116.226C84.6743 117.89 85.8263 122.434 88.3223 120.45C89.3463 119.618 90.2423 118.658 91.0743 117.698C92.2903 116.354 93.5063 114.882 94.6583 113.474C96.4503 111.362 98.1783 109.186 99.8423 106.946L99.0103 107.01C101.058 107.714 103.17 108.354 105.346 108.866C106.882 109.25 109.122 110.082 110.338 108.61C111.362 107.138 112.194 105.602 112.77 103.938C113.73 101.634 114.626 99.2661 115.458 96.8981C117.25 91.9061 118.658 86.7861 119.81 81.6021C120.066 80.1941 120.514 78.4661 120.258 76.9941C119.938 75.6501 118.722 74.6261 117.314 74.5621C116.034 74.4981 114.754 74.5621 113.538 74.8181C111.746 75.0741 109.954 75.5221 108.162 75.9701C103.49 77.1221 98.8823 78.5301 94.3383 80.0021C86.1463 82.6261 78.0183 85.3781 70.0183 88.6421C69.2503 88.8981 68.4823 89.2181 67.8423 89.6661C66.4983 90.7541 68.9303 92.7381 69.7623 93.3141C73.4103 95.9381 77.4423 98.0501 81.4103 100.162L82.3703 100.674C82.8823 100.93 83.5863 100.994 83.7143 100.29C83.7783 99.5221 83.3303 98.8181 82.6263 98.4981Z"
			fill="#7DD3FC"
		/>
		<path
			d="M110.719 84.1641C110.719 84.1641 88.8947 101.316 88.3187 102.468C87.7428 103.62 86.7188 119.492 86.7188 119.492"
			fill="white"
		/>
		<path
			d="M109.632 84.6127C104.64 88.5167 99.6485 92.4847 94.7205 96.5167C92.2885 98.5007 89.7925 100.421 87.4885 102.597C86.9765 103.045 86.6565 103.685 86.6565 104.389C86.4005 106.117 86.2725 107.909 86.0805 109.637C85.7605 113.221 85.5685 116.805 85.3125 120.389C85.3125 120.517 86.7205 119.813 86.7845 119.749C87.1045 119.557 88.0005 119.173 88.0645 118.725C88.2565 115.717 88.4485 112.773 88.7045 109.829C88.8325 107.845 89.0245 105.925 89.2165 104.005C89.2805 103.429 89.3445 102.789 89.4725 102.213C89.4725 102.085 89.5365 101.957 89.6005 101.829C89.6645 101.637 89.5365 101.893 89.6645 101.765C89.8565 101.573 89.9205 101.509 89.9845 101.445L90.2405 101.253L90.3685 101.125C90.8165 100.677 91.3285 100.293 91.8405 99.9087C93.1845 98.7567 94.5925 97.6047 95.9365 96.5167C99.2005 93.8927 102.464 91.2687 105.728 88.6447C107.712 87.0447 109.696 85.5087 111.68 83.9087C112.128 83.5887 112 83.4607 111.488 83.6527C110.784 83.9727 110.144 84.3567 109.568 84.8047L109.632 84.6127Z"
			fill="#7DD3FC"
		/>
		<path
			d="M105.922 105.414L90.4981 101.446L88.2581 100.87C87.4901 100.678 86.9141 101.574 86.9141 102.214C86.9781 103.046 87.5541 103.75 88.3861 103.942L103.81 107.91L106.05 108.486C106.818 108.678 107.394 107.782 107.394 107.142C107.33 106.31 106.754 105.606 105.922 105.414Z"
			fill="#7DD3FC"
		/>
		<path
			d="M109.827 82.879L100.739 87.551L86.2749 94.975L82.9469 96.639C81.8589 97.215 83.5869 99.839 84.7389 99.263L93.8269 94.591L108.291 87.167L111.619 85.439C112.643 84.927 110.979 82.303 109.827 82.879Z"
			fill="#7DD3FC"
		/>
		<path
			d="M74.2272 41.3416L55.2656 47.6016L59.8001 61.3366L78.7617 55.0766L74.2272 41.3416Z"
			fill="white"
		/>
		<path
			d="M78.8496 54.1463L62.2096 59.6503L59.8416 60.4183L61.2496 60.6103L57.2816 48.5783L56.7056 46.8503L55.2336 48.4503L71.8736 42.9463L74.2416 42.1783L72.8336 41.9863L76.8016 54.0183L77.3776 55.7463C77.6976 56.7063 80.6416 55.4263 80.2576 54.3383L76.2896 42.3063L75.7136 40.5783C75.5856 40.0663 74.6256 40.3223 74.3056 40.3863L57.6656 45.8903L55.2976 46.6583C54.7216 46.8503 53.5696 47.4903 53.8256 48.2583L57.7936 60.2903L58.3696 62.0183C58.4976 62.5303 59.4576 62.2743 59.7776 62.2103L76.4176 56.7063L78.7856 55.9383C79.2976 55.7463 80.3216 55.2343 80.2576 54.5303C80.1936 53.8263 79.2336 54.0183 78.8496 54.1463Z"
			fill="#7DD3FC"
		/>
		<path
			d="M55.875 47.8754C59.203 48.1954 62.083 50.3714 65.347 50.8834C65.603 50.9474 65.795 50.9474 66.051 50.8834C66.243 50.7554 66.435 50.6274 66.563 50.4354L73.347 41.8594"
			fill="white"
		/>
		<path
			d="M54.9147 48.9608C56.7067 49.2169 58.4987 49.7928 60.1627 50.5609C61.7627 51.2008 63.8747 52.2888 65.6667 51.9049C66.8827 51.6488 67.5867 50.7529 68.2907 49.8569L70.3387 47.2969L74.4987 42.0489C74.8827 41.6009 75.1387 40.9608 74.3707 40.7048C73.6027 40.6408 72.8347 40.8969 72.3227 41.5369L68.7387 46.0809L66.8827 48.4489L65.9867 49.5369C65.7947 49.7289 65.6667 49.9209 65.4747 50.1129L65.3467 50.3048C66.4347 50.0488 66.6907 49.8569 66.1787 49.7929C65.4747 49.5369 64.6427 49.4089 63.8747 49.1529C63.1067 48.8969 62.3387 48.5128 61.5707 48.1928C60.0347 47.4888 58.4347 47.0408 56.8347 46.7848C56.0667 46.7208 55.2987 47.0409 54.7867 47.6809C54.5307 48.0009 54.1467 48.9608 54.9147 48.9608Z"
			fill="#7DD3FC"
		/>
		<path
			d="M59.3906 60.4197C59.5826 57.7957 60.8626 52.7397 61.5666 50.1797L59.3906 60.4197Z"
			fill="white"
		/>
		<path
			d="M60.9915 60.5461C61.1835 58.8181 61.4395 57.0901 61.8875 55.3621C62.2715 53.6341 62.7195 51.9701 63.1675 50.2421C63.3595 49.4741 60.2235 48.9621 59.9675 49.9221C59.5195 51.5861 59.0715 53.3141 58.6875 55.0421C58.2395 56.7701 57.9835 58.4341 57.7915 60.2261C57.7275 60.8021 58.9435 60.9941 59.3275 60.9941C59.7115 60.9941 60.9275 61.1221 60.9915 60.5461Z"
			fill="#7DD3FC"
		/>
		<path
			d="M70.0156 47.75C72.3836 49.926 74.6876 52.166 76.9276 54.47L70.0156 47.75Z"
			fill="white"
		/>
		<path
			d="M69.3807 48.6389C71.7487 50.8149 74.0527 53.0549 76.2927 55.3589C76.6767 55.8069 77.5727 56.2549 78.0207 55.6149C78.3407 54.9109 78.2127 54.0789 77.6367 53.5669C75.3327 51.3269 73.0287 49.0869 70.7247 46.8469C70.2767 46.4629 69.4447 45.9509 68.9967 46.6549C68.6127 47.2949 68.8047 48.1269 69.3807 48.6389Z"
			fill="#7DD3FC"
		/>
		<path
			d="M190.927 38.7064L164.367 38.8594L164.478 58.0594L191.038 57.9064L190.927 38.7064Z"
			fill="white"
		/>
		<path
			d="M190.34 56.7703L167.108 56.8983H163.78L165.956 58.5623L165.892 41.7303V39.3623L165.06 40.0023L188.292 39.8743H191.62L189.444 38.2103L189.508 55.0423V57.4743C189.508 58.7543 192.452 59.8423 192.452 58.4983L192.388 41.6663V39.2343C192.388 38.2103 191.108 37.5703 190.212 37.5703L166.98 37.6983H163.652C163.268 37.6983 162.82 37.8903 162.82 38.3383L162.884 55.1703V57.6023C162.884 58.6263 164.164 59.2663 165.06 59.2663L188.292 59.1383H191.62C192.004 59.1383 192.388 58.8183 192.388 58.4343C192.388 58.2423 192.324 58.1143 192.26 57.9223C191.876 57.2183 191.108 56.7703 190.34 56.7703Z"
			fill="#7DD3FC"
		/>
		<path
			d="M164.93 39.5511C169.026 41.2791 171.778 45.2471 175.682 47.2311C175.938 47.3591 176.258 47.4871 176.578 47.4871C176.898 47.4231 177.218 47.2951 177.41 47.1031L189.506 39.0391"
			fill="white"
		/>
		<path
			d="M164.351 40.0058C166.463 40.9018 168.191 42.5658 169.919 44.0378C171.647 45.5098 173.695 47.3018 175.935 48.0058C176.575 48.2618 177.343 48.3258 178.047 48.1338C178.623 47.8778 179.199 47.5578 179.647 47.1738L183.359 44.6778L190.975 39.6218C191.487 39.3018 190.335 38.6618 190.143 38.5338C189.631 38.2778 188.671 37.9578 188.159 38.3418L181.311 42.8858L177.855 45.1898L176.127 46.3418L175.807 46.5338C175.295 46.7258 175.551 46.8538 176.511 46.8538C176.319 46.7258 176.191 46.6618 175.999 46.5978C174.207 45.4458 172.543 44.1658 171.007 42.7578C169.343 41.2858 167.487 40.0698 165.503 39.1098C165.055 38.9178 163.903 38.4698 163.519 38.9178C163.135 39.3658 164.095 39.8778 164.351 40.0058Z"
			fill="#7DD3FC"
		/>
		<path
			d="M164.289 56.7039C165.633 53.4399 169.281 47.5519 171.201 44.6719L164.289 56.7039Z"
			fill="white"
		/>
		<path
			d="M165.695 56.197C166.591 54.085 167.679 52.0369 168.959 50.0529C170.111 48.0689 171.391 46.085 172.671 44.1649C172.799 43.9089 171.583 44.3569 171.519 44.3569C171.135 44.4849 170.751 44.6769 170.367 44.8689C170.111 44.9329 169.919 45.125 169.727 45.253C168.447 47.173 167.231 49.157 166.015 51.141C164.799 53.125 163.711 55.173 162.815 57.285C162.687 57.541 163.839 57.1569 163.967 57.0929C164.351 56.9649 164.735 56.773 165.119 56.581C165.311 56.517 165.695 56.389 165.695 56.197Z"
			fill="#7DD3FC"
		/>
		<path
			d="M182.914 45.125C184.962 48.837 186.946 52.613 188.93 56.453L182.914 45.125Z"
			fill="white"
		/>
		<path
			d="M181.379 45.0574C183.427 48.8334 185.411 52.5454 187.395 56.3854C187.651 56.8974 188.867 56.8974 189.315 56.8974C189.571 56.8974 190.723 56.8974 190.467 56.4494C188.547 52.6734 186.499 48.8974 184.451 45.1214C184.195 44.6094 182.979 44.6094 182.531 44.6094C182.339 44.6094 181.123 44.6094 181.379 45.0574Z"
			fill="#7DD3FC"
		/>
		<path
			d="M256.124 79.8188L248.922 97.6172L273.543 107.58L280.745 89.7814L256.124 79.8188Z"
			fill="white"
		/>
		<path
			d="M275.006 107.141L256.51 99.6533L252.094 97.8613L250.814 97.3493C250.686 97.3493 250.622 97.2853 250.494 97.2213C250.366 97.0933 250.494 97.2853 250.494 97.2213C250.558 96.9013 250.686 96.6453 250.814 96.3893L251.582 94.4693L253.886 88.8373L257.726 79.4293L254.654 80.3893L273.15 87.8773L277.566 89.6693L278.846 90.1813C278.974 90.1813 279.038 90.2453 279.166 90.3093C279.166 90.2453 279.294 90.4373 279.166 90.3093C279.102 90.6293 278.974 90.8853 278.846 91.1413L278.078 93.0613L275.774 98.6933L271.934 108.101C271.87 108.229 273.47 107.973 273.534 107.909C273.918 107.781 274.814 107.589 275.006 107.141L281.342 91.5893L282.238 89.3493L282.174 89.2853L260.67 80.5813L257.598 79.3653C257.15 79.1733 256.254 79.5573 255.87 79.6853C255.486 79.8133 254.782 79.9413 254.59 80.3253L248.254 95.8773L247.422 98.1173L247.486 98.1813L268.99 106.885L272.062 108.101C272.574 108.293 273.534 107.909 273.982 107.717C274.11 107.717 275.262 107.205 275.006 107.141Z"
			fill="#7DD3FC"
		/>
		<path
			d="M256.453 80.7031C259.589 83.8391 260.613 88.5111 263.493 91.9031C263.685 92.1591 263.941 92.3511 264.197 92.4791C264.517 92.5431 264.837 92.5431 265.157 92.4791L279.429 89.6631"
			fill="white"
		/>
		<path
			d="M256.77 81.8553C258.242 83.3913 259.138 85.4393 260.098 87.2953C261.186 89.3433 262.338 91.7753 264.13 93.3113C265.09 94.1433 266.242 93.6953 267.394 93.5033L271.554 92.6713L280.258 90.9433C280.642 90.8793 279.49 87.9993 278.658 88.1913L270.594 89.7913L266.562 90.6233L264.578 91.0073C263.874 91.1353 263.618 91.1353 263.17 90.6233C261.89 89.0233 261.122 87.1673 260.226 85.3753C259.202 83.2633 257.858 81.3433 256.258 79.5513C255.874 79.1033 255.618 79.3593 255.682 79.8713C255.81 80.6393 256.194 81.2793 256.77 81.8553Z"
			fill="#7DD3FC"
		/>
		<path
			d="M249.281 96.387C251.777 93.891 257.345 89.859 260.289 87.875L249.281 96.387Z"
			fill="white"
		/>
		<path
			d="M250.689 96.6445C250.881 96.4525 250.625 96.7085 250.817 96.5165L251.073 96.2605C251.265 96.0685 251.457 95.8765 251.649 95.7485C252.033 95.3645 252.481 95.0445 252.929 94.6605C253.889 93.8925 254.849 93.0605 255.873 92.3565C257.729 90.9485 259.585 89.6685 261.505 88.3885C261.825 88.1965 261.953 87.7485 261.761 87.3645C261.633 87.1725 261.505 87.1085 261.313 87.0445C260.545 86.7885 259.713 86.9165 259.073 87.3645C257.153 88.6445 255.233 90.0525 253.313 91.4605C251.393 92.8685 249.537 94.4045 247.809 96.0685C247.297 96.6445 248.065 97.1565 248.577 97.2845C249.345 97.4125 250.177 97.1565 250.689 96.6445Z"
			fill="#7DD3FC"
		/>
		<path
			d="M270.914 92.7422C271.362 96.9662 271.81 101.19 272.13 105.478L270.914 92.7422Z"
			fill="white"
		/>
		<path
			d="M269.698 91.8417C270.146 96.0657 270.594 100.29 270.914 104.578C270.978 105.218 271.746 105.794 272.194 106.114C272.322 106.178 273.474 106.882 273.41 106.37C273.026 102.082 272.642 97.8577 272.194 93.6337C272.13 92.9937 271.362 92.4177 270.914 92.0977C270.786 92.0337 269.634 91.3297 269.698 91.8417Z"
			fill="#7DD3FC"
		/>
		<path
			d="M96.1303 50.37C106.754 48.898 117.826 53.186 124.994 61.058C126.786 63.042 128.386 65.218 129.602 67.586C131.01 70.274 132.034 73.09 133.634 75.65C135.17 78.274 137.41 80.322 140.162 81.666C142.914 82.882 145.986 83.394 148.994 83.138C156.29 82.498 162.242 77.89 167.426 73.09C168.706 71.938 166.018 70.146 164.866 71.234C160.386 75.33 155.266 79.49 149.058 80.45C146.37 80.898 143.618 80.578 141.122 79.426C138.626 78.274 136.898 76.098 135.618 73.73C134.21 71.17 133.186 68.482 131.778 65.922C130.434 63.554 128.77 61.314 126.914 59.33C123.074 55.234 118.338 52.098 113.154 50.05C107.33 47.746 100.994 46.978 94.7864 47.81C94.2104 47.938 93.8264 48.45 93.9544 49.026C93.9544 49.154 94.0184 49.282 94.0824 49.346C94.4664 50.178 95.2983 50.562 96.1303 50.37Z"
			fill="#082F49"
		/>
		<path
			d="M203.519 51.1351C205.567 49.0871 208.447 48.2551 211.199 47.7431C214.335 47.1031 217.535 46.5271 220.799 46.1431C226.815 45.5031 233.471 45.4391 238.911 48.3191C243.391 50.6871 247.231 54.8471 248.447 59.8391C248.767 61.0551 248.895 62.3351 248.831 63.6151C248.831 64.2551 248.767 64.8311 248.639 65.4071C248.575 65.7271 248.511 66.0471 248.383 66.3671C248.255 66.6231 248.127 66.8151 247.935 67.0711C247.423 68.1591 247.807 67.0711 247.807 67.1351C247.935 67.1351 248.063 67.1991 248.191 67.1991C248.319 67.1991 248.383 67.3911 248.191 67.1991C247.871 66.8791 247.679 66.4311 247.679 65.9831C247.743 64.8951 248.895 64.1911 249.855 63.9351C252.223 63.2951 254.975 64.2551 256.895 65.7271C259.199 67.3911 260.735 69.8231 261.375 72.5751C261.631 73.2791 262.271 73.7911 262.975 73.8551C263.359 73.9191 264.575 73.9191 264.383 73.2151C263.039 66.8791 256.959 62.0151 250.495 61.7591C248.191 61.6951 243.775 62.8471 244.671 66.0471C245.439 68.7991 250.367 70.7831 251.327 67.1991C253.055 60.9271 249.599 54.5271 245.055 50.4311C239.551 45.4391 231.999 43.7111 224.703 43.7751C220.287 43.9031 215.871 44.4151 211.519 45.3111C207.679 46.0151 203.519 46.7831 200.639 49.5991C199.871 50.5591 202.687 51.9671 203.519 51.1351Z"
			fill="#082F49"
		/>
		<path
			d="M96.8998 174.402C90.0518 174.018 82.9478 172.738 77.6358 168.066C73.2198 164.098 71.0438 157.57 73.7318 152.002C74.3718 150.658 75.2678 149.506 76.4198 148.61C77.1238 148.098 78.5958 147.266 79.4918 147.842C80.3878 148.418 80.1318 149.762 79.8118 150.53C79.2998 151.618 78.1478 152.258 76.9958 152.066C73.9238 151.618 72.7078 147.97 72.1318 145.41C71.4918 142.53 71.4278 139.586 71.8118 136.642C72.7718 129.922 76.3558 123.842 81.7958 119.81C82.2438 119.426 82.3078 118.786 81.9238 118.338C81.8598 118.274 81.7958 118.21 81.6678 118.146C81.0278 117.634 80.1318 117.57 79.4278 118.018C73.6678 122.242 69.8278 128.642 68.7398 135.682C68.1638 139.202 68.2918 142.786 69.1878 146.178C70.1478 149.954 72.3878 153.666 76.5478 154.434C78.4678 154.882 80.5158 154.306 81.9238 152.898C82.9478 151.81 83.3958 150.21 83.0758 148.738C82.6278 146.946 81.0918 145.602 79.2358 145.346C77.3158 145.09 75.4598 145.666 73.9238 146.818C71.0438 148.994 69.6358 152.578 69.3798 156.098C69.1878 159.746 70.2758 163.33 72.4518 166.274C78.0198 174.082 88.0038 176.322 97.0278 176.834C97.6678 176.898 98.5638 176.514 98.4998 175.746C98.4358 174.978 97.6038 174.402 96.8998 174.402Z"
			fill="#082F49"
		/>
	</svg>
);

export const AstraThemeLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 21 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M10.5 20C16.0229 20 20.5 15.5228 20.5 10C20.5 4.47715 16.0229 0 10.5 0C4.97716 0 0.5 4.47715 0.5 10C0.5 15.5228 4.97716 20 10.5 20ZM10.379 4.43553C9.53231 6.22172 8.68559 8.00991 7.83888 9.79805C6.99206 11.5865 6.14519 13.3749 5.29838 15.1613H7.47578C8.1613 13.7783 8.84678 12.3932 9.53225 11.0081C10.2177 9.62302 10.9032 8.23794 11.5887 6.85487L10.379 4.43553ZM11.5887 11.0483C11.9374 10.3225 12.2862 9.59679 12.637 8.87103C13.149 9.91933 13.6591 10.9677 14.1691 12.016C14.6793 13.0644 15.1894 14.1129 15.7015 15.1613H13.3628C13.2298 14.8509 13.0946 14.5424 12.9596 14.2339C12.8245 13.9255 12.6894 13.617 12.5563 13.3065H10.5402H10.4999L10.5402 13.2258C10.8911 12.5 11.2399 11.7742 11.5887 11.0483Z"
			fill="url(#paint0_linear_9131_38968)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_9131_38968"
				x1="20.5"
				y1="-5.96046e-07"
				x2="0.499998"
				y2="20"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#B147E1" />
				<stop offset="1" stopColor="#5236DD" />
			</linearGradient>
		</defs>
	</svg>
);

export const StartersTemplatesLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 21 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_9150_48086)">
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M16.4016 1.63934H4.59835C3.24029 1.63934 2.13934 2.74029 2.13934 4.09835V15.9016C2.13934 17.2597 3.24029 18.3606 4.59835 18.3606H16.4016C17.7597 18.3606 18.8606 17.2597 18.8606 15.9016V4.09835C18.8606 2.74029 17.7597 1.63934 16.4016 1.63934ZM4.59835 0C2.3349 0 0.5 1.8349 0.5 4.09835V15.9016C0.5 18.1651 2.3349 20 4.59835 20H16.4016C18.6651 20 20.5 18.1651 20.5 15.9016V4.09835C20.5 1.8349 18.6651 0 16.4016 0H4.59835Z"
				fill="url(#paint0_linear_9150_48086)"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M12.5872 6.29437C12.5488 6.26 12.5082 6.2271 12.4655 6.19567C12.0954 5.92315 11.593 5.78687 10.9584 5.78687C10.5273 5.78687 10.1632 5.8479 9.86628 5.96992C9.56934 6.08788 9.34155 6.25262 9.18293 6.46415C9.01251 6.69733 8.7223 6.88631 8.47134 6.74335C8.27436 6.63112 8.09247 6.49269 7.93091 6.33115C7.62957 6.02981 7.40864 5.65771 7.28832 5.2489C7.2353 5.06879 7.28222 4.87194 7.42403 4.7489C7.74116 4.47371 8.11186 4.24208 8.53616 4.05404C9.25207 3.73677 10.0656 3.57812 10.9768 3.57812C11.9042 3.57812 12.7137 3.73677 13.4052 4.05404C14.1007 4.37133 14.6417 4.81267 15.0282 5.37808C15.1695 5.5849 15.2858 5.80371 15.3771 6.03448C15.6478 6.71883 15.023 7.34275 14.2871 7.34275C13.7126 7.34275 13.2527 6.91308 12.8182 6.50717C12.7406 6.4346 12.6637 6.36281 12.5872 6.29437ZM8.80462 7.648C8.91368 7.60535 9.03045 7.6699 9.09141 7.76985C9.19716 7.93663 9.34155 8.08104 9.52459 8.20306C9.70766 8.32102 9.91918 8.42475 10.1592 8.51425C10.3992 8.59967 10.6554 8.67287 10.9279 8.7339L12.0506 9.00235C12.5957 9.1244 13.096 9.2871 13.5516 9.49048C14.0072 9.69387 14.4017 9.94402 14.7353 10.241C15.0688 10.5379 15.3271 10.8877 15.5102 11.2904C15.6973 11.6931 15.7929 12.1548 15.7969 12.6755C15.7929 13.4402 15.5976 14.1032 15.2112 14.6646C14.8288 15.2218 14.2756 15.655 13.5516 15.9642C12.8316 16.2692 11.9632 16.4218 10.9463 16.4218C9.93747 16.4218 9.05887 16.2672 8.31041 15.9581C7.56603 15.6489 6.98434 15.1913 6.56539 14.5852C6.37201 14.3009 6.22151 13.9852 6.11384 13.6381C5.89668 12.938 6.51564 12.3216 7.24859 12.3216H7.34364C7.97716 12.3216 8.44774 12.8651 8.82903 13.371C9.04461 13.6476 9.33139 13.8571 9.68934 13.9995C10.0514 14.1378 10.4602 14.2069 10.9157 14.2069C11.3632 14.2069 11.7517 14.1419 12.0811 14.0117C12.4147 13.8815 12.673 13.7005 12.856 13.4687C13.0391 13.2368 13.1306 12.9704 13.1306 12.6694C13.1306 12.3887 13.0472 12.1528 12.8804 11.9616C12.7177 11.7704 12.4777 11.6077 12.1604 11.4735C11.8472 11.3392 11.4628 11.2172 11.0073 11.1074L9.64664 10.7657C8.75409 10.5486 8.02066 10.2278 7.44634 9.80344C7.29109 9.68871 7.2338 9.48675 7.28832 9.30156C7.40859 8.89279 7.62951 8.52071 7.9308 8.21937C8.18005 7.97008 8.47776 7.77581 8.80462 7.648ZM7.18782 5.92431L7.06824 5.51804C7.06309 5.5004 7.05236 5.4849 7.03768 5.47387C7.02297 5.46285 7.00509 5.4569 6.98672 5.4569C6.96834 5.4569 6.95047 5.46285 6.93576 5.47387C6.92105 5.4849 6.91032 5.5004 6.90518 5.51804L6.78578 5.92431C6.70555 6.19681 6.55824 6.44485 6.35734 6.64571C6.15647 6.84656 5.90841 6.99381 5.63586 7.07402L5.22957 7.19358C5.14822 7.21771 5.14822 7.33285 5.22957 7.35665L5.63586 7.47621C5.90836 7.55642 6.15639 7.70371 6.35726 7.90456C6.55811 8.1054 6.70539 8.35342 6.78561 8.62592L6.90518 9.03235C6.92914 9.11354 7.0443 9.11354 7.06824 9.03235L7.18782 8.62608C7.26801 8.35356 7.41528 8.1055 7.61616 7.90462C7.81701 7.70375 8.06505 7.55644 8.33757 7.47621L8.74403 7.35665C8.82522 7.33269 8.82522 7.21754 8.74403 7.19375L8.33774 7.07419C8.06518 6.99398 7.81712 6.84669 7.61622 6.64579C7.41532 6.44492 7.26803 6.19685 7.18782 5.92431ZM5.73847 8.32398L5.77434 8.44585C5.79841 8.52763 5.84259 8.60204 5.90286 8.66231C5.96311 8.72256 6.03755 8.76675 6.1193 8.79081L6.2412 8.82669C6.26555 8.83383 6.26555 8.86837 6.2412 8.87556L6.11926 8.91144C6.03751 8.9355 5.96309 8.97969 5.90282 9.03996C5.84257 9.10023 5.79839 9.17465 5.77434 9.2564L5.73847 9.37827C5.73128 9.40263 5.69674 9.40263 5.68955 9.37827L5.65368 9.25633C5.62961 9.1746 5.58543 9.10019 5.52516 9.03994C5.46491 8.97967 5.39049 8.9355 5.30874 8.91144L5.18686 8.87556C5.16245 8.86842 5.16245 8.83388 5.18686 8.82665L5.30874 8.79077C5.39051 8.76671 5.46493 8.72254 5.5252 8.66227C5.58547 8.60202 5.62966 8.5276 5.65372 8.44585L5.68955 8.32398C5.69109 8.31869 5.6943 8.31404 5.69872 8.31073C5.70314 8.30742 5.70849 8.30562 5.71401 8.30562C5.71951 8.30562 5.72489 8.30742 5.72928 8.31073C5.7337 8.31404 5.73693 8.31869 5.73847 8.32398ZM5.50482 5.00817L5.44903 4.81858C5.44661 4.81035 5.44161 4.80313 5.43476 4.79798C5.42789 4.79283 5.41955 4.79004 5.41097 4.79004C5.40241 4.79004 5.39405 4.79283 5.3872 4.79798C5.38034 4.80313 5.37532 4.81035 5.37293 4.81858L5.3172 5.00817C5.27976 5.13535 5.21103 5.25108 5.11728 5.34483C5.02353 5.43856 4.90776 5.50727 4.78057 5.54471L4.59097 5.6005C4.55301 5.61175 4.55301 5.6655 4.59097 5.6766L4.78057 5.7324C4.90774 5.76983 5.02349 5.83856 5.11722 5.93229C5.21097 6.02602 5.2797 6.14177 5.31714 6.26892L5.37293 6.4586C5.38411 6.49648 5.43784 6.49648 5.44903 6.4586L5.50482 6.269C5.54224 6.14183 5.61097 6.02606 5.70472 5.93231C5.79845 5.83858 5.9142 5.76983 6.04136 5.7324L6.23105 5.6766C6.26895 5.66542 6.26895 5.61169 6.23105 5.60058L6.04145 5.54477C5.91426 5.50735 5.79849 5.43862 5.70474 5.34487C5.61099 5.25112 5.54226 5.13535 5.50482 5.00817Z"
				fill="url(#paint1_linear_9150_48086)"
			/>
		</g>
		<defs>
			<linearGradient
				id="paint0_linear_9150_48086"
				x1="1.80248"
				y1="19.7653"
				x2="8.31504"
				y2="-2.89315"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#C639FF" />
				<stop offset="1" stopColor="#3662FF" />
			</linearGradient>
			<linearGradient
				id="paint1_linear_9150_48086"
				x1="5.29414"
				y1="16.271"
				x2="9.96601"
				y2="2.05327"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#C639FF" />
				<stop offset="1" stopColor="#3662FF" />
			</linearGradient>
			<clipPath id="clip0_9150_48086">
				<rect
					width="20"
					height="20"
					fill="white"
					transform="translate(0.5)"
				/>
			</clipPath>
		</defs>
	</svg>
);

export const PrestoPlayerLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 21 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M13.6094 9.93105L19.3338 6.60156V13.2606L13.6094 9.93105Z"
			fill="#3A30E5"
		/>
		<path
			d="M13.6094 3.32812L19.3338 6.65763L13.6094 9.98711V3.32812Z"
			fill="#3058E5"
		/>
		<path
			d="M13.615 3.32812V9.9287L7.89062 6.59922L13.615 3.32812Z"
			fill="#4067EE"
		/>
		<path
			d="M13.6697 3.32948L7.94531 6.65899V0L13.6697 3.32948Z"
			fill="#476EF9"
		/>
		<path
			d="M7.88845 6.66016V13.3191L2.16406 9.98964L7.88845 6.66016Z"
			fill="#624AF6"
		/>
		<path
			d="M7.88845 0V6.65899L2.16406 3.32948L7.88845 0Z"
			fill="#4067EE"
		/>
		<path
			d="M7.88845 13.2578V19.9168L2.16406 16.5873L7.88845 13.2578Z"
			fill="#7C3AED"
		/>
		<path
			d="M13.6094 9.92969L19.3338 13.2592L13.6094 16.5887V9.92969Z"
			fill="#4F46E5"
		/>
		<path
			d="M2.16406 9.92969L7.88845 13.2592L2.16406 16.5887V9.92969Z"
			fill="#814AF7"
		/>
		<path
			d="M2.16406 3.32812L7.88845 6.65763L2.16406 9.98711V3.32812Z"
			fill="#3058E5"
		/>
		<path
			d="M13.615 9.92969V16.5887L7.89062 13.2592L13.615 9.92969Z"
			fill="#624AF6"
		/>
		<path
			d="M13.6094 9.93105L19.3338 6.60156V13.2606L13.6094 9.93105Z"
			fill="#3A30E5"
		/>
		<path
			d="M13.6094 3.32812L19.3338 6.65763L13.6094 9.98711V3.32812Z"
			fill="#3058E5"
		/>
		<path
			d="M13.615 3.32812V9.9287L7.89062 6.59922L13.615 3.32812Z"
			fill="#4067EE"
		/>
		<path
			d="M13.6697 3.32948L7.94531 6.65899V0L13.6697 3.32948Z"
			fill="#476EF9"
		/>
		<path
			d="M7.88845 6.66016V13.3191L2.16406 9.98964L7.88845 6.66016Z"
			fill="#624AF6"
		/>
		<path
			d="M7.88845 0V6.65899L2.16406 3.32948L7.88845 0Z"
			fill="#4067EE"
		/>
		<path
			d="M7.88845 13.2578V19.9168L2.16406 16.5873L7.88845 13.2578Z"
			fill="#7C3AED"
		/>
		<path
			d="M13.6094 9.92969L19.3338 13.2592L13.6094 16.5887V9.92969Z"
			fill="#4F46E5"
		/>
		<path
			d="M2.16406 9.92969L7.88845 13.2592L2.16406 16.5887V9.92969Z"
			fill="#814AF7"
		/>
		<path
			d="M2.16406 3.32812L7.88845 6.65763L2.16406 9.98711V3.32812Z"
			fill="#3058E5"
		/>
		<path
			d="M13.615 9.92969V16.5887L7.89062 13.2592L13.615 9.92969Z"
			fill="#624AF6"
		/>
		<path
			d="M13.6094 9.93105L19.3338 6.60156V13.2606L13.6094 9.93105Z"
			fill="#3A30E5"
		/>
		<path
			d="M13.6094 3.32812L19.3338 6.65763L13.6094 9.98711V3.32812Z"
			fill="#3058E5"
		/>
		<path
			d="M13.615 3.32812V9.9287L7.89062 6.59922L13.615 3.32812Z"
			fill="#4067EE"
		/>
		<path
			d="M13.6697 3.32948L7.94531 6.65899V0L13.6697 3.32948Z"
			fill="#476EF9"
		/>
		<path
			d="M7.88845 6.66016V13.3191L2.16406 9.98964L7.88845 6.66016Z"
			fill="#624AF6"
		/>
		<path
			d="M7.88845 0V6.65899L2.16406 3.32948L7.88845 0Z"
			fill="#4067EE"
		/>
		<path
			d="M7.88845 13.2578V19.9168L2.16406 16.5873L7.88845 13.2578Z"
			fill="#7C3AED"
		/>
		<path
			d="M13.6094 9.92969L19.3338 13.2592L13.6094 16.5887V9.92969Z"
			fill="#4F46E5"
		/>
		<path
			d="M2.16406 9.92969L7.88845 13.2592L2.16406 16.5887V9.92969Z"
			fill="#814AF7"
		/>
		<path
			d="M2.16406 3.32812L7.88845 6.65763L2.16406 9.98711V3.32812Z"
			fill="#3058E5"
		/>
		<path
			d="M13.615 9.92969V16.5887L7.89062 13.2592L13.615 9.92969Z"
			fill="#624AF6"
		/>
	</svg>
);

export const UAE = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M12.0002 0C5.37167 0 0 5.37381 0 11.9991C0 18.6267 5.37167 24 12.0002 24C18.6279 24 24 18.6267 24 11.9991C24 5.37241 18.6269 0 12.0002 0ZM11.7686 14.1946C11.6219 14.7039 11.403 15.154 11.102 15.5402C10.809 15.9218 10.426 16.2254 9.96699 16.4447C9.5038 16.6625 8.95904 16.7716 8.32145 16.7716C7.66183 16.7716 7.10253 16.6541 6.63606 16.4218C6.17147 16.1942 5.79642 15.8835 5.50013 15.4945C5.21368 15.1083 4.9985 14.6592 4.86488 14.147C4.72752 13.6316 4.66189 13.0966 4.66189 12.5355V8.18455H6.56715V12.5355C6.56715 12.8662 6.59809 13.1796 6.65857 13.473C6.72092 13.7729 6.81796 14.0341 6.96142 14.2673C7.10253 14.4987 7.27787 14.6839 7.50337 14.8187C7.7209 14.9544 7.99328 15.023 8.32098 15.023C8.64868 15.023 8.91919 14.9544 9.14469 14.814C9.37019 14.6741 9.55584 14.4889 9.68945 14.2594C9.83056 14.0276 9.92995 13.7599 9.98902 13.4567C10.0462 13.1591 10.0767 12.8545 10.0767 12.5369V8.18875H11.9819V12.5369H11.9829C11.9824 13.1325 11.9102 13.6824 11.7686 14.1946ZM19.3376 16.7726H13.5665V14.9941H19.3376V16.7726ZM19.3376 13.3685H13.5665V11.59H19.3376V13.3685ZM19.3376 9.96587H13.5665V8.18735H19.3376V9.96587Z"
			fill="url(#paint0_linear_17897_4967)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_17897_4967"
				x1="0"
				y1="12"
				x2="24.0002"
				y2="12"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#681DDD" />
				<stop offset="1" stopColor="#3A1B95" />
			</linearGradient>
		</defs>
	</svg>
);

export const EmailSetup = ( props ) => (
	<svg
		width="128"
		height="128"
		viewBox="0 0 128 128"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M63.7335 29.385C62.7029 29.385 13.5889 65.0722 13.5889 65.0722L63.7629 96.6371L113.937 65.0722C113.907 65.0722 64.764 29.385 63.7335 29.385Z"
			fill="#7DD3FC"
		/>
		<path
			d="M63.4084 28.9987C63.1434 29.0281 62.8784 29.1459 62.6723 29.2931C62.3189 29.4992 61.9656 29.7348 61.5828 29.9703C60.3167 30.8242 59.0505 31.6781 57.8139 32.5615C53.7799 35.3587 49.7754 38.2149 45.8004 41.071C41.0008 44.4867 36.2013 47.9317 31.4313 51.4062C27.309 54.3801 23.1573 57.3835 19.035 60.3574C17.0327 61.8002 15.0305 63.2136 13.0577 64.6858L12.9693 64.7447C12.8516 64.8036 12.8221 64.9803 12.881 65.098C12.9105 65.1569 12.9399 65.1864 12.9988 65.2158L17.975 68.3664L29.959 75.9043L44.4459 85.0322L56.96 92.9234C58.9917 94.1896 61.0233 95.4851 63.0256 96.7513L63.1139 96.8102C63.4084 96.9868 63.9384 97.1635 64.2623 96.9574L69.2679 93.8068L81.252 86.2689L95.7683 77.141L108.282 69.2792C110.314 68.0131 112.375 66.7764 114.348 65.4514L114.436 65.3925C114.642 65.2747 114.584 65.0686 114.407 64.9508L109.46 61.3586C105.485 58.5024 101.539 55.6168 97.5644 52.7607C92.7649 49.3156 87.9654 45.8706 83.1659 42.4255C79.0142 39.4516 74.833 36.4776 70.6224 33.5332C69.2385 32.5615 67.8251 31.5898 66.4118 30.6476C65.7051 30.1176 64.969 29.6464 64.2034 29.2342C63.9973 29.1164 63.7617 29.0575 63.5262 29.0575C63.32 29.0575 62.8784 29.087 62.9373 29.3814C62.9961 29.6759 63.5556 29.7937 63.7912 29.7937C63.6145 29.7937 63.4673 29.7642 63.32 29.6759C63.3495 29.7053 63.4084 29.7053 63.4378 29.7348L63.585 29.8231L63.6734 29.882C63.585 29.8231 63.8206 29.9703 63.6734 29.882C64.0562 30.1176 64.4389 30.3826 64.8217 30.6476C66.1173 31.5015 67.3834 32.3848 68.679 33.2976C72.713 36.1243 76.7175 38.9805 80.7514 41.8366C85.5215 45.2522 90.2915 48.6678 95.0322 52.0834C99.125 55.0279 103.218 57.9724 107.311 60.9463L111.315 63.8614L112.552 64.7742C112.758 64.9508 112.964 65.098 113.2 65.2453C113.229 65.2747 113.259 65.2747 113.288 65.3042L113.259 64.8625L108.253 68.0131L96.2688 75.551L81.7525 84.6789L69.2973 92.4523L65.2045 95.0435C64.5567 95.4557 63.85 95.8385 63.2317 96.2802L63.1434 96.339L64.2917 96.4863L59.3155 93.3357L47.3315 85.7978L32.8446 76.6699L20.3306 68.7787L16.2083 66.1875L14.9127 65.3631C14.7066 65.1864 14.471 65.0686 14.2355 64.9508C14.206 64.9214 14.1766 64.9214 14.1471 64.8919L14.1766 65.3336L19.0644 61.8002C22.9806 58.9735 26.8968 56.1174 30.8129 53.2907C35.583 49.8456 40.3531 46.43 45.1231 42.985C49.2748 40.011 53.456 37.0371 57.6372 34.0926C59.7572 32.5909 61.8772 31.0304 64.1151 29.7053C64.3212 29.5876 64.0856 29.7053 63.9973 29.7053C64.2623 29.7053 64.5273 29.5287 64.3506 29.2637C64.1739 28.9987 63.7028 28.9987 63.4084 28.9987Z"
			fill="#7DD3FC"
		/>
		<path
			d="M54.8428 80.7632C54.8428 80.7632 69.4474 59.6806 77.9864 64.7746C78.6342 65.1574 79.1937 65.6579 79.6648 66.2468L79.6353 66.0113C79.6353 66.0113 94.9172 88.9783 92.0905 100.521C89.5877 110.709 80.4304 113.3 74.9831 95.3384C68.5052 92.9239 57.6695 85.386 54.8428 80.7632Z"
			fill="white"
		/>
		<path
			d="M55.43 81.1767L55.5478 81.0295L55.6067 80.9412L55.7833 80.6762C56.1661 80.1462 56.5783 79.6162 56.9611 79.1156C58.2567 77.4078 59.6406 75.7589 61.054 74.1689C62.7912 72.2255 64.6462 70.3999 66.6485 68.7216C68.4741 67.2199 70.4763 65.8065 72.7436 65.041C73.6564 64.7171 74.628 64.5698 75.5997 64.5993C75.6292 64.5993 75.6292 64.5993 75.6586 64.5993L75.8058 64.6287C75.9236 64.6287 76.0708 64.6582 76.1886 64.6876C76.4242 64.7171 76.6597 64.7759 76.8659 64.8643C76.7481 64.8348 77.0131 64.9232 77.072 64.9232C77.1897 64.9821 77.3075 65.0115 77.4253 65.0704C77.5431 65.1293 77.6314 65.1587 77.7198 65.2176C77.8081 65.2765 77.6609 65.1587 77.8081 65.2765C77.9553 65.3943 78.0436 65.4237 78.1614 65.5121C78.5737 65.8065 78.9564 66.1893 79.2803 66.5721C79.5748 66.9254 80.3698 66.9843 80.2815 66.3365L80.252 66.101L79.1331 66.1893C79.7514 67.1021 80.3403 68.0738 80.8998 69.016C82.3132 71.3422 83.6382 73.6977 84.9043 76.1122C86.4943 79.1156 87.8782 82.2073 89.1149 85.3579C90.2927 88.4496 91.2938 91.6002 91.6472 94.898C91.8238 96.2819 91.8238 97.6659 91.6472 99.0498C91.4411 100.404 91.0583 101.759 90.4694 103.025C89.9983 104.144 89.3505 105.145 88.5555 106.028C87.9077 106.764 87.0832 107.324 86.141 107.648C86.0232 107.677 85.9054 107.707 85.7876 107.736C85.7288 107.765 85.8171 107.736 85.8171 107.736L85.7288 107.765L85.5521 107.795C85.3165 107.824 85.081 107.854 84.8454 107.854H84.6687H84.5804H84.6099C84.4921 107.854 84.3449 107.824 84.2271 107.795C84.1093 107.765 83.9915 107.765 83.9032 107.736L83.7265 107.707L83.6382 107.677C83.5204 107.648 83.6971 107.707 83.6382 107.677C83.3732 107.589 83.1376 107.5 82.9021 107.383L82.7254 107.294L82.6076 107.235L82.4898 107.177L82.2543 107.029C81.9893 106.853 81.7537 106.676 81.5181 106.47C81.3709 106.352 81.5476 106.499 81.4592 106.411L81.2531 106.234C81.1354 106.117 81.0176 105.999 80.8704 105.881C80.6053 105.616 80.3698 105.322 80.1342 105.057C80.1342 105.057 80.0165 104.909 80.0753 104.998L80.0459 104.939C79.987 104.85 79.9281 104.762 79.8692 104.674C79.7514 104.497 79.6337 104.35 79.5159 104.173C78.9859 103.408 78.5148 102.583 78.0731 101.759C77.602 100.816 77.1603 99.8153 76.7775 98.8436C76.542 98.2547 76.3358 97.6953 76.1297 97.1064C76.0414 96.812 75.9236 96.5175 75.8353 96.2525C75.747 95.8992 75.6292 95.5164 75.4819 95.1925C75.2169 94.7803 74.5986 94.633 74.1569 94.4564C73.7153 94.2797 73.3619 94.1325 72.9791 93.9264C72.1252 93.5436 71.3008 93.1019 70.4763 92.6602C68.6802 91.6885 66.9429 90.5991 65.2351 89.4507C62.0845 87.3307 58.9339 84.9751 56.4311 82.0895C56.3133 81.9423 56.1956 81.7951 56.0778 81.6479C56.0483 81.6184 56.0483 81.589 56.0189 81.5595C55.9306 81.4712 56.0778 81.6479 56.0189 81.5595L55.8717 81.3534C55.6656 81.0884 55.4889 80.8234 55.3122 80.5584C55.1355 80.2934 54.7528 80.0284 54.4289 80.1462C54.105 80.2639 54.1639 80.7056 54.3111 80.9706C55.0472 82.0895 55.9011 83.1495 56.8728 84.0623C58.1095 85.2696 59.4051 86.4179 60.7595 87.4779C63.6746 89.8041 66.7957 91.8652 70.0641 93.6614C71.6247 94.5153 73.2147 95.2808 74.893 95.8992L74.363 95.3692C75.3936 98.6964 76.6892 102.083 78.7503 104.909C80.0459 106.676 81.6948 108.325 83.8443 108.943C85.4638 109.385 87.201 109.032 88.5555 108.001C90.116 106.853 91.1761 105.086 91.8827 103.349C92.7366 101.229 93.1489 98.9614 93.0311 96.6647C92.9133 94.0736 92.3244 91.5119 91.5588 89.0385C89.9688 83.7973 87.5838 78.7917 84.9632 73.9627C83.4615 71.2244 81.9304 68.486 80.1931 65.8949L80.1048 65.7771C79.9576 65.5121 79.6631 65.3354 79.3687 65.3354C79.1331 65.3648 78.9564 65.571 78.9859 65.8065C78.9859 65.836 78.9859 65.836 78.9859 65.8654L79.0153 66.101L80.0165 65.8654C78.3675 63.8337 75.6881 62.9209 73.1558 63.5098C70.7708 64.0398 68.6507 65.3354 66.7368 66.7782C64.6168 68.4271 62.644 70.2527 60.8184 72.2255C59.2284 73.9039 57.7561 75.6705 56.3428 77.4961C55.8717 78.085 55.43 78.7034 54.9883 79.2923C54.7233 79.6162 54.4878 79.94 54.2816 80.2934C54.2816 80.3228 54.2522 80.3228 54.2522 80.3228C54.0461 80.6173 54.37 81.059 54.6055 81.2356C54.8117 81.4417 55.165 81.4417 55.3711 81.2062C55.4006 81.2356 55.4006 81.2062 55.43 81.1767Z"
			fill="#082F49"
		/>
		<path
			d="M86.669 59.2998C89.5252 48.9941 83.2828 45.1368 78.66 44.0768C74.0372 43.0168 70.651 44.3418 69.4732 46.1674C68.5899 47.5219 70.7982 56.6792 70.7982 56.6792L77.8061 65.1593C77.7767 65.1299 84.4901 67.1616 86.669 59.2998Z"
			fill="#082F49"
		/>
		<path
			d="M65.6123 60.3857C63.2567 56.5873 69.4402 47.9305 69.4402 47.9305C71.2069 47.96 74.328 46.9883 74.328 46.9883C72.3552 51.935 78.097 54.6439 78.097 54.6439C79.9225 52.1411 82.9554 53.8195 82.1898 56.499C81.4242 59.1785 78.7742 58.9134 78.7742 58.9134C78.7742 58.9134 78.7153 65.8919 78.2147 66.9224C78.2147 66.9224 73.1502 69.0719 71.2069 64.5669C71.2069 64.5963 67.2024 62.9474 65.6123 60.3857Z"
			fill="white"
		/>
		<path
			d="M66.2325 60.0352C65.8203 59.3285 65.7319 58.3863 65.8203 57.5324C65.9381 56.5018 66.2031 55.4712 66.5858 54.529C67.322 52.674 68.2348 50.9073 69.3242 49.2584C69.5598 48.905 69.7953 48.5222 70.0603 48.1689L69.2359 48.5222C71.0026 48.5517 72.8282 48.0511 74.5065 47.5211L73.6526 46.9322C72.9754 48.6106 73.1226 50.5245 74.0943 52.0556C74.801 53.1451 75.7726 54.0579 76.8915 54.7351C77.1565 54.9118 77.451 55.059 77.7454 55.2062C78.0988 55.324 78.4816 55.2062 78.7171 54.9118C78.9527 54.5879 79.2471 54.3229 79.6005 54.1462C79.836 54.0579 80.0716 54.0284 80.3366 54.0579C80.6016 54.1168 80.8666 54.2345 81.0433 54.4406C81.2494 54.6468 81.3966 54.8823 81.4849 55.1768C81.691 55.9423 81.5438 56.7962 81.0727 57.444C80.9844 57.5618 80.896 57.6796 80.7783 57.7679L80.5721 57.9446C80.5427 57.974 80.4838 58.0329 80.4249 58.0329C80.366 58.0624 80.2777 58.1213 80.2188 58.1507C80.1599 58.1801 80.0421 58.239 80.1599 58.1801C80.0127 58.239 79.8655 58.2979 79.7182 58.3274C79.6594 58.3568 79.5121 58.3568 79.6594 58.3568L79.4532 58.3863C79.3355 58.3863 79.2177 58.4157 79.0999 58.4157C78.8643 58.4451 79.2177 58.4157 79.041 58.4157H78.9527C78.5993 58.3863 78.0399 58.6218 78.0104 59.0635C77.981 61.2424 77.9516 63.4508 77.716 65.6002C77.6866 65.8947 77.6571 66.1891 77.5982 66.4836C77.5982 66.5425 77.5688 66.6014 77.5688 66.6603C77.5982 66.5425 77.5688 66.6603 77.5688 66.6897C77.5393 66.778 77.5099 66.8369 77.4804 66.9253L78.0104 66.4836C77.8927 66.5425 77.7454 66.5719 77.6277 66.6308C77.5099 66.6897 77.3627 66.7192 77.2154 66.7486L76.9799 66.8075C76.7738 66.8369 76.9504 66.8075 76.9799 66.8075L76.8327 66.8369C76.6265 66.8664 76.4204 66.8958 76.2143 66.9253C76.0965 66.9253 75.9787 66.9547 75.8904 66.9547H75.7432C75.6549 66.9547 75.6549 66.9547 75.7432 66.9547H75.6254C75.1543 66.9547 74.6832 66.8664 74.2415 66.7192C73.7409 66.5425 73.2698 66.248 72.887 65.8652C72.6809 65.6297 72.4748 65.3941 72.2981 65.1291C72.092 64.8052 71.9742 64.2752 71.5915 64.128C70.9731 63.863 70.3548 63.5391 69.7364 63.1858C68.382 62.3613 67.0864 61.3602 66.2325 60.0352C65.8497 59.4757 64.5247 60.0941 64.9664 60.7713C65.8203 62.1258 67.1453 63.1269 68.4703 63.9219C69.2359 64.393 70.0014 64.7758 70.8259 65.1291L70.502 64.8347C71.2087 66.4247 72.4454 67.5436 74.1532 67.9264C75.3604 68.1325 76.5677 68.0736 77.7454 67.7203C77.9516 67.6614 78.1577 67.6025 78.3638 67.5142C78.9821 67.2492 79.041 66.6308 79.1293 66.0714C79.306 64.7169 79.3944 63.333 79.4238 61.9491C79.4532 60.948 79.4827 59.9174 79.4827 58.9163L78.5405 59.5641C79.9832 59.6818 81.3966 59.034 82.2505 57.8857C82.8688 57.0024 83.2222 55.7951 82.8688 54.7351C82.545 53.8223 81.7794 53.1451 80.8077 52.9684C79.4827 52.7328 78.246 53.4984 77.4804 54.529L78.4816 54.2051C78.3932 54.1756 78.6288 54.2934 78.5699 54.264C78.5405 54.2345 78.4816 54.2345 78.4521 54.2051C78.3049 54.1462 78.1871 54.0579 78.0693 53.9695C77.6277 53.7045 77.2154 53.4101 76.8327 53.0862C75.861 52.2912 74.9776 51.1428 74.7126 49.8178C74.536 48.905 74.6537 47.9628 75.0071 47.1089C75.2132 46.5789 74.536 46.4022 74.1532 46.52C72.887 46.9617 71.562 47.2561 70.237 47.4033C69.7364 47.4622 69.177 47.3444 68.8236 47.7861C68.7942 47.8156 68.7648 47.8744 68.7353 47.9039C68.5586 48.1689 68.382 48.4339 68.1759 48.7283C66.6742 51.0545 65.2608 53.6162 64.613 56.3251C64.2597 57.7974 64.1419 59.4463 64.9369 60.8007C65.3492 61.3307 66.6447 60.7124 66.2325 60.0352Z"
			fill="#082F49"
		/>
		<path
			d="M74.8959 57.941C74.8959 58.0294 74.8959 58.1177 74.8959 58.2355V58.1177C74.8959 58.5005 74.837 58.9127 74.6898 59.2661L74.7193 59.1483C74.6898 59.2661 74.6309 59.3544 74.572 59.4427C74.572 59.4722 74.5426 59.4722 74.5426 59.5016C74.4837 59.5899 74.6309 59.4133 74.5426 59.4722C74.5131 59.5016 74.4837 59.5311 74.4248 59.5899L74.3954 59.6194C74.3365 59.6488 74.5131 59.5605 74.4543 59.5899C74.4248 59.5899 74.3954 59.6194 74.3954 59.6194L74.3659 59.6488C74.307 59.6783 74.4248 59.6194 74.4248 59.6194C74.4248 59.6194 74.3659 59.6488 74.3365 59.6488H74.307C74.2187 59.6783 74.4248 59.6488 74.3954 59.6488H74.2481C74.1598 59.6488 74.307 59.6488 74.3365 59.6488C74.3659 59.6488 74.2776 59.6488 74.2187 59.6194C74.1893 59.6194 74.1304 59.5899 74.1009 59.5899C74.0126 59.5605 74.2187 59.6488 74.1598 59.6194L74.1009 59.5899C74.0126 59.5605 73.8948 59.5016 73.8065 59.4427C73.5709 59.3249 73.247 59.3838 73.0703 59.5899C72.9231 59.855 73.1292 60.0611 73.3354 60.1788C73.7476 60.4144 74.2187 60.5027 74.6604 60.4438C75.0137 60.385 75.3082 60.1788 75.5143 59.8844C75.7793 59.4427 75.9265 58.9422 75.9265 58.4122C75.9265 58.2649 75.9265 58.0883 75.9265 57.941C75.8971 57.8233 75.8382 57.7055 75.7204 57.6466C75.6026 57.5583 75.4554 57.5288 75.3082 57.5288C75.0432 57.5288 74.8076 57.676 74.837 57.941H74.8959Z"
			fill="#082F49"
		/>
		<path
			d="M70.0948 53.557C68.9759 54.087 67.7981 54.4698 66.5614 54.6759C62.4391 55.412 61.968 56.8548 63.2635 57.6498C64.5591 58.4449 70.1536 57.7676 70.1536 57.7676"
			fill="white"
		/>
		<path
			d="M69.4751 53.1707C68.2384 53.848 66.825 54.0835 65.4411 54.378C64.5872 54.5252 63.7628 54.7902 62.9677 55.2024C62.585 55.4085 62.1433 55.703 61.9961 56.1447C61.6722 57.1458 63.1444 57.9113 63.8805 58.1175C65.1172 58.5002 66.5011 58.4119 67.7672 58.353C68.7684 58.2941 69.7695 58.2352 70.7412 58.1175C70.9767 58.088 70.4467 57.6758 70.4173 57.6463C70.1523 57.4402 69.8578 57.3519 69.5339 57.3519H69.4456L68.9745 57.4108C68.4739 57.4697 67.9439 57.4991 67.4434 57.5286C66.2656 57.6463 65.0583 57.6463 63.8805 57.5286C63.7628 57.5286 63.645 57.4991 63.5272 57.4697C63.4977 57.4697 63.3505 57.4402 63.4094 57.4402C63.4683 57.4402 63.3211 57.4108 63.2916 57.4108C63.38 57.4402 63.38 57.4402 63.2916 57.4108C63.3211 57.4402 63.5566 57.558 63.4683 57.4991C63.5272 57.558 63.5566 57.558 63.4683 57.4991C63.5566 57.5875 63.4683 57.4991 63.4389 57.4697C63.4094 57.4402 63.4683 57.4991 63.4094 57.4402C63.38 57.4108 63.38 57.3813 63.3505 57.3519C63.3505 57.3519 63.2916 57.2341 63.2916 57.2047C63.2622 57.0869 63.2622 56.9397 63.3211 56.8219C63.4977 56.4391 63.8216 56.1447 64.2339 55.968C64.9405 55.6146 65.6767 55.3791 66.4128 55.2319C67.8556 54.908 69.3573 54.6724 70.6823 53.9952C70.8884 53.8774 70.4173 53.583 70.3584 53.5241C70.1523 53.3474 69.6812 53.0529 69.4751 53.1707Z"
			fill="#082F49"
		/>
		<path
			d="M72.5617 53.0271C72.5617 53.0271 71.9139 52.9976 71.9434 53.616C71.9728 54.2343 72.7384 54.2343 72.8856 53.6749C72.9739 53.4393 72.8561 53.1449 72.6206 53.0565C72.5911 53.0271 72.5911 53.0271 72.5617 53.0271Z"
			fill="#082F49"
		/>
		<path
			d="M68.5363 51.787C68.5363 51.787 67.8885 51.7575 67.918 52.3759C67.9474 52.9942 68.713 52.9942 68.8602 52.4348C68.9485 52.1992 68.8308 51.9047 68.5952 51.8164C68.5658 51.787 68.5658 51.787 68.5363 51.787Z"
			fill="#082F49"
		/>
		<path
			d="M82.458 61.5355C82.6053 62.4778 82.8997 63.3905 83.2825 64.2739C83.7831 65.4517 84.6958 66.7767 86.1681 66.4528C87.2281 66.2173 88.1409 65.4517 88.7887 64.6272C89.2598 64.0383 89.672 63.2433 89.5248 62.4483C89.2598 61.0939 87.7581 60.5933 86.5803 61.1527C84.6075 62.095 84.8431 64.48 85.4909 66.2173C85.9031 67.3067 86.492 68.3078 87.2576 69.1617C87.8465 69.8095 88.5826 70.4868 89.4365 70.7812C91.0854 71.3407 92.8226 69.839 92.646 68.1312C92.5576 67.0417 91.6743 66.2173 90.7026 65.805C89.5837 65.3045 88.2881 65.4517 87.3164 66.2173C86.1387 67.2184 86.4625 68.7201 87.022 69.9862C87.2576 70.5162 87.552 71.0168 87.8465 71.5173C88.082 71.8707 89.3187 71.0757 89.0831 70.7223C88.5826 69.9568 88.1703 69.1323 87.9053 68.249C87.7581 67.7778 87.7287 67.2478 87.8465 66.7473C87.8759 66.6884 87.8759 66.6589 87.9053 66.6C87.9348 66.5411 87.8464 66.6884 87.9348 66.5706L87.9937 66.4528C87.8465 66.6589 88.1115 66.3645 87.9642 66.4823C87.817 66.6 87.9348 66.5117 87.9642 66.4823C88.0526 66.4234 87.8465 66.5412 87.8759 66.5412C87.9053 66.5117 87.9642 66.4823 87.9937 66.4823C87.8465 66.5117 87.9348 66.5117 88.0231 66.4823L88.1703 66.4528H88.2587H88.3765C89.4954 66.4528 90.4965 67.0417 91.0854 67.9839C91.2915 68.3667 91.3798 68.8084 91.3209 69.2206C91.2621 69.5151 91.1443 69.7801 90.9971 70.0451C91.0265 70.0156 90.997 70.0156 91.0265 70.0156C90.9382 70.0745 91.2621 69.8684 91.1148 69.9568C91.1737 69.9273 91.2032 69.9273 91.1443 69.9273C91.0854 69.9273 91.0559 69.9273 90.9971 69.9273C90.3198 69.9273 89.672 69.4856 89.2009 69.0734C88.4942 68.4845 87.9053 67.7484 87.4342 66.9534C86.8748 66.07 86.492 65.0984 86.3153 64.0678C86.1975 63.3906 86.1386 62.4483 86.492 61.9183C86.492 61.8889 86.6098 61.7122 86.5509 61.83C86.5803 61.8005 86.5803 61.7711 86.6098 61.7711C86.6098 61.7711 86.492 61.8594 86.5803 61.8005C86.6687 61.7416 86.5214 61.83 86.5509 61.83C86.4625 61.8889 86.5214 61.8594 86.5509 61.83C86.4037 61.9183 86.492 61.83 86.5509 61.83C86.6687 61.83 86.4625 61.83 86.5803 61.83H86.6687C86.5803 61.83 86.757 61.83 86.6687 61.83C86.7864 61.83 86.8748 61.83 86.9926 61.8594C87.8759 62.0655 88.4059 62.9194 88.2292 63.8028C88.1998 63.9206 88.1703 64.0678 88.082 64.1856C87.9348 64.5095 87.7287 64.8039 87.4637 65.0395C87.3459 65.1572 87.2281 65.2456 87.1103 65.3634C87.1692 65.3045 86.8748 65.5106 86.9926 65.4517C87.1103 65.3928 86.7275 65.5695 86.9042 65.5106C86.8748 65.5106 86.7275 65.5695 86.757 65.5695C86.7864 65.5695 86.6392 65.5989 86.6098 65.5989C86.5803 65.5989 86.5214 65.5989 86.492 65.5989C86.4331 65.5989 86.3448 65.5989 86.2859 65.5695C86.0798 65.5106 85.8736 65.4222 85.6675 65.275C85.2553 64.9217 84.902 64.4506 84.6664 63.95C84.2247 63.0667 83.9303 62.1244 83.7242 61.1527L83.6947 60.9761C83.6653 60.4461 82.3992 61.1233 82.458 61.5355Z"
			fill="#082F49"
		/>
		<path
			d="M54.1055 79.7328L74.923 89.7735L54.341 96.163L54.1055 79.7328Z"
			fill="#082F49"
		/>
		<path
			d="M55.9872 72.4L54.3383 96.162L33.0791 85.6502L33.8447 61.4465L55.9872 72.4Z"
			fill="#082F49"
		/>
		<path
			d="M46.9516 77.7908C46.6866 76.9958 45.9505 76.4364 45.126 76.4364C44.331 76.4069 43.5654 76.878 43.0649 77.4669C42.5054 78.1147 42.0637 78.9686 42.0932 79.8814C42.1521 80.6764 42.5643 81.4125 43.2415 81.8542C43.8893 82.237 44.596 82.502 45.3616 82.5903C45.7443 82.6787 46.1566 82.4726 46.2744 82.0603C46.3921 81.6775 46.1566 81.2653 45.7738 81.1475C45.4499 81.0887 45.1554 81.0298 44.8316 80.9414L44.596 80.8531C44.5666 80.8531 44.331 80.7353 44.4782 80.8236C44.3604 80.7648 44.2132 80.7059 44.0954 80.6175C44.066 80.5881 43.8599 80.4409 44.0071 80.5586C43.9482 80.4998 43.8893 80.4703 43.8304 80.4114C43.801 80.382 43.7127 80.2348 43.801 80.382C43.7421 80.3231 43.7127 80.2347 43.6832 80.1759C43.6538 80.117 43.6538 80.117 43.6832 80.1759C43.6538 80.1464 43.6538 80.0875 43.6538 80.0581C43.6538 79.9992 43.6243 79.9697 43.6243 79.9109C43.6243 79.9697 43.6243 79.9697 43.6243 79.9109C43.6243 79.8225 43.6243 79.7342 43.6243 79.6459C43.6243 79.7636 43.6538 79.4986 43.6538 79.4692C43.7421 79.1158 43.9188 78.8214 44.1249 78.5269C44.0365 78.6153 44.2132 78.4092 44.2427 78.4092C44.2721 78.4092 44.331 78.2914 44.3899 78.2619C44.4488 78.2325 44.6254 78.0853 44.5077 78.1442C44.596 78.0853 44.6549 78.0558 44.7432 77.9969C44.861 77.9086 44.6843 77.9969 44.8316 77.9675C44.861 77.9675 45.1555 77.9086 44.9493 77.9086C45.0377 77.9086 45.126 77.9086 45.1849 77.9086C45.0082 77.9086 45.2438 77.938 45.3027 77.938C45.4793 77.9675 45.2143 77.8792 45.3616 77.938C45.391 77.9675 45.5971 78.1147 45.4793 77.9969C45.5088 78.0264 45.6266 78.2031 45.5677 78.0558C45.5971 78.0853 45.5971 78.1147 45.6266 78.1736C45.5971 78.0853 45.5971 78.0853 45.6266 78.1736C45.7444 78.5564 46.1271 78.7919 46.5394 78.6742C46.8633 78.5564 47.0988 78.1442 46.9516 77.7908Z"
			fill="white"
		/>
		<path
			d="M55.017 81.3184C55.017 81.554 55.017 81.6718 55.017 81.9662C55.017 82.349 54.9875 82.7023 54.9875 83.0851C54.9286 84.1157 54.8992 85.1463 54.8403 86.1768C54.7225 88.3852 54.5753 90.5936 54.4281 92.8019C54.3692 93.5086 54.3397 94.2447 54.2514 94.9514C54.1925 95.452 55.2525 95.6581 55.3409 95.1869C55.5764 93.5675 55.6059 91.9186 55.7236 90.2697C55.8709 88.0319 55.9886 85.794 56.077 83.5268C56.1064 82.7907 56.1359 82.0545 56.1359 81.3479C56.1359 80.9062 55.0464 80.759 55.017 81.3184Z"
			fill="white"
		/>
		<path
			d="M67.3528 89.3018C66.9994 89.0662 66.5872 88.8601 66.2044 88.654C65.3505 88.1829 64.4966 87.7118 63.6427 87.2407L58.0187 84.1489L56.7232 83.4423C56.4876 83.3245 56.4287 83.6484 56.4582 83.7956C56.4876 84.0606 56.6643 84.2962 56.8998 84.4139C59.9032 86.0629 62.936 87.7412 65.9394 89.3901C66.4105 89.6551 66.9111 89.8907 67.3528 90.1851C67.5294 90.3029 67.7061 90.2146 67.7061 90.0085C67.7061 89.7435 67.5883 89.4785 67.3528 89.3018Z"
			fill="white"
		/>
		<path
			d="M63.4061 90.6005L57.5466 87.1554L56.7221 86.6843C56.5454 86.5665 56.2215 86.5665 56.1626 86.8021C56.1038 87.0376 56.3688 87.3026 56.5749 87.391L62.4344 90.836L63.2589 91.3366C63.4355 91.4544 63.7594 91.4544 63.8183 91.2188C63.8772 90.9832 63.5827 90.6888 63.4061 90.6005Z"
			fill="white"
		/>
		<path
			d="M59.9622 91.8077L57.0472 89.8643L56.6349 89.5993C56.3699 89.4521 56.046 89.5404 55.8694 89.776C55.7221 89.9821 55.7516 90.2766 55.9577 90.4238L55.9871 90.4532L58.9022 92.3966L59.3144 92.6616C59.5794 92.8088 59.9033 92.7205 60.08 92.4849C60.2272 92.2788 60.1978 91.9844 59.9916 91.8371C59.9916 91.8077 59.9622 91.8077 59.9622 91.8077Z"
			fill="white"
		/>
		<path
			d="M64.6749 87.2974C64.4982 87.3857 64.8221 87.2385 64.6749 87.2974L64.5571 87.3563C64.3216 87.4446 64.086 87.5329 63.8505 87.6507C63.1732 87.9157 62.496 88.1807 61.7893 88.4457C60.3465 89.0052 58.9037 89.5352 57.4315 90.0946L56.4304 90.448C56.3126 90.5069 55.8709 90.6541 55.8415 90.8308C55.812 91.0074 56.1948 90.8308 56.2537 90.8013C58.6976 89.8885 61.171 88.9757 63.6149 88.004C64.086 87.8274 64.5571 87.6507 65.0282 87.4151C65.0871 87.3857 65.4405 87.1796 65.3227 87.1207C65.2049 87.0618 64.7632 87.2679 64.6749 87.3268V87.2974Z"
			fill="white"
		/>
		<path
			d="M63.7335 96.6328L13.5889 65.0679V123.486H113.907V65.0679L63.7335 96.6328Z"
			fill="white"
		/>
		<path
			d="M64.3499 96.2176L59.3443 93.067L47.3603 85.5291L32.8734 76.4012L20.3299 68.51L16.2076 65.9188L14.912 65.0944C14.7059 64.9472 14.4704 64.7999 14.2348 64.6822C14.2054 64.6527 14.1759 64.6527 14.1465 64.6233C13.9403 64.5055 12.9098 65.1827 12.9098 65.3888V122.924C12.8803 123.189 12.8803 123.454 12.9098 123.719C12.9098 123.749 12.9098 123.778 12.9098 123.807H12.9392H109.224C110.519 123.807 111.815 123.837 113.111 123.807H113.287C113.523 123.807 114.495 123.277 114.495 123.012V65.5655C114.524 65.3005 114.524 65.0355 114.495 64.7705C114.495 64.7411 114.495 64.7116 114.495 64.6822C114.495 64.6233 113.817 64.9766 113.817 64.9766L108.812 68.1272L96.8276 75.6651L82.3113 84.793L69.7972 92.6842C67.7655 93.9503 65.7339 95.2165 63.7316 96.512L63.6433 96.5709C63.5844 96.6004 63.0249 96.9537 63.0838 97.0421C63.1427 97.1304 63.7316 96.7771 63.761 96.7476L68.7667 93.597L80.7507 86.0591L95.267 76.9312L107.781 69.04C109.813 67.7739 111.874 66.5372 113.847 65.2122L113.935 65.1533L113.258 65.4477V121.54C113.258 122.276 113.199 123.071 113.258 123.807C113.258 123.837 113.258 123.866 113.258 123.896L114.465 123.101H14.5292C14.4409 123.101 14.3231 123.101 14.2348 123.101C14.1465 123.071 14.2054 123.13 14.2054 123.101C14.117 122.924 14.2054 122.394 14.2054 122.188V64.6527L12.9687 65.4183L17.9743 68.5689L29.9583 76.1068L44.4452 85.2347L56.9887 93.1259L61.111 95.717L62.4066 96.5415C62.6127 96.6887 62.8483 96.8359 63.0838 96.9537C63.1133 96.9832 63.1427 96.9832 63.1721 97.0126C63.3194 97.1009 63.7316 96.7771 63.8494 96.7182C63.8494 96.6887 64.4088 96.2765 64.3499 96.2176Z"
			fill="#7DD3FC"
		/>
		<path
			d="M20.5703 119.192C20.5703 119.192 58.3481 85.0652 64.0309 85.978C69.7138 86.8907 103.693 117.513 103.693 117.513"
			fill="white"
		/>
		<path
			d="M21.1883 119.515C22.3367 118.485 23.485 117.454 24.6334 116.453C27.4601 113.95 30.3162 111.477 33.1724 109.004C36.7646 105.912 40.4158 102.85 44.0964 99.8463C47.6298 96.9902 51.1926 94.1634 54.8732 91.5134C56.316 90.4828 57.7588 89.4817 59.2899 88.5395C59.9083 88.1567 60.4972 87.8034 61.145 87.4795C61.41 87.3322 61.675 87.185 61.9694 87.0672C62.0872 87.0083 62.2344 86.9495 62.3522 86.8906L62.5289 86.8022L62.6467 86.7433C62.5289 86.7728 62.735 86.7139 62.7644 86.7139L62.9117 86.655C63.0294 86.6256 63.1178 86.5961 63.2356 86.5372C63.3533 86.4783 63.4122 86.4783 63.5006 86.4783C63.53 86.4783 63.5889 86.4783 63.6183 86.4489C63.4417 86.4783 63.6478 86.4195 63.6183 86.4489L63.8539 86.4195C64.0011 86.39 63.7656 86.4195 63.795 86.4195C63.8245 86.4195 63.8833 86.4195 63.9128 86.4195C64.1483 86.4195 63.795 86.39 63.9422 86.4195C64.0306 86.4489 64.1189 86.4783 64.2072 86.5078C64.2956 86.5372 64.3839 86.5667 64.4722 86.5961C64.5606 86.6256 64.2956 86.5078 64.5017 86.5961L64.6784 86.6845C64.9139 86.8022 65.1495 86.8906 65.3556 87.0083C65.915 87.3028 66.4745 87.6267 67.0045 87.98C67.7406 88.4217 68.1823 88.7456 68.9184 89.2756C69.6545 89.8056 70.4201 90.3356 71.1562 90.8951C72.8935 92.1906 74.6013 93.5157 76.3091 94.8701C80.1369 97.9029 83.8764 101.024 87.5865 104.204C90.9137 107.031 94.241 109.916 97.5094 112.802C99.3055 114.392 101.102 116.012 102.868 117.602L103.104 117.808C103.398 118.043 103.811 118.073 104.134 117.925C104.341 117.837 104.429 117.602 104.341 117.395C104.311 117.337 104.252 117.278 104.193 117.219C102.927 116.07 101.661 114.952 100.366 113.833C97.3033 111.124 94.2115 108.444 91.1198 105.765C87.3803 102.555 83.6114 99.3752 79.7836 96.254C76.4857 93.5745 73.1585 90.9245 69.6545 88.4806C68.4767 87.6267 67.2401 86.8611 65.9445 86.1839C65.12 85.7717 64.2367 85.3594 63.2944 85.4772C62.205 85.595 61.1744 86.0956 60.2322 86.5961C58.8777 87.3322 57.5527 88.1272 56.2571 89.0106C52.6649 91.4251 49.2198 94.0457 45.8631 96.7546C42.0353 99.7874 38.2958 102.909 34.5857 106.059C31.4057 108.768 28.2551 111.477 25.1339 114.245C23.485 115.717 21.8066 117.189 20.1577 118.662L19.9222 118.868C19.6572 119.103 19.8633 119.427 20.0988 119.574C20.4816 119.751 20.8939 119.722 21.1883 119.515Z"
			fill="#7DD3FC"
		/>
		<path
			d="M73.7393 85.0587C73.7393 85.0587 75.1526 108.909 85.2816 109.527C95.4107 110.146 93.114 90.6827 86.3711 78.3453C79.6282 66.0079 78.8921 66.5084 78.8921 66.5084"
			fill="white"
		/>
		<path
			d="M73.1289 84.8258C73.1878 85.9742 73.335 87.0931 73.4528 88.212C73.7767 90.8326 74.2478 93.4237 74.8662 95.9854C75.5728 98.8416 76.4856 101.698 77.9284 104.289C79.1945 106.556 80.9907 108.794 83.5229 109.736C85.8785 110.619 88.7347 110.237 90.4425 108.293C92.3858 106.114 92.7686 102.875 92.7981 100.078C92.857 96.221 92.1208 92.3342 91.0903 88.6536C90.5308 86.6514 89.8241 84.6786 89.0291 82.7647C88.1458 80.733 87.1741 78.7307 86.0846 76.7874C84.4063 73.7545 82.6985 70.6628 80.6962 67.8361C80.3723 67.3356 79.9896 66.8644 79.5773 66.4522C79.3712 66.2166 79.0768 66.04 78.7529 65.9516C78.6645 65.9222 78.5468 65.9517 78.4584 65.9811C77.8695 66.3639 78.8707 67.4239 79.3712 67.1C79.1946 67.1589 79.0179 67.1294 78.8707 67.0411C79.0179 67.1294 78.8118 66.9822 78.8118 66.9822C78.8412 67.0117 78.8707 67.0411 78.9295 67.0706C78.959 67.1 78.959 67.1 78.9884 67.1294C79.1062 67.2178 78.8412 66.9528 78.959 67.1C79.0768 67.2472 79.2534 67.4533 79.4007 67.63C79.6362 67.9244 79.8423 68.2189 80.0484 68.5133C80.1073 68.6017 80.1662 68.69 80.2251 68.7784L80.284 68.8667C80.284 68.8667 80.1957 68.7489 80.2546 68.8372L80.3723 69.0434C80.5196 69.2789 80.6962 69.5439 80.8435 69.7795C81.7857 71.2517 82.669 72.7829 83.5524 74.314C84.7007 76.3457 85.8785 78.3774 86.9091 80.468C87.763 82.2347 88.4991 84.0602 89.1175 85.9153C90.3836 89.5664 91.208 93.3354 91.5025 97.1926C91.7086 100.108 91.6497 103.347 90.2658 106.026C89.7653 106.998 89.0291 107.822 88.0575 108.382C87.0269 108.912 85.8785 109.118 84.7302 108.971C84.4652 108.941 84.1707 108.882 83.9057 108.823C84.0529 108.853 83.8174 108.794 83.7879 108.794L83.6113 108.735C83.4641 108.676 83.3463 108.647 83.199 108.588L83.0224 108.499L82.9046 108.441C82.9929 108.47 82.7868 108.382 82.7574 108.382C82.7279 108.382 82.6396 108.323 82.5807 108.264C82.4629 108.205 82.3451 108.117 82.2274 108.058C82.1685 108.028 82.1096 107.999 82.0801 107.94L81.9918 107.881C81.9035 107.822 82.139 107.999 81.9918 107.881C81.7563 107.704 81.5501 107.528 81.344 107.322C81.2557 107.233 81.1379 107.145 81.0496 107.027L80.9907 106.968L80.8435 106.792C80.6373 106.556 80.4312 106.321 80.2546 106.085C80.1662 105.967 80.0779 105.849 79.9896 105.702C79.9601 105.643 79.9012 105.584 79.8718 105.526L79.8129 105.408C79.7246 105.29 79.8423 105.437 79.7834 105.378C78.2229 103.052 77.3101 100.49 76.5445 97.7815C76.1617 96.4271 75.8378 95.0726 75.5728 93.6887C75.3078 92.452 75.1312 91.3331 74.9545 90.067C74.7484 88.5653 74.5717 87.0636 74.4539 85.5325C74.4539 85.4736 74.4539 85.3853 74.4539 85.3264C74.395 84.973 74.1595 84.6491 73.8061 84.5314C73.5411 84.443 73.1584 84.4725 73.1878 84.8258H73.1289Z"
			fill="#082F49"
		/>
		<path
			d="M81.0431 83.6465C81.0431 83.6465 82.7804 73.3408 78.8937 73.4586C78.8937 73.4586 78.4814 70.6319 75.4781 71.633C75.4781 71.633 74.1236 69.8663 72.1802 69.8663C70.2369 69.8663 65.9968 72.8108 66.5563 74.5481C67.1157 76.2853 71.5619 74.7247 71.5619 74.7247C71.1497 75.5786 70.8552 76.462 70.7374 77.4042C70.7374 77.4042 66.7035 76.992 66.5563 78.9354C66.409 80.8787 68.7646 84.3532 70.2958 84.4121C71.8269 84.471 71.8858 83.411 71.8858 83.411C71.8858 83.411 72.2391 84.5593 74.5653 85.6193C76.8914 86.6793 81.0431 83.6465 81.0431 83.6465Z"
			fill="white"
		/>
		<path
			d="M81.7495 83.8266C81.9556 82.5899 82.0734 81.3238 82.1323 80.0577C82.2206 78.1732 82.2501 75.9648 81.2784 74.2865C80.8073 73.4031 79.865 72.8437 78.8639 72.8437L79.6295 73.462C79.5412 72.8437 79.2761 72.2548 78.8639 71.7837C77.8922 70.6647 76.42 70.6353 75.095 71.0475L76.0961 71.3125C75.2422 70.1936 73.9761 69.4575 72.5922 69.2514C71.0905 69.0453 69.5593 69.8697 68.3815 70.6942C67.2921 71.4303 65.8787 72.5787 65.7904 73.992C65.7021 75.4937 67.4099 75.9648 68.5877 75.9059C69.736 75.847 70.8844 75.6115 71.9738 75.1993L70.9433 74.3159C70.4721 75.1993 70.1777 76.1709 70.0599 77.1426L70.7371 76.7304C70.0305 76.6715 69.2943 76.6715 68.5877 76.7598C67.5865 76.8776 66.3204 77.2604 65.9376 78.3499C65.7904 78.9388 65.8198 79.5571 66.026 80.1166C66.2321 80.8232 66.5265 81.471 66.9093 82.0894C67.5571 83.1788 68.5288 84.4449 69.8243 84.8277C70.9432 85.1811 72.5627 84.6805 72.6216 83.3555L71.2083 83.4438C71.4144 83.8855 71.7088 84.2977 72.0622 84.6216C72.4744 85.0044 72.9161 85.3283 73.4166 85.5933C73.8877 85.8877 74.4177 86.1233 74.9772 86.2411C76.8028 86.5944 78.7167 85.7405 80.2773 84.8572C80.7484 84.5922 81.1901 84.3272 81.6317 84.0033C81.8673 83.7972 81.8673 83.4438 81.6612 83.2377C81.6317 83.2083 81.6023 83.1788 81.5728 83.1494C81.2784 82.9138 80.8662 82.8844 80.5423 83.0905L80.3067 83.2377L80.0417 83.4144L79.8945 83.5027C79.8356 83.5322 79.8945 83.5027 79.9239 83.5027L79.7767 83.591C79.1289 83.9738 78.4517 84.3272 77.745 84.6216C77.0678 84.9161 76.3317 85.0927 75.5955 85.1222C75.4778 85.1222 75.3894 85.1222 75.3011 85.0927C75.2128 85.0633 75.3305 85.0927 75.2128 85.0633C75.0066 85.0338 74.83 84.9455 74.6533 84.8572C74.1822 84.6511 73.7405 84.3566 73.3577 84.0327C73.0927 83.856 72.8866 83.591 72.7099 83.326C72.6805 83.2966 72.651 83.2377 72.6216 83.1788C72.7394 83.3555 72.651 83.2377 72.6216 83.2083L72.5922 83.1199C72.3861 82.4721 71.2083 82.4721 71.1788 83.2083C71.2083 82.9138 71.1788 83.1494 71.1494 83.2377C71.1199 83.326 71.2083 83.1494 71.1199 83.2966L71.061 83.3849C71.061 83.4144 71.1199 83.3555 71.0316 83.4144C70.8844 83.5322 70.7371 83.591 70.5605 83.591C70.5016 83.591 70.2071 83.591 70.2955 83.591C70.3838 83.591 70.001 83.4733 70.1777 83.5616C69.7949 83.3849 69.471 83.1494 69.206 82.8255C68.7938 82.3838 68.4699 81.9127 68.1754 81.4121C67.881 80.9116 67.6454 80.3815 67.4982 79.8515C67.4393 79.6454 67.3804 79.4099 67.3804 79.1743C67.351 78.9976 67.351 78.7915 67.4099 78.6149C67.4099 78.5854 67.4393 78.4971 67.4099 78.6149C67.4393 78.5854 67.4393 78.5265 67.4688 78.4971C67.4982 78.4676 67.5276 78.4087 67.5571 78.3793C67.616 78.3204 67.7043 78.2615 67.7926 78.2026C67.7043 78.2615 67.9399 78.1437 67.9693 78.1143C68.3227 77.9671 68.7054 77.8787 69.0882 77.8198C69.2943 77.7904 69.471 77.761 69.6771 77.761C69.8832 77.761 70.0893 77.761 70.2955 77.761C70.5016 77.761 70.6782 77.761 70.8844 77.7904C71.1199 77.8198 71.5027 77.6432 71.5616 77.3782C71.6499 76.7304 71.7971 76.112 72.0327 75.4937C72.121 75.2581 72.2094 75.052 72.3272 74.8459C72.6805 74.1981 71.7971 73.7859 71.2966 73.9626C71.2377 73.992 71.1788 73.992 71.1199 74.0215C71.061 74.0509 70.8844 74.1098 71.061 74.0509L70.7371 74.1392C70.2366 74.2865 69.736 74.4042 69.2354 74.4631C68.9999 74.4926 68.7643 74.522 68.5582 74.522C68.411 74.522 68.2638 74.522 68.146 74.522H67.8221H67.7043C67.7927 74.522 67.7927 74.522 67.7043 74.522C67.616 74.522 67.3215 74.3748 67.4982 74.4631L67.351 74.3748C67.3804 74.3748 67.4982 74.4337 67.3804 74.3748C67.351 74.3454 67.2332 74.2276 67.351 74.3454C67.3215 74.3159 67.2921 74.257 67.2626 74.2276C67.351 74.3454 67.2626 74.1981 67.2626 74.1687C67.2332 74.0215 67.2626 74.257 67.2626 74.1098C67.2332 73.9331 67.2626 73.727 67.351 73.5503C67.4688 73.3442 67.5865 73.1381 67.7338 72.932C68.1165 72.4609 68.5582 72.0192 69.0588 71.6659C69.9716 70.9592 71.1199 70.3114 72.2094 70.1936C72.0327 70.2231 72.2094 70.1936 72.2388 70.1936C72.386 70.1936 72.5333 70.1936 72.6511 70.2231C72.8277 70.2525 72.9749 70.3114 73.1516 70.3703C73.4755 70.4881 73.77 70.6353 74.035 70.8414C74.3 71.0181 74.5355 71.2242 74.7416 71.4598C74.6239 71.342 74.83 71.5186 74.7416 71.4598L74.83 71.5775L74.8889 71.6659C75.1244 71.9603 75.5366 72.0781 75.89 71.9309C76.1255 71.8425 76.3611 71.8131 76.6261 71.7837C76.7439 71.7837 76.8911 71.7837 77.0089 71.7837C77.1267 71.7837 76.8617 71.7542 77.0678 71.7837L77.215 71.8131C77.4211 71.872 77.1561 71.7837 77.2444 71.8131L77.3917 71.872C77.4211 71.872 77.5389 71.9603 77.48 71.9014C77.4211 71.8425 77.5389 71.9603 77.5389 71.9603C77.5978 72.0192 77.6567 72.0781 77.7156 72.137C77.6567 72.0487 77.7745 72.1959 77.7156 72.137L77.8039 72.2548C77.8333 72.3137 77.8922 72.3726 77.9217 72.4314C77.8922 72.3726 77.9511 72.4903 77.9217 72.4314C77.9511 72.4609 77.9511 72.4903 77.9806 72.5492C78.0395 72.667 78.0984 72.7848 78.1278 72.9026C78.1572 72.9909 78.2161 73.2853 78.1867 73.0498C78.1867 73.0792 78.2161 73.1087 78.2161 73.1676C78.275 73.5503 78.5989 73.8154 78.9817 73.7859C79.07 73.7859 79.1584 73.7859 79.2467 73.7859C79.335 73.7859 79.07 73.727 79.2173 73.7859C79.2467 73.7859 79.3056 73.8153 79.335 73.8153C79.5412 73.8742 79.2761 73.7565 79.4234 73.8448C79.4528 73.8742 79.6589 73.992 79.5706 73.9331C79.4823 73.8742 79.6884 74.0215 79.7178 74.0509C79.865 74.1687 79.6884 73.992 79.7767 74.1098C79.8356 74.1687 79.865 74.2276 79.9239 74.2865C79.9828 74.3454 80.1006 74.5809 80.0123 74.4337C80.1889 74.787 80.3362 75.1404 80.4245 75.5232C80.5128 75.9354 80.6012 76.3182 80.6306 76.7304C80.7189 77.7021 80.7484 78.6738 80.6895 79.6454C80.6601 80.0871 80.6306 80.5288 80.6012 80.9705C80.5717 81.2355 80.5717 81.206 80.5717 81.4121C80.5717 81.6182 80.5423 81.7655 80.5128 81.9716C80.4539 82.3838 80.4245 82.7666 80.3362 83.1788C80.3067 83.5322 80.5423 83.856 80.8956 83.9444C81.1606 84.2977 81.6906 84.2094 81.7495 83.8266Z"
			fill="#082F49"
		/>
		<path
			d="M70.6221 79.7058C70.6221 79.7058 72.7127 81.5314 71.8293 83.3864L70.6221 79.7058Z"
			fill="white"
		/>
		<path
			d="M70.0922 80.17L70.1805 80.2583L70.2688 80.3467C70.3277 80.4056 70.1805 80.2583 70.2394 80.3172L70.3277 80.4056C70.5338 80.6411 70.74 80.9061 70.9166 81.2006C71.005 81.3772 71.1227 81.5539 71.1816 81.7306C71.1816 81.76 71.2405 81.9073 71.2111 81.7895C71.2111 81.8189 71.2405 81.8778 71.2405 81.9072C71.27 81.9956 71.2994 82.1134 71.3288 82.2017C71.3583 82.3195 71.3583 82.4078 71.3583 82.5256C71.3583 82.555 71.3583 82.7023 71.3583 82.6434C71.3583 82.5845 71.3583 82.7612 71.3583 82.7612C71.3288 82.8789 71.3288 82.9967 71.2994 83.085C71.27 83.2028 71.3289 82.9967 71.27 83.1439C71.2405 83.2028 71.2111 83.2617 71.1816 83.3501C71.0638 83.5267 71.1227 83.7623 71.2994 83.8801C71.3583 83.9095 71.4466 83.939 71.535 83.939C71.9177 83.939 72.2416 83.7034 72.4183 83.3795C73.125 81.8778 72.2711 80.2289 71.1227 79.1983C70.9755 79.11 70.8283 79.11 70.6811 79.1394C70.5044 79.1689 70.3277 79.2572 70.1805 79.4044C70.0038 79.6106 69.8272 79.9639 70.0922 80.17Z"
			fill="#082F49"
		/>
		<path
			d="M78.1943 79.4351C78.0176 80.3184 77.5759 81.1134 76.987 81.7907C76.8104 81.9673 76.6042 82.1146 76.3687 82.2323C76.2509 82.2912 76.1331 82.3207 76.0153 82.2912C75.8976 82.2912 76.0153 82.2912 75.8976 82.2912L75.7503 82.2618C75.7798 82.2618 75.7798 82.2618 75.7503 82.2618C75.6031 82.2618 75.8092 82.2912 75.7798 82.2912C75.7503 82.2912 75.7209 82.2618 75.662 82.2323C75.5148 82.0557 75.8976 82.3796 75.662 82.2323C75.6031 82.1734 75.5442 82.1146 75.5148 82.0262C75.4853 81.9379 75.4853 81.9968 75.4853 81.9968C75.4559 81.9379 75.4264 81.9084 75.397 81.8496C75.1909 81.4373 75.0731 80.9957 75.0142 80.554C74.9259 79.9945 74.9259 79.4056 74.9848 78.8462C75.0731 77.6684 75.4264 76.52 76.0153 75.4895C76.3098 74.9595 76.7515 74.5472 77.2815 74.2233C77.3698 74.1644 77.4876 74.1056 77.5759 74.0761C77.7231 74.0172 77.8704 73.9878 78.047 73.9583C77.9587 73.9583 78.1354 73.9289 78.047 73.9583H78.1648L78.4298 73.9289C78.577 73.9289 78.7243 73.9289 78.9009 73.9583C79.1954 73.9878 79.5782 73.87 79.5782 73.5167C79.5782 73.1633 79.107 72.9572 78.8126 72.9278C77.3698 72.7216 75.9565 73.2811 75.0437 74.4C74.2192 75.5189 73.7186 76.8439 73.6009 78.1984C73.4536 79.4056 73.4831 80.7601 74.0131 81.879C74.602 83.1451 76.1037 83.6751 77.3698 83.0862C77.4287 83.0568 77.4876 83.0273 77.517 82.9979C78.6065 82.409 79.2837 80.9956 79.5487 79.8473C79.7548 79.1995 78.3415 78.7873 78.1943 79.4351Z"
			fill="#082F49"
		/>
		<path
			d="M74.984 71.3087C73.5118 71.7209 72.2162 72.6042 71.3034 73.8704C70.4495 75.0482 69.9784 76.4615 69.949 77.9043C69.9195 78.9938 70.2728 80.1127 71.2445 80.7016C72.3634 81.3199 73.7179 81.2905 74.8074 80.6132C75.0724 80.4366 74.8073 80.2304 74.6012 80.1421C74.2773 79.9949 73.924 79.9949 73.6001 80.1127C73.4529 80.2304 73.2762 80.3188 73.0995 80.3777C73.0112 80.4071 72.8934 80.4366 72.8051 80.466C72.7462 80.466 72.6873 80.466 72.6579 80.4954C72.7462 80.4954 72.5695 80.4954 72.5695 80.4954C72.4223 80.4954 72.5695 80.4954 72.599 80.4954L72.4812 80.466C72.599 80.4954 72.3929 80.4366 72.4223 80.4366C72.3634 80.4071 72.3045 80.3482 72.2456 80.3188C71.4801 79.7004 71.4212 78.5521 71.5095 77.6687C71.6862 75.4604 72.9523 73.4876 74.8662 72.3687C75.2196 72.1626 75.6024 71.9859 76.0146 71.8975C76.309 71.8387 76.309 71.6031 76.0735 71.4559C75.6907 71.2792 75.3079 71.2203 74.984 71.3087Z"
			fill="#082F49"
		/>
		<path
			d="M85.5507 91.1546C85.0207 90.2418 84.6379 89.2701 84.1962 88.3279C83.6073 87.0323 82.989 85.7073 82.3412 84.4412C82.1645 84.0289 81.929 83.6167 81.6345 83.2339C81.399 82.9689 80.2212 83.8228 80.3979 83.9995C80.6334 84.3234 80.8395 84.6473 80.9868 85.0006C81.2812 85.5895 81.5757 86.149 81.8407 86.7379C82.459 88.0335 83.0479 89.329 83.6662 90.6246C83.8723 91.0368 84.049 91.4785 84.2846 91.8907C84.4612 92.1852 85.7274 91.4196 85.5507 91.1546Z"
			fill="#082F49"
		/>
		<path
			d="M26.1062 90.8368C25.2817 90.8368 24.3689 91.0135 23.8389 91.6907C23.3384 92.3385 23.3089 93.2513 23.8095 93.9285C24.31 94.5469 25.1934 94.7235 25.9001 94.3997C26.6951 94.0463 27.0779 93.2219 27.3429 92.4268L26.0767 92.103C26.1945 93.4574 27.2545 94.5763 28.609 94.753C30.199 94.9002 30.4935 93.1041 30.464 91.8968C30.4346 90.4246 29.8162 89.129 28.4912 88.3929C25.5467 86.8912 21.9839 88.069 20.4822 90.984C20.2466 91.4257 20.07 91.9263 19.9816 92.3974C19.5105 94.8413 20.6883 97.4914 22.9261 98.6692C24.3984 99.4053 26.1062 99.4642 27.6373 98.8458C29.0212 98.2275 30.199 97.1969 30.994 95.9013C31.1707 95.5774 31.1118 95.1652 30.8174 94.9002C30.5818 94.6941 30.1107 94.6058 29.9046 94.9002C28.7562 96.6669 26.8129 98.1391 24.6045 97.8447C22.6611 97.5797 21.395 95.9602 21.2183 94.0758C21.0711 92.2796 22.0133 90.5424 23.6034 89.7179C24.3984 89.2762 25.2817 89.0701 26.1651 89.0996C27.019 89.129 28.0495 89.3646 28.6384 90.0124C28.9623 90.4246 29.139 90.9252 29.1684 91.4552C29.2273 91.9557 29.1684 92.4857 29.0212 92.9863C28.8151 93.4574 28.344 93.3985 27.9612 93.163C27.6079 92.9274 27.4017 92.5152 27.3723 92.103C27.3134 91.5141 26.3417 91.0724 26.1062 91.7791C25.9884 92.2207 25.7823 92.633 25.4584 92.9568C25.3701 93.0452 24.8695 93.3396 24.7223 93.1335C24.6634 93.0452 24.8695 92.6919 24.9578 92.6035C25.3112 92.2796 25.8706 92.2502 26.3123 92.2207C27.2251 92.2207 26.9012 90.8368 26.1062 90.8368Z"
			fill="#7DD3FC"
		/>
		<path
			d="M34.8217 91.4239C33.85 91.6595 33.3789 92.69 33.2906 93.6323C33.1728 94.8101 33.7911 96.0468 35.0278 96.3412C36.0878 96.5473 37.1773 96.1645 37.8545 95.3695C38.2667 94.9573 38.414 94.339 38.2667 93.7795C38.0901 93.2495 37.354 92.6017 36.7651 92.8373C36.2939 93.0139 36.1173 93.6028 36.1467 94.0445C36.1762 94.5745 36.4117 95.1045 36.7945 95.4873C37.5895 96.3706 38.8851 96.5473 39.9157 95.9879C40.9168 95.3401 41.6235 94.339 41.859 93.1612C42.0062 92.5723 41.8885 91.9834 41.5646 91.4828C41.2701 91.0117 40.6518 90.4522 40.0334 90.5111C39.3562 90.57 39.3856 91.5711 39.3268 92.0423C39.2679 92.7195 39.3562 93.3967 39.6212 94.0151C40.1218 95.1929 41.3585 96.2529 42.6835 96.1056C43.3902 96.0468 42.5657 94.8984 42.0357 94.9279C40.6223 95.0456 40.4162 93.3967 40.534 92.3367C40.5634 92.16 40.5929 92.0128 40.6223 91.8361L40.6812 91.6595C40.6812 91.6595 40.534 91.6595 40.5634 91.6006C40.5634 91.63 40.6223 91.7772 40.6223 91.8067C40.6518 92.0128 40.6518 92.1895 40.5929 92.3956C40.4162 93.1023 40.0629 93.7501 39.5918 94.3095C39.1795 94.8395 38.5612 95.134 37.884 95.134C37.4128 95.1045 37.1773 94.8395 37.3245 94.339C37.354 94.2212 37.4128 94.1328 37.4717 94.0445L37.5012 94.0151C37.6778 93.8678 37.5306 93.7206 37.0595 93.6323C37.0301 93.7206 37.0006 93.8089 37.0006 93.8973C36.8828 94.1917 36.7062 94.4567 36.4706 94.6628C35.9995 95.0751 35.3811 95.2812 34.7628 95.2517C34.7039 95.2223 34.645 95.2223 34.5861 95.2223C34.4978 95.2223 34.5272 95.1929 34.5567 95.2517C34.4978 95.1634 34.4684 95.0456 34.4389 94.9279C34.38 94.604 34.4095 94.2506 34.4978 93.9267C34.645 93.3084 34.9984 92.7195 35.6461 92.5723C35.97 92.4839 35.7345 91.9834 35.6167 91.8361C35.4989 91.5417 35.175 91.3945 34.8217 91.4239Z"
			fill="#7DD3FC"
		/>
		<path
			d="M24.6866 32.5297C24.6866 32.5297 18.0026 29.0257 18.4148 28.5841C18.827 28.1424 41.2346 19.9273 41.529 21.9884C41.8235 24.0496 37.8779 36.3575 36.7001 36.4164C35.5223 36.4753 32.2539 35.327 32.2539 35.327C32.2539 35.327 27.1894 41.8637 26.6005 41.687C26.0116 41.5104 24.6866 32.5297 24.6866 32.5297Z"
			fill="white"
		/>
		<path
			d="M24.7158 32.0332C23.273 31.2677 21.8302 30.4727 20.4463 29.6482C20.0341 29.3832 19.5924 29.1182 19.1802 28.8532C19.0624 28.7943 19.1802 28.8532 19.2096 28.8827L19.0919 28.7943L18.8858 28.6471C18.8563 28.6176 18.7974 28.5588 18.7385 28.5293C18.6207 28.4704 18.8858 28.6765 18.7974 28.5882C18.7091 28.4999 18.7091 28.441 18.8563 28.6471C18.9446 28.8238 18.9446 29.0004 18.8858 29.1771C18.8858 29.1771 18.9152 29.1771 18.9152 29.1477C18.9152 29.1182 18.7974 29.2065 18.8858 29.1771C18.9741 29.1477 19.1508 29.0593 19.298 29.0004C22.5075 27.6165 25.8642 26.5271 29.1915 25.4082C31.282 24.7015 33.4021 24.0537 35.5515 23.4354C37.1121 22.9642 38.7316 22.5815 40.3805 22.3753C40.4099 22.3753 40.4688 22.3753 40.4983 22.3753H40.6749C40.7927 22.3753 40.9105 22.3753 41.0283 22.3753C41.1461 22.3753 41.205 22.4048 41.2933 22.4048C41.3816 22.4048 41.1461 22.3753 41.2638 22.4048C41.2933 22.4048 41.3522 22.4342 41.3816 22.4342C41.2344 22.4048 41.2344 22.3753 41.3227 22.4048C41.2638 22.3753 41.0872 22.2281 41.1166 22.2281C41.0283 22.1103 40.9988 21.9926 40.9399 21.9042C40.8811 21.8159 40.9399 21.8748 40.9399 21.9631C40.9694 21.757 40.9399 21.9631 40.9399 22.022C40.9399 22.0809 40.9399 22.1398 40.9399 22.1987C40.9399 22.3753 40.9105 22.5226 40.8811 22.6992C40.6161 24.7604 39.9683 26.8215 39.3205 28.7943C38.6727 30.8555 37.9955 32.946 36.9943 34.86C36.9354 35.0072 36.8471 35.1544 36.7588 35.3016C36.7293 35.3605 36.6704 35.4194 36.641 35.5077C36.6116 35.5961 36.4938 35.7139 36.5821 35.5961C36.5232 35.6844 36.4349 35.7433 36.376 35.8316C36.3465 35.8611 36.3171 35.8611 36.2877 35.8905C36.3465 35.8316 36.4054 35.8316 36.3171 35.8611C36.2288 35.8905 36.4938 35.8905 36.3466 35.8611C35.8165 35.8022 35.2865 35.7139 34.7565 35.5961C34.1382 35.4489 33.5493 35.2722 32.9604 35.0661C32.6659 34.9777 32.4009 34.8894 32.1065 34.8011C32.0182 34.7716 31.812 34.7422 31.7237 34.8305C30.1926 36.8033 28.6614 38.835 26.8948 40.6017C26.7475 40.7784 26.5709 40.9256 26.3647 41.0728L26.2764 41.1317L26.2175 41.1612C26.4531 41.1612 26.6592 41.2789 26.8064 41.4556C26.7475 41.3967 26.9536 41.6617 26.8653 41.5439C26.777 41.4262 26.9242 41.7501 26.8948 41.6028C26.8653 41.5145 26.8359 41.4262 26.8064 41.3378C26.777 41.2495 26.777 41.22 26.7475 41.1612C26.7181 41.1023 26.777 41.2789 26.7475 41.1023C26.7181 40.9256 26.6592 40.8373 26.6297 40.69C26.247 39.1884 25.982 37.6278 25.717 36.0966C25.5403 35.0072 25.3342 33.9177 25.187 32.7988C25.0986 32.4455 24.8631 32.151 24.5097 32.0038C24.3331 31.9155 24.1564 32.0038 24.068 32.151C24.0386 32.2394 24.0386 32.3277 24.0386 32.3866C24.4214 34.9777 24.8336 37.6278 25.452 40.1895C25.6581 40.955 26.1881 43.0456 27.3364 42.1328C27.8075 41.7501 28.2198 41.3084 28.6026 40.8667C29.162 40.2484 29.7215 39.5711 30.2515 38.9233C31.0759 37.9517 31.8709 36.9505 32.6365 35.92L32.2537 35.9494C33.196 36.2733 34.1676 36.5678 35.1688 36.8033C35.8754 36.98 36.906 37.3628 37.4655 36.6855C37.9366 36.0083 38.3194 35.3016 38.5844 34.5361C39.026 33.476 39.4383 32.3866 39.821 31.2971C40.6455 29.0004 41.2933 26.6448 41.8233 24.2598C41.9411 23.612 42.1472 22.817 42.0294 22.1398C41.8822 21.5214 41.3227 21.0503 40.6749 21.0209C40.086 20.9914 39.4971 21.0209 38.9377 21.1387C38.1132 21.2564 37.2888 21.4625 36.4643 21.6687C34.3149 22.1987 32.1948 22.8465 30.1042 23.5237C26.3353 24.7309 22.5958 25.9971 18.9152 27.4987C18.5619 27.6165 18.2085 27.7637 17.9141 27.9699C17.2957 28.4704 18.4146 29.3832 18.7974 29.6482C20.4758 30.8555 22.3308 31.8271 24.1564 32.7988L24.5981 33.0344C24.8336 33.1522 25.1575 33.1816 25.2164 32.8577C25.2458 32.5044 25.0397 32.1805 24.7158 32.0332Z"
			fill="#7DD3FC"
		/>
		<path
			d="M37.6424 25.4403C37.6424 25.4403 27.6017 33.3315 27.3367 33.8615C27.0717 34.3915 26.6006 41.6939 26.6006 41.6939"
			fill="white"
		/>
		<path
			d="M37.1422 25.6449C34.8455 27.4411 32.5488 29.2666 30.2815 31.1217C29.1626 32.0345 28.0143 32.9178 26.9542 33.9189C26.7187 34.125 26.5715 34.4195 26.5715 34.7434C26.4537 35.5384 26.3948 36.3628 26.3065 37.1579C26.1592 38.8068 26.0709 40.4557 25.9531 42.1046C25.9531 42.1635 26.6009 41.8396 26.6304 41.8101C26.7776 41.7218 27.1898 41.5451 27.2193 41.339C27.3076 39.9551 27.3959 38.6007 27.5137 37.2462C27.5726 36.3334 27.6609 35.4501 27.7493 34.5667C27.7787 34.3017 27.8082 34.0073 27.867 33.7423C27.867 33.6834 27.8965 33.6245 27.9259 33.5656C27.9554 33.4773 27.8965 33.595 27.9554 33.5361C28.0437 33.4478 28.0732 33.4184 28.1026 33.3889L28.2204 33.3006L28.2793 33.2417C28.4854 33.0356 28.7209 32.8589 28.9565 32.6822C29.5748 32.1522 30.2226 31.6222 30.841 31.1217C32.3427 29.9144 33.8443 28.7072 35.346 27.4999C36.2588 26.7638 37.1716 26.0571 38.0844 25.321C38.2905 25.1738 38.2316 25.1149 37.9961 25.2032C37.6722 25.3505 37.3777 25.5271 37.1127 25.7333L37.1422 25.6449Z"
			fill="#7DD3FC"
		/>
		<path
			d="M35.4355 35.208L28.3393 33.3824L27.3088 33.1174C26.9554 33.029 26.6904 33.4413 26.6904 33.7357C26.7199 34.1185 26.9849 34.4424 27.3677 34.5307L34.4639 36.3563L35.4944 36.6213C35.8478 36.7097 36.1128 36.2974 36.1128 36.003C36.0833 35.6202 35.8183 35.2963 35.4355 35.208Z"
			fill="#7DD3FC"
		/>
		<path
			d="M37.2298 24.8491L33.0487 26.9985L26.3941 30.4141L24.863 31.1797C24.3624 31.4447 25.1575 32.652 25.6875 32.387L29.8686 30.2375L36.5232 26.8219L38.0543 26.0269C38.5254 25.7913 37.7598 24.5841 37.2298 24.8491Z"
			fill="#7DD3FC"
		/>
		<path
			d="M20.8566 5.73871L12.1328 8.61877L14.219 14.9379L22.9428 12.0579L20.8566 5.73871Z"
			fill="white"
		/>
		<path
			d="M22.98 11.6261L15.3243 14.1584L14.2348 14.5117L14.8826 14.6001L13.057 9.06444L12.792 8.26943L12.1148 9.00555L19.7705 6.47329L20.8599 6.11995L20.2121 6.03162L22.0377 11.5673L22.3027 12.3623C22.45 12.8039 23.8044 12.215 23.6277 11.7145L21.8022 6.17884L21.5372 5.38383C21.4783 5.14827 21.0366 5.26605 20.8894 5.2955L13.2337 7.82776L12.1443 8.18109C11.8792 8.26943 11.3492 8.56388 11.467 8.91722L13.2926 14.4528L13.5576 15.2479C13.6165 15.4834 14.0582 15.3656 14.2054 15.3362L21.8611 12.8039L22.9505 12.4506C23.1861 12.3623 23.6572 12.1267 23.6277 11.8028C23.5983 11.4789 23.1566 11.5673 22.98 11.6261Z"
			fill="#7DD3FC"
		/>
		<path
			d="M12.4121 8.74474C13.9432 8.89197 15.2683 9.89309 16.7699 10.1287C16.8877 10.1581 16.9761 10.1581 17.0938 10.1287C17.1822 10.0698 17.2705 10.0109 17.3294 9.92254L20.4506 5.97693"
			fill="white"
		/>
		<path
			d="M11.9646 9.24052C12.7891 9.3583 13.6135 9.6233 14.3791 9.97664C15.1152 10.2711 16.0869 10.7717 16.9113 10.595C17.4708 10.4772 17.7947 10.065 18.1186 9.65275L19.0608 8.47495L20.9747 6.06047C21.1514 5.85436 21.2692 5.55991 20.9158 5.44213C20.5625 5.41269 20.2092 5.53047 19.9736 5.82492L18.3247 7.9155L17.4708 9.00496L17.0586 9.50552C16.9702 9.59386 16.9113 9.68219 16.823 9.77053L16.7641 9.85886C17.2647 9.74108 17.3825 9.65275 17.1469 9.6233C16.823 9.50552 16.4402 9.44663 16.0869 9.32885C15.7335 9.21107 15.3802 9.0344 15.0269 8.88718C14.3202 8.56329 13.5841 8.35717 12.848 8.23939C12.4946 8.20995 12.1413 8.35717 11.9057 8.65162C11.7879 8.79885 11.6113 9.24052 11.9646 9.24052Z"
			fill="#7DD3FC"
		/>
		<path
			d="M14.0293 14.516C14.1176 13.3087 14.7065 10.9826 15.0304 9.80481L14.0293 14.516Z"
			fill="white"
		/>
		<path
			d="M14.7654 14.5742C14.8537 13.7792 14.9715 12.9842 15.1776 12.1892C15.3543 11.3942 15.5604 10.6286 15.7665 9.83358C15.8548 9.48025 14.412 9.24469 14.2942 9.68636C14.0881 10.4519 13.882 11.2469 13.7053 12.0419C13.4992 12.837 13.3814 13.6025 13.2931 14.427C13.2637 14.692 13.8231 14.7803 13.9998 14.7803C14.1765 14.7803 14.7359 14.8392 14.7654 14.5742Z"
			fill="#7DD3FC"
		/>
		<path
			d="M18.917 8.68164C20.0065 9.68277 21.0665 10.7133 22.097 11.7734L18.917 8.68164Z"
			fill="white"
		/>
		<path
			d="M18.6201 9.09066C19.7096 10.0918 20.7696 11.1224 21.8002 12.1824C21.9769 12.3885 22.3891 12.5946 22.5952 12.3001C22.7424 11.9763 22.6835 11.5935 22.4185 11.3579C21.3585 10.3273 20.2985 9.29677 19.2385 8.2662C19.0324 8.08953 18.6496 7.85397 18.4435 8.17787C18.2668 8.47231 18.3551 8.8551 18.6201 9.09066Z"
			fill="#7DD3FC"
		/>
		<path
			d="M74.539 4.52264L62.3193 4.59302L62.3702 13.4265L74.5898 13.3561L74.539 4.52264Z"
			fill="white"
		/>
		<path
			d="M74.2707 12.8335L63.5822 12.8923H62.051L63.0522 13.6579L63.0227 5.91392V4.82446L62.6399 5.1189L73.3284 5.06001H74.8596L73.8584 4.29445L73.8879 12.0384V13.1574C73.8879 13.7462 75.2423 14.2468 75.2423 13.6285L75.2129 5.88447V4.76557C75.2129 4.29445 74.624 4 74.2118 4L63.5233 4.05889H61.9922C61.8155 4.05889 61.6094 4.14722 61.6094 4.35334L61.6388 12.0973V13.2162C61.6388 13.6874 62.2277 13.9818 62.6399 13.9818L73.3284 13.9229H74.8596C75.0362 13.9229 75.2129 13.7757 75.2129 13.599C75.2129 13.5107 75.1835 13.4518 75.154 13.3635C74.9773 13.0396 74.624 12.8335 74.2707 12.8335Z"
			fill="#7DD3FC"
		/>
		<path
			d="M62.5801 4.90951C64.4645 5.70452 65.7307 7.5301 67.5268 8.44289C67.6446 8.50178 67.7918 8.56067 67.939 8.56067C68.0863 8.53123 68.2335 8.47234 68.3218 8.384L73.8869 4.67395"
			fill="white"
		/>
		<path
			d="M62.3205 5.11689C63.2921 5.52912 64.0871 6.29468 64.8822 6.97191C65.6772 7.64915 66.6194 8.4736 67.65 8.7975C67.9444 8.91528 68.2978 8.94472 68.6217 8.85639C68.8867 8.73861 69.1517 8.59138 69.3578 8.41471L71.0656 7.26636L74.5695 4.94022C74.8051 4.793 74.2751 4.49855 74.1867 4.43966C73.9512 4.32188 73.5095 4.17465 73.2739 4.35132L70.1233 6.44191L68.5333 7.50192L67.7383 8.03193L67.5911 8.12026C67.3555 8.2086 67.4733 8.26749 67.915 8.26749C67.8266 8.2086 67.7678 8.17915 67.6794 8.14971C66.855 7.6197 66.0894 7.0308 65.3827 6.38302C64.6172 5.70579 63.7633 5.14633 62.8505 4.70466C62.6443 4.61633 62.1143 4.41021 61.9377 4.61633C61.761 4.82244 62.2027 5.058 62.3205 5.11689Z"
			fill="#7DD3FC"
		/>
		<path
			d="M62.292 12.8065C62.9103 11.3048 64.5887 8.59589 65.472 7.27087L62.292 12.8065Z"
			fill="white"
		/>
		<path
			d="M62.939 12.5643C63.3512 11.5926 63.8517 10.6504 64.4406 9.73759C64.9706 8.8248 65.5595 7.91201 66.1484 7.02866C66.2073 6.91088 65.6479 7.117 65.6184 7.117C65.4418 7.17589 65.2651 7.26422 65.0884 7.35255C64.9706 7.382 64.8823 7.47033 64.794 7.52922C64.2051 8.41257 63.6456 9.32536 63.0862 10.2382C62.5267 11.1509 62.0262 12.0932 61.6139 13.0649C61.555 13.1826 62.0851 13.006 62.1439 12.9765C62.3206 12.9176 62.4973 12.8293 62.674 12.741C62.7623 12.7115 62.939 12.6526 62.939 12.5643Z"
			fill="#7DD3FC"
		/>
		<path
			d="M70.8555 7.47754C71.7977 9.18534 72.7105 10.9226 73.6233 12.6893L70.8555 7.47754Z"
			fill="white"
		/>
		<path
			d="M70.1529 7.44098C71.0952 9.17822 72.008 10.886 72.9207 12.6527C73.0385 12.8883 73.598 12.8883 73.8041 12.8883C73.9219 12.8883 74.4519 12.8883 74.3341 12.6822C73.4508 10.9449 72.5085 9.20767 71.5663 7.47042C71.4485 7.23486 70.8891 7.23486 70.6829 7.23486C70.5946 7.23486 70.0352 7.23486 70.1529 7.44098Z"
			fill="#7DD3FC"
		/>
		<path
			d="M104.541 23.4339L101.228 31.6226L112.555 36.2061L115.869 28.0175L104.541 23.4339Z"
			fill="white"
		/>
		<path
			d="M113.227 36.0061L104.717 32.5611L102.686 31.7366L102.097 31.501C102.038 31.501 102.008 31.4716 101.949 31.4422C101.891 31.3833 101.949 31.4716 101.949 31.4422C101.979 31.2949 102.038 31.1772 102.097 31.0594L102.45 30.176L103.51 27.5849L105.277 23.2565L103.863 23.6982L112.373 27.1432L114.405 27.9677L114.994 28.2032C115.052 28.2032 115.082 28.2327 115.141 28.2621C115.141 28.2327 115.2 28.321 115.141 28.2621C115.111 28.4093 115.052 28.5271 114.994 28.6449L114.64 29.5282L113.58 32.1194L111.814 36.4478C111.784 36.5067 112.52 36.3889 112.55 36.3595C112.726 36.3006 113.139 36.2122 113.227 36.0061L116.142 28.851L116.554 27.8204L116.525 27.791L106.631 23.7865L105.218 23.227C105.012 23.1387 104.6 23.3154 104.423 23.3743C104.246 23.4332 103.922 23.492 103.834 23.6687L100.919 30.8238L100.536 31.8544L100.566 31.8838L110.459 35.8883L111.872 36.4478C112.108 36.5361 112.55 36.3594 112.756 36.2711C112.815 36.2711 113.345 36.0356 113.227 36.0061Z"
			fill="#7DD3FC"
		/>
		<path
			d="M104.688 23.8497C106.13 25.2925 106.601 27.442 107.926 29.0026C108.015 29.1204 108.133 29.2087 108.25 29.2676C108.398 29.297 108.545 29.297 108.692 29.2676L115.258 27.972"
			fill="white"
		/>
		<path
			d="M104.833 24.3781C105.51 25.0848 105.923 26.027 106.364 26.8809C106.865 27.8231 107.395 28.942 108.219 29.6487C108.661 30.0315 109.191 29.8254 109.721 29.7371L111.635 29.3543L115.639 28.5593C115.816 28.5298 115.286 27.2048 114.903 27.2931L111.193 28.0293L109.338 28.412L108.425 28.5887C108.102 28.6476 107.984 28.6476 107.778 28.412C107.189 27.6759 106.835 26.822 106.423 25.9976C105.952 25.0259 105.334 24.1425 104.598 23.3181C104.421 23.112 104.303 23.2297 104.333 23.4653C104.392 23.8186 104.568 24.1131 104.833 24.3781Z"
			fill="#7DD3FC"
		/>
		<path
			d="M101.39 31.0637C102.538 29.9154 105.1 28.0604 106.454 27.1476L101.39 31.0637Z"
			fill="white"
		/>
		<path
			d="M102.037 31.175C102.126 31.0867 102.008 31.2044 102.096 31.1161L102.214 30.9983C102.302 30.91 102.391 30.8217 102.479 30.7628C102.656 30.5861 102.862 30.4389 103.068 30.2622C103.51 29.9089 103.951 29.5261 104.422 29.2022C105.276 28.5544 106.13 27.9655 107.014 27.3766C107.161 27.2883 107.22 27.0822 107.131 26.9055C107.073 26.8172 107.014 26.7877 106.925 26.7583C106.572 26.6405 106.189 26.6994 105.895 26.9055C105.011 27.4944 104.128 28.1422 103.245 28.79C102.361 29.4378 101.507 30.1444 100.712 30.91C100.477 31.175 100.83 31.4106 101.066 31.4694C101.419 31.5283 101.802 31.4106 102.037 31.175Z"
			fill="#7DD3FC"
		/>
		<path
			d="M111.346 29.385C111.552 31.3284 111.758 33.2717 111.905 35.2445L111.346 29.385Z"
			fill="white"
		/>
		<path
			d="M110.781 28.9671C110.988 30.9105 111.194 32.8539 111.341 34.8267C111.37 35.1211 111.724 35.3861 111.93 35.5333C111.989 35.5628 112.519 35.8867 112.489 35.6511C112.313 33.6783 112.136 31.735 111.93 29.7916C111.9 29.4971 111.547 29.2321 111.341 29.0849C111.282 29.0555 110.752 28.7316 110.781 28.9671Z"
			fill="#7DD3FC"
		/>
		<path
			d="M30.9285 9.89242C35.8163 9.21519 40.9103 11.188 44.2081 14.8097C45.0326 15.7225 45.7687 16.7236 46.3281 17.8131C46.9759 19.0498 47.4471 20.3453 48.1832 21.5231C48.8899 22.7304 49.9204 23.6726 51.1866 24.291C52.4527 24.8504 53.866 25.086 55.2499 24.9682C58.6067 24.6737 61.345 22.5537 63.7301 20.3453C64.319 19.8153 63.0823 18.9909 62.5523 19.4914C60.4911 21.3759 58.1355 23.2898 55.2794 23.7315C54.0427 23.9376 52.7766 23.7904 51.6282 23.2604C50.4799 22.7304 49.6849 21.7293 49.096 20.6398C48.4482 19.462 47.9771 18.2253 47.3293 17.0475C46.7109 15.9581 45.9454 14.9275 45.0915 14.0147C43.3248 12.1302 41.1459 10.6874 38.7608 9.7452C36.0813 8.68518 33.1663 8.33184 30.3101 8.71463C30.0451 8.77352 29.8685 9.00907 29.9274 9.27408C29.9274 9.33297 29.9568 9.39186 29.9863 9.4213C30.1629 9.80409 30.5457 9.98075 30.9285 9.89242Z"
			fill="#082F49"
		/>
		<path
			d="M80.3376 10.2445C81.2798 9.30225 82.6048 8.91947 83.871 8.68391C85.3138 8.38946 86.786 8.12446 88.2877 7.94779C91.0555 7.65334 94.1178 7.62389 96.6206 8.94891C98.6817 10.0384 100.448 11.9523 101.008 14.249C101.155 14.8084 101.214 15.3973 101.185 15.9862C101.185 16.2807 101.155 16.5457 101.096 16.8107C101.067 16.9579 101.037 17.1051 100.978 17.2524C100.92 17.3701 100.861 17.4585 100.772 17.5763C100.537 18.0768 100.713 17.5763 100.713 17.6057C100.772 17.6057 100.831 17.6351 100.89 17.6351C100.949 17.6351 100.978 17.7235 100.89 17.6351C100.743 17.4879 100.655 17.2818 100.655 17.0757C100.684 16.5751 101.214 16.2512 101.656 16.1335C102.745 15.839 104.011 16.2807 104.895 16.9579C105.955 17.7235 106.661 18.8424 106.956 20.1085C107.074 20.4324 107.368 20.668 107.692 20.6974C107.869 20.7269 108.428 20.7269 108.34 20.403C107.721 17.4879 104.924 15.2501 101.95 15.1323C100.89 15.1029 98.8584 15.6329 99.2706 17.1051C99.624 18.3713 101.891 19.2841 102.333 17.6351C103.128 14.7495 101.538 11.8051 99.4473 9.92059C96.915 7.6239 93.4405 6.82888 90.0838 6.85833C88.0521 6.91722 86.0204 7.15278 84.0182 7.565C82.2515 7.8889 80.3376 8.24224 79.0126 9.53781C78.6592 9.97948 79.9548 10.6273 80.3376 10.2445Z"
			fill="#082F49"
		/>
		<path
			d="M31.2795 66.9567C28.1289 66.78 24.8605 66.1911 22.4166 64.0416C20.3849 62.2161 19.3838 59.2127 20.6204 56.651C20.9149 56.0326 21.3271 55.5026 21.8571 55.0904C22.181 54.8548 22.8582 54.4721 23.2705 54.7371C23.6827 55.0021 23.5649 55.6204 23.4177 55.9738C23.1821 56.4743 22.6521 56.7688 22.1221 56.6804C20.7088 56.4743 20.1493 54.796 19.8843 53.6182C19.5899 52.2931 19.5604 50.9387 19.7371 49.5842C20.1788 46.4925 21.8277 43.6952 24.3305 41.8402C24.5366 41.6636 24.566 41.3691 24.3894 41.163C24.3599 41.1335 24.3305 41.1041 24.2716 41.0747C23.9772 40.8391 23.5649 40.8096 23.241 41.0158C20.591 42.9591 18.8243 45.9036 18.3237 49.1425C18.0587 50.762 18.1176 52.4109 18.5299 53.9715C18.9715 55.7087 20.0021 57.4166 21.916 57.7699C22.7994 57.976 23.7416 57.711 24.3894 57.0632C24.8605 56.5626 25.0666 55.8265 24.9194 55.1493C24.7133 54.3248 24.0066 53.7065 23.1527 53.5887C22.2694 53.4709 21.4154 53.7359 20.7088 54.2659C19.3838 55.2671 18.736 56.916 18.6182 58.5355C18.5299 60.2138 19.0304 61.8627 20.0315 63.2172C22.5932 66.8095 27.1866 67.84 31.3384 68.0756C31.6328 68.105 32.045 67.9284 32.0156 67.575C31.9862 67.2217 31.6034 66.9567 31.2795 66.9567Z"
			fill="#082F49"
		/>
	</svg>
);
export const EmailitIcon = ( props ) => (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 53.02 45.95"
		{ ...props }
	>
		<g>
			<g>
				<g>
					<path
						d="m7.83,45.41c3.85.27,9.96.55,18.68.54,8.72,0,14.84-.29,18.68-.56,3.85-.27,6.9-3.18,7.25-7.06.29-3.34.58-8.38.57-15.36,0-.44,0-.88,0-1.3-3.14,1.45-6.31,2.83-9.51,4.13-2.95,1.19-6.15,2.39-9.11,3.29-2.91.89-5.74,1.55-7.88,1.55s-4.98-.66-7.88-1.55c-2.96-.9-6.16-2.1-9.11-3.29C6.31,24.5,3.14,23.13,0,21.68c0,.43,0,.86,0,1.31,0,6.98.29,12.02.58,15.36.34,3.89,3.4,6.79,7.25,7.06Z"
						fill="#15c182"
						strokeWidth="0"
					/>
					<path
						d="m.05,17.8c.1-4.37.31-7.74.52-10.19C.91,3.73,3.97.83,7.82.56,11.67.29,17.78,0,26.5,0c8.72,0,14.84.28,18.68.54,3.85.27,6.91,3.17,7.25,7.06.22,2.45.43,5.81.53,10.19-.04.02-.08.03-.12.05l-.05.02-.16.08c-.98.46-1.95.91-2.94,1.35-2.48,1.12-4.98,2.19-7.51,3.22-2.9,1.17-6,2.33-8.82,3.19-2.87.88-5.27,1.4-6.85,1.4s-3.98-.52-6.85-1.39c-2.82-.86-5.92-2.02-8.82-3.19-3.52-1.42-7.01-2.95-10.45-4.56l-.16-.08-.05-.02s-.08-.04-.12-.05h0Z"
						fill="#007b5e"
						strokeWidth="0"
					/>
				</g>
			</g>
		</g>
	</svg>
);
export const PhpMailIcon = ( props ) => (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		height="32"
		viewBox="0 0 32 32"
		width="32"
		{ ...props }
	>
		<defs>
			<clipPath id="A">
				<path d="M11.52 162C11.52 81.677 135.307 16.56 288 16.56S564.48 81.677 564.48 162 440.693 307.44 288 307.44 11.52 242.322 11.52 162" />
			</clipPath>
			<radialGradient
				cx="0"
				cy="0"
				fx="0"
				fy="0"
				gradientTransform="matrix(363.05789,0,0,-363.05789,177.52002,256.30713)"
				gradientUnits="userSpaceOnUse"
				id="B"
				r="1"
				spreadMethod="pad"
			>
				<stop offset="0" stopColor="#aeb2d5" />
				<stop offset=".3" stopColor="#aeb2d5" />
				<stop offset=".75" stopColor="#484c89" />
				<stop offset="1" stopColor="#484c89" />
			</radialGradient>
			<clipPath id="C">
				<path d="M0 324h576V0H0v324z" />
			</clipPath>
			<clipPath id="D">
				<path d="M0 324h576V0H0v324z" />
			</clipPath>
		</defs>
		<g transform="matrix(.05787 0 0 -.057079 -.666665 24.945283)">
			<g clipPath="url(#A)">
				<path
					d="M11.52 162C11.52 81.677 135.307 16.56 288 16.56S564.48 81.677 564.48 162 440.693 307.44 288 307.44 11.52 242.322 11.52 162"
					fill="url(#B)"
				/>
			</g>
			<g clipPath="url(#C)">
				<path
					d="M288 27.36c146.73 0 265.68 60.28 265.68 134.64S434.73 296.64 288 296.64 22.32 236.36 22.32 162 141.27 27.36 288 27.36"
					fill="#777bb3"
				/>
			</g>
			<g clipPath="url(#D)">
				<path d="M161.734 145.307c12.065 0 21.072 2.225 26.77 6.61 5.638 4.34 9.532 11.862 11.573 22.353 1.903 9.806 1.178 16.653-2.154 20.348-3.407 3.774-10.773 5.688-21.893 5.688h-19.28l-10.69-55h15.673zM98.67 77.557c-.895 0-1.745.4-2.314 1.092a3 3 0 0 0-.63 2.48l28.328 145.75a3 3 0 0 0 2.945 2.427h61.054c19.188 0 33.47-5.2 42.447-15.487 9.025-10.33 11.812-24.772 8.283-42.92-1.436-7.394-3.906-14.26-7.34-20.41-3.44-6.155-7.984-11.85-13.51-16.93-6.616-6.192-14.104-10.682-22.236-13.324-8.003-2.607-18.28-3.93-30.548-3.93h-24.722l-7.06-36.322a3 3 0 0 0-2.944-2.428H98.67z" />
				<path
					d="M159.224 197.307h16.808c13.42 0 18.083-2.945 19.667-4.7 2.628-2.914 3.124-9.058 1.435-17.767-1.898-9.75-5.416-16.663-10.458-20.545-5.162-3.974-13.554-5.988-24.94-5.988H149.7l9.523 49zm28.83 35H127a6 6 0 0 1-5.889-4.855L92.783 81.7a6 6 0 0 1 5.889-7.144h31.75a6 6 0 0 1 5.89 4.855l6.588 33.895h22.25c12.582 0 23.174 1.372 31.48 4.077 8.54 2.775 16.4 7.48 23.354 13.984 5.752 5.292 10.5 11.232 14.08 17.657s6.17 13.594 7.668 21.302c3.715 19.104.697 34.402-8.97 45.466-9.572 10.958-24.614 16.514-44.706 16.514m-45.633-90h19.313c12.8 0 22.336 2.41 28.6 7.234s10.492 12.875 12.688 24.157c2.1 10.832 1.144 18.476-2.87 22.93s-12.06 6.68-24.12 6.68h-21.754l-11.856-61m45.633 84c18.367 0 31.766-4.82 40.188-14.46s10.957-23.098 7.597-40.375c-1.383-7.117-3.722-13.624-7.015-19.52s-7.602-11.293-12.922-16.184c-6.34-5.933-13.383-10.16-21.133-12.68-7.75-2.525-17.62-3.782-29.62-3.782h-27.196l-7.53-38.75h-31.75L127 226.307h61.055"
					fill="#fff"
				/>
				<path d="M311.583 116.307c-.896 0-1.745.4-2.314 1.092s-.802 1.6-.63 2.48l12.53 64.49c1.192 6.133.898 10.535-.827 12.395-1.056 1.137-4.228 3.044-13.607 3.044h-22.702l-15.755-81.072a3 3 0 0 0-2.945-2.428h-31.5a3 3 0 0 0-2.945 3.572l28.328 145.75a3 3 0 0 0 2.945 2.427h31.5a3 3 0 0 0 2.945-3.572l-6.836-35.178h24.422c18.605 0 31.22-3.28 38.57-10.028 7.5-6.884 9.827-17.89 6.947-32.72l-13.18-67.825a3 3 0 0 0-2.945-2.428h-32z" />
				<path
					d="M293.66 271.057h-31.5a6 6 0 0 1-5.89-4.855l-28.328-145.75a6 6 0 0 1 5.89-7.144h31.5a6 6 0 0 1 5.89 4.855l15.283 78.645h20.23c9.363 0 11.328-2 11.407-2.086.568-.61 1.315-3.44.082-9.78l-12.53-64.49a6 6 0 0 1 5.89-7.144h32a6 6 0 0 1 5.89 4.855l13.18 67.825c3.093 15.92.447 27.864-7.86 35.5-7.928 7.28-21.208 10.82-40.6 10.82h-20.784l6.143 31.605a6 6 0 0 1-5.89 7.145m0-6l-7.53-38.75h28.062c17.657 0 29.836-3.082 36.54-9.238s8.71-16.14 6.032-29.938l-13.18-67.824h-32l12.53 64.488c1.426 7.336.902 12.34-1.574 15.008s-7.746 4.004-15.805 4.004H281.56l-16.226-83.5h-31.5l28.328 145.75h31.5"
					fill="#fff"
				/>
				<path d="M409.55 145.307c12.065 0 21.072 2.225 26.77 6.61 5.638 4.34 9.532 11.86 11.574 22.353 1.903 9.806 1.178 16.653-2.155 20.348-3.407 3.774-10.773 5.688-21.893 5.688h-19.28l-10.69-55h15.673zm-63.062-67.75c-.895 0-1.745.4-2.314 1.092a3 3 0 0 0-.631 2.48l28.328 145.75a3 3 0 0 0 2.946 2.427h61.053c19.19 0 33.47-5.2 42.448-15.487 9.025-10.33 11.81-24.77 8.283-42.92-1.438-7.394-3.907-14.26-7.342-20.41-3.44-6.155-7.984-11.85-13.51-16.93-6.616-6.192-14.104-10.682-22.236-13.324-8.003-2.607-18.28-3.93-30.548-3.93H388.24l-7.057-36.322a3 3 0 0 0-2.946-2.428h-31.75z" />
				<path
					d="M407.04 197.307h16.808c13.42 0 18.083-2.945 19.667-4.7 2.63-2.914 3.125-9.058 1.435-17.766-1.898-9.75-5.417-16.664-10.458-20.546-5.162-3.974-13.554-5.988-24.94-5.988h-12.033l9.522 49zm28.83 35h-61.054a6 6 0 0 1-5.889-4.855L340.6 81.7a6 6 0 0 1 5.889-7.144h31.75a6 6 0 0 1 5.89 4.855l6.587 33.895h22.25c12.582 0 23.174 1.372 31.48 4.077 8.54 2.775 16.4 7.48 23.356 13.986 5.752 5.29 10.488 11.23 14.078 17.655s6.17 13.594 7.668 21.302c3.715 19.105.697 34.403-8.97 45.467-9.572 10.957-24.613 16.513-44.706 16.513m-45.632-90h19.312c12.8 0 22.336 2.41 28.6 7.234s10.492 12.875 12.688 24.157c2.102 10.832 1.145 18.476-2.87 22.93s-12.06 6.68-24.12 6.68h-21.754l-11.855-61m45.632 84c18.367 0 31.766-4.82 40.188-14.46s10.957-23.098 7.597-40.375c-1.383-7.117-3.722-13.624-7.015-19.52s-7.602-11.293-12.922-16.184c-6.34-5.933-13.383-10.16-21.133-12.68-7.75-2.525-17.62-3.782-29.62-3.782h-27.196l-7.53-38.75h-31.75l28.328 145.75h61.054"
					fill="#fff"
				/>
			</g>
		</g>
	</svg>
);
